/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.compress.utils.Lists;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
extends HussarServiceImpl<ProcessDefinitionsMapper, ProcessExtendProperties>
implements ProcessDefinitionsService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    private IProcessGroupService processGroupService;
    @Autowired
    private GodAxeModelService godAxeModelService;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, String procGroupNumber, Page<DefinitionModel> page) {
        ProcessGroup processGroup;
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName, procGroupNumber);
        if (HussarUtils.isNotEmpty((Object)procGroupNumber) && (processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)definitionName)).eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber))) != null && processGroup.getMainProcDefId() != null) {
            for (DefinitionModel definitionModel : instList) {
                if (!definitionModel.getId().equals(processGroup.getMainProcDefId())) continue;
                definitionModel.setMain("1");
                break;
            }
        }
        page.setRecords(instList);
        return page;
    }

    public IPage<DefinitionModel> queryMainProcessDefinitionsList(String definitionName, String procGroupNumber, Page<DefinitionModel> page) {
        ProcessGroup processGroup;
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName, procGroupNumber);
        List<Object> mainList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)procGroupNumber) && (processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)definitionName)).eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber))) != null && processGroup.getMainProcDefId() != null) {
            mainList = instList.stream().filter(s -> s.getId().equals(processGroup.getMainProcDefId())).collect(Collectors.toList());
        }
        page.setRecords(mainList);
        return page;
    }

    public WorkFlow copyWorkFlow(String procDefId, List<String> deptIdList, String groupName) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(procDefId);
        WorkFlow processFile = this.sysActProcessFileService.getFileByProcessKey(processDefinition.getKey(), Integer.valueOf(processDefinition.getVersion()));
        if (HussarUtils.isNotEmpty(deptIdList)) {
            ProcessGroup processGroup = this.processGroupService.addProcessGroup(new ProcessGroup().setGroupName(HussarUtils.isNotEmpty((Object)groupName) ? groupName : processDefinition.getName()).setProcessKey(processDefinition.getKey()).setDeptId(deptIdList));
            processFile.setGroupNumber(processGroup.getGroupNumber());
            String deptId = deptIdList.get(0);
            if (deptIdList.size() > 1) {
                for (int i = 1; i < deptIdList.size(); ++i) {
                    deptId = deptId + ',' + deptIdList.get(i);
                }
            }
            processFile.setDeptId(deptId);
        } else {
            processFile.setGroupNumber(null);
        }
        this.godAxeModelService.saveAndPublish(processFile, null, true);
        processFile.setData(null);
        return processFile;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessNotExist(), Boolean.valueOf(false));
    }

    public String getStartProcessDefinitionId(String processKey, String version) {
        DefinitionModel mainOrNew;
        if (HussarUtils.isEmpty((Object)version) && (mainOrNew = this.getMainOrNew(processKey)) != null) {
            return mainOrNew.getId();
        }
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey, version, true);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new BpmException(this.bpmConstantProperties.getProcessKeyError());
    }

    public Integer getMaxProcGroupNumber(String processKey, String processGroupNumber) {
        return this.processDefinitionsMapper.getMaxProcGroupNumber(processKey, processGroupNumber);
    }

    public String getLastProcessDefinitionId(String processKey) {
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey, null, false);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new BpmException(this.bpmConstantProperties.getProcessKeyError());
    }

    public List<String> getProcessDefinitionId(String processKey, Integer version) {
        return this.processDefinitionsMapper.getProcessDefinitionId(processKey, version);
    }

    public ApiResponse<String> setMain(String procDefId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(procDefId);
        if (processDefinition == null) {
            throw new PublicClientException("\u672a\u53d1\u73b0\u8be5\u6d41\u7a0b\u5b9a\u4e49\uff01");
        }
        ProcessExtendProperties processExtendProperties = this.getProcessExtendProperties(procDefId);
        String procGroupNumber = processExtendProperties.getProcGroupNumber();
        ProcessGroup processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)processDefinition.getKey())).eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber));
        if (processGroup == null) {
            throw new PublicClientException("\u672a\u53d1\u73b0\u6d41\u7a0b\u5206\u7ec4");
        }
        this.processGroupService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ProcessGroup::getProcGroupId, (Object)processGroup.getProcGroupId())).set(ProcessGroup::getMainProcDefId, (Object)procDefId));
        return ApiResponse.success((String)"");
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_DELETE_THE_ONLY_PROCESS_DEFINITION);
        }
    }

    public int setNotMain(String processKey) {
        throw new UnsupportedOperationException();
    }

    public ApiResponse<String> cancelMain(String processKey, String id) {
        throw new UnsupportedOperationException();
    }

    public int updateProcessName(String id, String processName) {
        return this.processDefinitionsMapper.updateProcessName(id, processName);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public List<ProcessDefinitionModel> getProcessMainOrNew(String processKey) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.getProcessMainOrNew(processKey);
        ArrayList newList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(list)) {
            newList.add(list.get(0));
        }
        return newList;
    }

    public List<ProcessDefinitionVo> queryFlowVersion(String processKey) {
        return this.processDefinitionsMapper.queryFlowVersion(processKey);
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId);
        this.processDefinitionsMapper.updateExecution(defId, processInsId);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId);
    }

    public void editTemporaryDefId(String defId, String version) {
        this.processDefinitionsMapper.updateProcDef(defId, null, Long.parseLong(version));
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    public ApiResponse<String> setMainVersion(String processKey, String processVersion) {
        DefinitionModel definitionModel = this.processDefinitionsMapper.getProcDefIdByKeyAndVersion(processKey, processVersion);
        if (HussarUtils.isEmpty((Object)definitionModel)) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessVersionNotFound());
        }
        String processDefinitionId = definitionModel.getId();
        ApiResponse<String> result = this.setMain(processDefinitionId);
        return result;
    }

    public Integer queryNewVersion(String processKey) {
        return this.processDefinitionsMapper.queryNewVersion(processKey);
    }

    public String getProcessDefIdByVersion(String identity, Integer processVersion) {
        return this.processDefinitionsMapper.getProcessDefIdByVersion(identity, processVersion);
    }

    public DefinitionModel getByVersion(String processKey, Integer version) {
        List<DefinitionModel> defByVersion = this.processDefinitionsMapper.getByVersion(processKey, version);
        if (HussarUtils.isNotEmpty(defByVersion)) {
            return defByVersion.get(0);
        }
        return null;
    }

    @CacheEvict(value={"process_extend_properties"}, allEntries=true)
    public void setProcessExtendProperties(String procDefId, ProcessExtendProperties processExtendProperties) {
        this.processDefinitionsMapper.setProcessExtendProperties(procDefId, processExtendProperties);
    }

    @Cacheable(value={"process_extend_properties"}, key="#procDefId", unless="#result == null")
    public ProcessExtendProperties getProcessExtendProperties(String procDefId) {
        ProcessExtendProperties processExtendProperties = this.processDefinitionsMapper.getProcessExtendProperties(procDefId);
        return processExtendProperties == null ? new ProcessExtendProperties() : processExtendProperties;
    }

    public List<ProcessDefinitionVo> listProcessByProcessKeys(@Param(value="processKeys") List<String> processKeys) {
        ArrayList processDefinitions = this.processDefinitionsMapper.listProcessByProcessKeys(processKeys);
        return processDefinitions == null ? new ArrayList() : processDefinitions;
    }
}

