/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.platform.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CharsetUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ResourceUtil;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.dto.AddWorkflowDto;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.service.IBpmDesignerService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BpmDesignerServiceImpl
implements IBpmDesignerService {
    private final GodAxeModelService godAxeModelService;
    private final BpmConstantProperties bpmConstantProperties;
    private final SysActProcessFileService sysActProcessFileService;
    private static final String BPM_TEMPLATE_RESOURCE = "bpm/template/bpm_template.json";

    public BpmDesignerServiceImpl(GodAxeModelService godAxeModelService, BpmConstantProperties bpmConstantProperties, SysActProcessFileService sysActProcessFileService) {
        this.godAxeModelService = godAxeModelService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.sysActProcessFileService = sysActProcessFileService;
    }

    public ApiResponse<?> saveWorkflow(WorkFlow workFlow) {
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)this.bpmConstantProperties.getSuccessSave());
    }

    public ApiResponse<?> addWorkflow(WorkFlow workFlow) {
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity()));
        if (HussarUtils.isNotEmpty((Object)list) && "0".equals(workFlow.getIsUpdate())) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getSameIdentity());
        }
        if (HussarUtils.isNotEmpty((Object)list) && "1".equals(workFlow.getIsUpdate())) {
            ArrayList<SysActProcessFile> updateList = new ArrayList<SysActProcessFile>();
            for (SysActProcessFile sysActProcessFile : list) {
                sysActProcessFile.setBusinessMainTable(workFlow.getBusinessMainTable());
                sysActProcessFile.setBusinessMainTableKey(workFlow.getBusinessMainTableKey());
                sysActProcessFile.setDetailName(workFlow.getDetailName());
                sysActProcessFile.setBusinessMainTableState(workFlow.getBusinessMainTableState());
                sysActProcessFile.setBusinessMainTableName(workFlow.getBusinessMainTableName());
                sysActProcessFile.setRemoteDbName(workFlow.getRemoteDbName());
                sysActProcessFile.setAttachmentFieldName(workFlow.getFileCountField());
                updateList.add(sysActProcessFile);
            }
            return ApiResponse.success((Object)this.sysActProcessFileService.updateProcessFileList(updateList));
        }
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)this.bpmConstantProperties.getSuccessSave());
    }

    public ApiResponse<?> addWorkflow(AddWorkflowDto addWorkflowDto) {
        if (HussarUtils.isEmpty((Object)addWorkflowDto.getProcessKey()) || HussarUtils.isEmpty((Object)addWorkflowDto.getProcessName())) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_IDENTITY_OR_NAME);
        }
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)addWorkflowDto.getProcessKey()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BpmException(BpmExceptionCodeEnum.SAME_IDENTITY);
        }
        String bpmTemplate = ResourceUtil.readStr((String)BPM_TEMPLATE_RESOURCE, (Charset)CharsetUtil.CHARSET_UTF_8);
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)bpmTemplate, WorkFlow.class);
        workFlow.setId(UUID.randomUUID().toString());
        workFlow.setName(addWorkflowDto.getProcessName());
        workFlow.setIdentity(addWorkflowDto.getProcessKey());
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)this.bpmConstantProperties.getSuccessSave());
    }

    public ApiResponse<WorkFlow> getExtendContend(String processkey) {
        WorkFlow workFlow = new WorkFlow();
        SysActProcessFile sysActProcessFile = this.sysActProcessFileService.getExtendContend(processkey);
        workFlow.setBusinessMainTable(sysActProcessFile.getBusinessMainTable());
        workFlow.setBusinessMainTableKey(sysActProcessFile.getBusinessMainTableKey());
        workFlow.setDetailName(sysActProcessFile.getDetailName());
        workFlow.setBusinessMainTableState(sysActProcessFile.getBusinessMainTableState());
        workFlow.setBusinessMainTableName(sysActProcessFile.getBusinessMainTableName());
        workFlow.setRemoteDbName(sysActProcessFile.getRemoteDbName());
        workFlow.setFileCountField(sysActProcessFile.getAttachmentFieldName());
        return ApiResponse.success((Object)workFlow);
    }

    public ApiResponse<Integer> getLatestVersion(String processKey) {
        LambdaQueryWrapper objectLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)objectLambdaQueryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey)).orderByDesc(SysActProcessFile::getVersion)).last("LIMIT 1");
        SysActProcessFile one = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)objectLambdaQueryWrapper);
        if (one != null) {
            return ApiResponse.success((Object)one.getVersion());
        }
        return ApiResponse.success((Object)0);
    }

    public ApiResponse<?> publishNewVersion(WorkFlow workFlow) {
        this.godAxeModelService.saveAndPublish(workFlow, null, true);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow);
    }

    public ApiResponse<?> publishWorkflow(WorkFlow workFlow) {
        if (HussarUtils.isEmpty((Object)workFlow.getProcDefId())) {
            return this.publishNewVersion(workFlow);
        }
        this.godAxeModelService.updateProcess(workFlow, null, false);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> updateProcessKey(String oldProcessKey, String processKey) {
        this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
        return ApiResponse.success();
    }
}

