/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessActionCmd
implements Command<Void> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessActionCmd.class);
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    private static String PROCESS_ACTION_EVENT = "\u6d41\u7a0b\u6d3b\u52a8\u65f6";
    private String processInsId;
    private int type;

    public ProcessActionCmd(String processInsId) {
        this.processInsId = processInsId;
        this.type = 0;
    }

    public ProcessActionCmd(String processInsId, int type) {
        this.processInsId = processInsId;
        this.type = type;
    }

    public Void execute(CommandContext commandContext) {
        Map<String, String> nodeMap;
        List<Map<String, String>> nodeMapList;
        Map subProcess;
        String subProcessVariable;
        HashMap<String, Object> subProcessMap;
        String subProcessNodeId;
        String[] subProcessKeyMessage;
        HashMap<String, Object> map;
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity historicProcessInstance = historicProcessInstanceEntityManager.findHistoricProcessInstance(this.processInsId);
        List taskEntities = new ArrayList();
        List historicProcessInstanceEntities = new ArrayList();
        List historicCallActivityEntities = new ArrayList();
        if (this.type == 2) {
            taskEntities = commandContext.getTaskEntityManager().findTasksByProcessInstanceIdFromCache(this.processInsId);
        } else if (this.type == 0) {
            while (historicProcessInstance.getEndTime() != null && historicProcessInstance.getSuperProcessInstanceId() != null) {
                this.processInsId = historicProcessInstance.getSuperProcessInstanceId();
                historicProcessInstance = historicProcessInstanceEntityManager.findHistoricProcessInstance(this.processInsId);
            }
            if (historicProcessInstance.getEndTime() != null) {
                return null;
            }
            taskEntities = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(this.processInsId);
            historicProcessInstanceEntities = commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().activityType("receiveTask").unfinished().processInstanceId(this.processInsId).list();
            historicCallActivityEntities = commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().activityType("callActivity").unfinished().processInstanceId(this.processInsId).list();
        }
        BpmnModel bpmnModel = repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("processInsId", this.processInsId);
        message.put("businessId", historicProcessInstance.getBusinessKey());
        message.put("startTime", historicProcessInstance.getStartTime());
        message.put("startUser", historicProcessInstance.getStartUserId());
        String processKey = historicProcessInstance.getProcessDefinitionId().split(":")[0];
        message.put("processKey", processKey);
        if (this.type == 1) {
            message.put("endTime", new Date());
            BpmnModel bm = repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
            Process process = (Process)bm.getProcesses().get(0);
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof EndEvent)) continue;
                message.put("taskDefinitionName", flowElement.getName());
            }
        }
        HashMap nodeMessageMap = new HashMap();
        ArrayList nodeMessages = new ArrayList();
        message.put("nodeMessage", nodeMessages);
        for (TaskEntity taskEntity : taskEntities) {
            HashMap<String, String> user;
            List identityLinks;
            ArrayList userIds;
            List tasks;
            boolean isMultiSubProcess;
            if (taskEntity.getSubProcessKey() == null) {
                map = (HashMap<String, Object>)nodeMessageMap.get(taskEntity.getTaskDefinitionKey());
                List tasks2 = new ArrayList();
                if (map == null) {
                    map = new HashMap();
                    map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    map.put("taskDefinitionName", taskEntity.getName());
                    map.put("type", "task");
                    map.put("tasks", tasks2);
                    nodeMessageMap.put(taskEntity.getTaskDefinitionKey(), map);
                } else {
                    tasks2 = (List)map.get("tasks");
                }
                HashMap<String, Object> stringMap2 = new HashMap<String, Object>();
                stringMap2.put("taskId", taskEntity.getId());
                stringMap2.put("startTime", taskEntity.getCreateTime());
                stringMap2.put("formKey", taskEntity.getFormKey());
                ArrayList userIds2 = new ArrayList();
                List identityLinks2 = taskEntity.getCandidates();
                for (IdentityLinkEntity identityLinkEntity : identityLinks2) {
                    HashMap<String, String> user3 = new HashMap<String, String>();
                    user3.put("assignee", identityLinkEntity.getUserId());
                    if (identityLinkEntity.getMandator() != null) {
                        user3.put("owner", identityLinkEntity.getMandator());
                    }
                    userIds2.add(user3);
                }
                if (taskEntity.getAssignee() != null) {
                    HashMap<String, String> user4 = new HashMap<String, String>();
                    user4.put("assignee", taskEntity.getAssignee());
                    userIds2.add(user4);
                }
                stringMap2.put("assignee", userIds2);
                tasks2.add(stringMap2);
                continue;
            }
            subProcessKeyMessage = taskEntity.getSubProcessKey().split(":");
            subProcessNodeId = subProcessKeyMessage[0];
            subProcessMap = (HashMap<String, Object>)nodeMessageMap.get(subProcessNodeId);
            boolean bl = isMultiSubProcess = !"".equals(subProcessKeyMessage[1]);
            if (subProcessMap == null) {
                subProcessMap = new HashMap<String, Object>();
                subProcessMap.put("taskDefinitionKey", subProcessNodeId);
                subProcessMap.put("taskDefinitionName", bpmnModel.getFlowElement(subProcessNodeId).getName());
                subProcessMap.put("type", isMultiSubProcess ? "multiSubProcess" : "subProcess");
            }
            if (isMultiSubProcess) {
                subProcessVariable = subProcessKeyMessage[1];
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (List)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                nodeMap = null;
                for (Map map2 : nodeMapList) {
                    if (!map2.get("taskDefinitionKey").equals(taskEntity.getTaskDefinitionKey())) continue;
                    nodeMap = map2;
                    break;
                }
                tasks = new ArrayList();
                if (nodeMap == null) {
                    nodeMap = new HashMap();
                    nodeMap.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    nodeMap.put("taskDefinitionName", taskEntity.getName());
                    nodeMap.put("type", "task");
                    nodeMap.put("tasks", (String)((Object)tasks));
                    nodeMapList.add(nodeMap);
                } else {
                    tasks = (List)nodeMap.get("tasks");
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("taskId", taskEntity.getId());
                hashMap.put("startTime", taskEntity.getCreateTime());
                hashMap.put("formKey", taskEntity.getFormKey());
                userIds = new ArrayList();
                identityLinks = taskEntity.getCandidates();
                for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                    HashMap<String, String> user2 = new HashMap<String, String>();
                    user2.put("assignee", identityLinkEntity.getUserId());
                    if (identityLinkEntity.getMandator() != null) {
                        user2.put("owner", identityLinkEntity.getMandator());
                    }
                    userIds.add(user2);
                }
                if (taskEntity.getAssignee() != null) {
                    user = new HashMap();
                    user.put("assignee", taskEntity.getAssignee());
                    userIds.add(user);
                }
                hashMap.put("assignee", userIds);
                tasks.add(hashMap);
                subProcessMap.put("subProcess", subProcess);
            } else {
                subProcessVariable = "";
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (ArrayList)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                subProcessMap.put("subProcess", subProcess);
                nodeMap = null;
                for (Map map3 : nodeMapList) {
                    if (!map3.get("taskDefinitionKey").equals(taskEntity.getTaskDefinitionKey())) continue;
                    nodeMap = map3;
                    break;
                }
                tasks = new ArrayList();
                if (nodeMap == null) {
                    nodeMap = new HashMap();
                    nodeMap.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    nodeMap.put("taskDefinitionName", taskEntity.getName());
                    nodeMap.put("type", "task");
                    nodeMap.put("tasks", (String)((Object)tasks));
                    nodeMapList.add(nodeMap);
                } else {
                    tasks = (List)nodeMap.get("tasks");
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("taskId", taskEntity.getId());
                hashMap.put("startTime", taskEntity.getCreateTime());
                hashMap.put("formKey", taskEntity.getFormKey());
                userIds = new ArrayList();
                identityLinks = taskEntity.getCandidates();
                for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                    HashMap<String, String> user2 = new HashMap<String, String>();
                    user2.put("assignee", identityLinkEntity.getUserId());
                    if (identityLinkEntity.getMandator() != null) {
                        user2.put("owner", identityLinkEntity.getMandator());
                    }
                    userIds.add(user2);
                }
                if (taskEntity.getAssignee() != null) {
                    user = new HashMap<String, String>();
                    user.put("assignee", taskEntity.getAssignee());
                    userIds.add(user);
                }
                hashMap.put("assignee", userIds);
                tasks.add(hashMap);
            }
            nodeMessageMap.put(subProcessNodeId, subProcessMap);
        }
        for (HistoricActivityInstance historicActivityInstance : historicProcessInstanceEntities) {
            boolean isMultiSubProcess;
            if (historicActivityInstance.getSubProcessKey() == null) {
                map = new HashMap<String, Object>();
                map.put("taskDefinitionKey", historicActivityInstance.getActivityId());
                map.put("taskDefinitionName", historicActivityInstance.getActivityName());
                map.put("type", "receiveTask");
                map.put("executionId", historicActivityInstance.getExecutionId());
                map.put("startTime", historicActivityInstance.getStartTime());
                nodeMessageMap.put(historicActivityInstance.getActivityId(), map);
                continue;
            }
            subProcessKeyMessage = historicActivityInstance.getSubProcessKey().split(":");
            subProcessNodeId = subProcessKeyMessage[0];
            subProcessMap = (Map)nodeMessageMap.get(subProcessNodeId);
            boolean bl = isMultiSubProcess = !"".equals(subProcessKeyMessage[1]);
            if (subProcessMap == null) {
                subProcessMap = new HashMap();
                subProcessMap.put("taskDefinitionKey", subProcessNodeId);
                subProcessMap.put("taskDefinitionName", bpmnModel.getFlowElement(subProcessNodeId).getName());
                subProcessMap.put("type", isMultiSubProcess ? "multiSubProcess" : "subProcess");
            }
            if (isMultiSubProcess) {
                subProcessVariable = subProcessKeyMessage[1];
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (List)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                nodeMap = new HashMap<String, String>();
                nodeMap.put("taskDefinitionKey", historicActivityInstance.getActivityId());
                nodeMap.put("taskDefinitionName", historicActivityInstance.getActivityName());
                nodeMap.put("type", "receiveTask");
                nodeMap.put("executionId", historicActivityInstance.getExecutionId());
                nodeMap.put("startTime", (String)((Object)historicActivityInstance.getStartTime()));
                nodeMapList.add(nodeMap);
                subProcessMap.put("subProcess", subProcess);
            } else {
                subProcessVariable = "";
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (List)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                subProcessMap.put("subProcess", subProcess);
                nodeMap = new HashMap();
                nodeMap.put("taskDefinitionKey", historicActivityInstance.getActivityId());
                nodeMap.put("taskDefinitionName", historicActivityInstance.getActivityName());
                nodeMap.put("type", "receiveTask");
                nodeMap.put("executionId", historicActivityInstance.getExecutionId());
                nodeMap.put("startTime", (String)((Object)historicActivityInstance.getStartTime()));
                nodeMapList.add(nodeMap);
            }
            nodeMessageMap.put(subProcessNodeId, subProcessMap);
        }
        for (HistoricActivityInstance historicActivityInstance : historicCallActivityEntities) {
            map = new HashMap();
            map.put("taskDefinitionKey", historicActivityInstance.getActivityId());
            map.put("taskDefinitionName", historicActivityInstance.getActivityName());
            map.put("type", "callActivity");
            map.put("startTime", historicActivityInstance.getStartTime());
            nodeMessageMap.put(historicActivityInstance.getActivityId(), map);
        }
        nodeMessages.addAll(nodeMessageMap.values());
        this.fireEvent(historicProcessInstance.getProcessDefinitionId(), message);
        return null;
    }

    private void fireEvent(String procDefId, Map<String, Object> message) {
        BpmnModel bpmnModel = repositoryService.getBpmnModel(procDefId);
        if (bpmnModel != null) {
            Process process = bpmnModel.getMainProcess();
            List executionListeners = process.getExecutionListeners();
            for (ActivitiListener activitiListener : executionListeners) {
                String event = activitiListener.getEvent();
                if (!"action".equals(event)) continue;
                String beanId = activitiListener.getImplementation();
                boolean isAsyn = false;
                String listenerModel = "";
                String requestMethod = "";
                List fieldExtensions = activitiListener.getFieldExtensions();
                for (FieldExtension fieldExtension : fieldExtensions) {
                    if ("isAsyn".equals(fieldExtension.getFieldName())) {
                        isAsyn = Boolean.parseBoolean(fieldExtension.getStringValue());
                    }
                    if ("listenerModel".equals(fieldExtension.getFieldName())) {
                        listenerModel = String.valueOf(fieldExtension.getStringValue());
                    }
                    if (!"requestMethod".equals(fieldExtension.getFieldName())) continue;
                    requestMethod = String.valueOf(fieldExtension.getStringValue());
                }
                try {
                    String serviceName = String.valueOf(modelService.getServiceName(procDefId.split(",")[0]));
                    WorkflowListenerUtils.executionListener(listenerModel, requestMethod, beanId, message, serviceName);
                }
                catch (Exception e) {
                    JSONObject jsonObject;
                    Object nodeMessage;
                    logger.error(e.getMessage(), (Throwable)e);
                    if (isAsyn) continue;
                    BpmExceptionMessageParam bpmExceptionMessageParam = new BpmExceptionMessageParam();
                    bpmExceptionMessageParam.setProcessKey(procDefId.split(":")[0]);
                    bpmExceptionMessageParam.setProcessName(((Process)bpmnModel.getProcesses().get(0)).getName());
                    bpmExceptionMessageParam.setProcessDefinitionId(procDefId);
                    String taskDefKey = " ";
                    String taskDefName = " ";
                    if (HussarUtils.isNotEmpty((Object)message.get("nodeMessage")) && HussarUtils.isNotEmpty((Object)(nodeMessage = JSON.parseArray((String)JSON.toJSONString((Object)message.get("nodeMessage"))).get(0))) && "task".equals((jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)nodeMessage))).getString("type"))) {
                        taskDefKey = jsonObject.getString("taskDefinitionKey");
                        taskDefName = jsonObject.getString("taskDefinitionName");
                    }
                    bpmExceptionMessageParam.setTaskDefinitionKey(taskDefKey);
                    bpmExceptionMessageParam.setTaskDefinitionName(taskDefName);
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_EXECUTION_LISTENER_WHEN_EVENT.format(new Object[]{PROCESS_ACTION_EVENT}), bpmExceptionMessageParam);
                }
            }
        }
    }
}

