/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActPostAction;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActPostActionService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DeleteModelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DownloadFilesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.AheadAction;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BehindAction;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.PostAction;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ModelServiceImpl
extends ServiceImpl<ModelMapper, ModelBuild>
implements ModelService {
    private static Logger logger = LoggerFactory.getLogger(ModelServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    private static final String SUFFIX = ".bpmn20.xml";
    @Resource
    private ISysActPostActionService iSysActPostActionService;
    @Autowired
    private IProcessGroupService processGroupService;
    private static final String USERTASK_NAME = "com.jxdinfo.workflow.User";

    public String deployModel(Long modelId) {
        try {
            Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(true);
            modelData.setDeploymentId(deployment.getId());
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelData.getKey(), Integer.valueOf(0));
            modelData.setCategory(workFlow.getCategory());
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).latestVersion().singleResult();
            this.saveModelExtendProperties(workFlow, processDefinition.getId());
            workFlow.setProcDefId(processDefinition.getId());
            workFlow.setVersion(String.valueOf(processDefinition.getVersion()));
            this.sysActProcessFileService.addFile(workFlow, null);
            this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String deployModel(String modelId) {
        return this.deployModel(Long.parseLong(modelId));
    }

    public ModelBuild queryModel(Long modelId) {
        return this.modelMapper.queryModel(modelId);
    }

    public ModelBuild queryModel(String modelId) {
        return this.modelMapper.queryModel(Long.parseLong(modelId));
    }

    public void addNodeSaveModelExtendProperties(BpmnModel bpmnModel, String defId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(defId);
        this.saveModelExtendProperties(bpmnModel, processDefinition);
    }

    public void addNodeSaveModelExtendProperties(WorkFlow workFlow, String defId) {
        this.saveModelExtendProperties(workFlow, defId);
    }

    public String deployModelByWorkFlowXml(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String processInsId, String version) {
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(false);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(workFlow, processDefinition.getId());
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, null);
        this.processDefinitionsService.setVersionTemporary(processDefinition.getId());
        this.saveProcessExtendProperties(processDefinition.getId(), workFlow);
        if (processInsId == null) {
            this.processDefinitionsService.editTemporaryDefId(processDefinition.getId(), version);
        } else {
            this.processDefinitionsService.editTemporaryDefId(processDefinition.getId(), processInsId, version);
        }
        this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinition.getId()));
        return processDefinition.getId();
    }

    private void saveProcessExtendProperties(String processId, WorkFlow workFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowProps flowProps = flowModel.getProps();
        ProcessExtendProperties processExtendProperties = new ProcessExtendProperties();
        processExtendProperties.setAllowNullApprover(flowProps.getAllowNullApprover());
        processExtendProperties.setCopyAttachmentAtRectification(flowProps.getCopyAttachmentAtRectification());
        processExtendProperties.setMustUploadAttachment(flowProps.getMustUploadAttachment());
        processExtendProperties.setRuleOfHiApproverAtApproval(Integer.valueOf(flowProps.getRuleOfHiApproverAtApproval()));
        processExtendProperties.setRectificationBeanId(flowProps.getRectificationBeanId());
        JSONObject viewFormAddressJsonObject = JSON.parseObject((String)flowProps.getFlowFormDetailAddress());
        JSONObject viewFormAddressObject = new JSONObject();
        if (viewFormAddressJsonObject != null) {
            for (String key : viewFormAddressJsonObject.keySet()) {
                viewFormAddressObject.put(key, viewFormAddressJsonObject.getJSONObject(key).get((Object)"url"));
            }
        }
        processExtendProperties.setViewFormAddress(viewFormAddressJsonObject != null ? JSON.toJSONString((Object)viewFormAddressObject) : null);
        JSONObject editFormAddressJsonObject = JSON.parseObject((String)flowProps.getFlowFormAddress());
        JSONObject editFormAddressObject = new JSONObject();
        if (editFormAddressJsonObject != null) {
            for (String key : editFormAddressJsonObject.keySet()) {
                editFormAddressObject.put(key, editFormAddressJsonObject.getJSONObject(key).get((Object)"url"));
            }
        }
        processExtendProperties.setEditFormAddress(editFormAddressJsonObject != null ? JSON.toJSONString((Object)editFormAddressObject) : null);
        this.processDefinitionsService.setProcessExtendProperties(processId, processExtendProperties);
    }

    private void saveModelExtendProperties(WorkFlow workFlow, String processId) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List flowObjects = flowModel.getSlots().getElement() != null ? flowModel.getSlots().getElement() : new ArrayList();
        ArrayList<Object> sysActExtendProperties = new ArrayList<Object>();
        for (FlowObject flowObject : flowObjects) {
            if (!USERTASK_NAME.equals(flowObject.getName())) continue;
            FlowProps flowProps = flowObject.getProps();
            SysActExtendProperties approvalExtends = new SysActExtendProperties();
            approvalExtends.setApprovalType(flowProps.getApprovalType());
            approvalExtends.setAdaptApprover(flowProps.getAdaptApprover());
            approvalExtends.setAddApprovalNode(flowProps.getAddApprovalNode());
            approvalExtends.setSetApprovalRemind(flowProps.getSetApprovalRemind());
            approvalExtends.setInitApprovalDisplay(flowProps.getInitApprovalDisplay());
            approvalExtends.setAddApprovalNodeAfterOther(flowProps.getAddApprovalNodeAfterOther());
            approvalExtends.setAdaptSubsequentApprover(flowProps.getAdaptSubsequentApprover());
            approvalExtends.setTaskDefKey(flowObject.getInstanceKey());
            approvalExtends.setTaskDefName(flowProps.getFlowName());
            approvalExtends.setAllowEditForm(flowProps.getAllowEditForm());
            approvalExtends.setProcDefId(processId);
            approvalExtends.setAllowAlterTaskToOther(flowProps.getAllowAlterTaskToOther());
            approvalExtends.setAllowAlterTask(flowProps.getAllowAlterTask());
            approvalExtends.setAlterNodeRelation(flowProps.getAlterNodeRelation());
            approvalExtends.setAttachmentType(flowProps.getAttachmentType());
            approvalExtends.setNumberOfAttachment(flowProps.getNumberOfAttachment());
            approvalExtends.setApproveOption(flowProps.getApproveOption());
            approvalExtends.setNumberOfApprover(flowProps.getNumberOfApprover());
            approvalExtends.setApprovalOrSign(flowProps.getFlowCountersign().isCountersign() ? "2" : flowProps.getApprovalOrSign());
            PostAction postAction = flowProps.getPostAction();
            if (postAction != null) {
                List behindActions;
                AheadAction aheadAction = postAction.getAheadAction();
                if (aheadAction != null) {
                    if (aheadAction.getFormAddress() != null) {
                        approvalExtends.setAheadActionFormAddress(aheadAction.getFormAddress().get((Object)"url") != null ? JSON.toJSONString((Object)aheadAction.getFormAddress().get((Object)"url")) : null);
                        approvalExtends.setAheadActionFormName(aheadAction.getFormAddress().get((Object)"desc") != null ? String.valueOf(aheadAction.getFormAddress().get((Object)"desc")) : null);
                    }
                    approvalExtends.setAheadActionFormType(aheadAction.getFormType());
                    approvalExtends.setAheadActionIsUsed(aheadAction.getUsed() != null ? aheadAction.getUsed() : false);
                    approvalExtends.setFrontActionUrl(aheadAction.getFrontActionUrl());
                    approvalExtends.setHussarSystem(aheadAction.isHussarSystem());
                    approvalExtends.setDefaultPrefix(aheadAction.isDefaultPrefix());
                }
                if ((behindActions = postAction.getBehindAction()) != null && !behindActions.isEmpty()) {
                    ArrayList<SysActPostAction> sysActPostActions = new ArrayList<SysActPostAction>();
                    for (BehindAction behindAction : behindActions) {
                        SysActPostAction sysActPostAction = new SysActPostAction(null, processId, flowObject.getInstanceKey(), flowProps.getFlowName(), behindAction.getType(), behindAction.getTypeName(), behindAction.getIsChecked(), behindAction.getIsUseInterface().toString(), behindAction.getUrl(), behindAction.getRoutingKey(), behindAction.getIsHussarSystem(), behindAction.getIsExecuteSql(), behindAction.getDataSource(), behindAction.getSql());
                        sysActPostAction.setDefaultPrefix(aheadAction.isDefaultPrefix());
                        sysActPostActions.add(sysActPostAction);
                    }
                    this.iSysActPostActionService.saveOrUpdateBatch(sysActPostActions);
                }
            }
            sysActExtendProperties.add(approvalExtends);
        }
        if (!sysActExtendProperties.isEmpty()) {
            ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
            ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
            QueryChainWrapper queryWrapper = this.iSysActExtendPropertiesService.query();
            for (SysActExtendProperties sysActExtendProperties2 : sysActExtendProperties) {
                String string = sysActExtendProperties2.getProcDefId();
                String taskDefKey = sysActExtendProperties2.getTaskDefKey();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_ID", (Object)string)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey);
            }
            List sameList = queryWrapper.list();
            for (SysActExtendProperties sysActExtendProperties3 : sysActExtendProperties) {
                boolean isadd = true;
                for (SysActExtendProperties actExtendProperties : sameList) {
                    if (!sysActExtendProperties3.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperties3.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                    sysActExtendProperties3.setId(actExtendProperties.getId());
                    updateList.add(sysActExtendProperties3);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActExtendProperties3);
            }
            this.iSysActExtendPropertiesService.saveBatch(addList);
            this.iSysActExtendPropertiesService.updateBatchById(updateList);
        }
    }

    private void saveModelExtendProperties(BpmnModel model, ProcessDefinition processDefinition) {
        ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
        String procDefId = processDefinition.getId();
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            for (FlowElement node : flowElements) {
                if (node instanceof UserTask) {
                    JSONObject jsonObject;
                    JSONObject jsonObject2;
                    JSONObject jsonObject3;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    String assistFormDetailKey = this.getAssistFormDetailKey(userTask);
                    String ccFormDetailKey = this.getCcFormDetailKey(userTask);
                    String formId = "";
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{formDetailKey, assistFormDetailKey, ccFormDetailKey})) continue;
                    JSONObject formDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)formDetailKey) && (jsonObject3 = JSON.parseObject((String)formDetailKey)) != null) {
                        for (Object key : jsonObject3.keySet()) {
                            formDetailKeyObject.put((String)key, jsonObject3.getJSONObject((String)key).get((Object)"url"));
                            formId = (String)jsonObject3.getJSONObject((String)key).get((Object)"id");
                        }
                    }
                    JSONObject assistFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)assistFormDetailKey) && (jsonObject2 = JSON.parseObject((String)assistFormDetailKey)) != null) {
                        Object key;
                        key = jsonObject2.keySet().iterator();
                        while (key.hasNext()) {
                            String key2 = (String)key.next();
                            assistFormDetailKeyObject.put(key2, jsonObject2.getJSONObject(key2).get((Object)"url"));
                        }
                    }
                    JSONObject ccFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)ccFormDetailKey) && (jsonObject = JSON.parseObject((String)ccFormDetailKey)) != null) {
                        for (Object key : jsonObject.keySet()) {
                            ccFormDetailKeyObject.put((String)key, jsonObject.getJSONObject((String)key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)formDetailKeyObject));
                    asep.setAssistFormDetailKey(JSON.toJSONString((Object)assistFormDetailKeyObject));
                    asep.setCcFormDetailKey(JSON.toJSONString((Object)ccFormDetailKeyObject));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    asep.setFormId(formId);
                    sysActExtendProperties.add(asep);
                    continue;
                }
                if (!(node instanceof SubProcess)) continue;
                SubProcess subProcess = (SubProcess)node;
                for (FlowElement element : subProcess.getFlowElements()) {
                    JSONObject jsonObject;
                    JSONObject jsonObject4;
                    JSONObject jsonObject5;
                    if (!(element instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)element;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    String assistFormDetailKey = this.getAssistFormDetailKey(userTask);
                    String ccFormDetailKey = this.getCcFormDetailKey(userTask);
                    String formId = "";
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{formDetailKey, assistFormDetailKey, ccFormDetailKey})) continue;
                    JSONObject formDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)formDetailKey) && (jsonObject5 = JSON.parseObject((String)formDetailKey)) != null) {
                        Object key;
                        key = jsonObject5.keySet().iterator();
                        while (key.hasNext()) {
                            String key3 = (String)key.next();
                            formDetailKeyObject.put(key3, jsonObject5.getJSONObject(key3).get((Object)"url"));
                            formId = (String)jsonObject5.getJSONObject(key3).get((Object)"id");
                        }
                    }
                    JSONObject assistFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)assistFormDetailKey) && (jsonObject4 = JSON.parseObject((String)assistFormDetailKey)) != null) {
                        for (String key : jsonObject4.keySet()) {
                            assistFormDetailKeyObject.put(key, jsonObject4.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    JSONObject ccFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)ccFormDetailKey) && (jsonObject = JSON.parseObject((String)ccFormDetailKey)) != null) {
                        for (String key : jsonObject.keySet()) {
                            ccFormDetailKeyObject.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)formDetailKeyObject));
                    asep.setAssistFormDetailKey(JSON.toJSONString((Object)assistFormDetailKeyObject));
                    asep.setCcFormDetailKey(JSON.toJSONString((Object)ccFormDetailKeyObject));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    asep.setFormId(formId);
                    sysActExtendProperties.add(asep);
                }
            }
        }
        if (!sysActExtendProperties.isEmpty()) {
            ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
            ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
            QueryChainWrapper queryWrapper = this.iSysActExtendPropertiesService.query();
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                String getProcDefId = sysActExtendProperty.getProcDefId();
                String taskDefKey = sysActExtendProperty.getTaskDefKey();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_ID", (Object)getProcDefId)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey);
            }
            List sameList = queryWrapper.list();
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                boolean isadd = true;
                for (SysActExtendProperties actExtendProperties : sameList) {
                    if (!sysActExtendProperty.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperty.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                    sysActExtendProperty.setId(actExtendProperties.getId());
                    updateList.add(sysActExtendProperty);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActExtendProperty);
            }
            this.iSysActExtendPropertiesService.saveBatch(addList);
            this.iSysActExtendPropertiesService.updateBatchById(updateList);
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        if (HussarUtils.isNotEmpty((Object)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes())) {
            return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
        }
        return null;
    }

    private String getAssistFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("assistFlowFormDetailKey")).get(0)).getAttributes().get("assistFlowFormDetailKey")).get(0)).getValue();
    }

    private String getCcFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("ccFlowFormDetailKey")).get(0)).getAttributes().get("ccFlowFormDetailKey")).get(0)).getValue();
    }

    public IPage<ModelBuild> queryModelList(String modelName, Boolean published, Page<ModelBuild> page, String businessModuleId) {
        try {
            List<ModelBuild> list = this.modelMapper.queryModelList(page, modelName, published, businessModuleId);
            for (ModelBuild modelBuild : list) {
                JSONObject jsonObject;
                if ("1".equals(modelBuild.getPublished())) {
                    jsonObject = JSON.parseObject((String)modelBuild.getDescription());
                    modelBuild.setDescription(jsonObject.getString("description"));
                    continue;
                }
                jsonObject = JSON.parseObject((String)new String(modelBuild.getContent(), StandardCharsets.UTF_8));
                modelBuild.setDescription(jsonObject.getString("description"));
            }
            page.setRecords(list);
            return page;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BpmException(BpmExceptionCodeEnum.MODEL_QUERY_ERROR);
        }
    }

    @CacheEvict(value={"workflow_file", "form_detail_key", "service_name", "workflow_file_by_key", "workflow_file_by_id", "get_file_by_process_key_and_id"}, allEntries=true)
    public ApiResponse<String> deleteModel(Long modelId) {
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(modelId, null))) {
            String processKey = this.modelMapper.getIdentityById(modelId);
            this.repositoryService.deleteModel(String.valueOf(modelId));
            this.sysActAssigneeService.delAssignee(processKey);
            this.modelMapper.deleteModelDef(modelId, null);
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getModelId, (Object)modelId));
            this.processGroupService.deleteProcessModel(processKey);
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        throw new BpmException(BpmExceptionCodeEnum.DELETE_RUNNING_FAIL);
    }

    public ApiResponse<String> deleteModel(String modelId) {
        return this.deleteModel(Long.parseLong(modelId));
    }

    public ApiResponse<String> deleteModel(DeleteModelDto deleteModelDto) {
        if (HussarUtils.isEmpty((Object)deleteModelDto.getModelId())) {
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)deleteModelDto.getIdentity()));
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        return this.deleteModel(deleteModelDto.getModelId());
    }

    @CacheEvict(value={"workflow_file", "form_detail_key", "service_name", "workflow_file", "workflow_file_by_key", "workflow_file_by_id", "get_file_by_process_key_and_id"}, allEntries=true)
    public ApiResponse<String> deleteModelWithVersion(String processDefId) {
        String procDefKey = processDefId.split(":")[0];
        int version = Integer.parseInt(processDefId.split(":")[1]);
        this.processDefinitionsService.canModelDeleteWithVersion(procDefKey);
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefId))) {
            this.processGroupService.canDeleteProcess(procDefKey, processDefId, () -> {
                String oldMainProcDefId = this.processDefinitionsService.getStartProcessDefinitionId(procDefKey, null);
                this.modelMapper.deleteModelDef(null, processDefId);
                this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefId));
                this.sysActAssigneeService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
                if (processDefId.equals(oldMainProcDefId)) {
                    this.sysActProcessFileService.copyFiles(procDefKey, null);
                }
                return true;
            });
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        throw new BpmException(BpmExceptionCodeEnum.DELETE_RUNNING_FAIL);
    }

    public ApiResponse<String> deleteModelByLogic(Long modelId, String isDelete) {
        String message = "";
        message = this.modelMapper.updateIsDelete(modelId, isDelete) > 0 ? BpmEnum.DELETE_SUCCESS.getMessage() : BpmEnum.DELETE_FAIL.getMessage();
        return ApiResponse.success((String)message);
    }

    public ApiResponse<String> deleteModelWithVersionByLogic(String tenantId, String processDefId, String isDeleteVersion) {
        String message = "";
        message = this.processGroupService.canDeleteProcess(null, processDefId, () -> this.modelMapper.updateIsDeleteVersion(processDefId, isDeleteVersion) > 0) ? BpmEnum.DELETE_SUCCESS.getMessage() : BpmEnum.DELETE_FAIL.getMessage();
        return ApiResponse.success((String)message);
    }

    public String getIdByIdentity(String identity) {
        return this.modelMapper.getIdByIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        InputStream in = null;
        OutputStream out = null;
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            long time = System.currentTimeMillis();
            ZipFile zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (filePath + time + File.separator + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                File file = new File(outPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
                in.close();
                out.close();
            }
            zip.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private List<String> getAllFile(File file) {
        if (file == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            return list;
        }
        for (File f : file.listFiles()) {
            String suffix;
            if (f.isDirectory()) {
                list.addAll(this.getAllFile(f));
                continue;
            }
            if (f.getPath().lastIndexOf(46) <= 0 || !"xml".equals(suffix = f.getPath().substring(f.getPath().lastIndexOf(46) + 1)) && !"lcdpbpm".equals(suffix)) continue;
            list.add(f.getPath());
        }
        return list;
    }

    public List<ModelBuild> getAllModel() {
        return this.modelMapper.getAllModel();
    }

    public List<ModelBuild> getAllModelWithBusinessModelId() {
        return this.modelMapper.getAllModelWithBusinessModelId();
    }

    public ApiResponse<String> importModel(MultipartFile file, HttpServletRequest request) {
        InputStream in = null;
        FileOutputStream out = null;
        String fileName = System.currentTimeMillis() + ".zip";
        try {
            in = file.getInputStream();
            File files = new File(this.hussarConfig.getFileUploadPath() + File.separator + fileName);
            if (!files.getParentFile().exists()) {
                files.getParentFile().mkdirs();
            }
            try {
                boolean isCreateNewFile = files.createNewFile();
                if (!isCreateNewFile) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                    throw new BpmException(BpmExceptionCodeEnum.UPLOAD_PATH_ERROR);
                }
            }
            catch (IOException e) {
                throw new BpmException(BpmExceptionCodeEnum.UPLOAD_PATH_ERROR);
            }
            out = new FileOutputStream(files);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
            List<String> fileList = this.unZipFile(this.hussarConfig.getFileUploadPath() + File.separator + fileName, this.hussarConfig.getFileUploadPath(), request);
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                files = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)files, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u538b\u7f29\u6587\u4ef6");
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_IMPORT);
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                XMLStreamReader xtr = xif.createXMLStreamReader(in);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                String identityId = this.modelMapper.getIdByIdentity(modelKey);
                Model modelData = null;
                if (HussarUtils.isEmpty((Object)identityId)) {
                    modelData = this.repositoryService.newModel();
                    ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    modelData.setMetaInfo(modelObjectNode.toString());
                    modelData.setName(impModelName);
                    modelData.setKey(modelKey);
                    this.repositoryService.saveModel(modelData);
                }
                ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                jsonConverter.updateConvertersToBpmnMap();
                jsonConverter.updateConvertersToJsonMap();
                ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                identityId = identityId == null ? modelData.getId() : identityId;
                this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
                workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
                this.deployModel(Long.parseLong(identityId));
            }
            ApiResponse apiResponse = ApiResponse.success((String)BpmEnum.IMPORT_SUCCESS.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_IMPORT);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean importModel(File file, List<String> coverList) {
        InputStream in = null;
        try {
            File f = null;
            List<String> fileList = this.getAllFile(file);
            if (fileList == null) {
                logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                throw new NullPointerException("\u9519\u8bef\u6587\u4ef6\u5939");
            }
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                f = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)f, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                    Boolean bl = false;
                    return bl;
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                if (!HussarUtils.isNotEmpty((Object)jsonArray)) continue;
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                try {
                    XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                    XMLStreamReader xtr = xif.createXMLStreamReader(in);
                    BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                    String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                    String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                    String identityId = this.modelMapper.getIdByIdentity(modelKey);
                    if (HussarUtils.isNotEmpty((Object)identityId)) {
                        if (HussarUtils.isNotEmpty(coverList.stream().filter(modelKey::equals).findFirst().orElse(null))) {
                            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
                            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
                            updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)));
                            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
                            continue;
                        }
                    }
                    if (HussarUtils.isEmpty((Object)identityId)) {
                        Model modelData = this.repositoryService.newModel();
                        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                        modelObjectNode.put("name", impModelName);
                        modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                        modelObjectNode.put("revision", 1);
                        modelData.setMetaInfo(modelObjectNode.toString());
                        modelData.setName(impModelName);
                        modelData.setKey(modelKey);
                        this.repositoryService.saveModel(modelData);
                        identityId = modelData.getId();
                    }
                    ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                    jsonConverter.updateConvertersToBpmnMap();
                    jsonConverter.updateConvertersToJsonMap();
                    ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                    this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                    WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
                    if (workFlow == null) {
                        logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                        throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
                    }
                    workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                    this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
                    this.deployModel(Long.parseLong(identityId));
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String exportAllFileModel(String keys, File file) {
        ByteArrayInputStream in = null;
        List<ExportModel> models = this.modelMapper.getModelWithKey(Arrays.asList(keys.split(",")));
        if (HussarUtils.isEmpty(models)) {
            return file.getPath();
        }
        try {
            HashMap fileMap = new HashMap();
            for (ExportModel model : models) {
                if (HussarUtils.isEmpty((Object)model.getDeploymentId())) continue;
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                File xmlFile = new File(file, filename);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)xmlFile);
                in.close();
            }
            List list = null;
            list = this.sysActProcessFileService.exportFileListByKeys(Arrays.asList(keys.split(",")));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("file", list);
            data.put("export_type", "lcdpbpm");
            File lcdpbpm = new File(file, "workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss_SSS") + ".lcdpbpm");
            if (!lcdpbpm.isFile()) {
                try {
                    FileUtils.write((File)lcdpbpm, (CharSequence)JSON.toJSONString(data), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BpmException(BpmExceptionCodeEnum.MODEL_EXPERT_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return file.getPath();
    }

    public void exportAllFileModel(String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ZipOutputStream zipOutputStream = null;
        ByteArrayInputStream in = null;
        List<String> str = Arrays.asList(modelId.split(","));
        List<Long> cdids = str.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<ExportModel> models = this.modelMapper.getModelWithVersion(cdids);
        try {
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
            HashMap fileMap = new HashMap();
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (ExportModel model : models) {
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                ZipEntry zipEntry = new ZipEntry(filename);
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                in.close();
            }
            this.toFileZip(modelId, null, zipOutputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BpmException(BpmExceptionCodeEnum.MODEL_EXPERT_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFileZip(String modelId, String procId, ZipOutputStream out) {
        List list;
        ZipOutputStream zipOutputStream = null;
        if (HussarUtils.isNotEmpty((Object)modelId)) {
            List<String> models = Arrays.asList(modelId.split(","));
            list = this.sysActProcessFileService.exportFileList(models);
        } else {
            list = this.sysActProcessFileService.exportFile(procId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", list);
        data.put("export_type", "lcdpbpm");
        zipOutputStream = out;
        try {
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)new ZipEntry("workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".lcdpbpm"));
            ByteArrayInputStream in = new ByteArrayInputStream(JSON.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            in.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ApiResponse<String> validationProcess(String processKey, String businessId, String userId, Map<String, Object> variables) {
        return ApiResponse.success((Object)"", (String)"");
    }

    public ApiResponse<JSONArray> doneList(String businessId) {
        BpmResponseResult bpmResponseResult = this.instanceEngineService.getDoneProcessTrace(businessId);
        if (HussarUtils.equals((Object)bpmResponseResult.getCode(), (Object)"1")) {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        throw new BpmException(bpmResponseResult.getMsg());
    }

    public String getRealVersion(String processDefId) {
        return this.modelMapper.getRealVersion(processDefId);
    }

    @Cacheable(value={"service_name"}, key="'service_name:'+#processKey", unless="#result == null")
    public String getServiceName(String processKey) {
        return this.modelMapper.getServiceName(processKey);
    }

    @CacheEvict(value={"service_name"}, allEntries=true)
    public int updateCategory(String identity, String category) {
        return this.modelMapper.updateCategory(identity, category);
    }

    public void downloadFiles(DownloadFilesDto downloadFilesDto, HttpServletResponse response) {
        String deploymentId = downloadFilesDto.getDeploymentId() == null ? "" : downloadFilesDto.getDeploymentId();
        String resourceName = downloadFilesDto.getResourceName() == null ? "" : downloadFilesDto.getResourceName();
        DefinitionModel processDefinitionModel = this.processDefinitionsMapper.getById(deploymentId);
        String key = processDefinitionModel.getId();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
        response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
        HashMap fileMap = new HashMap();
        ArrayList files = new ArrayList();
        fileMap.put(processDefinitionModel.getName(), files);
        String filename = processDefinitionModel.getName() + "_" + key.split(":")[0] + "/" + key.replace(":", "_") + SUFFIX;
        ZipEntry zipEntry = new ZipEntry(filename);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
             ByteArrayInputStream in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            this.toFileZip(null, key, zipOutputStream);
        }
        catch (IOException e) {
            throw new BpmException(BpmExceptionCodeEnum.FILE_ZIP_ERROR);
        }
    }

    public String getRealProcessDefinitionId(String processKey, String realVersion) {
        return this.modelMapper.getRealProcessDefinitionId(processKey, realVersion);
    }

    public Map<String, String> selectModelNames(List<String> processKey) {
        List<ExportModel> nameList = this.modelMapper.selectModelNames(processKey);
        HashMap<String, String> modelNames = new HashMap<String, String>();
        for (ExportModel exportModel : nameList) {
            modelNames.put(exportModel.getBusinessId(), exportModel.getName());
        }
        return modelNames;
    }
}

