/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import cn.hutool.core.date.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IExecuteSqlService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.ProcessState;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessStateChangeLis {
    private static Logger logger = LogManager.getLogger(ProcessStateChangeLis.class);
    @Autowired
    private IExecuteSqlService executeSqlService;
    @Autowired
    private SysActProcessFileService processFileService;

    public void ProcessStateChange(ProcessInstance processInstance, ProcessState processState) {
        try {
            logger.info("\u8bd5\u56fe\u4fee\u6539\u6d41\u7a0b\u5b9e\u4f8b{}\u5bf9\u5e94\u7684\u4e1a\u52a1\u4fe1\u606f", (Object)processInstance.getId());
            String processDefinitionId = processInstance.getProcessDefinitionId();
            List processFiles = this.processFileService.getProcessFile(processDefinitionId);
            if (HussarUtils.isNotEmpty((Object)processFiles)) {
                SysActProcessFile processFile = (SysActProcessFile)processFiles.get(0);
                this.tryUpdateBusinessTable(processInstance, processState, processFile);
            } else {
                logger.info("\u672a\u53d1\u73b0\u8be5\u6d41\u7a0b\u7684\u6d41\u7a0b\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void tryUpdateBusinessTable(ProcessInstance processInstance, ProcessState processState, SysActProcessFile processFile) {
        String remoteDbName = processFile.getRemoteDbName();
        String businessMainTable = processFile.getBusinessMainTable();
        String businessMainTableKey = processFile.getBusinessMainTableKey();
        String businessMainTableName = processFile.getBusinessMainTableName();
        String businessMainTableState = processFile.getBusinessMainTableState();
        String approvalStartTime = processFile.getApprovalStartTime();
        String approvalEndTime = processFile.getApprovalEndTime();
        String lastUpdateTime = processFile.getLastUpdateTime();
        String processInstanceIdFieldName = processFile.getProcessInstanceIdFieldName();
        logger.info("\u6570\u636e\u6e90:{}\u3001\u4e3b\u8868:{}\u3001\u4e3b\u8868\u4e3b\u952e:{}", (Object)remoteDbName, (Object)businessMainTable, (Object)businessMainTableKey);
        if (HussarUtils.hasEmpty((Object[])new Object[]{remoteDbName, businessMainTable, businessMainTableKey})) {
            logger.info("\u8be5\u6d41\u7a0b\u6570\u636e\u6e90\u3001\u4e3b\u8868\u3001\u4e3b\u8868\u4e3b\u952e\u4e2d\u6709\u7a7a\u503c");
            return;
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{businessMainTableName, businessMainTableState, approvalStartTime, approvalEndTime, lastUpdateTime, processInstanceIdFieldName})) {
            logger.info("\u8be5\u6d41\u7a0b\u5bf9\u5e94\u7684\u4e1a\u52a1\u8868\u4e2d\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5b57\u6bb5");
            return;
        }
        ArrayList<String> updateColumn = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)businessMainTableName)) {
            updateColumn.add(businessMainTableName + " = '" + processState.getLabel() + "'");
        }
        if (HussarUtils.isNotEmpty((Object)businessMainTableState)) {
            updateColumn.add(businessMainTableState + " = '" + processState.getValue() + "'");
        }
        if (ProcessState.RUNNING.equals((Object)processState)) {
            if (HussarUtils.isNotEmpty((Object)approvalStartTime)) {
                updateColumn.add(approvalStartTime + " = '" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "'");
            }
        } else if (!ProcessState.DRAFT.equals((Object)processState) && HussarUtils.isNotEmpty((Object)approvalEndTime)) {
            updateColumn.add(approvalEndTime + " = '" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "'");
        }
        if (HussarUtils.isNotEmpty((Object)lastUpdateTime)) {
            updateColumn.add(lastUpdateTime + " = '" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "'");
        }
        if (HussarUtils.isNotEmpty((Object)processInstanceIdFieldName)) {
            updateColumn.add(processInstanceIdFieldName + " = '" + processInstance.getProcessInstanceId() + "'");
        }
        StringBuilder sql = new StringBuilder().append("UPDATE ").append(businessMainTable).append(" SET ").append(String.join((CharSequence)",", updateColumn)).append(" WHERE ").append(businessMainTableKey).append(" = '").append(processInstance.getBusinessKey()).append("'");
        logger.info("\u6267\u884csql\uff0c{}", (Object)sql.toString());
        Boolean res = this.executeSqlService.updateSql(sql.toString(), remoteDbName);
        logger.info("\u6267\u884csql\u7ed3\u675f\uff0c\u8fd4\u56de\u503c\u4e3a{}", (Object)res);
        if (!Boolean.TRUE.equals(res)) {
            throw new PublicClientException("\u4e1a\u52a1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }
}

