/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processhistory.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiActinstMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiActinst;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.dao.TaskCommentMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.model.vo.PersonnelQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processhistory.dao.SysActProcessHistoryMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processhistory.dto.SysActProcessHistory;
import com.jxdinfo.hussar.workflow.engine.bpm.processhistory.dto.SysActProcessHistoryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processhistory.service.ISysActProcessHistoryService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessHistoryImpl
implements ISysActProcessHistoryService {
    @Resource
    private SysActProcessHistoryMapper sysActProcessHistoryMapper;
    @Resource
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;
    @Resource
    private TaskCommentMapper taskCommentMapper;
    @Resource
    private BpmActHiActinstMapper bpmActHiActinstMapper;

    public ApiResponse<Page<SysActProcessHistory>> list(Page<SysActProcessHistory> page, SysActProcessHistoryDto sysActProcessHistoryDto) {
        Page<SysActProcessHistory> sysActProcessHistoryPage = this.sysActProcessHistoryMapper.list(page, sysActProcessHistoryDto);
        if (sysActProcessHistoryPage.getRecords() != null && !sysActProcessHistoryPage.getRecords().isEmpty()) {
            for (int i = 0; i < sysActProcessHistoryPage.getRecords().size(); ++i) {
                if (((SysActProcessHistory)sysActProcessHistoryPage.getRecords().get(i)).getDuration() == null) continue;
                Long time = ((SysActProcessHistory)sysActProcessHistoryPage.getRecords().get(i)).getDuration() / 1000L;
                ((SysActProcessHistory)sysActProcessHistoryPage.getRecords().get(i)).setShowDuration(time / 86400L + "\u5929" + time / 3600L % 24L + "\u5c0f\u65f6" + time / 60L % 60L + "\u5206" + time % 60L + "\u79d2");
            }
        }
        return ApiResponse.success(sysActProcessHistoryPage);
    }

    public ApiResponse<String> adjustProcessHistory(Map<String, Object> map) {
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String personObject = JSONObject.toJSONString((Object)map.get("checkedCurAduit"));
        PersonnelQueryVo personnelQueryVo = (PersonnelQueryVo)JSONObject.parseObject((String)personObject, PersonnelQueryVo.class);
        String startTime = map.get("startTime").toString();
        String endTime = map.get("endTime").toString();
        LocalDateTime start = LocalDateTime.parse(startTime, dtf1);
        LocalDateTime end = LocalDateTime.parse(endTime, dtf1);
        Duration duration = Duration.between(start, end);
        BpmActHiTaskinst bpmActHiTaskinst = new BpmActHiTaskinst();
        bpmActHiTaskinst.setId(Long.valueOf(map.get("id").toString()));
        bpmActHiTaskinst.setAssignee(personnelQueryVo.getUserId());
        bpmActHiTaskinst.setDeptId(personnelQueryVo.getDepartmentId());
        bpmActHiTaskinst.setUnitId(personnelQueryVo.getUnitId());
        bpmActHiTaskinst.setPostId(personnelQueryVo.getPostId());
        bpmActHiTaskinst.setApprovalNumber(personnelQueryVo.getUserNumber());
        bpmActHiTaskinst.setStartTime(start);
        bpmActHiTaskinst.setEndTime(end);
        bpmActHiTaskinst.setDuration(Long.valueOf(duration.toMillis()));
        this.bpmActHiTaskinstMapper.updateById(bpmActHiTaskinst);
        TaskComment taskComment = new TaskComment();
        taskComment.setId(Long.valueOf(map.get("commentId").toString()));
        taskComment.setMessage(map.get("comment").toString());
        taskComment.setFullMsg(map.get("comment").toString().getBytes());
        taskComment.setUserId(personnelQueryVo.getUserId());
        taskComment.setTime(end);
        this.taskCommentMapper.updateById(taskComment);
        BpmActHiActinst bpmActHiActinst = new BpmActHiActinst();
        bpmActHiActinst.setAssignee(personnelQueryVo.getUserId());
        bpmActHiActinst.setStartTime(start);
        bpmActHiActinst.setEndTime(end);
        bpmActHiActinst.setDuration(Long.valueOf(duration.toMillis()));
        this.bpmActHiActinstMapper.update(bpmActHiActinst, (Wrapper)new LambdaQueryWrapper().eq(BpmActHiActinst::getTaskId, (Object)Long.valueOf(map.get("id").toString())));
        return ApiResponse.success((String)"success");
    }
}

