/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.ApprovalUser;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dao.BpmActPendingTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dto.PendingListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dto.PendingTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.model.BpmActPendingTask;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.model.SubCandidate;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.service.ISubCandidateService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.BuildDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmActPendingTaskServiceImpl
extends HussarServiceImpl<BpmActPendingTaskMapper, BpmActPendingTask>
implements BpmActPendingTaskService {
    private static final Logger logger = LoggerFactory.getLogger(BpmActPendingTaskServiceImpl.class);
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    private static final List<String> ACTIVITY_TYPES = Arrays.asList("userTask", "receiveTask", "callActivity");
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private BpmActPendingTaskMapper bpmActPendingTaskMapper;
    @Resource
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private SqlConditionHandleService sqlConditionHandleService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ISubCandidateService subCandidateService;
    @Autowired
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private ISysActProcessDeptService processDeptService;
    private static final Set<String> simpleVariableType = new HashSet<String>();

    public ApiResponse<Page<PendingTaskVo>> queryList(PendingListDto pendingListDto) {
        Page pages = new Page((long)pendingListDto.getPage().intValue(), (long)pendingListDto.getSize().intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = HussarUtils.isNotEmpty((Object)pendingListDto.getStartTime()) ? format.parse(pendingListDto.getStartTime()) : null;
            endTime = HussarUtils.isNotEmpty((Object)pendingListDto.getEndTime()) ? format.parse(pendingListDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<PendingTaskVo> pendingTaskVoList = this.bpmActPendingTaskMapper.query((Page<PendingTaskVo>)pages, pendingListDto.getUserId(), pendingListDto.getProcessKey(), pendingListDto.getStartTime(), startTime, endTime, pendingListDto.getTodoConfiguration());
        HashSet<String> userIdSet = new HashSet<String>();
        for (PendingTaskVo pendingTaskVo : pendingTaskVoList) {
            userIdSet.add(pendingTaskVo.getAssignee());
            userIdSet.add(pendingTaskVo.getStartUser());
            if (HussarUtils.isNotEmpty((Object)pendingTaskVo.getAssignedUser())) {
                userIdSet.add(pendingTaskVo.getAssignedUser());
            }
            if (!HussarUtils.isNotEmpty((Object)pendingTaskVo.getOwner())) continue;
            userIdSet.add(pendingTaskVo.getOwner());
        }
        Map map = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIdSet));
        for (PendingTaskVo pendingTaskVo : pendingTaskVoList) {
            pendingTaskVo.setAssigneeName((String)map.get(pendingTaskVo.getAssignee()));
            pendingTaskVo.setStartUserName((String)map.get(pendingTaskVo.getStartUser()));
            if (HussarUtils.isNotEmpty((Object)pendingTaskVo.getAssignedUser())) {
                pendingTaskVo.setStartUserName((String)map.get(pendingTaskVo.getAssignedUser()));
            }
            if (HussarUtils.isNotEmpty((Object)pendingTaskVo.getOwner())) {
                pendingTaskVo.setOwnerName((String)map.get(pendingTaskVo.getOwner()));
            }
            if (pendingTaskVo.getOwner().equals(pendingTaskVo.getAssignee())) continue;
            pendingTaskVo.setTaskName(pendingTaskVo.getTaskName() + "(" + pendingTaskVo.getOwnerName() + ")");
        }
        return ApiResponse.success((Object)pages.setRecords(pendingTaskVoList));
    }

    public ApiResponse<JSONArray> getPendingTask(String businessId, String taskId) {
        if (HussarUtils.isEmpty((Object)taskId) && HussarUtils.isNotEmpty((Object)businessId)) {
            return ApiResponse.success();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        } else {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (HussarUtils.isEmpty((Object)task)) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            queryWrapper.eq(BpmActPendingTask::getProcInstId, (Object)task.getProcessInstanceId());
        }
        List pendingTasks = this.list((Wrapper)queryWrapper);
        Map map = this.iAssigneeChooseService.getUserListByUserId(pendingTasks.stream().map(BpmActPendingTask::getOwner).distinct().collect(Collectors.toList()));
        Map<String, List<BpmActPendingTask>> pendingTasksMap = pendingTasks.stream().collect(Collectors.groupingBy(BpmActPendingTask::getTaskDefKey));
        JSONArray jsonArray = new JSONArray();
        for (String taskDefKey : pendingTasksMap.keySet()) {
            List<BpmActPendingTask> singlePendingTasks = pendingTasksMap.get(taskDefKey);
            String ownerName = singlePendingTasks.stream().map(o -> (String)map.get(o.getOwner())).collect(Collectors.joining(","));
            JSONObject object = new JSONObject();
            object.put("taskDefKey", (Object)taskDefKey);
            object.put("taskName", (Object)singlePendingTasks.get(0).getTaskName());
            object.put("assignee", (Object)ownerName);
            jsonArray.add((Object)object);
        }
        return ApiResponse.success((Object)jsonArray);
    }

    public BpmResponseResult updatePendingTask(String procInstId, String businessId) {
        return this.updatePendingTask(null, null, businessId, procInstId, null, null, null, null, true);
    }

    public BpmResponseResult updatePendingTask(String processKey, String procDefId, String businessId, String procInstId, String userId, String deptId, String postId, Map<String, Object> variables, boolean forceUpdate) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{businessId, procInstId})) {
            return this.tryUpdateFirst(processKey, procDefId, businessId, userId, deptId, postId, variables, forceUpdate);
        }
        HistoricProcessInstance processInstance = HussarUtils.isNotEmpty((Object)procInstId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return this.tryUpdateFirst(processKey, procDefId, businessId, userId, deptId, postId, variables, forceUpdate);
        }
        if (processInstance.getEndTime() != null) {
            return InstallResult.success();
        }
        this.updatePendingTaskDetails(processInstance, variables);
        this.recursiveUpdateCallActivityPendingTask(processInstance.getId(), variables);
        return InstallResult.success();
    }

    private BpmResponseResult tryUpdateFirst(String processKey, String procDefId, String businessId, String userId, String deptId, String postId, Map<String, Object> variables, boolean forceUpdate) {
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{processKey, procDefId})) {
            this.updateFirstPendingTask(processKey, procDefId, businessId, userId, deptId, postId, variables, forceUpdate);
            return InstallResult.success();
        }
        return InstallResult.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
    }

    private void updateFirstPendingTask(String processKey, String procDefId, String businessId, String userId, String deptId, String postId, Map<String, Object> variables, boolean forceUpdate) {
        List historicTaskInstances;
        List historicProcessInstances;
        String processDefinitionId;
        List list;
        if (HussarUtils.isEmpty((Object)businessId) || HussarUtils.isAllEmpty((Object[])new Object[]{processKey, procDefId})) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult())) {
            throw new PublicClientException("\u6d41\u7a0b\u5df2\u542f\u52a8\uff01");
        }
        if (!forceUpdate && !(list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BpmActPendingTask::getBusinessId, (Object)businessId)).list()).isEmpty()) {
            return;
        }
        String string = processDefinitionId = HussarUtils.isEmpty((Object)procDefId) ? this.getProcessDefinitionId(processKey, deptId) : procDefId;
        if (HussarUtils.isEmpty((Object)processKey)) {
            processKey = processDefinitionId.split(":")[0];
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bm.getProcesses().get(0);
        String startTaskKey = this.getStartTaskDefKey(bm);
        Map taskMap = null;
        HashMap<String, List> pendingAssigneeMap = new HashMap<String, List>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        List oldPendingTasks = this.list((Wrapper)queryWrapper);
        for (BpmActPendingTask oldPendingTask : oldPendingTasks) {
            pendingAssigneeMap.computeIfAbsent(oldPendingTask.getTaskDefKey(), key -> new ArrayList()).add(oldPendingTask);
        }
        ProcessExtendProperties processExtendPropertie = this.processDefinitionsService.getProcessExtendProperties(processDefinitionId);
        Integer ruleOfHiApproverAtApproval = processExtendPropertie.getRuleOfHiApproverAtApproval();
        HistoricProcessInstance historicProcessInstance = null;
        if (ProcessExtendProperties.AS_DEPT.equals(ruleOfHiApproverAtApproval)) {
            historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().startedByDept(deptId).orderByProcessInstanceStartTime().desc()).listPage(0, 1);
            if (!(historicProcessInstances = historicProcessInstances.stream().filter(a -> !"endProcess".equals(a.getDeleteReason())).collect(Collectors.toList())).isEmpty()) {
                historicProcessInstance = (HistoricProcessInstance)historicProcessInstances.get(0);
            }
        } else if (ProcessExtendProperties.AS_PERSON.equals(ruleOfHiApproverAtApproval)) {
            historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().startedBy(userId).orderByProcessInstanceStartTime().desc()).listPage(0, 1);
            if (!(historicProcessInstances = historicProcessInstances.stream().filter(a -> !"endProcess".equals(a.getDeleteReason())).collect(Collectors.toList())).isEmpty()) {
                historicProcessInstance = (HistoricProcessInstance)historicProcessInstances.get(0);
            }
        }
        if (historicProcessInstance != null && !(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicProcessInstance.getId())).orderByTaskCreateTime()).desc()).list()).isEmpty()) {
            taskMap = historicTaskInstances.stream().collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (key1, key2) -> key2));
        }
        Map<String, Object> taskVariables = CommonCodeUtil.getGodAxeResult(startTaskKey, businessId, processDefinitionId);
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution(businessId, null, variables);
        HashMap<String, Integer> sortedMap = new HashMap<String, Integer>();
        Collection<BpmActPendingTask> pendingTasks = this.recursiveGetNextPendingTaskBySequence(process, (SequenceFlow)((FlowNode)process.getFlowElement(startTaskKey)).getOutgoingFlows().get(0), taskVariables, variables, businessId, processDefinitionId, sortedMap, null, processDefinitionId);
        BpmActPendingTaskServiceImpl.sortPendingTask(pendingTasks, sortedMap);
        ArrayList<Object> addPendingTasks = new ArrayList<Object>();
        String firstUserTask = ((SequenceFlow)((FlowNode)process.getFlowElement(startTaskKey)).getOutgoingFlows().get(0)).getTargetRef();
        if (!(process.getFlowElement(firstUserTask) instanceof UserTask)) {
            firstUserTask = null;
        }
        List sysActExtendProperties = this.extendPropertiesService.queryList(processDefinitionId);
        Map<Object, Object> extendPropertiesMap = new HashMap();
        if (sysActExtendProperties != null) {
            extendPropertiesMap = sysActExtendProperties.stream().collect(Collectors.toMap(SysActExtendProperties::getTaskDefKey, Function.identity(), (v1, v2) -> v2));
        }
        for (BpmActPendingTask pendingTask : pendingTasks) {
            Object bpmActPendingTask3;
            HistoricTaskInstance historicTaskInstance;
            SysActExtendProperties extendProperties = (SysActExtendProperties)extendPropertiesMap.get(pendingTask.getTaskDefKey());
            if (extendProperties != null && !"1".equals(extendProperties.getInitApprovalDisplay())) continue;
            if (taskMap != null && (historicTaskInstance = (HistoricTaskInstance)taskMap.get(pendingTask.getTaskDefKey())) != null) {
                BpmActPendingTask bpmActPendingTask2 = new BpmActPendingTask();
                bpmActPendingTask2.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask2.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask2.setFormKey(pendingTask.getFormKey());
                bpmActPendingTask2.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask2.setSeq(pendingTask.getSeq());
                bpmActPendingTask2.setProcDefId(processDefinitionId);
                bpmActPendingTask2.setProcessKey(processKey);
                bpmActPendingTask2.setBusinessId(businessId);
                bpmActPendingTask2.setPendingType("1");
                bpmActPendingTask2.setIsMain("1");
                bpmActPendingTask2.setOwner(historicTaskInstance.getOriginalAssignee());
                bpmActPendingTask2.setAssignee(historicTaskInstance.getOriginalAssignee());
                bpmActPendingTask2.setPosition(historicTaskInstance.getPostId());
                bpmActPendingTask2.setDeptId(historicTaskInstance.getDeptId());
                addPendingTasks.add(bpmActPendingTask2);
                continue;
            }
            List bpmActPendingTasks = (List)pendingAssigneeMap.get(pendingTask.getTaskDefKey());
            if (bpmActPendingTasks != null) {
                for (Object bpmActPendingTask3 : bpmActPendingTasks) {
                    BpmActPendingTask newBpmActPendingTask = new BpmActPendingTask();
                    newBpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
                    newBpmActPendingTask.setTaskName(pendingTask.getTaskName());
                    newBpmActPendingTask.setFormKey(pendingTask.getFormKey());
                    newBpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
                    newBpmActPendingTask.setSeq(pendingTask.getSeq());
                    newBpmActPendingTask.setProcDefId(processDefinitionId);
                    newBpmActPendingTask.setProcessKey(processKey);
                    newBpmActPendingTask.setBusinessId(businessId);
                    newBpmActPendingTask.setPendingType(bpmActPendingTask3.getPendingType());
                    newBpmActPendingTask.setIsMain(bpmActPendingTask3.getIsMain());
                    newBpmActPendingTask.setOwner(bpmActPendingTask3.getOwner());
                    newBpmActPendingTask.setAssignee(bpmActPendingTask3.getAssignee());
                    newBpmActPendingTask.setPosition(bpmActPendingTask3.getPosition());
                    newBpmActPendingTask.setDeptId(bpmActPendingTask3.getDeptId());
                    newBpmActPendingTask.setAssignee(bpmActPendingTask3.getAssignee());
                    addPendingTasks.add(newBpmActPendingTask);
                }
                continue;
            }
            List<ApprovalUser> approvalUsers = AnalyticalModelUtil.getPendingTaskConfigUser(null, userId, deptId, bm, pendingTask.getTaskDefKey(), "", processKey, businessId, pendingTask.getTaskName(), processDefinitionId, null, extendProperties);
            bpmActPendingTask3 = approvalUsers.iterator();
            while (bpmActPendingTask3.hasNext()) {
                ApprovalUser user = (ApprovalUser)bpmActPendingTask3.next();
                BpmActPendingTask bpmActPendingTask4 = new BpmActPendingTask();
                bpmActPendingTask4.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask4.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask4.setFormKey(pendingTask.getFormKey());
                bpmActPendingTask4.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask4.setSeq(pendingTask.getSeq());
                bpmActPendingTask4.setProcDefId(processDefinitionId);
                bpmActPendingTask4.setProcessKey(processKey);
                bpmActPendingTask4.setBusinessId(businessId);
                user.buildPendingTask(bpmActPendingTask4, null);
                addPendingTasks.add(bpmActPendingTask4);
            }
            if (!HussarUtils.isEmpty(approvalUsers)) continue;
            bpmActPendingTask3 = new BpmActPendingTask();
            bpmActPendingTask3.setTaskDefKey(pendingTask.getTaskDefKey());
            bpmActPendingTask3.setTaskName(pendingTask.getTaskName());
            bpmActPendingTask3.setFormKey(pendingTask.getFormKey());
            bpmActPendingTask3.setSeq(pendingTask.getSeq());
            bpmActPendingTask3.setTodoConfiguration(pendingTask.getTodoConfiguration());
            bpmActPendingTask3.setProcDefId(processDefinitionId);
            bpmActPendingTask3.setProcessKey(processKey);
            bpmActPendingTask3.setBusinessId(businessId);
            bpmActPendingTask3.setPendingType("0");
            addPendingTasks.add(bpmActPendingTask3);
        }
        List collect = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BpmActPendingTask::getBusinessId, (Object)businessId)).list().stream().map(BpmActPendingTask::getPendingTaskId).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            this.removeByIds(collect);
        }
        this.saveBatch(addPendingTasks);
    }

    private String getProcessDefinitionId(String processKey, String deptId) {
        String processDefinitionId = this.processDeptService.getProcessDefId(deptId, processKey);
        if (HussarUtils.isNotEmpty((Object)processDefinitionId)) {
            return processDefinitionId;
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError());
    }

    private void recursiveUpdateCallActivityPendingTask(String processInstanceId, Map<String, Object> variables) {
        List processInstanceList = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstanceId).list();
        for (HistoricProcessInstance processInstance : processInstanceList) {
            this.updatePendingTaskDetails(processInstance, variables);
            this.recursiveUpdateCallActivityPendingTask(processInstance.getId(), variables);
        }
    }

    private Map<String, Object> queryVariables(String procInstId) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        List list = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(procInstId).excludeVariableInitialization().list();
        for (HistoricVariableInstance historicVariableInstance : list) {
            if (!simpleVariableType.contains(historicVariableInstance.getVariableTypeName())) continue;
            res.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
        }
        return res;
    }

    private void updatePendingTaskDetails(HistoricProcessInstance processInstance, Map<String, Object> variables) {
        BpmnModel bm = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Process process = (Process)bm.getProcesses().get(0);
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).unfinished().list();
        Map taskMap = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).processInstanceId(processInstance.getId())).taskVariableValueNotEquals("reject_to", null)).orderByTaskCreateTime()).asc()).list().stream().collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (task1, task2) -> task2));
        Set runningTaskKeys = historicActivityInstances.stream().filter(o -> ACTIVITY_TYPES.contains(o.getActivityType())).map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
        List sysActExtendProperties = this.extendPropertiesService.queryList(processInstance.getProcessDefinitionId());
        Map<Object, Object> extendPropertiesMap = new HashMap();
        if (sysActExtendProperties != null) {
            extendPropertiesMap = sysActExtendProperties.stream().collect(Collectors.toMap(SysActExtendProperties::getTaskDefKey, Function.identity(), (v1, v2) -> v2));
        }
        HashSet<BpmActPendingTask> pendingTasks = new HashSet<BpmActPendingTask>();
        HashMap<String, Integer> sortedMap = new HashMap<String, Integer>();
        for (String taskDefKey : runningTaskKeys) {
            String rejectFromStr;
            Map<String, Object> taskVariables = CommonCodeUtil.getGodAxeResult(taskDefKey, processInstance.getBusinessKey(), processInstance.getProcessDefinitionId());
            Map<String, Object> processVariables = this.queryVariables(processInstance.getId());
            processVariables.putAll(variables);
            Object rejectFrom = null;
            HistoricTaskInstance task = (HistoricTaskInstance)taskMap.get(taskDefKey);
            if (task != null && (rejectFromStr = (String)task.getTaskLocalVariables().get("reject_from")) != null && !rejectFromStr.isEmpty()) {
                rejectFrom = new HashSet<String>(Arrays.asList(rejectFromStr.split(",")));
            }
            pendingTasks.addAll(this.recursiveGetNextPendingTaskBySequence(process, (SequenceFlow)((Activity)process.getFlowElement(taskDefKey)).getOutgoingFlows().get(0), taskVariables, processVariables, processInstance.getBusinessKey(), processInstance.getProcessDefinitionId(), sortedMap, (Set<String>)rejectFrom, processInstance.getProcessDefinitionId()));
        }
        BpmActPendingTaskServiceImpl.sortPendingTask(pendingTasks, sortedMap);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)processInstance.getBusinessKey());
        List oldPendingTasks = this.list((Wrapper)queryWrapper);
        logger.info("\u4e1a\u52a1\u4e3b\u952e: {}", (Object)processInstance.getBusinessKey());
        logger.info("\u5386\u53f2\u5f85\u5ba1\u6570\u636e: {}", (Object)JSON.toJSONString((Object)oldPendingTasks));
        HashMap<String, List> pendingAssigneeMap = new HashMap<String, List>();
        HashSet<Long> oldPendingTaskId = new HashSet<Long>();
        for (BpmActPendingTask oldPendingTask : oldPendingTasks) {
            pendingAssigneeMap.computeIfAbsent(oldPendingTask.getTaskDefKey(), key -> new ArrayList()).add(oldPendingTask);
            oldPendingTaskId.add(oldPendingTask.getPendingTaskId());
        }
        if (!oldPendingTaskId.isEmpty()) {
            this.removeByIds(oldPendingTaskId);
        }
        String startTaskKey = this.getStartTaskDefKey(bm);
        ArrayList<BpmActPendingTask> addPendingTasks = new ArrayList<BpmActPendingTask>();
        for (BpmActPendingTask pendingTask : pendingTasks) {
            ArrayList<ApprovalUser> approvalUserList = new ArrayList<ApprovalUser>();
            String startDept = null;
            if (HussarUtils.isNotEmpty(pendingAssigneeMap) && pendingAssigneeMap.containsKey(pendingTask.getTaskDefKey())) {
                ((List)pendingAssigneeMap.get(pendingTask.getTaskDefKey())).forEach(thePendingTask -> {
                    thePendingTask.setAssignee(thePendingTask.getOwner());
                    approvalUserList.add(AnalyticalModelUtil.getApprovalUser(thePendingTask));
                });
            }
            List<ApprovalUser> approvalUsers = AnalyticalModelUtil.getPendingTaskConfigUser(approvalUserList, processInstance.getStartUserId(), startDept, bm, pendingTask.getTaskDefKey(), processInstance.getId(), processInstance.getProcessDefinitionKey(), processInstance.getBusinessKey(), pendingTask.getTaskName(), processInstance.getProcessDefinitionId(), processInstance.getProcessVariables(), (SysActExtendProperties)extendPropertiesMap.get(pendingTask.getTaskDefKey()));
            String url = this.dataPushService.getTaskUrl(processInstance.getProcessDefinitionId(), pendingTask.getTaskDefKey());
            for (ApprovalUser approvalUser : approvalUsers) {
                BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask.setFormKey(url);
                bpmActPendingTask.setSeq(pendingTask.getSeq());
                bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask.setProcDefId(processInstance.getProcessDefinitionId());
                bpmActPendingTask.setProcessKey(processInstance.getProcessDefinitionKey());
                bpmActPendingTask.setProcInstId(processInstance.getId());
                bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
                approvalUser.buildPendingTask(bpmActPendingTask, null);
                addPendingTasks.add(bpmActPendingTask);
            }
            if (!HussarUtils.isEmpty(approvalUsers)) continue;
            BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
            bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
            bpmActPendingTask.setTaskName(pendingTask.getTaskName());
            bpmActPendingTask.setFormKey(url);
            bpmActPendingTask.setSeq(pendingTask.getSeq());
            bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
            bpmActPendingTask.setProcDefId(processInstance.getProcessDefinitionId());
            bpmActPendingTask.setProcessKey(processInstance.getProcessDefinitionKey());
            bpmActPendingTask.setProcInstId(processInstance.getId());
            bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
            bpmActPendingTask.setPendingType("0");
            addPendingTasks.add(bpmActPendingTask);
        }
        if (!addPendingTasks.isEmpty()) {
            this.saveBatch(addPendingTasks);
        }
        logger.info("\u65b0\u589e\u7684\u5f85\u5ba1\u4efb\u52a1: {}", (Object)JSON.toJSONString(addPendingTasks));
        this.dataPushService.updatePendingTask(BuildDataPush.forPendingTask(addPendingTasks), new DataPush().setProcessInsId(processInstance.getId()));
    }

    public List<ApprovalUser> getPendingTaskAssignees(String businessId, String taskDefKey) {
        List<Object> users = new ArrayList<ApprovalUser>();
        if (HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{businessId, taskDefKey})) {
            return users;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        queryWrapper.eq(BpmActPendingTask::getTaskDefKey, (Object)taskDefKey);
        queryWrapper.eq(BpmActPendingTask::getPendingType, (Object)"1");
        List bpmActPendingTasks = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)bpmActPendingTasks)) {
            users = bpmActPendingTasks.stream().map(ApprovalUser::new).collect(Collectors.toList());
        }
        return users;
    }

    public void endProcessUpdatePendingTasks(String processInstanceId) {
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (processInstanceId.contains(",")) {
            List<String> processInstanceIdList = Arrays.asList(processInstanceId.split(","));
            queryWrapper.in(BpmActPendingTask::getProcInstId, processInstanceIdList);
        } else {
            queryWrapper.eq(BpmActPendingTask::getProcInstId, (Object)processInstanceId);
        }
        this.remove((Wrapper)queryWrapper);
        this.subCandidateService.remove((Wrapper)new LambdaUpdateWrapper().in(SubCandidate::getProcInstId, Arrays.asList(processInstanceId.split(","))));
    }

    public ApiResponse<String> assignPendingTasksUser(String businessId, String taskDefKey, String userId, List<ApprovalUser> approvalUserList) {
        BpmnModel bm;
        if (HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{businessId, taskDefKey}) || HussarUtils.isEmpty(approvalUserList)) {
            throw new PublicClientException("\u7f3a\u5c11\u5fc5\u4f20\u4fe1\u606f\uff01");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        queryWrapper.eq(BpmActPendingTask::getTaskDefKey, (Object)taskDefKey);
        List pendingTasks = this.list((Wrapper)queryWrapper);
        List deleteTask = null;
        deleteTask = this.list((Wrapper)queryWrapper);
        BpmActPendingTask pendingTask = pendingTasks.isEmpty() ? null : (BpmActPendingTask)pendingTasks.get(0);
        this.remove((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)processInstance)) {
            bm = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        } else {
            if (pendingTasks.isEmpty()) {
                throw new PublicClientException("\u5f85\u5ba1\u672a\u521d\u59cb\u5316\uff01");
            }
            bm = this.repositoryService.getBpmnModel(pendingTask.getProcDefId());
        }
        String startTaskKey = this.getStartTaskDefKey(bm);
        ArrayList<BpmActPendingTask> addPendingTasks = new ArrayList<BpmActPendingTask>();
        String startUser = "";
        String startDeptId = "";
        if (HussarUtils.isNotEmpty((Object)processInstance)) {
            startUser = processInstance.getStartUserId();
            startDeptId = processInstance.getDepartmentId();
        }
        approvalUserList = HussarUtils.isNotEmpty((Object)processInstance) ? AnalyticalModelUtil.getPendingTaskConfigUser(approvalUserList, startUser, startDeptId, bm, pendingTask.getTaskDefKey(), processInstance.getId(), pendingTask.getProcessKey(), processInstance.getBusinessKey(), pendingTask.getTaskName(), processInstance.getProcessDefinitionId(), processInstance.getProcessVariables(), null) : AnalyticalModelUtil.getPendingTaskConfigUser(approvalUserList, startUser, startDeptId, bm, pendingTask.getTaskDefKey(), "", pendingTask.getProcessKey(), businessId, pendingTask.getTaskName(), pendingTask.getProcDefId(), null, null);
        for (ApprovalUser approvalUser : approvalUserList) {
            BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
            BeanUtils.copyProperties((Object)pendingTask, (Object)bpmActPendingTask);
            bpmActPendingTask.setPendingTaskId(null);
            bpmActPendingTask.setAssignedUser(userId);
            approvalUser.setOwner(approvalUser.getUserId());
            approvalUser.buildPendingTask(bpmActPendingTask, null);
            addPendingTasks.add(bpmActPendingTask);
        }
        if (HussarUtils.isNotEmpty(addPendingTasks)) {
            this.saveBatch(addPendingTasks);
        }
        if (processInstance != null) {
            if (deleteTask != null && deleteTask.size() > 0) {
                for (int i = 0; i < deleteTask.size(); ++i) {
                    String url = this.dataPushService.getTaskUrl(processInstance.getProcessDefinitionId(), taskDefKey);
                    ((BpmActPendingTask)deleteTask.get(i)).setFormKey(url);
                }
            }
            this.dataPushService.updatePendingTaskUser(BuildDataPush.forPendingTask(deleteTask), BuildDataPush.forPendingTask(addPendingTasks), new DataPush().setProcessInsId(processInstance.getId()));
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("taskName", ((BpmActPendingTask)pendingTasks.get(0)).getTaskName());
        info.put("procDefId", ((BpmActPendingTask)pendingTasks.get(0)).getProcDefId());
        info.put("taskKey", ((BpmActPendingTask)pendingTasks.get(0)).getTaskDefKey());
        return ApiResponse.success((String)"");
    }

    private Collection<BpmActPendingTask> recursiveGetNextPendingTaskBySequence(Process process, SequenceFlow sequenceFlow, Map<String, Object> variables, Map<String, Object> processVariables, String businessId, String processDefinitionId, Map<String, Integer> sortedMap, Set<String> rejectFrom, String procDefId) {
        PendTaskRecursionModel recursionParam = new PendTaskRecursionModel(sortedMap);
        HashSet<BpmActPendingTask> pendingTasks = new HashSet<BpmActPendingTask>();
        if (rejectFrom != null) {
            Map<String, HistoricTaskInstance> collect = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list().stream().filter(task -> task.getTaskLocalVariables().containsKey("reject_to")).collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (task1, task2) -> task2));
            recursionParam.setHistoricTaskInstance(collect);
            for (String rejectTask : rejectFrom) {
                sequenceFlow = new SequenceFlow();
                sequenceFlow.setTargetRef(rejectTask);
                recursionParam.setReject();
                this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, sequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
            }
        } else {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, sequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
        }
        return pendingTasks;
    }

    private void recursiveGetNextPendingTaskBySequence(Set<BpmActPendingTask> pendingTasks, Process process, SequenceFlow sequenceFlow, Map<String, Object> variables, Map<String, Object> processVariables, String businessId, String processDefinitionId, PendTaskRecursionModel recursionParam, String procDefId) {
        if (HussarUtils.isEmpty((Object)sequenceFlow)) {
            return;
        }
        AnalyticalModelUtil.getAllVariables(processVariables, variables);
        FlowElement flowElement = process.getFlowElement(sequenceFlow.getTargetRef());
        String taskDefKey = flowElement.getId();
        logger.info("\u8282\u70b9\u6807\u8bc6: {}", (Object)taskDefKey);
        if (flowElement instanceof UserTask) {
            if (recursionParam.isNext(taskDefKey)) {
                Collection<String> rejectNodes;
                Map<String, Object> newVariables = CommonCodeUtil.getGodAxeResult(taskDefKey, businessId, processDefinitionId);
                if (recursionParam.isNeedBuildTask(taskDefKey)) {
                    BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                    bpmActPendingTask.setTaskDefKey(taskDefKey);
                    bpmActPendingTask.setTaskName(flowElement.getName());
                    bpmActPendingTask.setFormKey(((UserTask)flowElement).getFormKey());
                    this.getPendingTaskDetail(bpmActPendingTask, process, newVariables, processVariables);
                    logger.info("\u5f85\u5ba1\u8282\u70b9: {}", (Object)JSON.toJSONString((Object)bpmActPendingTask));
                    pendingTasks.add(bpmActPendingTask);
                }
                if ((rejectNodes = recursionParam.isContinueReject(taskDefKey)) != null && rejectNodes.size() == 1) {
                    for (String rejectNode : rejectNodes) {
                        SequenceFlow flow = new SequenceFlow();
                        flow.setTargetRef(rejectNode);
                        this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, flow, newVariables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
                        recursionParam.returnPer(taskDefKey);
                    }
                } else {
                    this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((UserTask)flowElement).getOutgoingFlows().get(0), newVariables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
                    recursionParam.returnPer(taskDefKey);
                }
            }
        } else if (flowElement instanceof Gateway) {
            Gateway gateway = (Gateway)flowElement;
            if (gateway instanceof ParallelGateway) {
                for (SequenceFlow singleSequenceFlow : gateway.getOutgoingFlows()) {
                    this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, singleSequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
                }
            } else {
                ArrayList<SequenceFlow> enabledSequenceFlows = new ArrayList<SequenceFlow>();
                SequenceFlow defaultSequenceFlow = null;
                boolean flag = true;
                for (SequenceFlow singleSequenceFlow : gateway.getOutgoingFlows()) {
                    if (HussarUtils.isEmpty((Object)singleSequenceFlow.getConditionExpression())) {
                        if (flowElement instanceof InclusiveGateway) {
                            enabledSequenceFlows.add(singleSequenceFlow);
                            continue;
                        }
                        defaultSequenceFlow = singleSequenceFlow;
                        continue;
                    }
                    boolean isConditionWithNextNode = singleSequenceFlow.getConditionExpression().contains("bpm_next_node");
                    variables.put("hussar_business_id", businessId);
                    if (!this.validateSequenceFlowByCondition(variables, singleSequenceFlow.getConditionExpression(), processDefinitionId)) continue;
                    enabledSequenceFlows.add(singleSequenceFlow);
                    if (isConditionWithNextNode) continue;
                    flag = false;
                }
                if (flag && HussarUtils.isNotEmpty(defaultSequenceFlow)) {
                    enabledSequenceFlows.add(defaultSequenceFlow);
                }
                for (SequenceFlow singleSequenceFlow : enabledSequenceFlows) {
                    this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, singleSequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
                }
            }
        } else if (flowElement instanceof CallActivity) {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((CallActivity)flowElement).getOutgoingFlows().get(0), variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
        } else if (flowElement instanceof ServiceTask) {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((ServiceTask)flowElement).getOutgoingFlows().get(0), variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
        } else if (flowElement instanceof ReceiveTask) {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((ReceiveTask)flowElement).getOutgoingFlows().get(0), variables, processVariables, businessId, processDefinitionId, recursionParam, procDefId);
        }
    }

    private boolean validateSequenceFlowByCondition(Map<String, Object> variables, String conditionExpression, String procDefId) {
        ValueExpression valueExpression;
        Matcher matcher;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (HussarUtils.isNotEmpty(variables)) {
            for (String k : variables.keySet()) {
                if (HussarUtils.isNotEmpty((Object)variables.get(k.toString()))) {
                    context.setVariable(k.toString(), factory.createValueExpression(variables.get(k.toString()), variables.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(variables.get(k.toString()), Object.class));
            }
        }
        if ((matcher = BPM_NEXT_NODE_REGEX.matcher(conditionExpression)).find()) {
            conditionExpression = conditionExpression.replaceAll(matcher.group(), "true");
        }
        return HussarUtils.isNotEmpty((Object)(valueExpression = factory.createValueExpression((ELContext)context, conditionExpression = this.sqlConditionHandleService.getSqlRealCondition(conditionExpression, variables, procDefId), Boolean.TYPE))) && (Boolean)valueExpression.getValue((ELContext)context) != false;
    }

    private void getPendingTaskDetail(BpmActPendingTask pendingTask, Process process, Map<String, Object> variables, Map<String, Object> processVariables) {
        AnalyticalModelUtil.getAllVariables(processVariables, variables);
        String todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)process.getFlowElement(pendingTask.getTaskDefKey()).getExtensionElements().get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
        if (HussarUtils.isEmpty((Object)todo)) {
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)process.getExtensionElements().get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
        }
        todo = AnalyticalModelUtil.getTodo(variables, todo);
        pendingTask.setTodoConfiguration(todo);
    }

    private String getStartTaskDefKey(BpmnModel bm) {
        for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            return flowElement.getId();
        }
        return null;
    }

    private static void sortPendingTask(Collection<BpmActPendingTask> pendingTasks, Map<String, Integer> sortedMap) {
        for (BpmActPendingTask pendingTask : pendingTasks) {
            Integer sort = sortedMap.get(pendingTask.getTaskDefKey());
            if (sort == null) {
                sort = Integer.MAX_VALUE;
            }
            pendingTask.setSeq(sort.intValue());
        }
    }

    static {
        simpleVariableType.add("boolean");
        simpleVariableType.add("date");
        simpleVariableType.add("double");
        simpleVariableType.add("integer");
        simpleVariableType.add("json");
        simpleVariableType.add("long");
        simpleVariableType.add("null");
        simpleVariableType.add("short");
        simpleVariableType.add("string");
        simpleVariableType.add("uuid");
    }

    private static class PendTaskRecursionModel {
        private int deep = 0;
        private final Map<String, Integer> sortMap;
        private final Set<String> passedTask = new HashSet<String>();
        private boolean isReject;
        private Map<String, HistoricTaskInstance> historicTaskInstance = new HashMap<String, HistoricTaskInstance>();

        public boolean isNext(String taskDefKey) {
            if (this.passedTask.contains(taskDefKey)) {
                return false;
            }
            Integer perDeep = this.sortMap.get(taskDefKey);
            if (perDeep != null && perDeep > this.deep) {
                return false;
            }
            ++this.deep;
            this.passedTask.add(taskDefKey);
            return true;
        }

        public boolean isNeedBuildTask(String taskDefKey) {
            boolean res = !this.sortMap.containsKey(taskDefKey);
            this.sortMap.put(taskDefKey, this.deep);
            return res;
        }

        public void returnPer(String taskDefKey) {
            if (this.passedTask.remove(taskDefKey)) {
                --this.deep;
            }
        }

        public Collection<String> isContinueReject(String taskDefKey) {
            if (this.isReject) {
                String rejectFromStr;
                HistoricTaskInstance historicTaskInstance = this.historicTaskInstance.get(taskDefKey);
                if (historicTaskInstance != null && (rejectFromStr = (String)historicTaskInstance.getTaskLocalVariables().get("reject_from")) != null && !rejectFromStr.isEmpty()) {
                    return new HashSet<String>(Arrays.asList(rejectFromStr.split(",")));
                }
                this.isReject = false;
            }
            return null;
        }

        public PendTaskRecursionModel(Map<String, Integer> sortMap) {
            this.sortMap = sortMap != null ? sortMap : new HashMap<String, Integer>();
        }

        public void setReject() {
            this.isReject = true;
        }

        public void setHistoricTaskInstance(Map<String, HistoricTaskInstance> historicTaskInstance) {
            this.historicTaskInstance = historicTaskInstance;
        }
    }
}

