/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.ApprovalUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.SkipTaskThreadContext;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.model.SubCandidate;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.service.ISubCandidateService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.BuildDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MSG = "Expression did not resolve to a string or collection of strings";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendUserTaskActivityBehavior.class);
    private static ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private static TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private static ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private static ICandidateUserService candidateUserService = (ICandidateUserService)SpringContextHolder.getApplicationContext().getBean(ICandidateUserService.class);
    private static ISubCandidateService subCandidateService = (ISubCandidateService)SpringContextHolder.getApplicationContext().getBean(ISubCandidateService.class);
    private static DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private static ISysActEntrustService entrustService = (ISysActEntrustService)SpringContextHolder.getApplicationContext().getBean(ISysActEntrustService.class);
    private static BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)SpringContextHolder.getApplicationContext().getBean(SysActProcessFileService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)SpringContextHolder.getApplicationContext().getBean(ISysCalendarRefService.class);
    private static ISysActExtendPropertiesService iSysActExtendPropertiesService = (ISysActExtendPropertiesService)SpringContextHolder.getApplicationContext().getBean(ISysActExtendPropertiesService.class);

    public ExtendUserTaskActivityBehavior(String userTaskId, TaskDefinition taskDefinition) {
        super(userTaskId, taskDefinition);
    }

    public void execute(ActivityExecution execution) throws Exception {
        Object formKey;
        Object category;
        Object priority;
        Set<Expression> activeCandidateGroupExpressions;
        Set<Expression> activeCandidateUserExpressions;
        Expression activeOwnerExpression;
        Expression activeAssigneeExpression;
        Expression activeFormKeyExpression;
        Expression activeCategoryExpression;
        Expression activePriorityExpression;
        Expression activeDueDateExpression;
        Expression activeDescriptionExpression;
        Expression activeNameExpression;
        HistoricTaskInstance lastComplete;
        TaskEntity task = TaskEntity.create((Date)new Date());
        task.setProcessCycleCount(((ExecutionEntity)execution).getProcessCycleCount());
        task.setId(Context.getProcessEngineConfiguration().getIdGenerator().getNextId());
        task.setExecution((DelegateExecution)execution);
        task.setCompleteType(BpmAttribute.getTaskSourceFlag(task));
        String allPrevNode = TaskSourceFlag.isRejectOrRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) ? ((lastComplete = BpmHistoryTask.getLastComplete(execution.getProcessInstanceId(), execution.getSubProcessKey(), execution.getCurrentActivityId())) == null ? null : lastComplete.getAllPrevNode()) : ((ExecutionEntity)execution).getAllPrevNode();
        task.setAllPrevNode(allPrevNode);
        JumpInfo jumpInfo = (JumpInfo)BpmAttribute.getContextAttribute("jump_info");
        if (jumpInfo != null && jumpInfo.isJumpExecution() && HussarUtils.isNotEmpty((Object)jumpInfo.getJumpFromExecutionInfo())) {
            task.setVariableLocal("jump_execution_info", (Object)jumpInfo.getJumpFromExecutionInfo());
        }
        task.setJumpInfo(JumpInfo.toJsonString((JumpInfo)jumpInfo));
        task.setTodoConfiguration(AnalyticalModelUtil.getTodo(execution.getProcessInstance().getVariables(), AnalyticalModelUtil.getToDoConfiguration(execution.getProcessDefinitionId(), execution.getCurrentActivityId())));
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)this.userTaskId, (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(this.taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            this.taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(this.taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            this.taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(this.taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            this.taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(this.taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            this.taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(this.taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            this.taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(this.taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            this.taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            Expression activeSkipExpression = this.getActiveValue(this.taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            this.taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(this.taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            this.taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(this.taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            this.taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            this.taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            this.taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = this.taskDefinition.getNameExpression();
            activeDescriptionExpression = this.taskDefinition.getDescriptionExpression();
            activeDueDateExpression = this.taskDefinition.getDueDateExpression();
            activePriorityExpression = this.taskDefinition.getPriorityExpression();
            activeCategoryExpression = this.taskDefinition.getCategoryExpression();
            activeFormKeyExpression = this.taskDefinition.getFormKeyExpression();
            activeAssigneeExpression = this.taskDefinition.getAssigneeExpression();
            activeOwnerExpression = this.taskDefinition.getOwnerExpression();
            activeCandidateUserExpressions = this.taskDefinition.getCandidateUserIdExpressions();
            activeCandidateGroupExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        }
        task.setTaskDefinition(this.taskDefinition);
        if (activeNameExpression != null) {
            String name;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null) {
            SysActExtendProperties sysActExtendPropertie;
            BpmnModel bm = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = bm.getFlowElement(execution.getActivity().getId());
            List chosenDayElement = (List)element.getExtensionElements().get("chosenDay");
            String chosenDay = null;
            if (HussarUtils.isNotEmpty((Object)chosenDayElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)chosenDayElement.get(0)).getAttributes())) {
                chosenDay = ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")).get(0)).getValue();
            }
            if ((sysActExtendPropertie = (SysActExtendProperties)iSysActExtendPropertiesService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)task.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, (Object)task.getTaskDefinitionKey()))) != null && sysActExtendPropertie.getIsWorkday().equals("1")) {
                chosenDay = "workingDay";
            }
            if ("workingDay".equals(chosenDay)) {
                Date date = new Date();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(activeDueDateExpression), true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date dueDate = Date.from(instant2);
                task.setDueDate(dueDate);
            } else {
                Object dueDate = activeDueDateExpression.getValue((VariableScope)execution);
                if (dueDate != null) {
                    if (dueDate instanceof Date) {
                        task.setDueDate((Date)dueDate);
                    } else if (dueDate instanceof String) {
                        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                        task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                    } else {
                        throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                    }
                }
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> messageType = new ArrayList<String>();
        String skipUserTask = this.setAssignments(activeAssigneeExpression, activeOwnerExpression, activeCandidateUserExpressions, activeCandidateGroupExpressions, task, execution, users, messageType);
        task.insert((ExecutionEntity)execution);
        task.fireEvent("create");
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (skipUserTask != null) {
            task.setSendUser(task.getAssignee());
            task.setTaskSourceFlag("skip");
            String todoConfiguration = task.getVariable("todoConfiguration") == null ? "" : task.getVariable("todoConfiguration");
            task.setVariablesLocal(execution.getVariablesLocal());
            task.setVariableLocal("todoConfiguration", (Object)String.valueOf(todoConfiguration));
            task.setVariableLocal("all_prev_node", null);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(task.getProcessDefinitionId());
            task.setApprovalType(skipUserTask);
            task.complete(null, false, null);
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)task));
            }
            if (!skipUserTask.equals("skip")) {
                SkipTaskThreadContext.addSkipTask((String)task.getId());
            }
            if (dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setUserId(task.getAssignee());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setEndDate(new Date());
                dataPush.setTenantId(task.getTenantId());
                List commentsByTaskId = taskService.getTaskComments(task.getId());
                dataPush.setComment(commentsByTaskId.isEmpty() ? null : ((Comment)commentsByTaskId.get(0)).getFullMessage());
                dataPushService.completeDataPush(dataPush);
            }
        }
        if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && skipUserTask == null) {
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setProcessKey(task.getProcessInstance().getProcessDefinitionKey());
            bpmActMsgDetail.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
            bpmActMsgDetail.setProcessDefinitionId(task.getProcessDefinitionId());
            bpmActMsgDetail.setTaskDefKey(task.getTaskDefinitionKey());
            bpmActMsgDetail.setTaskDefName(task.getName());
            bpmActMsgDetail.setReceive(users);
            bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? (String)messageType.get(0) : null);
            if (TaskSourceFlag.isReject((String)BpmAttribute.getTaskSourceFlag(execution))) {
                bpmActMsgDetail.setSceneCode("reject");
            } else {
                bpmActMsgDetail.setSceneCode("todo");
            }
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
            }
            bpmActMsgDetailList.add(bpmActMsgDetail);
            msgPushService.pushMessage(bpmActMsgDetailList);
        }
        task.fireEvent("start");
    }

    private String setAssignments(Expression assigneeExpression, Expression ownerExpression, Set<Expression> candidateUserExpressions, Set<Expression> candidateGroupExpressions, TaskEntity task, ActivityExecution execution, List<String> userList, List<String> messageType) {
        Object value;
        Map identityLinks;
        Boolean notNeedCheckAssignee;
        List hisTaskList;
        Map extensionElementsNode;
        String skipRepetition;
        Map<String, Object> ccUsersMessage;
        List historicTaskInstances;
        if ("callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"))) {
            return null;
        }
        BpmnModel bm = repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (assigneeExpression != null) {
            Object assigneeExpressionValue = assigneeExpression.getValue((VariableScope)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            task.setAssignee(assigneeValue, true, false);
        }
        if (ownerExpression != null) {
            Iterator<Expression> ownerExpressionValue = ownerExpression.getValue((VariableScope)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            task.setOwner(ownerValue);
        }
        if (candidateGroupExpressions != null && !candidateGroupExpressions.isEmpty()) {
            for (Expression groupIdExpr : candidateGroupExpressions) {
                Object value2 = groupIdExpr.getValue((VariableScope)execution);
                if (value2 instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException(ERROR_MSG);
            }
        }
        this.setVariables(task, execution.getVariables());
        HashSet<String> mainTaskUser = new HashSet<String>();
        HashSet<String> subTaskUser = new HashSet<String>();
        List<ApprovalUser> approvalUsers = AnalyticalModelUtil.getEntrustCandidateUser(bm, task.getTaskDefinitionKey(), execution, false, mainTaskUser, subTaskUser, execution.getTenantId(), messageType);
        if (HussarUtils.isEmpty(mainTaskUser) && HussarUtils.isNotEmpty((Object)(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).orderByTaskCreateTime()).asc()).listPage(0, 1))) && !historicTaskInstances.isEmpty() && execution.getCurrentActivityId().equals(((HistoricTaskInstance)historicTaskInstances.get(0)).getTaskDefinitionKey())) {
            mainTaskUser.add(((HistoricTaskInstance)historicTaskInstances.get(0)).getAssignee());
        }
        userList.addAll(mainTaskUser);
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
        if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutStrategy.get(0)).getAttributes())) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            StringBuilder stringBuilder = new StringBuilder();
            if (HussarUtils.isNotEmpty(mainTaskUser)) {
                for (String user : mainTaskUser) {
                    stringBuilder.append(user).append(",");
                }
                timeOutModel.setAssignee(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
            }
            timeOutModel.setTimeOutType(((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue());
            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", task.getName());
                map.put("processInsId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("todoConfiguration", task.getTodoConfiguration());
                map.put("sendUser", task.getVariable("sendUser"));
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && HussarUtils.isNotEmpty(ccUsersMessage = AnalyticalModelUtil.getCcUser(bm, execution))) {
            List ccUsers = (List)ccUsersMessage.get("ccUser");
            String sendUserId = (String)ccUsersMessage.get("ccSendUser");
            if (HussarUtils.isNotEmpty((Object)ccUsers) && HussarUtils.isNotEmpty((Object)sendUserId)) {
                this.ccTask((Task)task, (List<String>)ccUsers, sendUserId, execution, bm);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(skipRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)(extensionElementsNode = bm.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements()).get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue())) && (hisTaskList = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).listPage(0, 1)) != null && !hisTaskList.isEmpty()) {
            List<String> skipList = Arrays.asList(skipRepetition.split(","));
            String taskSourceFlag = BpmAttribute.getTaskSourceFlag(execution);
            if (taskSourceFlag == null || TaskSourceFlag.isComplete((String)taskSourceFlag)) {
                if (skipList.contains("1")) {
                    if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                        activityRedisTimer.delTimeOutModel(task.getId());
                    }
                    return "skip";
                }
                if (approvalUsers.isEmpty()) {
                    throw new PublicClientException("\u65e0\u4efb\u52a1\u63a5\u6536\u4eba\uff01");
                }
                if (skipList.contains("2")) {
                    String lastActivityId = task.getAllPrevNode();
                    HashMap<String, String> lastNodeAssignees = new HashMap<String, String>();
                    if (HussarUtils.isNotEmpty((Object)lastActivityId)) {
                        List<String> lastTaskDefinitionKeyList = Arrays.asList(lastActivityId.split(","));
                        Iterator<String> iterator = lastTaskDefinitionKeyList.iterator();
                        block2: while (iterator.hasNext()) {
                            String taskDefinitionKey = iterator.next();
                            List historicTaskInstances2 = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(taskDefinitionKey)).subProcessKey(task.getSubProcessKey())).list();
                            historicTaskInstances2.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                            historicTaskInstances2.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                            if (!HussarUtils.isNotEmpty((Object)historicTaskInstances2)) continue;
                            HistoricTaskInstance historicTaskInstance2 = (HistoricTaskInstance)historicTaskInstances2.get(0);
                            lastNodeAssignees.put(historicTaskInstance2.getAssignee(), historicTaskInstance2.getApprovalType());
                            Date start = historicTaskInstance2.getStartTime();
                            for (int j = 1; j < historicTaskInstances2.size(); ++j) {
                                HistoricTaskInstance hisTask = (HistoricTaskInstance)historicTaskInstances2.get(j);
                                if (start.getTime() > hisTask.getEndTime().getTime()) continue block2;
                                if (hisTask.getCreateTime().compareTo(start) < 0) {
                                    start = hisTask.getCreateTime();
                                }
                                lastNodeAssignees.put(hisTask.getOriginalAssignee(), historicTaskInstance2.getApprovalType());
                            }
                        }
                    }
                    if (mainTaskUser != null && HussarUtils.isNotEmpty(lastNodeAssignees)) {
                        for (String lastNodeAssignee : lastNodeAssignees.keySet()) {
                            Optional<ApprovalUser> any;
                            if (!mainTaskUser.contains(lastNodeAssignee)) continue;
                            if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                                activityRedisTimer.delTimeOutModel(task.getId());
                            }
                            if ((any = approvalUsers.stream().filter(approvalUser -> "1".equals(approvalUser.getIsMain()) && lastNodeAssignees.containsKey(approvalUser.getUserId())).findAny()).isPresent()) {
                                ApprovalUser user = any.get();
                                task.setDeptId(user.getDeptId());
                                task.setUnitId(user.getUnitId());
                                task.setPostId(user.getPostId());
                            }
                            task.setAssignee(lastNodeAssignee);
                            return (String)lastNodeAssignees.get(lastNodeAssignee);
                        }
                    }
                }
            }
        }
        if ((notNeedCheckAssignee = (Boolean)Context.getCommandContext().getAttribute("notNeedCheckAssignee")) != null && !notNeedCheckAssignee.booleanValue() && (mainTaskUser == null || mainTaskUser.isEmpty())) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_ASSIGNEE);
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign");
            String string = delayToAssign = HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "false";
        }
        if (mainTaskUser != null && !mainTaskUser.isEmpty()) {
            if (!"true".equals(delayToAssign)) {
                approvalUsers.stream().filter(approvalUser -> "1".equals(approvalUser.getIsMain())).forEach(approvalUser -> task.addCandidateUser(AnalyticalModelUtil.getIdentityLinkEntityByApprovalUser(approvalUser)));
            } else {
                String taskId = task.getId();
                candidateUserService.saveBatch((Collection)approvalUsers.stream().filter(approvalUser -> "1".equals(approvalUser.getIsMain())).map(approvalUser -> {
                    CandidateUser candidateUser = new CandidateUser();
                    candidateUser.setTaskId(Long.valueOf(taskId));
                    candidateUser.setAssignee(approvalUser.getOwner() == null ? approvalUser.getUserId() : approvalUser.getOwner());
                    candidateUser.setDeptId(approvalUser.getDeptId());
                    candidateUser.setPostId(approvalUser.getPostId());
                    return candidateUser;
                }).collect(Collectors.toList()));
            }
        }
        if (!subTaskUser.isEmpty()) {
            List subCandidates = approvalUsers.stream().filter(approvalUser -> "0".equals(approvalUser.getIsMain())).map(approvalUser -> new SubCandidate(approvalUser, task.getId(), task.getProcessInstanceId())).collect(Collectors.toList());
            subCandidateService.saveBatch((Collection)subCandidates);
            String url = dataPushService.getTaskUrl(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
            task.setFormKey(url);
            dataPushService.addSubTask(BuildDataPush.forSubTask((List<SubCandidate>)subCandidates, task));
        }
        if (candidateUserExpressions != null && !candidateUserExpressions.isEmpty()) {
            for (Expression userIdExpr : candidateUserExpressions) {
                Object value3 = userIdExpr.getValue((VariableScope)execution);
                if (value3 instanceof String) {
                    List<String> candiates = this.extractCandidates((String)value3);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value3 instanceof Collection) {
                    task.addCandidateUsers((Collection)value3);
                    continue;
                }
                throw new ActivitiException(ERROR_MSG);
            }
        }
        if (!this.taskDefinition.getCustomUserIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomUserIdentityLinkExpressions();
            for (Map.Entry identityLink : identityLinks.entrySet()) {
                for (Expression idExpression : (Set)identityLink.getValue()) {
                    value = idExpression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, (String)identityLink.getKey());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), (String)identityLink.getKey());
                        }
                        continue;
                    }
                    throw new ActivitiException(ERROR_MSG);
                }
            }
        }
        if (!this.taskDefinition.getCustomGroupIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomGroupIdentityLinkExpressions();
            for (Map.Entry identityLink : identityLinks.entrySet()) {
                for (Expression idExpression : (Set)identityLink.getValue()) {
                    value = idExpression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, (String)identityLink.getKey());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), (String)identityLink.getKey());
                        }
                        continue;
                    }
                    throw new ActivitiException(ERROR_MSG);
                }
            }
        }
        return null;
    }

    private void setVariables(TaskEntity task, Map<String, Object> variables) {
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        if (newVariables.containsKey("all_prev_node")) {
            task.setVariableLocal("all_prev_node", newVariables.get("all_prev_node"));
        }
        if (newVariables.containsKey("reject_to")) {
            task.removeVariable("reject_from");
            task.removeVariable("reject_to");
            task.setVariableLocal("reject_from", newVariables.get("reject_from"));
            task.setVariableLocal("reject_to", newVariables.get("reject_to"));
            if (newVariables.containsKey("reject_execution")) {
                task.removeVariable("reject_execution");
                task.setVariableLocal("reject_execution", newVariables.get("reject_execution"));
            }
        }
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!((ExecutionEntity)execution).getTasks().isEmpty()) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    public void leave(ActivityExecution execution) {
        if (execution.getActivity() != null && ((ActivityImpl)execution.getActivity()).getActivityBehavior() instanceof ExtendUserTaskActivityBehavior) {
            BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
            Map<String, Object> ccUserMap = AnalyticalModelUtil.getCcEndUser(bm, execution);
            List ccUserIds = (List)ccUserMap.get("ccUser");
            String ccSendUser = (String)ccUserMap.get("ccSendUser");
            if (!ccUserIds.isEmpty()) {
                String processInsId = execution.getProcessInstanceId();
                String taskDefKey = execution.getCurrentActivityId();
                String subProcessKey = execution.getSubProcessKey();
                HistoricTaskInstanceEntity historicTaskInstance = Context.getCommandContext().getTaskEntityManager().findLastFinishedTaskFromCache(processInsId, taskDefKey, subProcessKey);
                if (historicTaskInstance == null) {
                    historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().finished().processInstanceId(processInsId)).taskDefinitionKey(taskDefKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1).get(0);
                }
                this.ccTask((HistoricTaskInstance)historicTaskInstance, (List<String>)ccUserIds, ccSendUser, execution, bm);
            }
        }
        super.leave(execution);
    }

    private void ccTask(HistoricTaskInstance task, List<String> users, String userId, ActivityExecution execution, BpmnModel bpmnModel) {
        if (users.isEmpty()) {
            return;
        }
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            for (String user : users) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setUserId(user);
                dataPush.setCcMoment("1");
                dataPush.setStartDate((Date)ts);
                dataPushList.add(dataPush);
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setFormId(task.getFormId());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("1");
                sysActCcTask.setToDoConfig(task.getTodoConfiguration());
                if (task.getAssignee().equals(sysActCcTask.getReceiveUser())) {
                    sysActCcTask.setTaskState("1");
                    if (sysActCcTask.getSendTime().after(task.getEndTime())) {
                        sysActCcTask.setEndTime(sysActCcTask.getSendTime());
                    } else {
                        sysActCcTask.setEndTime(new Timestamp(task.getEndTime().getTime()));
                    }
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                }
                list.add(sysActCcTask);
            }
            dataPushService.addCcTask(dataPushList);
        }
        if (!list.isEmpty()) {
            iSysActCcTaskService.saveBatch(list);
        }
    }

    private void ccTask(Task task, List<String> users, String userId, ActivityExecution execution, BpmnModel bpmnModel) {
        if (users.isEmpty()) {
            return;
        }
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (processInstance != null) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setFormId(task.getFormId());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("0");
                sysActCcTask.setToDoConfig(task.getTodoConfiguration());
                list.add(sysActCcTask);
            }
        }
        if (!list.isEmpty()) {
            iSysActCcTaskService.saveBatch(list);
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.isEmpty()) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }
}

