/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class AlternativeMultiInstanceJumpTaskCmd
extends AddAttributeCmd<Void> {
    protected String userId;
    private String executionId;
    private JumpModel jumpModel;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String taskId;
    private String comment;
    private String type;
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private BpmActPendingTaskService pendingTaskService = (BpmActPendingTaskService)SpringContextHolder.getBean(BpmActPendingTaskService.class);

    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        this.addExecutionAttribute(executionEntity);
        String type = BpmAttribute.getTaskSourceFlag((ActivityExecution)executionEntity);
        boolean needRemoveTask = TaskSourceFlag.isRevoke((String)type);
        boolean reject = TaskSourceFlag.isReject((String)type);
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setExecutions(null);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ArrayList taskEntities = new ArrayList();
        ExecutionEntity scopeExecution = (ExecutionEntity)executionEntity.getExecutions().get(0);
        for (ExecutionEntity taskExecution : scopeExecution.getExecutions()) {
            taskEntities.addAll(taskExecution.getTasks());
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Long> longTaskIds = new ArrayList<Long>();
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId) && !needRemoveTask) continue;
            taskIds.add(taskEntity.getId());
            longTaskIds.add(Long.parseLong(taskEntity.getId()));
        }
        if (HussarUtils.isNotEmpty(taskIds)) {
            Object ccTasks;
            this.taskEngineService.removeMultiHistoryTask(longTaskIds);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskIds(taskIds);
                dataPush.setComment(this.comment);
                this.dataPushService.deleteMultiTask(dataPush);
            }
            if (HussarUtils.isNotEmpty((Object)((TaskEntity)taskEntities.get(0)).getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            if (HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, longTaskIds))))) {
                ArrayList<String> userList = new ArrayList<String>();
                Iterator iterator = ccTasks.iterator();
                while (iterator.hasNext()) {
                    SysActCcTask ccTask = (SysActCcTask)iterator.next();
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(this.taskId)));
                    userList.add(ccTask.getReceiveUser());
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(String.join((CharSequence)",", userList));
                    dataPush.setTaskId(this.taskId);
                    dataPushes.add(dataPush);
                    this.dataPushService.addCcTask(dataPushes);
                }
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId)) {
                taskEntity.setAssignee(this.userId);
            }
            ParamModel paramModel = this.getParamModel(taskEntity, this.taskRejectModel);
            Context.getCommandContext().addAttribute("info", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            if (this.taskRejectModel != null) {
                taskEntity.setApprovalType(this.taskRejectModel.getApprovalType());
                if (this.taskRejectModel.getIdentityLink() != null) {
                    taskEntity.setDeptId(this.taskRejectModel.getIdentityLink().getDeptId());
                    taskEntity.setPostId(this.taskRejectModel.getIdentityLink().getPostId());
                }
            }
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "addedFrontNode", false, this.mandator);
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity.getId());
        ExecutionEntity ee = new ExecutionEntity();
        for (ExecutionEntity executionEntity2 : list) {
            List parent = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity2.getId());
            for (ExecutionEntity executionEntity3 : parent) {
                executionEntity3.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
            }
            executionEntity2.remove();
            List tasks = executionEntity2.getTasks();
            if (tasks != null && !tasks.isEmpty() && HussarUtils.isNotEmpty((Object)this.userId)) {
                ((TaskEntity)tasks.get(0)).setAssignee(this.userId);
            }
            ee = executionEntity2;
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        this.fireExecutionListener(executionEntity);
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.jumpModel, this.userId, type, this.taskRejectModel != null && this.taskRejectModel.isSubmit(), this.paramvar));
        return null;
    }

    public AlternativeMultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String taskId, String comment, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = this.type;
        this.mandator = mandator;
    }

    public AlternativeMultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String taskId, String comment, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = this.type;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
    }

    private static String joinStr(List<String> list) {
        return list == null ? null : String.join((CharSequence)",", list);
    }

    public ParamModel getParamModel(TaskEntity task, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setFrom(AlternativeMultiInstanceJumpTaskCmd.joinStr(this.jumpModel.getJumpFrom()));
        paramModel.setTo(AlternativeMultiInstanceJumpTaskCmd.joinStr(this.jumpModel.getJumpTo()));
        if (HussarUtils.isEmpty((Object)taskRejectModel)) {
            paramModel.setApprovalType(taskRejectModel.getApprovalType());
            paramModel.mappingCompleteType(this.type);
            paramModel.setHandler(this.userId);
            paramModel.setSendUser(this.userId);
            paramModel.mappingToCreateReason(this.type);
            paramModel.setLastNodeId(task.getTaskDefinitionKey());
            paramModel.setLastNodeName(task.getName());
            paramModel.mappingLastCompleteType(this.type);
            paramModel.setLastNodeHandler(this.userId);
            return paramModel;
        }
        paramModel.setComment(this.comment);
        paramModel.mappingCompleteType(this.type);
        if (HussarUtils.isNotEmpty((Object)taskRejectModel.getTaskId())) {
            if (!task.getId().equals(taskRejectModel.getTaskId())) {
                paramModel.mappingToDeleteType(this.type);
            }
        } else {
            paramModel.mappingToDeleteType(this.type);
        }
        Map targetAssigneeMap = (Map)BpmAttribute.getExecutionAttribute(task, "appoint_assignee");
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setAffectedNodeId(taskRejectModel.getAllAffectedTaskIds());
        paramModel.setHandler(taskRejectModel.getUserId());
        paramModel.setSendUser(taskRejectModel.getUserId());
        paramModel.mappingToCreateReason(this.type);
        paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
        paramModel.setLastNodeName(taskRejectModel.getTask().getName());
        paramModel.mappingLastCompleteType(this.type);
        paramModel.setLastNodeHandler(taskRejectModel.getUserId());
        paramModel.setActivityType("userTask");
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            execution.setEventName("end");
            List executionListeners = activity.getExecutionListeners("end");
            ExecutionListener executionListener = (ExecutionListener)executionListeners.get(0);
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

