/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.assignee.model.SysDepartment;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.dao.SysBusinessModuleMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmBusinessModule;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmBusinessModuleTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmModuleTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.service.ISysBusinessModuleService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysBusinessModuleServiceImpl
extends HussarServiceImpl<SysBusinessModuleMapper, BpmBusinessModule>
implements ISysBusinessModuleService {
    @Autowired
    private SysBusinessModuleMapper sysBusinessModuleMapper;
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    public ApiResponse<List<BpmBusinessModuleTreeModel>> getBusinessModuleTree() {
        List<BpmBusinessModuleTreeModel> oldBusinessModuleTree = this.sysBusinessModuleMapper.businessModuleTree();
        List<BpmBusinessModuleTreeModel> businessModuleTree = this.mergeTree(oldBusinessModuleTree, -1L);
        return ApiResponse.success(businessModuleTree);
    }

    public ApiResponse<List<BpmModuleTreeModel>> getBpmModuleTree() {
        List<BpmModuleTreeModel> oldBusinessModuleTree = this.sysBusinessModuleMapper.bpmModuleTree();
        List modelBuilds = this.modelService.getAllModelWithBusinessModelId();
        List<BpmModuleTreeModel> bpmModuleTreeModels = this.mergeBpmTree(oldBusinessModuleTree, modelBuilds, -1L);
        return ApiResponse.success(bpmModuleTreeModels);
    }

    public ApiResponse<List<SysDepartment>> getDepartmentList() {
        return ApiResponse.success((Object)this.iAssigneeChooseService.getDepartmentList());
    }

    public ApiResponse<BpmBusinessModuleTreeModel> queryById(Long businessModuleId) {
        BpmBusinessModuleTreeModel businessModule = this.sysBusinessModuleMapper.queryById(businessModuleId);
        return ApiResponse.success((Object)businessModule);
    }

    public ApiResponse<String> delete(Long businessModuleId) throws Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        List list = new ArrayList<Long>();
        ids.add(businessModuleId);
        list.add(businessModuleId);
        while (!(list = this.sysBusinessModuleMapper.selectObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BpmBusinessModule::getParentId, list)).select(new SFunction[]{BpmBusinessModule::getBusinessModuleId}))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                ids.add((Long)list.get(i));
            }
        }
        Long counts = this.modelService.count((Wrapper)new LambdaQueryWrapper().in(ModelBuild::getBusinessModelId, ids));
        if (counts > 0L) {
            throw new PublicClientException("\u5f53\u524d\u4e1a\u52a1\u6a21\u5757\u6216\u5b50\u6a21\u5757\u6709\u5173\u8054\u6d41\u7a0b\uff0c\u5220\u9664\u5931\u8d25", Boolean.valueOf(false));
        }
        if (this.removeByIds(ids)) {
            return ApiResponse.success((String)this.bpmConstantProperties.getDeleteSuccess());
        }
        return ApiResponse.fail((String)this.bpmConstantProperties.getDeleteFail());
    }

    private List<BpmBusinessModuleTreeModel> mergeTree(List<BpmBusinessModuleTreeModel> list, Long parentId) {
        ArrayList<BpmBusinessModuleTreeModel> tree = new ArrayList<BpmBusinessModuleTreeModel>();
        for (BpmBusinessModuleTreeModel temp : list) {
            if (!temp.getParentId().equals(parentId)) continue;
            temp.setChildrenList(this.mergeTree(list, temp.getId()));
            tree.add(temp);
        }
        return tree;
    }

    private List<BpmModuleTreeModel> mergeBpmTree(List<BpmModuleTreeModel> list, List<ModelBuild> modelBuilds, Long parentId) {
        ArrayList<BpmModuleTreeModel> tree = new ArrayList<BpmModuleTreeModel>();
        for (BpmModuleTreeModel temp : list) {
            if (!temp.getParentId().equals(parentId)) continue;
            temp.setChildrenList(this.mergeBpmTree(list, modelBuilds, temp.getId()));
            temp.setType("isModule");
            List bpmModuleTreeModels = modelBuilds.stream().filter(s -> temp.getId().toString().equals(s.getBusinessModelId())).map(s -> new BpmModuleTreeModel(Long.valueOf(s.getModelId()), s.getName(), s.getModelKey(), s.getVersion(), "1")).collect(Collectors.toList());
            temp.setChildrenList(bpmModuleTreeModels);
            tree.add(temp);
        }
        return tree;
    }

    public List<BpmModuleTreeModel> getBusinessModelByBusinessKeys(Collection<String> processKeys) {
        if (processKeys.isEmpty()) {
            return Collections.emptyList();
        }
        return this.sysBusinessModuleMapper.getBusinessModelByBusinessKeys(processKeys);
    }
}

