/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganOrPostInfo;
import com.jxdinfo.hussar.workflow.assignee.model.Personnel;
import com.jxdinfo.hussar.workflow.assignee.model.SysDepartment;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.assignee.model.UserMainInfo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import com.jxdinfo.hussar.workflow.outside.assigneefunction.service.AssigneeFunctionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@HussarTokenDs
@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeModeChooseService assigneeModeChooseService;
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";
    private static final Pattern UPDATE_SQL_REGEX = Pattern.compile("[^'\"]\\b(CREATE|INSERT|DELETE|UPDATE|DROP|ALTER)\\b[^'\"]");
    public static final char ESCAPE = '\\';
    private static final Map<String, String> POST_TYPE = new HashMap<String, String>();

    private String getDeploymentModel() {
        return this.lcdpBpmProperties.getDeploymentModel();
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userTree(id, isMainPost);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userTree(id, isMainPost);
                }
            }
            return this.workflowAssigneeChooseService.userTree(id, isMainPost, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getOrganIdByOutOrganId(String outOrganId) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getOrganIdByOutOrganId(outOrganId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getOrganIdByOutStruId(String outStruId) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getOrganIdByOutStruId(outStruId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.deptTree(id, organId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.deptTree(id, organId);
                }
            }
            return this.workflowAssigneeChooseService.deptTree(id, organId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> deptTrees() {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.deptTrees();
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.deptTrees();
                }
            }
            return this.workflowAssigneeChooseService.deptTrees();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree();
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.roleTree();
                }
            }
            return this.workflowAssigneeChooseService.roleTree();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree(id, roleId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.roleTree(id, roleId);
                }
            }
            return this.workflowAssigneeChooseService.roleTree(id, roleId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDetail(userIds);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userDetail(String.join((CharSequence)",", userIds));
                }
            }
            return this.workflowAssigneeChooseService.userDetail(userIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> organDetail(List<String> organIds, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.organDetail(organIds);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userDetail(String.join((CharSequence)",", organIds));
                }
            }
            return this.workflowAssigneeChooseService.userDetail(organIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private List<BpmTreeModel> userDeptDetail(String userId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDeptDetail(userId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userDeptDetail(userId);
                }
            }
            return this.workflowAssigneeChooseService.userDeptDetail(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getUserNames(List<String> userIds) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList) {
        List<BpmTreeModel> list = this.userDetail(userList, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    public Map<String, String> getUserNumberListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getNumber());
            }
        }
        return map;
    }

    public Map<String, Map<String, String>> getOrganNameAndOrganNumberByOrganId(List<String> organIds) {
        HashMap<String, Map<String, String>> mapFromOrganIdToOrganInfo = new HashMap<String, Map<String, String>>();
        List<BpmTreeModel> list = this.organDetail(organIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> organInfo = new HashMap<String, String>();
                organInfo.put("organName", bpmTreeModel.getLabel());
                organInfo.put("organNumber", bpmTreeModel.getNumber());
                organInfo.put("avatarUrl", bpmTreeModel.getAvatarUrl());
                mapFromOrganIdToOrganInfo.put(bpmTreeModel.getId(), organInfo);
            }
        }
        return mapFromOrganIdToOrganInfo;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getCandidateUser(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.get("workflowProcessInsId") != null) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        serviceName = null;
        deploymentModel = this.getDeploymentModel();
        if ("micro".equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        var7_7 = deploymentModel;
        var8_9 = -1;
        switch (var7_7.hashCode()) {
            case -1663673663: {
                if (!var7_7.equals("workflow-platform")) break;
                var8_9 = 0;
                break;
            }
            case 103890628: {
                if (!var7_7.equals("micro")) break;
                var8_9 = 1;
                break;
            }
            case -902265784: {
                if (!var7_7.equals("single")) break;
                var8_9 = 2;
                break;
            }
        }
        switch (var8_9) {
            case 0: {
                return this.assigneeModeChooseService.getCandidateUsers(condition, securityLevel);
            }
            case 1: {
                ** GOTO lbl45
            }
            default: {
                return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel);
            }
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
            }
lbl45:
            // 1 sources

            try {
                assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getCandidateUser(condition, securityLevel, false);
            }
            catch (Exception e) {}
            {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BpmTreeModel> getCandidateUserWithParent(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        serviceName = null;
        deploymentModel = this.getDeploymentModel();
        if ("micro".equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        var7_7 = deploymentModel;
        var8_9 = -1;
        switch (var7_7.hashCode()) {
            case -1663673663: {
                if (!var7_7.equals("workflow-platform")) break;
                var8_9 = 0;
                break;
            }
            case 103890628: {
                if (!var7_7.equals("micro")) break;
                var8_9 = 1;
                break;
            }
            case -902265784: {
                if (!var7_7.equals("single")) break;
                var8_9 = 2;
                break;
            }
        }
        switch (var8_9) {
            case 0: {
                return this.assigneeModeChooseService.getCandidateUsersWithParent(condition, securityLevel);
            }
            case 1: {
                ** GOTO lbl45
            }
            default: {
                return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel);
            }
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
            }
lbl45:
            // 1 sources

            try {
                assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getCandidateUserWithParent(condition, securityLevel, false);
            }
            catch (Exception e) {}
            {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        SysActFunction function = this.sysActFunctionService.getFunctionByBeanId(beanId);
        if (HussarUtils.isEmpty((Object)function)) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
        }
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = this.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((String)beanId);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                    return hussarBpmVariablesVisitor.visit(map);
                }
                case "micro": {
                    try {
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)SpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    String response = HttpClient.doGet((String)url, (Map)map);
                    return JSON.parseArray((String)response, String.class);
                }
                case "POST": {
                    String response = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)map));
                    return JSON.parseArray((String)response, String.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserId(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getSameLevelDeptIdByUserId(userId);
                }
            }
            return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserId(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getParentDeptIdByUserId(userId);
                }
            }
            return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getDeptIdByUserIds(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getDeptIdByUserIds(userId);
                }
            }
            return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserIds(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getSameLevelDeptIdByUserIds(userId);
                }
            }
            return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserIds(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getParentDeptIdByUserIds(userId);
                }
            }
            return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Integer getSecurityLevel(String userId, String url) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSecurityLevel(userId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return Integer.valueOf(remoteAssigneeChooseService.getSecurityLevel(userId));
                }
            }
            return this.workflowAssigneeChooseService.getSecurityLevel(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getStarterDept(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByDeptName(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryDeptTreeByDeptName(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeByUserName(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserTreeByUserName(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByUserName(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserListByUserName(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryUserListByUserName(organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryRoleTreeByRoleName(roleName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryRoleTreeByRoleName(roleName);
                }
            }
            return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTree(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserTree(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryUserTree(organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> postTree() {
        ArrayList<BpmTreeModel> postTypeNodes = new ArrayList<BpmTreeModel>();
        postTypeNodes.add(new BpmTreeModel("0201", POST_TYPE.get("0201"), "0201"));
        postTypeNodes.add(new BpmTreeModel("0202", POST_TYPE.get("0202"), "0202"));
        postTypeNodes.add(new BpmTreeModel("0203", POST_TYPE.get("0203"), "0203"));
        postTypeNodes.add(new BpmTreeModel("0204", POST_TYPE.get("0204"), "0204"));
        postTypeNodes.add(new BpmTreeModel("0205", POST_TYPE.get("0205"), "0205"));
        postTypeNodes.add(new BpmTreeModel("0206", POST_TYPE.get("0206"), "0206"));
        postTypeNodes.add(new BpmTreeModel("0207", POST_TYPE.get("0207"), "0207"));
        postTypeNodes.add(new BpmTreeModel("0208", POST_TYPE.get("0208"), "0208"));
        postTypeNodes.add(new BpmTreeModel("0301", POST_TYPE.get("0301"), "0301"));
        postTypeNodes.add(new BpmTreeModel("0302", POST_TYPE.get("0302"), "0302"));
        postTypeNodes.add(new BpmTreeModel("0303", POST_TYPE.get("0303"), "0303"));
        postTypeNodes.add(new BpmTreeModel("0304", POST_TYPE.get("0304"), "0304"));
        List postNodes = new ArrayList();
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    postNodes = this.assigneeModeChooseService.postTree();
                    break;
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    postNodes = assigneeChooseService.postTree();
                    break;
                }
                default: {
                    postNodes = this.workflowAssigneeChooseService.postTree();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
        HashMap<String, BpmTreeModel> map = new HashMap<String, BpmTreeModel>();
        if (postNodes != null && postNodes.size() != 0) {
            for (BpmTreeModel postNode : postNodes) {
                map.put(String.valueOf(postNode.getId()), postNode);
            }
        }
        if (postNodes != null && postNodes.size() != 0) {
            for (BpmTreeModel postNode : postNodes) {
                Object o;
                if ("-1".equals(String.valueOf(postNode.getParentId())) || (o = map.get(String.valueOf(postNode.getParentId()))) == null) continue;
                ((BpmTreeModel)o).getChildren().add(postNode);
            }
        }
        for (BpmTreeModel postTypeNode : postTypeNodes) {
            String postType = postTypeNode.getType();
            ArrayList<BpmTreeModel> childrenList = new ArrayList<BpmTreeModel>();
            for (BpmTreeModel postNode : postNodes) {
                if (postNode.getParentId() != null && !"-1".equals(postNode.getParentId()) || !postType.equals(postNode.getType())) continue;
                childrenList.add(postNode);
            }
            postTypeNode.setChildrenList(childrenList);
            postTypeNode.setChildren(childrenList);
            if (childrenList.size() != 0) {
                postTypeNode.setIsLeaf("false");
                continue;
            }
            postTypeNode.setIsLeaf("true");
        }
        return postTypeNodes;
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType());
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType());
                }
            }
            return this.workflowAssigneeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByChildren(bpmTreeModel);
                }
            }
            return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryAssigneeAndDept(users, organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryAssigneeAndDept(users, organName);
                }
            }
            return this.workflowAssigneeChooseService.queryAssigneeAndDept(users, organName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryNodeAssigneeListByPage(pages, String.join((CharSequence)",", users), organId, type);
                }
            }
            return this.workflowAssigneeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, JSON.toJSONString(users), organId, type, organName);
                }
            }
            return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, true, organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserAndAccountListByUserId(userIds);
                }
            }
            return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(userIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserInfoVo>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserMsgByUserIds(userIds);
                }
            }
            return this.workflowAssigneeChooseService.getUserMsgByUserIds(userIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryList(page, getListDto);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.queryList(Long.valueOf(page.getSize()), Long.valueOf(page.getCurrent()), getListDto);
            }
        }
        return this.workflowAssigneeChooseService.queryList(page, getListDto, true);
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryDept(name);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.queryDept(name);
            }
        }
        return this.workflowAssigneeChooseService.queryDept(name);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryRole(name);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.queryRole(name);
            }
        }
        return this.workflowAssigneeChooseService.queryRole(name);
    }

    public String queryPlatformModel() {
        String deploymentModel = this.getDeploymentModel();
        if (WORKFLOW_PLATFORM.equals(deploymentModel)) {
            return this.lcdpBpmProperties.getAssigneeMode();
        }
        return deploymentModel;
    }

    public Map<String, UserDepartmentAndPostModel> getUserMainInfo(Collection<String> userIds) {
        List userDepartmentAndPostModels;
        String deploymentModel;
        if (userIds.isEmpty()) {
            return new HashMap<String, UserDepartmentAndPostModel>();
        }
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                userDepartmentAndPostModels = this.assigneeModeChooseService.getUserMainInfo(userIds);
                break;
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                userDepartmentAndPostModels = assigneeChooseService.getUserMainInfo(userIds);
                break;
            }
            default: {
                userDepartmentAndPostModels = this.workflowAssigneeChooseService.getUserMainInfo(userIds);
            }
        }
        return userDepartmentAndPostModels == null ? new HashMap<String, UserDepartmentAndPostModel>() : userDepartmentAndPostModels.stream().collect(Collectors.toMap(UserDepartmentAndPostModel::getUserId, Function.identity(), (o1, o2) -> o2));
    }

    public Object getSqlResult(Map<String, String> sqlMessage) {
        Matcher matcher;
        boolean needChangeDataSource = false;
        if (!"master".equals(sqlMessage.get("dataBaseName"))) {
            needChangeDataSource = true;
        }
        boolean isSqlError = (matcher = UPDATE_SQL_REGEX.matcher(" " + sqlMessage.get("sql").toUpperCase() + " ")).find() || sqlMessage.get("sql").contains(";");
        String deploymentModel = this.getDeploymentModel();
        switch (sqlMessage.get("resultType")) {
            case "List<String>": {
                if (isSqlError) {
                    return new ArrayList();
                }
                switch (deploymentModel) {
                    case "workflow-platform": {
                        return this.assigneeModeChooseService.getListStringSqlResult(sqlMessage.get("sql"));
                    }
                    case "micro": {
                        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                        return assigneeChooseService.getListStringSqlResult(sqlMessage.get("sql"));
                    }
                }
                return this.workflowAssigneeChooseService.getListStringSqlResult(sqlMessage.get("sql"));
            }
            case "List<Map<String, String>>": {
                if (isSqlError) {
                    return new ArrayList();
                }
                switch (deploymentModel) {
                    case "workflow-platform": {
                        return this.assigneeModeChooseService.getListMapSqlResult(sqlMessage.get("sql"));
                    }
                    case "micro": {
                        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                        return assigneeChooseService.getListMapSqlResult(sqlMessage.get("sql"));
                    }
                }
                return this.workflowAssigneeChooseService.getListMapSqlResult(sqlMessage.get("sql"));
            }
            case "Boolean": {
                if (isSqlError) {
                    return false;
                }
                switch (deploymentModel) {
                    case "workflow-platform": {
                        return this.assigneeModeChooseService.getBooleanSqlResult(sqlMessage.get("sql"));
                    }
                    case "micro": {
                        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                        return assigneeChooseService.getBooleanSqlResult(sqlMessage.get("sql"));
                    }
                }
                return this.workflowAssigneeChooseService.getBooleanSqlResult(sqlMessage.get("sql"));
            }
        }
        return null;
    }

    public Map<String, Object> getDeptParamsByUserId(String userId, String tenantId) {
        Map result;
        String deploymentModel;
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                result = this.assigneeModeChooseService.getDeptParamsByUserId(userId);
                break;
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                result = assigneeChooseService.getDeptParamsByUserId(userId);
                break;
            }
            default: {
                result = this.workflowAssigneeChooseService.getDeptParamsByUserId(userId);
            }
        }
        return result == null ? new HashMap() : result;
    }

    public List<Personnel> getPersonnelByDepartmentId(String organType, String departmentId) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getPersonnelByDepartmentId(organType, departmentId);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getPersonnelByDepartmentId(organType, departmentId);
            }
        }
        return this.workflowAssigneeChooseService.getPersonnelByDepartmentId(organType, departmentId);
    }

    public List<Personnel> getPersonnelByUserName(String userName) {
        if (userName != null && userName.length() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object c : (String)userName.toCharArray()) {
                if (c == 37 || c == 95) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append((char)c);
            }
            userName = stringBuilder.toString();
        }
        String deploymentModel = this.getDeploymentModel();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getPersonnelByUserName(userName);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getPersonnelByUserName(userName);
            }
        }
        return this.workflowAssigneeChooseService.getPersonnelByUserName(userName);
    }

    public Map<String, UserDepartmentAndPostModel> getUserDepartmentAndPostModelByUserIds(List<String> userIds) {
        HashMap<String, UserDepartmentAndPostModel> userDepartmentAndPostModelMap = new HashMap<String, UserDepartmentAndPostModel>();
        ArrayList<String> departmentIds = new ArrayList<String>();
        ArrayList<String> postIds = new ArrayList<String>();
        ArrayList<String> unitIds = new ArrayList<String>();
        List userDepartmentAndPostModels = new ArrayList();
        String deploymentModel = this.getDeploymentModel();
        switch (deploymentModel) {
            case "workflow-platform": {
                userDepartmentAndPostModels = this.assigneeModeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
                break;
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                userDepartmentAndPostModels = assigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
                break;
            }
            default: {
                userDepartmentAndPostModels = this.workflowAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
            }
        }
        if (userDepartmentAndPostModels != null && userDepartmentAndPostModels.size() != 0) {
            for (UserDepartmentAndPostModel userDepartmentAndPostModel : userDepartmentAndPostModels) {
                if (userDepartmentAndPostModel.getDepartmentId() != null && userDepartmentAndPostModel.getDepartmentId().length() != 0) {
                    departmentIds.add(userDepartmentAndPostModel.getDepartmentId());
                }
                if (userDepartmentAndPostModel.getPostId() != null && userDepartmentAndPostModel.getPostId().length() != 0) {
                    postIds.add(userDepartmentAndPostModel.getPostId());
                }
                if (userDepartmentAndPostModel.getUnitId() == null || userDepartmentAndPostModel.getUnitId().length() == 0) continue;
                unitIds.add(userDepartmentAndPostModel.getUnitId());
            }
        }
        Map<String, String> depatments = this.getDepartmentNameBydepartmentIds(departmentIds);
        Map<String, String> posts = this.getPostNameBypostIds(postIds);
        Map<String, String> units = this.getDepartmentNameBydepartmentIds(unitIds);
        if (userDepartmentAndPostModels != null && userDepartmentAndPostModels.size() != 0) {
            for (UserDepartmentAndPostModel userDepartmentAndPostModel : userDepartmentAndPostModels) {
                String userId = userDepartmentAndPostModel.getUserId();
                String departmentId = userDepartmentAndPostModel.getDepartmentId();
                String postId = userDepartmentAndPostModel.getPostId();
                String unitId = userDepartmentAndPostModel.getUnitId();
                if (departmentId != null && departmentId.length() != 0) {
                    userDepartmentAndPostModel.setDepartmentName(depatments.get(departmentId));
                }
                if (postId != null && postId.length() != 0) {
                    userDepartmentAndPostModel.setPostName(posts.get(postId));
                }
                if (unitId != null && unitId.length() != 0) {
                    userDepartmentAndPostModel.setUnitName(units.get(unitId));
                }
                userDepartmentAndPostModelMap.put(userId, userDepartmentAndPostModel);
            }
        }
        return userDepartmentAndPostModelMap;
    }

    public Map<String, UserMainInfo> getUserOutMainInfo(Collection<String> userIds, String userIdType) {
        String deploymentModel;
        HashSet<String> userSet = this.collectionToHashSet(userIds);
        if (userSet.isEmpty()) {
            return new HashMap<String, UserMainInfo>();
        }
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.group(this.assigneeModeChooseService.getUserOutMainInfo(userSet, userIdType), UserMainInfo::getInnerUserId);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return this.group(assigneeChooseService.getUserOutMainInfo(userSet), UserMainInfo::getInnerUserId);
            }
        }
        return this.group(this.workflowAssigneeChooseService.getUserOutMainInfo(userSet, userIdType), UserMainInfo::getInnerUserId);
    }

    public Map<String, OrganOrPostInfo> getUserOutOrganInfo(Collection<String> userIds, String userIdType) {
        String deploymentModel;
        HashSet<String> userSet = this.collectionToHashSet(userIds);
        if (userSet.isEmpty()) {
            return new HashMap<String, OrganOrPostInfo>();
        }
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.group(this.assigneeModeChooseService.getUserOutOrganInfo(userSet, userIdType), OrganOrPostInfo::getInnerId);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return this.group(assigneeChooseService.getUserOutOrganInfo(userSet), OrganOrPostInfo::getInnerId);
            }
        }
        return this.group(this.workflowAssigneeChooseService.getUserOutOrganInfo(userSet, userIdType), OrganOrPostInfo::getInnerId);
    }

    public Map<String, OrganOrPostInfo> getUserOutPostInfo(Collection<String> userIds) {
        String deploymentModel;
        HashSet<String> userSet = this.collectionToHashSet(userIds);
        if (userSet.isEmpty()) {
            return new HashMap<String, OrganOrPostInfo>();
        }
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.group(this.assigneeModeChooseService.getUserOutPostInfo(userSet), OrganOrPostInfo::getInnerId);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return this.group(assigneeChooseService.getUserOutPostInfo(userSet), OrganOrPostInfo::getInnerId);
            }
        }
        return this.group(this.workflowAssigneeChooseService.getUserOutPostInfo(userSet), OrganOrPostInfo::getInnerId);
    }

    public Map<String, String> getDepartmentNameBydepartmentIds(List<String> departmentIds) {
        HashMap<String, String> departmentMap = new HashMap<String, String>();
        List departmentInfos = new ArrayList();
        String deploymentModel = this.getDeploymentModel();
        switch (deploymentModel) {
            case "workflow-platform": {
                departmentInfos = this.assigneeModeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
                break;
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                departmentInfos = assigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
                break;
            }
            default: {
                departmentInfos = this.workflowAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
            }
        }
        if (departmentInfos != null && departmentInfos.size() != 0) {
            for (Map departmentInfo : departmentInfos) {
                String departmentId = String.valueOf(departmentInfo.get("departmentId"));
                String departmentName = (String)departmentInfo.get("departmentName");
                departmentMap.put(departmentId, departmentName);
            }
        }
        return departmentMap;
    }

    public Map<String, String> getPostNameBypostIds(List<String> postIds) {
        HashMap<String, String> postMap = new HashMap<String, String>();
        List postInfos = new ArrayList();
        String deploymentModel = this.getDeploymentModel();
        switch (deploymentModel) {
            case "workflow-platform": {
                postInfos = this.assigneeModeChooseService.getPostNameBypostIds(postIds);
                break;
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                postInfos = assigneeChooseService.getPostNameBypostIds(postIds);
                break;
            }
            default: {
                postInfos = this.workflowAssigneeChooseService.getPostNameBypostIds(postIds);
            }
        }
        if (postInfos != null && postInfos.size() != 0) {
            for (Map postInfo : postInfos) {
                String postId = String.valueOf(postInfo.get("postId"));
                String postName = (String)postInfo.get("postName");
                postMap.put(postId, postName);
            }
        }
        return postMap;
    }

    public List<Map<String, String>> getDepartmentIdAndPost(List<String> postIdList, List<String> postOrganIdList, List<String> userIdList) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getDepartmentIdAndPost(postIdList, postOrganIdList, userIdList);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getDepartmentIdAndPost(postIdList, postOrganIdList, userIdList);
            }
        }
        return this.workflowAssigneeChooseService.getDepartmentIdAndPost(postIdList, postOrganIdList, userIdList);
    }

    public List<Map<String, String>> getAllOrgansBysk() {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getAllOrgansBysk();
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getAllOrgansBysk();
            }
        }
        return this.workflowAssigneeChooseService.getAllOrgansBysk();
    }

    public List<UserDepartmentAndPostModel> getUserInfoByPost(List<String> departmentIdList, List<Long> postIdList) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getUserInfoByPost(departmentIdList, postIdList);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getUserInfoByPost(departmentIdList, postIdList);
            }
        }
        return this.workflowAssigneeChooseService.getUserInfoByPost(departmentIdList, postIdList);
    }

    public Collection<String> getUserIdsByUserName(String userName) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getUserIdsByUserName(userName);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getUserIdsByUserName(userName);
            }
        }
        return this.workflowAssigneeChooseService.getUserIdsByUserName(userName);
    }

    public Collection<String> getPostIdsByPostName(String postName) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getPostIdsByPostName(postName);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getPostIdsByPostName(postName);
            }
        }
        return this.workflowAssigneeChooseService.getPostIdsByPostName(postName);
    }

    public Collection<String> getDeptIdsByDeptName(String deptName) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getDeptIdsByDeptName(deptName);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getDeptIdsByDeptName(deptName);
            }
        }
        return this.workflowAssigneeChooseService.getDeptIdsByDeptName(deptName);
    }

    public String getUserIdByUserNumber(String userNumber) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getUserIdByUserNumber(userNumber);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getUserIdByUserNumber(userNumber);
            }
        }
        return this.workflowAssigneeChooseService.getUserIdByUserNumber(userNumber);
    }

    public List<BpmTreeModel> deptName(String id) {
        String deploymentModel;
        List<Object> newId;
        List<Object> list = newId = StringUtils.isEmpty((Object)id) ? new ArrayList() : Arrays.asList(id.split(","));
        if (HussarUtils.isEmpty(newId)) {
            return new ArrayList<BpmTreeModel>();
        }
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.deptName(newId.stream().map(Long::valueOf).collect(Collectors.toList()));
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.deptName(id);
            }
        }
        return this.workflowAssigneeChooseService.deptName(newId.stream().map(Long::valueOf).collect(Collectors.toList()));
    }

    public String getParentId(String userId) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getParentId(userId);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getParentId(userId);
            }
        }
        return this.workflowAssigneeChooseService.getparentId(userId);
    }

    public List<SysDepartment> getDepartmentList() {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getDepartmentList();
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getDepartmentList();
            }
        }
        return this.workflowAssigneeChooseService.getDepartmentList();
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }

    private HashSet<String> collectionToHashSet(Collection<String> set) {
        HashSet<String> result = set instanceof HashSet ? (HashSet<String>)set : new HashSet<String>(set);
        this.removeNull(result);
        return result;
    }

    private void removeNull(Set<String> set) {
        set.remove("");
        set.remove(null);
    }

    private <KEY, T> Map<KEY, T> group(List<T> list, Function<T, KEY> function) {
        HashMap<KEY, T> map = new HashMap<KEY, T>();
        if (HussarUtils.isEmpty(list)) {
            return map;
        }
        for (T t : list) {
            map.put(function.apply(t), t);
        }
        return map;
    }

    static {
        POST_TYPE.put("0201", "\u516c\u53f8");
        POST_TYPE.put("0202", "\u4e8c\u7ea7\u5355\u4f4d/\u7ecf\u7406\u90e8");
        POST_TYPE.put("0203", "\u7247\u533a");
        POST_TYPE.put("0204", "\u9879\u76ee");
        POST_TYPE.put("0205", "\u90e8\u95e8");
        POST_TYPE.put("0206", "\u76f8\u5173\u65b9\u7ec4\u7ec7");
        POST_TYPE.put("0207", "\u673a\u5173");
        POST_TYPE.put("0208", "\u9879\u76ee\u90e8");
        POST_TYPE.put("0301", "\u5206\u5305");
        POST_TYPE.put("0302", "\u4f9b\u5e94\u5546\uff08\u5206\u4f9b\uff09");
        POST_TYPE.put("0303", "\u4e1a\u4e3b");
        POST_TYPE.put("0304", "\u7532\u6307\u5206\u5305");
    }
}

