/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.constant;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.context.Context;

public class BpmHistoryActivity {
    private static final HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);

    private static ProcessHistoryActivityModel getHistoryTaskList(String processInstId) {
        ProcessHistoryActivityModel historyActivity;
        HashMap<String, ProcessHistoryActivityModel> historyActivityMap = (HashMap<String, ProcessHistoryActivityModel>)BpmAttribute.getContextAttribute("history_activity");
        if (historyActivityMap == null) {
            historyActivityMap = new HashMap<String, ProcessHistoryActivityModel>();
            Context.getCommandContext().addAttribute("history_activity", historyActivityMap);
        }
        if ((historyActivity = (ProcessHistoryActivityModel)historyActivityMap.get(processInstId)) == null) {
            List historicActivityInstances = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstId).list();
            historyActivity = new ProcessHistoryActivityModel(historicActivityInstances);
            historyActivityMap.put(processInstId, historyActivity);
        }
        return historyActivity;
    }

    public static List<HistoricActivityInstance> getActivityByType(String procInstId, String activityType) {
        return BpmHistoryActivity.getHistoryTaskList(procInstId).getActivity(acticity -> Objects.equals(acticity.getActivityType(), activityType));
    }

    public static List<HistoricActivityInstance> getRunningActivityByType(String procInstId, String activityType) {
        return BpmHistoryActivity.getHistoryTaskList(procInstId).getRunningActivity(acticity -> Objects.equals(acticity.getActivityType(), activityType));
    }

    public static List<HistoricActivityInstance> getRunningActivity(String procInstId) {
        List<HistoricActivityInstance> runningActivity = BpmHistoryActivity.getHistoryTaskList(procInstId).getRunningActivity();
        return runningActivity == null ? null : Collections.unmodifiableList(runningActivity);
    }

    public static List<HistoricActivityInstance> getRunningActivity(String procInstId, Predicate<HistoricActivityInstance> predicate) {
        return BpmHistoryActivity.getHistoryTaskList(procInstId).getRunningActivity(predicate);
    }

    private static class ProcessHistoryActivityModel {
        private final List<HistoricActivityInstance> allActivity;
        private List<HistoricActivityInstance> runningActivity;

        private ProcessHistoryActivityModel(List<HistoricActivityInstance> allActivity) {
            this.allActivity = allActivity;
        }

        public List<HistoricActivityInstance> getAllActivity() {
            return this.allActivity;
        }

        public List<HistoricActivityInstance> getRunningActivity() {
            if (this.runningActivity == null) {
                this.runningActivity = this.allActivity.stream().filter(task -> task.getEndTime() == null).collect(Collectors.toList());
            }
            return this.runningActivity;
        }

        public List<HistoricActivityInstance> getActivity(Predicate<HistoricActivityInstance> predicate) {
            return this.getAllActivity().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<HistoricActivityInstance> getRunningActivity(Predicate<HistoricActivityInstance> predicate) {
            return this.getRunningActivity().stream().filter(predicate).collect(Collectors.toList());
        }
    }
}

