/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActRuTaskMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuTask;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.dto.AlternativeTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.model.AlternativeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.service.IAlternativeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.ApprovalUser;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowlog.model.UserLog;
import com.jxdinfo.hussar.workflow.engine.bpm.flowlog.service.IBpmLogService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.AlterTaskNodeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.model.BpmActPendingTask;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.model.SubCandidate;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.service.ISubCandidateService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.LineConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.flowmodel.SequenceSourceTarget;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AddCustomNodeServiceImpl
implements AddCustomNodeService {
    private static final Logger logger = LoggerFactory.getLogger(AddCustomNodeServiceImpl.class);
    private static final int USER_TASK_WIDTH = 48;
    private static final int USER_TASK_HEIGHT = 48;
    private static final int MOVE_WIDTH = 96;
    private static final String ADD_CUSTOM_PATH_ID_PREFIX = "jxd_bpm_custom_path";
    private Bpm2XMLService xmlService;
    private SysActProcessFileService sysActProcessFileService;
    private ITaskEngineService taskEngineService;
    private ModelService modelService;
    private BpmConstantProperties bpmConstantProperties;
    private SysActFormAuthService sysActFormAuthService;
    private LcdpBpmProperties lcdpBpmProperties;
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;
    @Autowired
    private BpmActPendingTaskService bpmActPendingTaskService;
    @Autowired
    private IBpmLogService iBpmLogService;
    @Autowired
    private BpmActRuTaskMapper bpmActRuTaskMapper;
    @Autowired
    private IAlternativeTaskService alternativeTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ISubCandidateService subCandidateService;
    @Autowired
    private IBpmActRuIdentitylinkService bpmActRuIdentitylinkService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    @Autowired
    public AddCustomNodeServiceImpl(Bpm2XMLService xmlService, ModelService modelService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ITaskEngineService taskEngineService, SysActFormAuthService sysActFormAuthService, LcdpBpmProperties lcdpBpmProperties, RepositoryService repositoryService) {
        this.xmlService = xmlService;
        this.modelService = modelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.taskEngineService = taskEngineService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.sysActFormAuthService = sysActFormAuthService;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.repositoryService = repositoryService;
    }

    public ApiResponse<String> isAddParallel(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.taskEngineService.getTask(taskId, "0");
        String identityId = task.getProcessDefinitionId().split(":")[0];
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId());
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        String nextNodeId = null;
        block0: for (Object path : paths) {
            if (!path.getStart().getKey().equals(task.getTaskDefinitionKey())) continue;
            nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) break block0;
                return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotAddParallel());
            }
        }
        if (nextNodeId == null) {
            throw new BpmException(BpmExceptionCodeEnum.SUB_PROCESS_CONNOT_ADD_NODE);
        }
        ArrayList<String> gatewayNextNodeId = new ArrayList<String>();
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nextNodeId)) continue;
            gatewayNextNodeId.add(path.getEnd().getKey());
        }
        String mergeGatewayId = null;
        for (FlowSequence path : paths) {
            if (!gatewayNextNodeId.contains(path.getStart().getKey())) continue;
            if (mergeGatewayId == null) {
                mergeGatewayId = path.getEnd().getKey();
                continue;
            }
            if (path.getEnd().getKey().equals(mergeGatewayId)) continue;
            return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotConfluenceParallel());
        }
        if (mergeGatewayId == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotConfluenceParallel());
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getId().equals(mergeGatewayId)) continue;
            if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) break;
            return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotConfluenceParallel());
        }
        return ApiResponse.success((String)this.bpmConstantProperties.getIsAddParallel());
    }

    public ApiResponse<String> isAddCustomNode(String taskId) {
        Task task = this.taskEngineService.getTask(taskId = RealTaskId.getRealTaskId(taskId), "0");
        String subProcessKey = task.getSubProcessKey();
        if (subProcessKey == null) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)this.bpmConstantProperties.getSubProcessCanNotAddNode());
    }

    public ApiResponse<String> addNode(String taskId, String addList, String parallel) {
        if (HussarUtils.isEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
        }
        List list = (List)JSON.parseObject((String)addList, List.class);
        Task task = this.taskEngineService.getTask(taskId, "0");
        try {
            String identityId = task.getProcessDefinitionId().split(":")[0];
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("nodeId", task.getTaskDefinitionKey());
            map.put("addList", list);
            map.put("parallel", parallel);
            ArrayList<String> addNodeIds = new ArrayList<String>();
            WorkFlow newWorkFlow = this.getNewWorkFlow(workFlow, addNodeIds, map);
            BpmnModel bpmnModel = this.xmlService.getBpmnModel(newWorkFlow, identityId);
            SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)0));
            Long modelId = metaInfo.getModelId();
            String version = this.modelService.getRealVersion(task.getProcessDefinitionId());
            String processKey = task.getProcessDefinitionId().split(":")[0];
            this.saveFormAuth(processKey, task.getTaskDefinitionKey(), addNodeIds);
            if (!task.getProcessDefinitionId().split(":")[1].equals(version)) {
                this.xmlService.updateModel(newWorkFlow, bpmnModel, task.getProcessDefinitionId());
                this.modelService.addNodeSaveModelExtendProperties(bpmnModel, task.getProcessDefinitionId());
            } else {
                this.modelService.deployModelByWorkFlowXml(newWorkFlow, bpmnModel, String.valueOf(modelId), task.getProcessInstanceId(), version);
            }
            return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
        }
        catch (BpmException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)this.bpmConstantProperties.getErrorAddCustomNode());
        }
    }

    public ApiResponse<String> alternativeTaskInStartProcess(String processDefinitionId, String userId, String deptId, List<AlternativeTaskDto> alternativeTaskDtos, boolean isDelete, String businessId, Map<String, Object> variables) {
        String version = this.modelService.getRealVersion(processDefinitionId);
        String identityId = processDefinitionId.split(":")[0];
        String realProcessDefinitionId = this.modelService.getRealProcessDefinitionId(identityId, version);
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, processDefinitionId);
        ArrayList<AlternativeTask> addFrontTaskNodes = new ArrayList<AlternativeTask>();
        ArrayList<AlternativeTask> addBackTaskNodes = new ArrayList<AlternativeTask>();
        ArrayList<String> deleteBackTaskNodeIds = new ArrayList<String>();
        if (!isDelete) {
            if (this.isFrontNodeAtFirstNode(workFlow, processDefinitionId, alternativeTaskDtos)) {
                throw new PublicClientException("\u4e0d\u5141\u8bb8\u5411\u7b2c\u4e00\u4e2a\u8282\u70b9\u524d\u6dfb\u52a0\u5907\u9009\u8282\u70b9");
            }
            String startDefKey = ((ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processDefinitionId)).getInitial().getId();
            this.handleAlternativeTaskInStartProcess(addFrontTaskNodes, addBackTaskNodes, deleteBackTaskNodeIds, alternativeTaskDtos, workFlow, businessId, realProcessDefinitionId);
            if (HussarUtils.isEmpty(alternativeTaskDtos) && HussarUtils.isEmpty(deleteBackTaskNodeIds)) {
                return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
            }
            for (AlternativeTask addTaskNode : addFrontTaskNodes) {
                this.addNodeNewWorkFlow(workFlow, addTaskNode, startDefKey, false, true, userId, deptId, businessId, processDefinitionId, variables);
            }
            for (AlternativeTask addTaskNode : addBackTaskNodes) {
                this.addNodeNewWorkFlow(workFlow, addTaskNode, startDefKey, false, false, userId, deptId, businessId, processDefinitionId, variables);
            }
            BpmnModel bpmnModel = this.xmlService.getBpmnModel(workFlow, identityId);
            if (!processDefinitionId.split(":")[1].equals(version)) {
                this.xmlService.updateModel(workFlow, bpmnModel, processDefinitionId);
                this.modelService.addNodeSaveModelExtendProperties(workFlow, processDefinitionId);
            } else {
                SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)version));
                Long modelId = metaInfo.getModelId();
                processDefinitionId = this.modelService.deployModelByWorkFlowXml(workFlow, bpmnModel, String.valueOf(modelId), null, version);
            }
            ArrayList pendingTasks = new ArrayList();
            String procDefId = processDefinitionId;
            addFrontTaskNodes.forEach(o -> {
                List approvalUsers = o.getApprovalUsers();
                approvalUsers.forEach(t -> {
                    BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                    bpmActPendingTask.setTaskDefKey(o.getNewTaskDefinitionKey());
                    bpmActPendingTask.setTaskName(o.getTaskDefinitionName());
                    bpmActPendingTask.setSeq(1);
                    bpmActPendingTask.setProcDefId(procDefId);
                    bpmActPendingTask.setProcessKey(identityId);
                    bpmActPendingTask.setBusinessId(businessId);
                    bpmActPendingTask.setIsMain("0");
                    bpmActPendingTask.setPendingType("1");
                    bpmActPendingTask.setIsMain(t.getIsMain());
                    bpmActPendingTask.setOwner(HussarUtils.isEmpty((Object)t.getOwner()) ? t.getUserId() : t.getOwner());
                    bpmActPendingTask.setAssignee(t.getUserId());
                    bpmActPendingTask.setPosition(t.getPostId());
                    bpmActPendingTask.setDeptId(t.getDeptId());
                    pendingTasks.add(bpmActPendingTask);
                });
            });
            if (!pendingTasks.isEmpty()) {
                ((BpmActPendingTask)pendingTasks.iterator().next()).setIsMain("1");
                this.bpmActPendingTaskService.saveBatch(pendingTasks);
            }
        } else {
            workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, processDefinitionId);
            if (!alternativeTaskDtos.get(0).getAlternativeTaskId().contains("jxd_bpm_custom_node")) {
                throw new PublicClientException("\u4e0d\u80fd\u5220\u9664\u975e\u5907\u9009\u8282\u70b9\uff01");
            }
            deleteBackTaskNodeIds.add(alternativeTaskDtos.get(0).getAlternativeTaskId());
            if (HussarUtils.isEmpty(alternativeTaskDtos) && HussarUtils.isEmpty(deleteBackTaskNodeIds)) {
                return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
            }
            for (String deleteNodeId : deleteBackTaskNodeIds) {
                this.deleteNodeNewWorkFlow(workFlow, deleteNodeId);
            }
            BpmnModel bpmnModel = this.xmlService.getBpmnModel(workFlow, identityId);
            if (!processDefinitionId.split(":")[1].equals(version)) {
                this.xmlService.updateModel(workFlow, bpmnModel, processDefinitionId);
                this.modelService.addNodeSaveModelExtendProperties(workFlow, processDefinitionId);
            } else {
                SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)version));
                Long modelId = metaInfo.getModelId();
                processDefinitionId = this.modelService.deployModelByWorkFlowXml(workFlow, bpmnModel, String.valueOf(modelId), processDefinitionId, version);
            }
        }
        this.bpmActPendingTaskService.updatePendingTask(null, processDefinitionId, businessId, null, userId, deptId, null, variables, true);
        if (!addFrontTaskNodes.isEmpty()) {
            for (int i = 0; i < addFrontTaskNodes.size(); ++i) {
                ArrayList<UserLog> users = new ArrayList<UserLog>();
                StringBuffer sb = new StringBuffer();
                sb.append("\u628a\u5ba1\u6279\u8282\u70b9");
                sb.append(((AlternativeTask)addFrontTaskNodes.get(i)).getTaskDefinitionName());
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("detail", sb.toString());
                info.put("taskKey", ((AlternativeTask)addFrontTaskNodes.get(i)).getAppointedSupplementaryLocation());
                info.put("procDefId", processDefinitionId);
                for (ApprovalUser approvalUser : ((AlternativeTask)addFrontTaskNodes.get(i)).getApprovalUsers()) {
                    UserLog userLog = new UserLog();
                    userLog.setUserId(approvalUser.getUserId());
                    userLog.setDeptId(approvalUser.getDeptId());
                    userLog.setUnitId(approvalUser.getUnitId());
                    userLog.setPostId(approvalUser.getPostId());
                    userLog.setIsMain(approvalUser.getIsMain());
                    users.add(userLog);
                }
            }
        }
        if (!addBackTaskNodes.isEmpty()) {
            for (int i = 0; i < addBackTaskNodes.size(); ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append("\u628a\u5ba1\u6279\u8282\u70b9");
                sb.append(((AlternativeTask)addBackTaskNodes.get(i)).getTaskDefinitionName());
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("detail", sb.toString());
                info.put("taskKey", ((AlternativeTask)addBackTaskNodes.get(i)).getLastSupplementaryNodeInProcessing());
                info.put("procDefId", processDefinitionId);
            }
        }
        if (isDelete) {
            return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getDelCustomNodeSuccess());
        }
        return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
    }

    private void handleAlternativeTaskInStartProcess(List<AlternativeTask> addFrontTaskNodes, List<AlternativeTask> addBackTaskNodes, List<String> deleteBackTaskNodeIds, List<AlternativeTaskDto> alternativeTaskDtos, WorkFlow workFlow, String businessId, String processDefId) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List paths = flowModel.getSlots().getPath();
        LambdaQueryWrapper oldAddBackNodeQueryWrapper = new LambdaQueryWrapper();
        oldAddBackNodeQueryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        List oldAddNodeList = this.bpmActPendingTaskService.list((Wrapper)oldAddBackNodeQueryWrapper).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).collect(Collectors.toList());
        if (HussarUtils.isEmpty(alternativeTaskDtos)) {
            return;
        }
        HashMap isFrontMap = new HashMap();
        alternativeTaskDtos.forEach(o -> isFrontMap.put(o.getAlternativeTaskId(), o.getIsFront()));
        List alternativeTaskIds = alternativeTaskDtos.stream().map(AlternativeTaskDto::getAlternativeTaskId).distinct().collect(Collectors.toList());
        List alternativeTasks = this.alternativeTaskService.listByIds(alternativeTaskIds);
        List alternativeTaskNodeIds = alternativeTasks.stream().map(AlternativeTask::getTaskDefinitionKey).collect(Collectors.toList());
        if (alternativeTaskIds.size() != alternativeTasks.size()) {
            throw new PublicClientException("\u5907\u9009\u8282\u70b9\u672a\u627e\u5230\uff01");
        }
        List oldAddNodeOriginalIds = oldAddNodeList.stream().map(o -> o.split("-")[3]).collect(Collectors.toList());
        deleteBackTaskNodeIds.addAll(oldAddNodeList.stream().filter(o -> o.contains("back")).filter(o -> !alternativeTaskNodeIds.contains(o.split("-")[3])).collect(Collectors.toList()));
        List addTaskNodes = alternativeTasks.stream().filter(o -> !oldAddNodeOriginalIds.contains(o.getTaskDefinitionKey())).collect(Collectors.toList());
        Map<String, List> assigneeMap = alternativeTaskDtos.stream().collect(Collectors.toMap(AlternativeTaskDto::getAlternativeTaskId, AlternativeTaskDto::getApprovalUsers, (a1, a2) -> a2));
        Map endToStartMap = paths.stream().collect(Collectors.groupingBy(o -> o.getEnd().getKey(), Collectors.mapping(o -> o.getStart().getKey(), Collectors.toList())));
        List allExtendProperties = this.iSysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)processDefId));
        HashMap alternativeToAppointedSupplementaryLocation = new HashMap();
        HashMap alternativeToIsParallel = new HashMap();
        allExtendProperties.forEach(o -> {
            if (HussarUtils.isNotEmpty((Object)o.getAllowAlterTask())) {
                List<String> alternativeNode = Arrays.asList(o.getAllowAlterTask().split(","));
                alternativeNode.forEach(n -> {
                    alternativeToAppointedSupplementaryLocation.put(n, o.getTaskDefKey());
                    alternativeToIsParallel.put(n, o.getAlterNodeRelation());
                });
            }
        });
        addBackTaskNodes.addAll(addTaskNodes.stream().filter(o -> (Boolean)isFrontMap.get(String.valueOf(o.getAlternativeTaskId())) == false).map(o -> {
            o.setIsParallel((String)alternativeToIsParallel.get(o.getTaskDefinitionKey()));
            o.setOriginalTaskDefKey((String)alternativeToAppointedSupplementaryLocation.get(o.getTaskDefinitionKey()));
            o.setApprovalUsers((List)assigneeMap.get(String.valueOf(o.getAlternativeTaskId())));
            o.setLastSupplementaryNodeInProcessing(o.getOriginalTaskDefKey());
            o.setIsJump(false);
            return o;
        }).collect(Collectors.toList()));
        HashMap alternativeToOriginalTaskDefKey = new HashMap();
        for (Map.Entry item : alternativeToAppointedSupplementaryLocation.entrySet()) {
            String lastNonAddNode = (String)endToStartMap.get(item.getValue()).get(0);
            while (lastNonAddNode.contains("jxd_bpm_custom_node") || lastNonAddNode.contains("parallel_node")) {
                lastNonAddNode = (String)endToStartMap.get(lastNonAddNode).get(0);
            }
            alternativeToOriginalTaskDefKey.put(item.getKey(), lastNonAddNode);
        }
        addFrontTaskNodes.addAll(addTaskNodes.stream().filter(o -> (Boolean)isFrontMap.get(String.valueOf(o.getAlternativeTaskId()))).map(o -> {
            o.setIsParallel("1");
            o.setOriginalTaskDefKey((String)alternativeToOriginalTaskDefKey.get(o.getTaskDefinitionKey()));
            o.setAppointedSupplementaryLocation((String)alternativeToAppointedSupplementaryLocation.get(o.getTaskDefinitionKey()));
            o.setApprovalUsers((List)assigneeMap.get(String.valueOf(o.getAlternativeTaskId())));
            o.setLastSupplementaryNodeInProcessing(o.getOriginalTaskDefKey());
            o.setIsJump(false);
            return o;
        }).collect(Collectors.toList()));
    }

    private boolean isFrontNodeAtFirstNode(WorkFlow workFlow, String processDefinitionId, List<AlternativeTaskDto> alternativeTasks) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        String startUserNodeKey = this.getFirstUserNode(flowModel);
        SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.iSysActExtendPropertiesService.lambdaQuery().eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId)).eq(SysActExtendProperties::getTaskDefKey, (Object)startUserNodeKey)).one();
        String allowAlterTask = sysActExtendProperties.getAllowAlterTask();
        for (AlternativeTaskDto alternativeTask : alternativeTasks) {
            String alternativeTaskId = alternativeTask.getAlternativeTaskId();
            String alternativeNodeKey = ((AlternativeTask)((LambdaQueryChainWrapper)this.alternativeTaskService.lambdaQuery().eq(AlternativeTask::getAlternativeTaskId, (Object)alternativeTaskId)).one()).getTaskDefinitionKey();
            boolean isFront = alternativeTask.getIsFront();
            if (!isFront || !allowAlterTask.contains(alternativeNodeKey)) continue;
            return true;
        }
        return false;
    }

    private String getFirstUserNode(FlowModel flowModel) {
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        String startNodeKey = (String)elements.stream().filter(element -> "com.jxdinfo.workflow.Start".equals(element.getName())).map(FlowObject::getInstanceKey).collect(Collectors.toList()).get(0);
        String startUserNodeKey = (String)paths.stream().filter(path -> path.getStart().getKey().equals(startNodeKey)).map(path -> path.getEnd().getKey()).collect(Collectors.toList()).get(0);
        return startUserNodeKey;
    }

    public ApiResponse<String> alternativeTask(String taskId, List<AlternativeTaskDto> alternativeTaskDtos, boolean isDelete) {
        if (alternativeTaskDtos == null) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart(), Boolean.valueOf(false));
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        try {
            Long modelId;
            SysActProcessFile metaInfo;
            BpmnModel bpmnModel;
            WorkFlow workFlow;
            String identityId;
            String version;
            HistoricProcessInstance processInstance;
            List oldAddNodeList = null;
            List newAddNodeList = null;
            ArrayList<AlternativeTask> addFrontTaskNodes = new ArrayList<AlternativeTask>();
            ArrayList<AlternativeTask> addBackTaskNodes = new ArrayList<AlternativeTask>();
            ArrayList<String> deleteBackTaskNodeIds = new ArrayList<String>();
            if (!isDelete) {
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                version = this.modelService.getRealVersion(task.getProcessDefinitionId());
                identityId = task.getProcessDefinitionId().split(":")[0];
                String realProcessDefinitionId = this.modelService.getRealProcessDefinitionId(identityId, version);
                workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId());
                if (this.isFrontNodeAtFirstNode(workFlow, processDefinitionId, alternativeTaskDtos)) {
                    throw new PublicClientException("\u4e0d\u5141\u8bb8\u5411\u7b2c\u4e00\u4e2a\u8282\u70b9\u524d\u6dfb\u52a0\u5907\u9009\u8282\u70b9");
                }
                this.handleAlternativeTask(addFrontTaskNodes, addBackTaskNodes, deleteBackTaskNodeIds, alternativeTaskDtos, task.getProcessInstanceId(), realProcessDefinitionId, task.getTaskDefinitionKey(), workFlow);
                if (HussarUtils.isEmpty(alternativeTaskDtos) && HussarUtils.isEmpty(deleteBackTaskNodeIds)) {
                    return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
                }
                for (AlternativeTask addTaskNode : addFrontTaskNodes) {
                    oldAddNodeList = this.bpmActHiTaskinstMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(BpmActHiTaskinst::getProcInstId, (Object)task.getProcessInstanceId())).stream().map(BpmActHiTaskinst::getTaskDefKey).distinct().filter(o -> o.contains("-front")).collect(Collectors.toList());
                    this.addNodeNewWorkFlow(workFlow, addTaskNode, task.getTaskDefinitionKey(), false, true, processInstance);
                }
                for (AlternativeTask addTaskNode : addBackTaskNodes) {
                    oldAddNodeList = this.bpmActPendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getProcInstId, (Object)task.getProcessInstanceId())).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("-back")).collect(Collectors.toList());
                    this.addNodeNewWorkFlow(workFlow, addTaskNode, task.getTaskDefinitionKey(), false, false, processInstance);
                }
                bpmnModel = this.xmlService.getBpmnModel(workFlow, identityId);
                metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)version));
                modelId = metaInfo.getModelId();
                if (!task.getProcessDefinitionId().split(":")[1].equals(version)) {
                    this.xmlService.updateModel(workFlow, bpmnModel, task.getProcessDefinitionId());
                    this.modelService.addNodeSaveModelExtendProperties(workFlow, task.getProcessDefinitionId());
                } else {
                    this.modelService.deployModelByWorkFlowXml(workFlow, bpmnModel, String.valueOf(modelId), task.getProcessInstanceId(), version);
                }
                if (HussarUtils.isNotEmpty(addFrontTaskNodes)) {
                    this.saveAlternativeNodePendingTask(task, bpmnModel, workFlow, addFrontTaskNodes, processInstance);
                }
            } else {
                oldAddNodeList = this.bpmActPendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getProcInstId, (Object)processInstanceId)).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("-back")).collect(Collectors.toList());
                version = this.modelService.getRealVersion(processDefinitionId);
                identityId = processDefinitionId.split(":")[0];
                workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, processDefinitionId);
                if (!alternativeTaskDtos.get(0).getAlternativeTaskId().contains("jxd_bpm_custom_node")) {
                    throw new PublicClientException("\u4e0d\u80fd\u5220\u9664\u975e\u5907\u9009\u8282\u70b9\uff01");
                }
                deleteBackTaskNodeIds.add(alternativeTaskDtos.get(0).getAlternativeTaskId());
                if (HussarUtils.isEmpty(alternativeTaskDtos) && HussarUtils.isEmpty(deleteBackTaskNodeIds)) {
                    return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
                }
                List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
                List<Object> doneAlterTaskKeys = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)historicTaskInstances)) {
                    doneAlterTaskKeys = historicTaskInstances.stream().map(TaskInfo::getTaskDefinitionKey).filter(o -> o.contains("jxd_bpm_custom_node")).distinct().collect(Collectors.toList());
                }
                for (String deleteNodeId : deleteBackTaskNodeIds) {
                    if (doneAlterTaskKeys.contains(deleteNodeId)) {
                        throw new PublicClientException("\u4e0d\u80fd\u5220\u9664\u5df2\u8fd0\u884c\u7684\u5907\u9009\u8282\u70b9\uff01");
                    }
                    this.deleteNodeNewWorkFlow(workFlow, deleteNodeId);
                }
                bpmnModel = this.xmlService.getBpmnModel(workFlow, identityId);
                metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)version));
                modelId = metaInfo.getModelId();
                if (!processDefinitionId.split(":")[1].equals(version)) {
                    this.xmlService.updateModel(workFlow, bpmnModel, processDefinitionId);
                    this.modelService.addNodeSaveModelExtendProperties(workFlow, processDefinitionId);
                } else {
                    this.modelService.deployModelByWorkFlowXml(workFlow, bpmnModel, String.valueOf(modelId), processInstanceId, version);
                }
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            }
            this.bpmActPendingTaskService.updatePendingTask(null, processInstance.getBusinessKey());
            newAddNodeList = addBackTaskNodes.size() > 0 ? this.bpmActPendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getProcInstId, (Object)processInstanceId)).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("-back")).collect(Collectors.toList()) : this.bpmActHiTaskinstMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(BpmActHiTaskinst::getProcInstId, (Object)processInstanceId)).stream().map(BpmActHiTaskinst::getTaskDefKey).distinct().filter(o -> o.contains("-front")).collect(Collectors.toList());
            if (!addFrontTaskNodes.isEmpty()) {
                for (int i = 0; i < addFrontTaskNodes.size(); ++i) {
                    ArrayList<UserLog> users = new ArrayList<UserLog>();
                    StringBuffer sb = new StringBuffer();
                    sb.append("\u628a\u5ba1\u6279\u8282\u70b9");
                    sb.append(((AlternativeTask)addFrontTaskNodes.get(i)).getTaskDefinitionName());
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("detail", sb.toString());
                    info.put("taskKey", ((AlternativeTask)addFrontTaskNodes.get(i)).getAppointedSupplementaryLocation());
                    info.put("procDefId", processInstance.getProcessDefinitionId());
                    for (ApprovalUser approvalUser : ((AlternativeTask)addFrontTaskNodes.get(i)).getApprovalUsers()) {
                        UserLog userLog = new UserLog();
                        userLog.setUserId(approvalUser.getUserId());
                        userLog.setDeptId(approvalUser.getDeptId());
                        userLog.setUnitId(approvalUser.getUnitId());
                        userLog.setPostId(approvalUser.getPostId());
                        userLog.setIsMain(approvalUser.getIsMain());
                        users.add(userLog);
                    }
                }
            }
            if (!addBackTaskNodes.isEmpty()) {
                for (int i = 0; i < addBackTaskNodes.size(); ++i) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("\u628a\u5ba1\u6279\u8282\u70b9");
                    sb.append(((AlternativeTask)addBackTaskNodes.get(i)).getTaskDefinitionName());
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("detail", sb.toString());
                    info.put("taskKey", ((AlternativeTask)addBackTaskNodes.get(i)).getLastSupplementaryNodeInProcessing());
                    info.put("procDefId", processInstance.getProcessDefinitionId());
                }
            }
            if (isDelete) {
                return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getDelCustomNodeSuccess());
            }
            return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
        }
        catch (PublicClientException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (isDelete) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrorDelCustomNode());
            }
            return ApiResponse.fail((String)this.bpmConstantProperties.getErrorAddCustomNode());
        }
    }

    public ApiResponse<List<AlterTaskNodeVo>> getAlterTasks(String taskId) {
        ArrayList<AlterTaskNodeVo> alterTaskNodeVos = new ArrayList<AlterTaskNodeVo>();
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart(), Boolean.valueOf(false));
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        if (task.getTaskDefinitionKey().contains("jxd_bpm_custom_node")) {
            return ApiResponse.success(alterTaskNodeVos);
        }
        String version = this.modelService.getRealVersion(task.getProcessDefinitionId());
        String realProcessDefinitionId = this.modelService.getRealProcessDefinitionId(task.getProcessDefinitionId().split(":")[0], version);
        ArrayList oldAddNodes = new ArrayList();
        oldAddNodes.addAll(this.bpmActPendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getProcInstId, (Object)task.getProcessInstanceId())).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).map(o -> o.split("-")[3]).collect(Collectors.toList()));
        List<String> finishedAddNodes = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).finished().list().stream().distinct().map(TaskInfo::getTaskDefinitionKey).filter(o -> o.contains("jxd_bpm_custom_node")).collect(Collectors.toList());
        oldAddNodes.addAll(finishedAddNodes.stream().map(o -> o.split("-")[3]).collect(Collectors.toList()));
        Map isFront = this.bpmActPendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getProcInstId, (Object)task.getProcessInstanceId())).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).collect(Collectors.groupingBy(o -> o.split("-")[3], Collectors.mapping(o -> o.split("-")[5], Collectors.toList())));
        finishedAddNodes.forEach(o -> isFront.put(o.split("-")[3], Collections.singletonList(o.split("-")[5])));
        SysActExtendProperties extendProperties = (SysActExtendProperties)this.iSysActExtendPropertiesService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)realProcessDefinitionId)).eq(SysActExtendProperties::getTaskDefKey, (Object)task.getTaskDefinitionKey()));
        List<String> alternativeTaskIds = null;
        if (HussarUtils.isNotEmpty((Object)extendProperties)) {
            if (HussarUtils.isEmpty((Object)extendProperties.getAllowAlterTaskToOther())) {
                return ApiResponse.success(alterTaskNodeVos);
            }
            alternativeTaskIds = Arrays.asList(extendProperties.getAllowAlterTaskToOther().split(","));
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).list();
        List<Object> doneAlterTaskKeys = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)historicTaskInstances)) {
            doneAlterTaskKeys = historicTaskInstances.stream().map(TaskInfo::getTaskDefinitionKey).filter(o -> o.contains("jxd_bpm_custom_node")).map(o -> o.split("-")[3]).distinct().collect(Collectors.toList());
        }
        List alternativeTasks = this.alternativeTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlternativeTask::getProcessKey, (Object)task.getProcessDefinitionId().split(":")[0])).eq(AlternativeTask::getProcessDefinitionVersion, (Object)version)).in(AlternativeTask::getTaskDefinitionKey, alternativeTaskIds));
        List allSysActExtendProperties = this.iSysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)realProcessDefinitionId));
        HashMap alternativeToAppointedSupplementaryLocationName = new HashMap();
        HashMap alternativeToAppointedSupplementaryLocation = new HashMap();
        allSysActExtendProperties.forEach(o -> {
            if (HussarUtils.isNotEmpty((Object)o.getAllowAlterTask())) {
                List<String> alternativeNode = Arrays.asList(o.getAllowAlterTask().split(","));
                alternativeNode.forEach(n -> {
                    alternativeToAppointedSupplementaryLocationName.put(n, o.getTaskDefName());
                    alternativeToAppointedSupplementaryLocation.put(n, o.getTaskDefKey());
                });
            }
        });
        String processInstanceId = task.getProcessInstanceId();
        ArrayList<Object> allAssigneeIds = new ArrayList<Object>();
        for (AlternativeTask alternativeTask : alternativeTasks) {
            List<Object> mainAssigneeIds;
            AlterTaskNodeVo alterTaskNodeVo2 = new AlterTaskNodeVo();
            alterTaskNodeVo2.setId(String.valueOf(alternativeTask.getAlternativeTaskId()));
            alterTaskNodeVo2.setTaskDefKey(alternativeTask.getTaskDefinitionKey());
            alterTaskNodeVo2.setTaskName(alternativeTask.getTaskDefinitionName());
            alterTaskNodeVo2.setProcessDefinitionId(realProcessDefinitionId);
            alterTaskNodeVo2.setAppointedSupplementaryLocationName((String)alternativeToAppointedSupplementaryLocationName.get(alternativeTask.getTaskDefinitionKey()));
            alterTaskNodeVo2.setAppointedSupplementaryLocation((String)alternativeToAppointedSupplementaryLocation.get(alternativeTask.getTaskDefinitionKey()));
            if (doneAlterTaskKeys.contains(alternativeTask.getTaskDefinitionKey())) {
                alterTaskNodeVo2.setIsDone("1");
                List<HistoricTaskInstance> hiTasks = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list().stream().filter(t -> t.getTaskDefinitionKey().split("-").length >= 4 && t.getTaskDefinitionKey().split("-")[3].contains(alternativeTask.getTaskDefinitionKey())).collect(Collectors.toList());
                mainAssigneeIds = new ArrayList();
                ArrayList taskIds = new ArrayList();
                if (hiTasks != null) {
                    hiTasks.forEach(hiTask -> {
                        mainAssigneeIds.add(hiTask.getAssignee());
                        taskIds.add(hiTask.getId());
                    });
                }
                ArrayList unMainAssigneeIds = new ArrayList();
                taskIds.forEach(t -> unMainAssigneeIds.addAll(((LambdaQueryChainWrapper)this.subCandidateService.lambdaQuery().eq(SubCandidate::getTaskId, t)).list().stream().map(SubCandidate::getUserId).collect(Collectors.toList())));
                ArrayList approvalUsers = new ArrayList();
                if (HussarUtils.isNotEmpty(mainAssigneeIds)) {
                    allAssigneeIds.addAll(mainAssigneeIds);
                    mainAssigneeIds.forEach(id -> {
                        ApprovalUser approvalUser = new ApprovalUser();
                        approvalUser.setUserId(id);
                        approvalUser.setIsMain("1");
                        approvalUsers.add(approvalUser);
                    });
                }
                if (HussarUtils.isNotEmpty(unMainAssigneeIds)) {
                    allAssigneeIds.addAll(unMainAssigneeIds);
                    unMainAssigneeIds.forEach(id -> {
                        ApprovalUser approvalUser = new ApprovalUser();
                        approvalUser.setUserId(id);
                        approvalUser.setIsMain("0");
                        approvalUsers.add(approvalUser);
                    });
                }
                alterTaskNodeVo2.setApprovalUsers(approvalUsers);
            } else {
                alterTaskNodeVo2.setIsDone("0");
            }
            if (oldAddNodes.contains(alternativeTask.getTaskDefinitionKey())) {
                alterTaskNodeVo2.setIsAdd("1");
                if ("0".equals(alterTaskNodeVo2.getIsDone())) {
                    List<String> taskIds = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).unfinished().list().stream().filter(t -> t.getTaskDefinitionKey().split("-").length >= 4 && t.getTaskDefinitionKey().split("-")[3].contains(alternativeTask.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.toList());
                    if (HussarUtils.isEmpty(taskIds)) {
                        List<BpmActPendingTask> pendingTasks = ((LambdaQueryChainWrapper)this.bpmActPendingTaskService.lambdaQuery().eq(BpmActPendingTask::getProcInstId, (Object)processInstanceId)).list().stream().filter(t -> t.getTaskDefKey().split("-").length >= 4 && t.getTaskDefKey().split("-")[3].contains(alternativeTask.getTaskDefinitionKey())).collect(Collectors.toList());
                        ArrayList approvalUsers = new ArrayList();
                        if (HussarUtils.isNotEmpty(pendingTasks)) {
                            pendingTasks.forEach(pendingTask -> {
                                allAssigneeIds.add(pendingTask.getAssignee());
                                ApprovalUser approvalUser = new ApprovalUser();
                                approvalUser.setUserId(pendingTask.getAssignee());
                                approvalUser.setIsMain(pendingTask.getIsMain());
                                approvalUsers.add(approvalUser);
                            });
                        }
                        alterTaskNodeVo2.setApprovalUsers(approvalUsers);
                    } else {
                        mainAssigneeIds = ((LambdaQueryChainWrapper)this.bpmActRuIdentitylinkService.lambdaQuery().eq(BpmActRuIdentitylink::getTaskId, taskIds.get(0))).list().stream().map(BpmActRuIdentitylink::getUserId).collect(Collectors.toList());
                        ArrayList unMainAssigneeIds = new ArrayList();
                        taskIds.forEach(t -> unMainAssigneeIds.addAll(((LambdaQueryChainWrapper)this.subCandidateService.lambdaQuery().eq(SubCandidate::getTaskId, t)).list().stream().map(SubCandidate::getUserId).collect(Collectors.toList())));
                        ArrayList approvalUsers = new ArrayList();
                        if (HussarUtils.isNotEmpty(mainAssigneeIds)) {
                            allAssigneeIds.addAll(mainAssigneeIds);
                            mainAssigneeIds.forEach(id -> {
                                ApprovalUser approvalUser = new ApprovalUser();
                                approvalUser.setUserId(id);
                                approvalUser.setIsMain("1");
                                approvalUsers.add(approvalUser);
                            });
                        }
                        if (HussarUtils.isNotEmpty(unMainAssigneeIds)) {
                            allAssigneeIds.addAll(unMainAssigneeIds);
                            unMainAssigneeIds.forEach(id -> {
                                ApprovalUser approvalUser = new ApprovalUser();
                                approvalUser.setUserId(id);
                                approvalUser.setIsMain("0");
                                approvalUsers.add(approvalUser);
                            });
                        }
                        alterTaskNodeVo2.setApprovalUsers(approvalUsers);
                    }
                }
            } else {
                alterTaskNodeVo2.setIsAdd("0");
            }
            if (HussarUtils.isEmpty(isFront.get(String.valueOf(alternativeTask.getTaskDefinitionKey())))) {
                alterTaskNodeVo2.setIsFront("");
            } else {
                alterTaskNodeVo2.setIsFront((String)isFront.get(String.valueOf(alternativeTask.getTaskDefinitionKey())).get(0));
            }
            alterTaskNodeVos.add(alterTaskNodeVo2);
        }
        Map allAssigneeNames = this.iAssigneeChooseService.getUserListByUserId(allAssigneeIds);
        if (HussarUtils.isNotEmpty(alterTaskNodeVos)) {
            alterTaskNodeVos.forEach(alterTaskNodeVo -> {
                List approvalUsers = alterTaskNodeVo.getApprovalUsers();
                if (approvalUsers != null) {
                    approvalUsers.forEach(approvalUser -> {
                        String assigneeId = approvalUser.getUserId();
                        String assigneeName = allAssigneeNames.get(assigneeId) == null ? "" : (String)allAssigneeNames.get(assigneeId);
                        approvalUser.setUserName(assigneeName);
                    });
                }
            });
        }
        return ApiResponse.success(alterTaskNodeVos);
    }

    public ApiResponse<List<AlterTaskNodeVo>> getAlterTasksInStartProcess(String processDefinitionId, String businessId) {
        ArrayList<AlterTaskNodeVo> alterTaskNodeVos = new ArrayList<AlterTaskNodeVo>();
        String version = this.modelService.getRealVersion(processDefinitionId);
        String processKey = processDefinitionId.split(":")[0];
        String realProcessDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, version);
        ArrayList<String> alternativeTaskIds = new ArrayList<String>();
        List extendPropertiesList = this.iSysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)realProcessDefinitionId));
        if (extendPropertiesList != null) {
            for (SysActExtendProperties extendProperties : extendPropertiesList) {
                if (!HussarUtils.isNotEmpty((Object)extendProperties) || !HussarUtils.isNotEmpty((Object)extendProperties.getAllowAlterTaskToOther())) continue;
                alternativeTaskIds.addAll(Arrays.asList(extendProperties.getAllowAlterTaskToOther().split(",")));
            }
        }
        ArrayList alternativeTasks = new ArrayList();
        if (alternativeTaskIds.size() != 0) {
            alternativeTasks.addAll(this.alternativeTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlternativeTask::getProcessKey, (Object)processKey)).eq(AlternativeTask::getProcessDefinitionVersion, (Object)version)).in(AlternativeTask::getTaskDefinitionKey, alternativeTaskIds)));
        }
        List allSysActExtendProperties = this.iSysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)realProcessDefinitionId));
        HashMap alternativeToAppointedSupplementaryLocationName = new HashMap();
        HashMap alternativeToAppointedSupplementaryLocation = new HashMap();
        allSysActExtendProperties.forEach(o -> {
            if (HussarUtils.isNotEmpty((Object)o.getAllowAlterTask())) {
                List<String> alternativeNode = Arrays.asList(o.getAllowAlterTask().split(","));
                alternativeNode.forEach(n -> {
                    alternativeToAppointedSupplementaryLocationName.put(n, o.getTaskDefName());
                    alternativeToAppointedSupplementaryLocation.put(n, o.getTaskDefKey());
                });
            }
        });
        List oldAddNodes = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bpmActPendingTaskService.lambdaQuery().eq(BpmActPendingTask::getBusinessId, (Object)businessId)).eq(BpmActPendingTask::getProcDefId, (Object)processDefinitionId)).list().stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).map(o -> o.split("-")[3]).collect(Collectors.toList());
        Map isFront = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bpmActPendingTaskService.lambdaQuery().eq(BpmActPendingTask::getBusinessId, (Object)businessId)).eq(BpmActPendingTask::getProcDefId, (Object)processDefinitionId)).list().stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).collect(Collectors.groupingBy(o -> o.split("-")[3], Collectors.mapping(o -> o.split("-")[5], Collectors.toList())));
        ArrayList allAssigneeIds = new ArrayList();
        for (AlternativeTask alternativeTask : alternativeTasks) {
            AlterTaskNodeVo alterTaskNodeVo2 = new AlterTaskNodeVo();
            alterTaskNodeVo2.setId(String.valueOf(alternativeTask.getAlternativeTaskId()));
            alterTaskNodeVo2.setTaskDefKey(alternativeTask.getTaskDefinitionKey());
            alterTaskNodeVo2.setTaskName(alternativeTask.getTaskDefinitionName());
            alterTaskNodeVo2.setProcessDefinitionId(realProcessDefinitionId);
            alterTaskNodeVo2.setAppointedSupplementaryLocationName((String)alternativeToAppointedSupplementaryLocationName.get(alternativeTask.getTaskDefinitionKey()));
            alterTaskNodeVo2.setAppointedSupplementaryLocation((String)alternativeToAppointedSupplementaryLocation.get(alternativeTask.getTaskDefinitionKey()));
            if (oldAddNodes.contains(alternativeTask.getTaskDefinitionKey())) {
                alterTaskNodeVo2.setIsAdd("1");
                List<BpmActPendingTask> pendingTasks = ((LambdaQueryChainWrapper)this.bpmActPendingTaskService.lambdaQuery().eq(BpmActPendingTask::getBusinessId, (Object)businessId)).list().stream().filter(t -> t.getTaskDefKey().split("-").length >= 4 && t.getTaskDefKey().split("-")[3].contains(alternativeTask.getTaskDefinitionKey())).collect(Collectors.toList());
                ArrayList approvalUsers = new ArrayList();
                if (HussarUtils.isNotEmpty(pendingTasks)) {
                    pendingTasks.forEach(pendingTask -> {
                        allAssigneeIds.add(pendingTask.getAssignee());
                        ApprovalUser approvalUser = new ApprovalUser();
                        approvalUser.setUserId(pendingTask.getAssignee());
                        approvalUser.setIsMain(pendingTask.getIsMain());
                        approvalUsers.add(approvalUser);
                    });
                }
                alterTaskNodeVo2.setApprovalUsers(approvalUsers);
            } else {
                alterTaskNodeVo2.setIsAdd("0");
            }
            if (HussarUtils.isEmpty(isFront.get(String.valueOf(alternativeTask.getTaskDefinitionKey())))) {
                alterTaskNodeVo2.setIsFront("");
            } else {
                alterTaskNodeVo2.setIsFront((String)isFront.get(String.valueOf(alternativeTask.getTaskDefinitionKey())).get(0));
            }
            alterTaskNodeVos.add(alterTaskNodeVo2);
        }
        Map allAssigneeNames = this.iAssigneeChooseService.getUserListByUserId(allAssigneeIds);
        if (HussarUtils.isNotEmpty(alterTaskNodeVos)) {
            alterTaskNodeVos.forEach(alterTaskNodeVo -> {
                List approvalUsers = alterTaskNodeVo.getApprovalUsers();
                if (approvalUsers != null) {
                    approvalUsers.forEach(approvalUser -> {
                        String assigneeId = approvalUser.getUserId();
                        String assigneeName = allAssigneeNames.get(assigneeId) == null ? "" : (String)allAssigneeNames.get(assigneeId);
                        approvalUser.setUserName(assigneeName);
                    });
                }
            });
        }
        return ApiResponse.success(alterTaskNodeVos);
    }

    private void handleAlternativeTask(List<AlternativeTask> addFrontTaskNodes, List<AlternativeTask> addBackTaskNodes, List<String> deleteBackTaskNodeIds, List<AlternativeTaskDto> alternativeTaskDtos, String processInsId, String processDefId, String taskDefKey, WorkFlow workFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List paths = flowModel.getSlots().getPath();
        ArrayList oldAddNodeList = new ArrayList();
        LambdaQueryWrapper oldAddFrontNodeQueryWrapper = new LambdaQueryWrapper();
        oldAddFrontNodeQueryWrapper.eq(BpmActRuTask::getProcInstId, (Object)processInsId);
        oldAddNodeList.addAll(this.bpmActRuTaskMapper.selectList((Wrapper)oldAddFrontNodeQueryWrapper).stream().map(BpmActRuTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node") && o.contains("front")).collect(Collectors.toList()));
        LambdaQueryWrapper oldAddBackNodeQueryWrapper = new LambdaQueryWrapper();
        oldAddBackNodeQueryWrapper.eq(BpmActPendingTask::getProcInstId, (Object)processInsId);
        oldAddNodeList.addAll(this.bpmActPendingTaskService.list((Wrapper)oldAddBackNodeQueryWrapper).stream().map(BpmActPendingTask::getTaskDefKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).collect(Collectors.toList()));
        oldAddNodeList.addAll(((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).finished().list().stream().map(TaskInfo::getTaskDefinitionKey).distinct().filter(o -> o.contains("jxd_bpm_custom_node")).collect(Collectors.toList()));
        if (HussarUtils.isEmpty(alternativeTaskDtos)) {
            oldAddNodeList.stream().forEach(o -> deleteBackTaskNodeIds.add((String)o));
            return;
        }
        HashMap isFrontMap = new HashMap();
        alternativeTaskDtos.stream().forEach(o -> isFrontMap.put(o.getAlternativeTaskId(), o.getIsFront()));
        List alternativeTaskIds = alternativeTaskDtos.stream().map(AlternativeTaskDto::getAlternativeTaskId).distinct().collect(Collectors.toList());
        List alternativeTasks = this.alternativeTaskService.listByIds(alternativeTaskIds);
        List alternativeTaskNodeIds = alternativeTasks.stream().map(AlternativeTask::getTaskDefinitionKey).collect(Collectors.toList());
        if (alternativeTaskIds.size() != alternativeTasks.size()) {
            throw new PublicClientException("\u5907\u9009\u8282\u70b9\u672a\u627e\u5230\uff01");
        }
        LambdaQueryWrapper querySysActExtendPropertiesByProcDefIdAndTaskDefKey = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)querySysActExtendPropertiesByProcDefIdAndTaskDefKey.eq(SysActExtendProperties::getProcDefId, (Object)processDefId)).eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefKey);
        SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)this.iSysActExtendPropertiesService.getOne((Wrapper)querySysActExtendPropertiesByProcDefIdAndTaskDefKey);
        List oldAddNodes = oldAddNodeList.stream().filter(o -> Arrays.asList(sysActExtendProperties.getAllowAlterTaskToOther().split(",")).contains(o.split("-")[3])).collect(Collectors.toList());
        List oldAddNodeOriginalIds = oldAddNodes.stream().map(o -> o.split("-")[3]).collect(Collectors.toList());
        deleteBackTaskNodeIds.addAll(oldAddNodes.stream().filter(o -> o.contains("back")).filter(o -> !alternativeTaskNodeIds.contains(o.split("-")[3])).collect(Collectors.toList()));
        List addTaskNodes = alternativeTasks.stream().filter(o -> !oldAddNodeOriginalIds.contains(o.getTaskDefinitionKey())).collect(Collectors.toList());
        Map<String, List> assigneeMap = alternativeTaskDtos.stream().collect(Collectors.toMap(AlternativeTaskDto::getAlternativeTaskId, AlternativeTaskDto::getApprovalUsers, (a1, a2) -> a2));
        Map endToStartMap = paths.stream().collect(Collectors.groupingBy(o -> o.getEnd().getKey(), Collectors.mapping(o -> o.getStart().getKey(), Collectors.toList())));
        List allExtendProperties = this.iSysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)processDefId));
        HashMap alternativeToAppointedSupplementaryLocation = new HashMap();
        HashMap alternativeToIsParallel = new HashMap();
        allExtendProperties.forEach(o -> {
            if (HussarUtils.isNotEmpty((Object)o.getAllowAlterTask())) {
                List<String> alternativeNode = Arrays.asList(o.getAllowAlterTask().split(","));
                alternativeNode.forEach(n -> {
                    alternativeToAppointedSupplementaryLocation.put(n, o.getTaskDefKey());
                    alternativeToIsParallel.put(n, o.getAlterNodeRelation());
                });
            }
        });
        addBackTaskNodes.addAll(addTaskNodes.stream().filter(o -> (Boolean)isFrontMap.get(String.valueOf(o.getAlternativeTaskId())) == false).map(o -> {
            o.setIsParallel((String)alternativeToIsParallel.get(o.getTaskDefinitionKey()));
            o.setOriginalTaskDefKey((String)alternativeToAppointedSupplementaryLocation.get(o.getTaskDefinitionKey()));
            o.setApprovalUsers((List)assigneeMap.get(String.valueOf(o.getAlternativeTaskId())));
            o.setLastSupplementaryNodeInProcessing(o.getOriginalTaskDefKey());
            o.setIsJump(false);
            return o;
        }).collect(Collectors.toList()));
        HashMap alternativeToOriginalTaskDefKey = new HashMap();
        for (Map.Entry item : alternativeToAppointedSupplementaryLocation.entrySet()) {
            String lastNonAddNode = (String)endToStartMap.get(item.getValue()).get(0);
            while (lastNonAddNode.contains("jxd_bpm_custom_node") || lastNonAddNode.contains("parallel_node")) {
                lastNonAddNode = (String)endToStartMap.get(lastNonAddNode).get(0);
            }
            alternativeToOriginalTaskDefKey.put(item.getKey(), lastNonAddNode);
        }
        String lastNonAddNode = (String)endToStartMap.get(taskDefKey).get(0);
        while (lastNonAddNode.contains("jxd_bpm_custom_node") || lastNonAddNode.contains("parallel_node")) {
            lastNonAddNode = (String)endToStartMap.get(lastNonAddNode).get(0);
        }
        String lastNode = lastNonAddNode;
        addFrontTaskNodes.addAll(addTaskNodes.stream().filter(o -> (Boolean)isFrontMap.get(String.valueOf(o.getAlternativeTaskId()))).map(o -> {
            o.setIsParallel("1");
            o.setOriginalTaskDefKey((String)alternativeToOriginalTaskDefKey.get(o.getTaskDefinitionKey()));
            o.setAppointedSupplementaryLocation((String)alternativeToAppointedSupplementaryLocation.get(o.getTaskDefinitionKey()));
            o.setApprovalUsers((List)assigneeMap.get(String.valueOf(o.getAlternativeTaskId())));
            o.setLastSupplementaryNodeInProcessing(o.getOriginalTaskDefKey());
            if (o.getOriginalTaskDefKey() == null) {
                throw new PublicClientException("\u672a\u914d\u7f6e" + o.getTaskDefinitionName() + "\u7981\u6b62\u6dfb\u52a0");
            }
            o.setIsJump(o.getOriginalTaskDefKey().equals(lastNode));
            return o;
        }).collect(Collectors.toList()));
    }

    private void addNodeNewWorkFlow(WorkFlow workFlow, AlternativeTask addTaskNode, String hostTaskDefKey, Boolean isAddParallel, Boolean isFront, HistoricProcessInstance processInstance) {
        String taskDefKey = addTaskNode.getOriginalTaskDefKey();
        if (isAddParallel.booleanValue() || HussarUtils.isNotEmpty((Object)addTaskNode.getPrevNode())) {
            taskDefKey = addTaskNode.getPrevNode();
        }
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List nodes = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        ArrayList<Map<String, String>> addIds = new ArrayList<Map<String, String>>();
        addIds.add(this.getNewAlternativeTask(addTaskNode, addTaskNode.getOriginalTaskDefKey(), addTaskNode.getTaskDefinitionKey(), hostTaskDefKey, isAddParallel, isFront));
        String newNodeId = (String)((Map)addIds.get(0)).get("nodeId");
        String newPathId = (String)((Map)addIds.get(0)).get("pathId");
        if (isAddParallel.booleanValue() || HussarUtils.isNotEmpty((Object)addTaskNode.getPrevNode())) {
            addTaskNode.setPrevNode(newNodeId);
        }
        if (!isAddParallel.booleanValue() && "1".equals(addTaskNode.getIsParallel())) {
            String nextNodeId = "";
            boolean isParallel = false;
            if (isFront.booleanValue()) {
                Iterator nodeSequenceOfPath = new ArrayList();
                this.searchForPathFromOriginalNodeToAppointedSupplementaryLocation(paths, taskDefKey, addTaskNode.getAppointedSupplementaryLocation(), (List<String>)((Object)nodeSequenceOfPath));
                nextNodeId = (String)nodeSequenceOfPath.get(nodeSequenceOfPath.indexOf(taskDefKey) + 1);
            } else {
                for (FlowSequence path : paths) {
                    if (!path.getStart().getKey().equals(taskDefKey)) continue;
                    nextNodeId = path.getEnd().getKey();
                    break;
                }
            }
            if (nextNodeId.startsWith("parallel_node")) {
                for (FlowObject flowObject : nodes) {
                    if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) && !BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) continue;
                    isParallel = true;
                    List goOutPath = flowObject.getGoOutPathes();
                    goOutPath.add(newPathId);
                    flowObject.setGoOutPathes(goOutPath);
                }
            }
            if (isParallel) {
                boolean isProcessRunningToRight = true;
                for (FlowSequence path : paths) {
                    if (!path.getStart().getKey().equals(nextNodeId) || !"L".equals(path.getStart().getPort())) continue;
                    isProcessRunningToRight = false;
                }
                String endPointNodeId = this.getNextParallelNodeId(nodes, paths, nextNodeId);
                if (HussarUtils.isEmpty((Object)endPointNodeId)) {
                    throw new PublicClientException(this.bpmConstantProperties.getIsNotConfluenceParallel());
                }
                ArrayList<String> nodeIds = new ArrayList<String>();
                List<Map<String, List<FlowSequenceXy>>> pointsList = this.getParallelNewPathPoints(paths, nextNodeId, endPointNodeId, 1, nodeIds, null);
                for (int i = 0; i < pointsList.size(); ++i) {
                    FlowSequenceXy point;
                    Map<String, List<FlowSequenceXy>> points;
                    if (isProcessRunningToRight) {
                        points = pointsList.get(i);
                        point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                        nodes.add(this.newNode(addTaskNode, Double.parseDouble(point.getX()), Double.parseDouble(point.getY()), newNodeId, (String)((Map)addIds.get(i)).get("endPathId"), processInstance));
                        paths.add(this.newPath((String)((Map)addIds.get(i)).get("pathId"), nextNodeId, newNodeId, 0.0, 0.0, 0, points.get("startPoints")));
                        paths.add(this.newPath((String)((Map)addIds.get(i)).get("endPathId"), newNodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                        continue;
                    }
                    points = pointsList.get(i);
                    points.get("endPoints").get(0).setX(String.valueOf(Double.valueOf(points.get("endPoints").get(0).getX()) - Double.valueOf(((FlowObject)nodes.get(0)).getWidth()) * 2.0));
                    point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                    nodes.add(this.newNode(addTaskNode, Double.parseDouble(point.getX()) - Double.parseDouble(((FlowObject)nodes.get(0)).getWidth()), Double.parseDouble(point.getY()), newNodeId, (String)((Map)addIds.get(i)).get("endPathId"), processInstance));
                    paths.add(this.newPath((String)((Map)addIds.get(i)).get("pathId"), nextNodeId, newNodeId, 0.0, 0.0, 0, points.get("startPoints")));
                    paths.add(this.newPath((String)((Map)addIds.get(i)).get("endPathId"), newNodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                }
                workFlow.setData(JSON.toJSONString((Object)flowModel));
                return;
            }
            addTaskNode.setPrevNode(taskDefKey);
            addTaskNode.setIsParallel("0");
            this.addNodeNewWorkFlow(workFlow, addTaskNode, hostTaskDefKey, true, isFront, processInstance);
            this.addNodeNewWorkFlow(workFlow, addTaskNode, hostTaskDefKey, false, isFront, processInstance);
            this.addNodeNewWorkFlow(workFlow, addTaskNode, hostTaskDefKey, true, isFront, processInstance);
            return;
        }
        this.tidyNodesAndPaths(nodes, paths, addTaskNode, taskDefKey, newNodeId, newPathId, isAddParallel, isFront, processInstance);
        workFlow.setData(JSON.toJSONString((Object)flowModel));
    }

    private void addNodeNewWorkFlow(WorkFlow workFlow, AlternativeTask addTaskNode, String hostTaskDefKey, Boolean isAddParallel, Boolean isFront, String userId, String deptId, String businessKey, String procDefId, Map<String, Object> variables) {
        String taskDefKey = addTaskNode.getOriginalTaskDefKey();
        if (isAddParallel.booleanValue() || HussarUtils.isNotEmpty((Object)addTaskNode.getPrevNode())) {
            taskDefKey = addTaskNode.getPrevNode();
        }
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List nodes = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        ArrayList<Map<String, String>> addIds = new ArrayList<Map<String, String>>();
        addIds.add(this.getNewAlternativeTask(addTaskNode, addTaskNode.getOriginalTaskDefKey(), addTaskNode.getTaskDefinitionKey(), hostTaskDefKey, isAddParallel, isFront));
        String newNodeId = (String)((Map)addIds.get(0)).get("nodeId");
        String newPathId = (String)((Map)addIds.get(0)).get("pathId");
        if (isAddParallel.booleanValue() || HussarUtils.isNotEmpty((Object)addTaskNode.getPrevNode())) {
            addTaskNode.setPrevNode(newNodeId);
        }
        if (!isAddParallel.booleanValue() && "1".equals(addTaskNode.getIsParallel())) {
            String nextNodeId = "";
            boolean isParallel = false;
            if (isFront.booleanValue()) {
                Iterator nodeSequenceOfPath = new ArrayList();
                this.searchForPathFromOriginalNodeToAppointedSupplementaryLocation(paths, taskDefKey, addTaskNode.getAppointedSupplementaryLocation(), (List<String>)((Object)nodeSequenceOfPath));
                nextNodeId = (String)nodeSequenceOfPath.get(nodeSequenceOfPath.indexOf(taskDefKey) + 1);
            } else {
                for (FlowSequence path : paths) {
                    if (!path.getStart().getKey().equals(taskDefKey)) continue;
                    nextNodeId = path.getEnd().getKey();
                    break;
                }
            }
            if (nextNodeId.startsWith("parallel_node")) {
                for (FlowObject flowObject : nodes) {
                    if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) && !BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) continue;
                    isParallel = true;
                    List goOutPath = flowObject.getGoOutPathes();
                    goOutPath.add(newPathId);
                    flowObject.setGoOutPathes(goOutPath);
                }
            }
            if (isParallel) {
                boolean isProcessRunningToRight = true;
                for (FlowSequence path : paths) {
                    if (!path.getStart().getKey().equals(nextNodeId) || !"L".equals(path.getStart().getPort())) continue;
                    isProcessRunningToRight = false;
                }
                String endPointNodeId = this.getNextParallelNodeId(nodes, paths, nextNodeId);
                if (HussarUtils.isEmpty((Object)endPointNodeId)) {
                    throw new PublicClientException(this.bpmConstantProperties.getIsNotConfluenceParallel());
                }
                ArrayList<String> nodeIds = new ArrayList<String>();
                List<Map<String, List<FlowSequenceXy>>> pointsList = this.getParallelNewPathPoints(paths, nextNodeId, endPointNodeId, 1, nodeIds, null);
                for (int i = 0; i < pointsList.size(); ++i) {
                    FlowSequenceXy point;
                    Map<String, List<FlowSequenceXy>> points;
                    if (isProcessRunningToRight) {
                        points = pointsList.get(i);
                        point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                        nodes.add(this.newNode(addTaskNode, Double.parseDouble(point.getX()), Double.parseDouble(point.getY()), newNodeId, (String)((Map)addIds.get(i)).get("endPathId"), userId, deptId, businessKey, procDefId, variables));
                        paths.add(this.newPath((String)((Map)addIds.get(i)).get("pathId"), nextNodeId, newNodeId, 0.0, 0.0, 0, points.get("startPoints")));
                        paths.add(this.newPath((String)((Map)addIds.get(i)).get("endPathId"), newNodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                        continue;
                    }
                    points = pointsList.get(i);
                    points.get("endPoints").get(0).setX(String.valueOf(Double.valueOf(points.get("endPoints").get(0).getX()) - Double.valueOf(((FlowObject)nodes.get(0)).getWidth()) * 2.0));
                    point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                    nodes.add(this.newNode(addTaskNode, Double.parseDouble(point.getX()) - Double.parseDouble(((FlowObject)nodes.get(0)).getWidth()), Double.parseDouble(point.getY()), newNodeId, (String)((Map)addIds.get(i)).get("endPathId"), userId, deptId, businessKey, procDefId, variables));
                    paths.add(this.newPath((String)((Map)addIds.get(i)).get("pathId"), nextNodeId, newNodeId, 0.0, 0.0, 0, points.get("startPoints")));
                    paths.add(this.newPath((String)((Map)addIds.get(i)).get("endPathId"), newNodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                }
                workFlow.setData(JSON.toJSONString((Object)flowModel));
                return;
            }
            addTaskNode.setPrevNode(taskDefKey);
            addTaskNode.setIsParallel("0");
            this.addNodeNewWorkFlow(workFlow, addTaskNode, hostTaskDefKey, true, isFront, userId, deptId, businessKey, procDefId, variables);
            this.addNodeNewWorkFlow(workFlow, addTaskNode, hostTaskDefKey, false, isFront, userId, deptId, businessKey, procDefId, variables);
            this.addNodeNewWorkFlow(workFlow, addTaskNode, hostTaskDefKey, true, isFront, userId, deptId, businessKey, procDefId, variables);
            return;
        }
        this.tidyNodesAndPaths(nodes, paths, addTaskNode, taskDefKey, newNodeId, newPathId, isAddParallel, isFront, userId, deptId, businessKey, procDefId, variables);
        workFlow.setData(JSON.toJSONString((Object)flowModel));
    }

    private FlowObject newNode(AlternativeTask alternativeTask, double x, double y, String newNodeId, String pathId, String startUserId, String startDeptId, String businessKey, String procDefId, Map<String, Object> variables) {
        FlowObject flowObject = (FlowObject)JSON.parseObject((byte[])alternativeTask.getNodeInfo(), FlowObject.class, (Feature[])new Feature[0]);
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - 25.0));
        flowObject.setInstanceKey(newNodeId);
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        if ("1".equals(alternativeTask.getEditNodeName())) {
            Map departmentMap;
            List<ApprovalUser> approvalUsers;
            BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
            String deptId = null;
            if (HussarUtils.isNotEmpty((Object)alternativeTask.getApprovalUsers())) {
                approvalUsers = alternativeTask.getApprovalUsers();
                for (ApprovalUser approvalUser : approvalUsers) {
                    if (!"1".equals(approvalUser.getIsMain())) continue;
                    deptId = approvalUser.getDeptId();
                    break;
                }
            } else {
                approvalUsers = AnalyticalModelUtil.getPendingTaskConfigUser(null, startUserId, startDeptId, bm, alternativeTask.getTaskDefinitionKey(), null, null, businessKey, alternativeTask.getTaskDefinitionName(), procDefId, variables, null);
                if (!approvalUsers.isEmpty()) {
                    ArrayList<BpmActPendingTask> addPendingTasks = new ArrayList<BpmActPendingTask>();
                    for (ApprovalUser user : approvalUsers) {
                        BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                        bpmActPendingTask.setTaskDefKey(newNodeId);
                        bpmActPendingTask.setBusinessId(businessKey);
                        user.buildPendingTask(bpmActPendingTask, Boolean.valueOf(true));
                        addPendingTasks.add(bpmActPendingTask);
                    }
                    if (addPendingTasks.size() != 1) {
                        throw new RuntimeException();
                    }
                    deptId = ((BpmActPendingTask)addPendingTasks.get(0)).getDeptId();
                    this.bpmActPendingTaskService.saveBatch(addPendingTasks);
                }
            }
            if (deptId != null && !(departmentMap = this.assigneeChooseService.getDepartmentNameBydepartmentIds(Collections.singletonList(deptId))).isEmpty() && HussarUtils.isNotEmpty(departmentMap.get(deptId))) {
                flowObject.getProps().setFlowName((String)departmentMap.get(deptId));
            }
        }
        return flowObject;
    }

    private FlowObject newNode(AlternativeTask alternativeTask, double x, double y, String newNodeId, String pathId, HistoricProcessInstance processInstance) {
        FlowObject flowObject = (FlowObject)JSON.parseObject((byte[])alternativeTask.getNodeInfo(), FlowObject.class, (Feature[])new Feature[0]);
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - 25.0));
        flowObject.setInstanceKey(newNodeId);
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        if ("1".equals(alternativeTask.getEditNodeName())) {
            Map departmentMap;
            List<ApprovalUser> approvalUsers;
            BpmnModel bm = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
            String startUser = processInstance.getStartUserId();
            String startDeptId = processInstance.getDepartmentId();
            String deptId = null;
            if (HussarUtils.isNotEmpty((Object)alternativeTask.getApprovalUsers())) {
                approvalUsers = alternativeTask.getApprovalUsers();
                for (ApprovalUser approvalUser : approvalUsers) {
                    if (!"1".equals(approvalUser.getIsMain())) continue;
                    deptId = approvalUser.getDeptId();
                    break;
                }
            } else {
                approvalUsers = AnalyticalModelUtil.getPendingTaskConfigUser(null, startUser, startDeptId, bm, alternativeTask.getTaskDefinitionKey(), processInstance.getId(), processInstance.getProcessDefinitionKey(), processInstance.getBusinessKey(), alternativeTask.getTaskDefinitionName(), processInstance.getProcessDefinitionId(), processInstance.getProcessVariables(), null);
                if (!approvalUsers.isEmpty()) {
                    ArrayList<BpmActPendingTask> addPendingTasks = new ArrayList<BpmActPendingTask>();
                    for (ApprovalUser user : approvalUsers) {
                        BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                        bpmActPendingTask.setTaskDefKey(newNodeId);
                        bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
                        user.buildPendingTask(bpmActPendingTask, Boolean.valueOf(true));
                        addPendingTasks.add(bpmActPendingTask);
                    }
                    if (addPendingTasks.size() != 1) {
                        throw new RuntimeException();
                    }
                    deptId = ((BpmActPendingTask)addPendingTasks.get(0)).getDeptId();
                    this.bpmActPendingTaskService.saveBatch(addPendingTasks);
                }
            }
            if (deptId != null && !(departmentMap = this.assigneeChooseService.getDepartmentNameBydepartmentIds(Collections.singletonList(deptId))).isEmpty() && HussarUtils.isNotEmpty(departmentMap.get(deptId))) {
                flowObject.getProps().setFlowName((String)departmentMap.get(deptId));
            }
        }
        return flowObject;
    }

    public void saveAlternativeNodePendingTask(Task task, BpmnModel bpmnModel, WorkFlow workFlow, List<AlternativeTask> addTaskNodes, HistoricProcessInstance processInstance) {
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        ArrayList pendingTasks = new ArrayList();
        ArrayList targetNodeIds = new ArrayList();
        addTaskNodes.stream().forEach(o -> {
            List approvalUsers = o.getApprovalUsers();
            approvalUsers.stream().forEach(t -> {
                BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                bpmActPendingTask.setTaskDefKey(o.getNewTaskDefinitionKey());
                bpmActPendingTask.setTaskName(o.getTaskDefinitionName());
                bpmActPendingTask.setFormKey(((UserTask)process.getFlowElement(o.getTaskDefinitionKey())).getFormKey());
                bpmActPendingTask.setSeq(1);
                bpmActPendingTask.setTodoConfiguration(flowModel.getProps().getTodoConfiguration().getModalValue());
                bpmActPendingTask.setProcDefId(processInstance.getProcessDefinitionId());
                bpmActPendingTask.setProcessKey(processInstance.getProcessDefinitionKey());
                bpmActPendingTask.setProcInstId(processInstance.getId());
                bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
                bpmActPendingTask.setIsMain("0");
                bpmActPendingTask.setPendingType("1");
                bpmActPendingTask.setIsMain(t.getIsMain());
                bpmActPendingTask.setOwner(HussarUtils.isEmpty((Object)t.getOwner()) ? t.getUserId() : t.getOwner());
                bpmActPendingTask.setAssignee(t.getUserId());
                bpmActPendingTask.setPosition(t.getPostId());
                bpmActPendingTask.setDeptId(t.getDeptId());
                pendingTasks.add(bpmActPendingTask);
            });
            if (o.getIsJump()) {
                targetNodeIds.add(o.getNewTaskDefinitionKey());
            }
        });
        this.bpmActPendingTaskService.saveBatch(pendingTasks);
        String userId = ((IdentityLink)this.taskService.getIdentityLinksForTask(task.getId()).get(0)).getUserId();
        String targetNodeId = String.join((CharSequence)",", targetNodeIds);
        if (HussarUtils.isNotEmpty((Object)targetNodeId)) {
            ArrayList approvalNodePending = new ArrayList();
            List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
            identityLinks.forEach(o -> {
                BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                bpmActPendingTask.setTaskDefKey(task.getTaskDefinitionKey());
                bpmActPendingTask.setTaskName(task.getName());
                bpmActPendingTask.setFormKey(((UserTask)process.getFlowElement(task.getTaskDefinitionKey())).getFormKey());
                bpmActPendingTask.setSeq(1);
                bpmActPendingTask.setTodoConfiguration(flowModel.getProps().getTodoConfiguration().getModalValue());
                bpmActPendingTask.setProcDefId(processInstance.getProcessDefinitionId());
                bpmActPendingTask.setProcessKey(processInstance.getProcessDefinitionKey());
                bpmActPendingTask.setProcInstId(processInstance.getId());
                bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
                bpmActPendingTask.setIsMain("0");
                bpmActPendingTask.setPendingType("1");
                bpmActPendingTask.setIsMain("1");
                bpmActPendingTask.setOwner(HussarUtils.isEmpty((Object)o.getMandator()) ? o.getUserId() : o.getMandator());
                bpmActPendingTask.setAssignee(o.getUserId());
                bpmActPendingTask.setPosition(o.getPostId());
                bpmActPendingTask.setDeptId(o.getDeptId());
                approvalNodePending.add(bpmActPendingTask);
            });
            this.bpmActPendingTaskService.saveBatch(approvalNodePending);
            this.taskEngineService.jumpToFrontNode(task.getId(), userId, targetNodeId);
        }
    }

    private void deleteNodeNewWorkFlow(WorkFlow workFlow, String deleteNodeId) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        FlowObject deleteNode = null;
        FlowSequence preSequence = null;
        FlowSequence rearSequence = null;
        FlowSequence preParallelSequence = null;
        FlowSequence rearParallelSequence = null;
        FlowObject startParallelNode = null;
        FlowObject endParallelNode = null;
        ArrayList<FlowSequence> preStartSequence = new ArrayList<FlowSequence>();
        FlowSequence rearEndSequence = null;
        for (FlowObject flowObject : elements) {
            if (!deleteNodeId.equals(flowObject.getId())) continue;
            deleteNode = flowObject;
            for (FlowSequence flowSequence : paths) {
                if (flowSequence.getEnd().getKey().equals(flowObject.getId()) && !flowSequence.getStart().getKey().contains("parallel_node")) {
                    preSequence = flowSequence;
                }
                if (!flowSequence.getEnd().getKey().equals(flowObject.getId()) || !flowSequence.getStart().getKey().contains("parallel_node")) continue;
                preParallelSequence = flowSequence;
            }
            for (FlowSequence flowSequence : paths) {
                if (flowSequence.getStart().getKey().equals(flowObject.getId()) && preSequence != null) {
                    rearSequence = flowSequence;
                }
                if (!flowSequence.getStart().getKey().equals(flowObject.getId()) || preParallelSequence == null) continue;
                rearParallelSequence = flowSequence;
            }
        }
        if (HussarUtils.isEmpty(deleteNode)) {
            throw new PublicClientException("\u5220\u9664\u8282\u70b9\u672a\u627e\u5230\uff01");
        }
        FlowSequenceXy delXy = null;
        FlowSequenceXy addXy = null;
        elements.remove(deleteNode);
        if (preSequence != null && rearSequence != null) {
            preSequence.getEnd().setKey(rearSequence.getEnd().getKey());
            if (preSequence.getStart().getPort().equals("R")) {
                for (FlowSequenceXy flowSequenceXy : preSequence.getPoints()) {
                    if (!Double.valueOf(flowSequenceXy.getX()).equals(Double.valueOf(deleteNode.getLeft()))) continue;
                    delXy = flowSequenceXy;
                }
                for (FlowSequenceXy flowSequenceXy : rearSequence.getPoints()) {
                    if (Math.abs(Double.valueOf(flowSequenceXy.getX()) - Double.valueOf(deleteNode.getLeft())) == 48.0) continue;
                    addXy = flowSequenceXy;
                }
            } else {
                for (FlowSequenceXy flowSequenceXy : preSequence.getPoints()) {
                    if (Math.abs(Double.valueOf(flowSequenceXy.getX()) - Double.valueOf(deleteNode.getLeft())) != 48.0) continue;
                    delXy = flowSequenceXy;
                }
                for (FlowSequenceXy flowSequenceXy : rearSequence.getPoints()) {
                    if (Double.valueOf(flowSequenceXy.getX()).equals(Double.valueOf(deleteNode.getLeft()))) continue;
                    addXy = flowSequenceXy;
                }
            }
            preSequence.getPoints().remove(delXy);
            preSequence.getPoints().add(addXy);
            paths.remove(rearSequence);
            workFlow.setData(JSON.toJSONString((Object)flowModel));
            return;
        }
        if (preParallelSequence != null && rearParallelSequence != null) {
            for (FlowObject flowObject : elements) {
                if (startParallelNode != null && endParallelNode != null) break;
                if (flowObject.getId().equals(preParallelSequence.getStart().getKey())) {
                    startParallelNode = flowObject;
                    continue;
                }
                if (!flowObject.getId().equals(rearParallelSequence.getEnd().getKey())) continue;
                endParallelNode = flowObject;
            }
            paths.remove(preParallelSequence);
            paths.remove(rearParallelSequence);
            if (startParallelNode.getGoOutPathes().size() > 1) {
                startParallelNode.getGoOutPathes().removeAll(Collections.singleton(preParallelSequence.getId()));
                workFlow.setData(JSON.toJSONString((Object)flowModel));
                return;
            }
        }
        for (FlowSequence flowSequence : paths) {
            if (HussarUtils.isNotEmpty(preStartSequence) && rearEndSequence != null) break;
            if (flowSequence.getEnd().getKey().equals(startParallelNode.getId())) {
                preStartSequence.add(flowSequence);
                continue;
            }
            if (!flowSequence.getStart().getKey().equals(endParallelNode.getId())) continue;
            rearEndSequence = flowSequence;
        }
        elements.remove(startParallelNode);
        elements.remove(endParallelNode);
        for (FlowSequence flowSequence : preStartSequence) {
            flowSequence.getEnd().setKey(rearEndSequence.getEnd().getKey());
            if (flowSequence.getStart().getPort().equals("R")) {
                for (FlowSequenceXy flowSequenceXy : flowSequence.getPoints()) {
                    if (!Double.valueOf(flowSequenceXy.getX()).equals(Double.valueOf(startParallelNode.getLeft()))) continue;
                    delXy = flowSequenceXy;
                }
                for (FlowSequenceXy flowSequenceXy : rearEndSequence.getPoints()) {
                    if (Math.abs(Double.valueOf(flowSequenceXy.getX()) - Double.valueOf(endParallelNode.getLeft())) == 48.0) continue;
                    addXy = flowSequenceXy;
                }
            } else {
                for (FlowSequenceXy flowSequenceXy : flowSequence.getPoints()) {
                    if (Math.abs(Double.valueOf(flowSequenceXy.getX()) - Double.valueOf(startParallelNode.getLeft())) != 48.0) continue;
                    delXy = flowSequenceXy;
                }
                for (FlowSequenceXy flowSequenceXy : rearEndSequence.getPoints()) {
                    if (Double.valueOf(flowSequenceXy.getX()).equals(Double.valueOf(endParallelNode.getLeft()))) continue;
                    addXy = flowSequenceXy;
                }
            }
            flowSequence.getPoints().remove(delXy);
            flowSequence.getPoints().add(addXy);
        }
        paths.remove(rearEndSequence);
        workFlow.setData(JSON.toJSONString((Object)flowModel));
    }

    private void searchForPathFromOriginalNodeToAppointedSupplementaryLocation(List<FlowSequence> paths, String originalTaskDefKey, String appointedSupplementaryLocation, List<String> nodeSequenceOfPath) {
        HashMap<String, List<String>> mappingFromHeadToTail = new HashMap<String, List<String>>();
        this.hasMappingFromHeadToTail(paths, mappingFromHeadToTail);
        this.searchForThisPathFromMapping(mappingFromHeadToTail, originalTaskDefKey, appointedSupplementaryLocation, nodeSequenceOfPath);
    }

    private void hasMappingFromHeadToTail(List<FlowSequence> paths, Map<String, List<String>> mappingFromHeadToTail) {
        mappingFromHeadToTail.putAll(paths.stream().collect(Collectors.groupingBy(o -> o.getStart().getKey(), Collectors.mapping(o -> o.getEnd().getKey(), Collectors.toList()))));
    }

    private void searchForThisPathFromMapping(Map<String, List<String>> mappingFromHeadToTail, String originalTaskDefKey, String appointedSupplementaryLocation, List<String> nodeSequenceOfPath) {
        HashMap<String, Boolean> nodeAccessTag = new HashMap<String, Boolean>();
        Stack<String> nodeStack = new Stack<String>();
        nodeStack.push(originalTaskDefKey);
        nodeAccessTag.put(originalTaskDefKey, true);
        while (!nodeStack.empty() && !((String)nodeStack.peek()).equals(appointedSupplementaryLocation)) {
            List<String> neighborNodes = mappingFromHeadToTail.get(nodeStack.peek());
            HashMap<String, Boolean> neighborNodeAccessTag = new HashMap<String, Boolean>();
            if (HussarUtils.isNotEmpty(neighborNodes)) {
                for (String neighborNode : neighborNodes) {
                    if (!nodeAccessTag.containsKey(neighborNode)) {
                        nodeAccessTag.put(neighborNode, true);
                        nodeStack.push(neighborNode);
                        break;
                    }
                    neighborNodeAccessTag.put(neighborNode, true);
                }
            }
            if (!HussarUtils.isEmpty(neighborNodes) && neighborNodeAccessTag.size() != neighborNodes.size()) continue;
            nodeStack.pop();
        }
        Stack destination = new Stack();
        while (!nodeStack.isEmpty()) {
            destination.push(nodeStack.pop());
        }
        while (!destination.isEmpty()) {
            nodeSequenceOfPath.add((String)destination.pop());
        }
    }

    private void tidyNodesAndPaths(List<FlowObject> nodes, List<FlowSequence> paths, AlternativeTask addTaskNode, String originalTaskDefKey, String newNodeId, String newPathId, boolean isAddParallel, boolean isFront, String userId, String deptId, String businessKey, String procDefId, Map<String, Object> variables) {
        double x = 0.0;
        double y = 0.0;
        double nodeWidth = 0.0;
        double nodeX = 0.0;
        String pathId = "";
        int moveWidth = 96;
        if (!isFront) {
            for (FlowSequence flowSequence : paths) {
                if (!flowSequence.getStart().getKey().equals(originalTaskDefKey)) continue;
                pathId = flowSequence.getId();
                flowSequence.getStart().setKey(newNodeId);
                if (!"L".equals(flowSequence.getStart().getPort())) continue;
                moveWidth = -moveWidth;
            }
            for (FlowObject flowObject : nodes) {
                if (!flowObject.getInstanceKey().equals(originalTaskDefKey)) continue;
                flowObject.getGoOutPathes().set(0, newPathId);
                nodeX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                x = Double.parseDouble(flowObject.getLeft());
                if (moveWidth > 0) {
                    x += Double.parseDouble(flowObject.getWidth());
                }
                y = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (FlowObject flowObject : nodes) {
                double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                if (moveWidth > 0 && flowObjectX > nodeX || moveWidth < 0 && flowObjectX < nodeX) {
                    flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                    continue;
                }
                list.add(flowObject.getId());
            }
            for (FlowSequence path : paths) {
                FlowSequenceXy flowSequenceXy;
                int i;
                boolean isStartNotMove = list.contains(path.getStart().getKey());
                boolean isEndNotMove = list.contains(path.getEnd().getKey());
                if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                    int moveNum = 2;
                    if (isStartNotMove) {
                        --moveNum;
                    }
                    if (isEndNotMove) {
                        --moveNum;
                    }
                    if (moveNum > 0) {
                        Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                        lineConfigX = lineConfigX + (double)(moveWidth / 2 * moveNum);
                        path.getLineConfig().setX(String.valueOf(lineConfigX));
                    }
                }
                List listXy = path.getPoints();
                for (i = 0; i < listXy.size(); ++i) {
                    if (i == 0 && isStartNotMove || i == listXy.size() - 1 && isEndNotMove) continue;
                    flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                    if (i != 0 && i != listXy.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < nodeX || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > nodeX)) continue;
                    flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
                }
                for (i = 0; i < listXy.size() - 1; ++i) {
                    flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                    FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                    if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                    FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                    FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                    flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                    flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                    double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                    flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                    flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                    listXy.add(i + 1, flowSequenceXyNewPoint1);
                    listXy.add(i + 2, flowSequenceXyNewPoint2);
                }
            }
            paths.add(this.newPath(newPathId, originalTaskDefKey, newNodeId, x, y, moveWidth, null));
            x = moveWidth < 0 ? (x += (double)moveWidth) : (x += (double)moveWidth / 2.0);
            if (isAddParallel) {
                nodes.add(this.newParallelNode(newNodeId, pathId, x, y));
            } else {
                nodes.add(this.newNode(addTaskNode, x, y, newNodeId, pathId, userId, deptId, businessKey, procDefId, variables));
            }
        } else {
            for (FlowSequence flowSequence : paths) {
                if (!flowSequence.getEnd().getKey().equals(addTaskNode.getAppointedSupplementaryLocation())) continue;
                flowSequence.getEnd().setKey(newNodeId);
                if ("L".equals(flowSequence.getStart().getPort())) {
                    moveWidth = -moveWidth;
                }
                if (flowSequence.getPoints().size() <= 0) continue;
                x = Double.valueOf(((FlowSequenceXy)flowSequence.getPoints().get(flowSequence.getPoints().size() - 1)).getX());
                y = Double.valueOf(((FlowSequenceXy)flowSequence.getPoints().get(flowSequence.getPoints().size() - 1)).getY());
            }
            ArrayList list = new ArrayList();
            for (FlowObject flowObject : nodes) {
                double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                if (moveWidth > 0 && flowObjectX > x || moveWidth < 0 && flowObjectX < x) {
                    flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                    continue;
                }
                nodeWidth = Double.parseDouble(flowObject.getWidth());
                list.add(flowObject.getId());
            }
            for (FlowSequence path : paths) {
                List listXy;
                if (!path.getStart().getKey().equals(addTaskNode.getLastSupplementaryNodeInProcessing())) {
                    FlowSequenceXy flowSequenceXy;
                    int i;
                    boolean isStartNotMove = list.contains(path.getStart().getKey());
                    boolean isEndNotMove = list.contains(path.getEnd().getKey());
                    if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                        int moveNum = 2;
                        if (isStartNotMove) {
                            --moveNum;
                        }
                        if (isEndNotMove) {
                            --moveNum;
                        }
                        if (moveNum > 0) {
                            Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                            lineConfigX = lineConfigX + (double)(moveWidth / 2 * moveNum);
                            path.getLineConfig().setX(String.valueOf(lineConfigX));
                        }
                    }
                    List listXy2 = path.getPoints();
                    for (i = 0; i < listXy2.size(); ++i) {
                        if (i == 0 && isStartNotMove || i == listXy2.size() - 1 && isEndNotMove || isStartNotMove && i < listXy2.size() - 1) continue;
                        flowSequenceXy = (FlowSequenceXy)listXy2.get(i);
                        if (i != 0 && i != listXy2.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy2.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy2.get(listXy2.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < nodeX || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > nodeX)) continue;
                        flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
                    }
                    for (i = 0; i < listXy2.size() - 1; ++i) {
                        flowSequenceXy = (FlowSequenceXy)listXy2.get(i);
                        FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy2.get(i + 1);
                        if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                        FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                        FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                        flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                        flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                        double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                        flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                        flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                        listXy2.add(i + 1, flowSequenceXyNewPoint1);
                        listXy2.add(i + 2, flowSequenceXyNewPoint2);
                    }
                    continue;
                }
                if (path.getEnd().getKey().equals(newNodeId)) continue;
                if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                    Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                    lineConfigX = lineConfigX + (double)(moveWidth / 2);
                    path.getLineConfig().setX(String.valueOf(lineConfigX));
                }
                if ((listXy = path.getPoints()).size() != 0) {
                    ((FlowSequenceXy)listXy.get(listXy.size() - 1)).setX(String.valueOf(Double.parseDouble(((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX()) + (double)moveWidth));
                }
                for (int i = 0; i < listXy.size() - 1; ++i) {
                    FlowSequenceXy flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                    FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                    if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                    FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                    FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                    flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                    flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                    double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                    flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                    flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                    listXy.add(i + 1, flowSequenceXyNewPoint1);
                    listXy.add(i + 2, flowSequenceXyNewPoint2);
                }
            }
            if (moveWidth > 0) {
                paths.add(this.newPath(newPathId, newNodeId, addTaskNode.getAppointedSupplementaryLocation(), x + nodeWidth, y, moveWidth, null));
            } else {
                paths.add(this.newPath(newPathId, newNodeId, addTaskNode.getAppointedSupplementaryLocation(), x - nodeWidth, y, moveWidth, null));
            }
            if (moveWidth < 0) {
                x -= nodeWidth;
            }
            addTaskNode.setLastSupplementaryNodeInProcessing(newNodeId);
            if (isAddParallel) {
                nodes.add(this.newParallelNode(newNodeId, newPathId, x, y));
            } else {
                nodes.add(this.newNode(addTaskNode, x, y, newNodeId, newPathId, userId, deptId, businessKey, procDefId, variables));
            }
        }
    }

    private void tidyNodesAndPaths(List<FlowObject> nodes, List<FlowSequence> paths, AlternativeTask addTaskNode, String originalTaskDefKey, String newNodeId, String newPathId, boolean isAddParallel, boolean isFront, HistoricProcessInstance processInstance) {
        double x = 0.0;
        double y = 0.0;
        double nodeWidth = 0.0;
        double nodeX = 0.0;
        String pathId = "";
        int moveWidth = 96;
        if (!isFront) {
            for (FlowSequence flowSequence : paths) {
                if (!flowSequence.getStart().getKey().equals(originalTaskDefKey)) continue;
                pathId = flowSequence.getId();
                flowSequence.getStart().setKey(newNodeId);
                if (!"L".equals(flowSequence.getStart().getPort())) continue;
                moveWidth = -moveWidth;
            }
            for (FlowObject flowObject : nodes) {
                if (!flowObject.getInstanceKey().equals(originalTaskDefKey)) continue;
                flowObject.getGoOutPathes().set(0, newPathId);
                nodeX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                x = Double.parseDouble(flowObject.getLeft());
                if (moveWidth > 0) {
                    x += Double.parseDouble(flowObject.getWidth());
                }
                y = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (FlowObject flowObject : nodes) {
                double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                if (moveWidth > 0 && flowObjectX > nodeX || moveWidth < 0 && flowObjectX < nodeX) {
                    flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                    continue;
                }
                list.add(flowObject.getId());
            }
            for (FlowSequence path : paths) {
                FlowSequenceXy flowSequenceXy;
                int i;
                boolean isStartNotMove = list.contains(path.getStart().getKey());
                boolean isEndNotMove = list.contains(path.getEnd().getKey());
                if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                    int moveNum = 2;
                    if (isStartNotMove) {
                        --moveNum;
                    }
                    if (isEndNotMove) {
                        --moveNum;
                    }
                    if (moveNum > 0) {
                        Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                        lineConfigX = lineConfigX + (double)(moveWidth / 2 * moveNum);
                        path.getLineConfig().setX(String.valueOf(lineConfigX));
                    }
                }
                List listXy = path.getPoints();
                for (i = 0; i < listXy.size(); ++i) {
                    if (i == 0 && isStartNotMove || i == listXy.size() - 1 && isEndNotMove) continue;
                    flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                    if (i != 0 && i != listXy.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < nodeX || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > nodeX)) continue;
                    flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
                }
                for (i = 0; i < listXy.size() - 1; ++i) {
                    flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                    FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                    if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                    FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                    FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                    flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                    flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                    double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                    flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                    flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                    listXy.add(i + 1, flowSequenceXyNewPoint1);
                    listXy.add(i + 2, flowSequenceXyNewPoint2);
                }
            }
            paths.add(this.newPath(newPathId, originalTaskDefKey, newNodeId, x, y, moveWidth, null));
            x = moveWidth < 0 ? (x += (double)moveWidth) : (x += (double)moveWidth / 2.0);
            if (isAddParallel) {
                nodes.add(this.newParallelNode(newNodeId, pathId, x, y));
            } else {
                nodes.add(this.newNode(addTaskNode, x, y, newNodeId, pathId, processInstance));
            }
        } else {
            for (FlowSequence flowSequence : paths) {
                if (!flowSequence.getEnd().getKey().equals(addTaskNode.getAppointedSupplementaryLocation())) continue;
                flowSequence.getEnd().setKey(newNodeId);
                if ("L".equals(flowSequence.getStart().getPort())) {
                    moveWidth = -moveWidth;
                }
                if (flowSequence.getPoints().size() <= 0) continue;
                x = Double.valueOf(((FlowSequenceXy)flowSequence.getPoints().get(flowSequence.getPoints().size() - 1)).getX());
                y = Double.valueOf(((FlowSequenceXy)flowSequence.getPoints().get(flowSequence.getPoints().size() - 1)).getY());
            }
            ArrayList list = new ArrayList();
            for (FlowObject flowObject : nodes) {
                double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                if (moveWidth > 0 && flowObjectX > x || moveWidth < 0 && flowObjectX < x) {
                    flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                    continue;
                }
                nodeWidth = Double.parseDouble(flowObject.getWidth());
                list.add(flowObject.getId());
            }
            for (FlowSequence path : paths) {
                List listXy;
                if (!path.getStart().getKey().equals(addTaskNode.getLastSupplementaryNodeInProcessing())) {
                    FlowSequenceXy flowSequenceXy;
                    int i;
                    boolean isStartNotMove = list.contains(path.getStart().getKey());
                    boolean isEndNotMove = list.contains(path.getEnd().getKey());
                    if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                        int moveNum = 2;
                        if (isStartNotMove) {
                            --moveNum;
                        }
                        if (isEndNotMove) {
                            --moveNum;
                        }
                        if (moveNum > 0) {
                            Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                            lineConfigX = lineConfigX + (double)(moveWidth / 2 * moveNum);
                            path.getLineConfig().setX(String.valueOf(lineConfigX));
                        }
                    }
                    List listXy2 = path.getPoints();
                    for (i = 0; i < listXy2.size(); ++i) {
                        if (i == 0 && isStartNotMove || i == listXy2.size() - 1 && isEndNotMove || isStartNotMove && i < listXy2.size() - 1) continue;
                        flowSequenceXy = (FlowSequenceXy)listXy2.get(i);
                        if (i != 0 && i != listXy2.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy2.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy2.get(listXy2.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < nodeX || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > nodeX)) continue;
                        flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
                    }
                    for (i = 0; i < listXy2.size() - 1; ++i) {
                        flowSequenceXy = (FlowSequenceXy)listXy2.get(i);
                        FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy2.get(i + 1);
                        if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                        FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                        FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                        flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                        flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                        double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                        flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                        flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                        listXy2.add(i + 1, flowSequenceXyNewPoint1);
                        listXy2.add(i + 2, flowSequenceXyNewPoint2);
                    }
                    continue;
                }
                if (path.getEnd().getKey().equals(newNodeId)) continue;
                if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                    Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                    lineConfigX = lineConfigX + (double)(moveWidth / 2);
                    path.getLineConfig().setX(String.valueOf(lineConfigX));
                }
                if ((listXy = path.getPoints()).size() != 0) {
                    ((FlowSequenceXy)listXy.get(listXy.size() - 1)).setX(String.valueOf(Double.parseDouble(((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX()) + (double)moveWidth));
                }
                for (int i = 0; i < listXy.size() - 1; ++i) {
                    FlowSequenceXy flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                    FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                    if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                    FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                    FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                    flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                    flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                    double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                    flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                    flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                    listXy.add(i + 1, flowSequenceXyNewPoint1);
                    listXy.add(i + 2, flowSequenceXyNewPoint2);
                }
            }
            if (moveWidth > 0) {
                paths.add(this.newPath(newPathId, newNodeId, addTaskNode.getAppointedSupplementaryLocation(), x + nodeWidth, y, moveWidth, null));
            } else {
                paths.add(this.newPath(newPathId, newNodeId, addTaskNode.getAppointedSupplementaryLocation(), x - nodeWidth, y, moveWidth, null));
            }
            if (moveWidth < 0) {
                x -= nodeWidth;
            }
            addTaskNode.setLastSupplementaryNodeInProcessing(newNodeId);
            if (isAddParallel) {
                nodes.add(this.newParallelNode(newNodeId, newPathId, x, y));
            } else {
                nodes.add(this.newNode(addTaskNode, x, y, newNodeId, newPathId, processInstance));
            }
        }
    }

    private FlowObject newParallelNode(String nodeId, String pathId, double x, double y) {
        FlowObject flowObject = new FlowObject();
        flowObject.setProps(new FlowProps());
        flowObject.setInstanceKey(nodeId);
        flowObject.setName(BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType());
        flowObject.setAlias("");
        flowObject.setWidth(String.valueOf(48));
        flowObject.setHeight(String.valueOf(48));
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - 25.0));
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        return flowObject;
    }

    private void saveFormAuth(String processKey, String nodeId, List<String> addNodeIds) {
        List list = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).eq(SysActFormAuth::getTaskDefinitionKey, (Object)nodeId));
        ArrayList<SysActFormAuth> addList = new ArrayList<SysActFormAuth>();
        for (SysActFormAuth sysActFormAuth : list) {
            for (String addNodeId : addNodeIds) {
                SysActFormAuth addSysActFormAuth = new SysActFormAuth();
                CopyPropertieUtils.copyProperties((Object)addSysActFormAuth, (Object)sysActFormAuth);
                addSysActFormAuth.setTaskDefinitionKey(addNodeId);
                addSysActFormAuth.setId(null);
                addList.add(addSysActFormAuth);
            }
        }
        this.sysActFormAuthService.saveBatch(addList);
    }

    private Map<String, String> getNewAlternativeTask(AlternativeTask addTaskNode, String perNode, String alternativeNode, String hostTaskDefKey, Boolean isAddParallel, Boolean isFront) {
        if (HussarUtils.isEmpty((Object)perNode)) {
            throw new PublicClientException("\u672a\u914d\u7f6e" + addTaskNode.getTaskDefinitionName() + "\u7981\u6b62\u6dfb\u52a0");
        }
        if (perNode.startsWith("jxd_bpm_custom_node")) {
            perNode = perNode.split("-")[1];
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (isAddParallel.booleanValue()) {
            map.put("nodeId", "parallel_node-" + hostTaskDefKey + "-" + (int)(1.0E7 + Math.random() * 9.0E7));
        } else if (isFront.booleanValue()) {
            String newNodeId = "jxd_bpm_custom_node-" + hostTaskDefKey + "-" + addTaskNode.getAppointedSupplementaryLocation() + "-" + alternativeNode + "-" + (int)(1.0E7 + Math.random() * 9.0E7) + "-" + "front";
            map.put("nodeId", newNodeId);
            addTaskNode.setNewTaskDefinitionKey(newNodeId);
        } else {
            String newNodeId = "jxd_bpm_custom_node-" + hostTaskDefKey + "-" + perNode + "-" + alternativeNode + "-" + (int)(1.0E7 + Math.random() * 9.0E7) + "-" + "back";
            map.put("nodeId", newNodeId);
            addTaskNode.setNewTaskDefinitionKey(newNodeId);
        }
        map.put("pathId", "jxd_bpm_custom_path-" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("endPathId", "jxd_bpm_custom_path-" + (int)(1.0E7 + Math.random() * 9.0E7));
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private WorkFlow getNewWorkFlow(WorkFlow workFlow, List<String> addNodeIds, Map<String, Object> map) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)workFlow.getData(), JSONObject.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        FlowProps extendFlowProps = null;
        List addList = (List)map.get("addList");
        String nextNodeId = "";
        boolean isParallel = false;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            nextNodeId = path.getEnd().getKey();
            break;
        }
        if ("".equals(nextNodeId)) {
            throw new BpmException(BpmExceptionCodeEnum.SUB_PROCESS_CONNOT_ADD_NODE);
        }
        ArrayList<Map<String, String>> addIds = new ArrayList<Map<String, String>>();
        for (int i = 0; i < addList.size(); ++i) {
            addIds.add(this.getNewId());
        }
        String newNodeId = (String)((Map)addIds.get(0)).get("nodeId");
        String newPathId = (String)((Map)addIds.get(0)).get("pathId");
        for (FlowObject flowObject : elements) {
            if (flowObject.getId().equals(map.get("nodeId"))) {
                extendFlowProps = flowObject.getProps();
            }
            if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) && !BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) continue;
            isParallel = true;
            List goOutPath = flowObject.getGoOutPathes();
            goOutPath.add(newPathId);
            for (Map map2 : addIds) {
                goOutPath.add(map2.get("pathId"));
            }
            flowObject.setGoOutPathes(goOutPath);
        }
        if (isParallel && "true".equals(map.get("parallel"))) {
            void var19_25;
            String endPointNodeId = this.getNextParallelNodeId(elements, paths, nextNodeId);
            if (HussarUtils.isEmpty((Object)endPointNodeId)) {
                throw new BpmException(BpmExceptionCodeEnum.IS_NOT_CONFLUENCE_PARALLEL);
            }
            ArrayList<String> nodeIds = new ArrayList<String>();
            List<Map<String, List<FlowSequenceXy>>> pointsList = this.getParallelNewPathPoints(paths, nextNodeId, endPointNodeId, addList.size(), nodeIds, elements);
            boolean bl = false;
            while (var19_25 < pointsList.size()) {
                String nodeId = (String)((Map)addIds.get((int)var19_25)).get("nodeId") + "parallel_node" + (String)nodeIds.get(0);
                addNodeIds.add(nodeId);
                Map<String, List<FlowSequenceXy>> points = pointsList.get((int)var19_25);
                FlowSequenceXy point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                elements.add(this.newNode(nodeId, ((Map)addList.get((int)var19_25)).get("nodeName"), (String)((Map)addIds.get((int)var19_25)).get("endPathId"), ((Map)addList.get((int)var19_25)).get("nodeAssignee"), ((Map)addList.get((int)var19_25)).get("counterSwitch"), ((Map)addList.get((int)var19_25)).get("multiType"), ((Map)addList.get((int)var19_25)).get("multiNumber"), Double.parseDouble(point.getX()), Double.parseDouble(point.getY()), extendFlowProps));
                paths.add(this.newPath((String)((Map)addIds.get((int)var19_25)).get("pathId"), nextNodeId, nodeId, 0.0, 0.0, 0, points.get("startPoints")));
                paths.add(this.newPath((String)((Map)addIds.get((int)var19_25)).get("endPathId"), nodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                ++var19_25;
            }
            workFlow.setData(JSON.toJSONString((Object)flowModel));
            return workFlow;
        }
        double x = 0.0;
        double y = 0.0;
        double d = 0.0;
        String pathId = "";
        int moveWidth = 96;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            pathId = path.getId();
            path.getStart().setKey(newNodeId);
            if (!"L".equals(path.getStart().getPort())) continue;
            moveWidth = -moveWidth;
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getInstanceKey().equals(map.get("nodeId"))) continue;
            flowObject.getGoOutPathes().set(0, newPathId);
            d = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            x = Double.parseDouble(flowObject.getLeft());
            if (moveWidth > 0) {
                x += Double.parseDouble(flowObject.getWidth());
            }
            y = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            if (moveWidth > 0 && flowObjectX > d || moveWidth < 0 && flowObjectX < d) {
                flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                continue;
            }
            list.add(flowObject.getId());
        }
        for (FlowSequence path : paths) {
            FlowSequenceXy flowSequenceXy;
            int i;
            boolean isStartNotMove = list.contains(path.getStart().getKey());
            boolean isEndNotMove = list.contains(path.getEnd().getKey());
            if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                int moveNum = 2;
                if (isStartNotMove) {
                    --moveNum;
                }
                if (isEndNotMove) {
                    --moveNum;
                }
                if (moveNum > 0) {
                    Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                    lineConfigX = lineConfigX + (double)(moveWidth / 2 * moveNum);
                    path.getLineConfig().setX(String.valueOf(lineConfigX));
                }
            }
            List listXy = path.getPoints();
            for (i = 0; i < listXy.size(); ++i) {
                if (i == 0 && isStartNotMove || i == listXy.size() - 1 && isEndNotMove) continue;
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                if (i != 0 && i != listXy.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < d || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > d)) continue;
                flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
            }
            for (i = 0; i < listXy.size() - 1; ++i) {
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                listXy.add(i + 1, flowSequenceXyNewPoint1);
                listXy.add(i + 2, flowSequenceXyNewPoint2);
            }
        }
        paths.add(this.newPath(newPathId, (String)map.get("nodeId"), newNodeId, x, y, moveWidth, null));
        x = moveWidth < 0 ? (x += (double)moveWidth) : (x += (double)moveWidth / 2.0);
        addNodeIds.add(newNodeId);
        elements.add(this.newNode(newNodeId, ((Map)addList.get(0)).get("nodeName"), pathId, ((Map)addList.get(0)).get("nodeAssignee"), ((Map)addList.get(0)).get("counterSwitch"), ((Map)addList.get(0)).get("multiType"), ((Map)addList.get(0)).get("multiNumber"), x, y, extendFlowProps));
        workFlow.setData(JSON.toJSONString((Object)flowModel));
        return workFlow;
    }

    private String getNextParallelNodeId(List<FlowObject> elements, List<FlowSequence> paths, String nodeId) {
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nodeId)) continue;
            String nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) {
                    return nextNodeId;
                }
                return this.getNextParallelNodeId(elements, paths, nextNodeId);
            }
        }
        return null;
    }

    private List<Map<String, List<FlowSequenceXy>>> getParallelNewPathPoints(List<FlowSequence> paths, String nextNodeId, String endPointNodeId, int num, List<String> nodeIds, List<FlowObject> elements) {
        ArrayList<FlowSequenceXy> newEndPoints;
        ArrayList<FlowSequenceXy> endPoints;
        ArrayList<Map<String, List<FlowSequenceXy>>> list = new ArrayList<Map<String, List<FlowSequenceXy>>>();
        HashMap map = new HashMap();
        FlowSequenceXy start1 = null;
        FlowSequenceXy start2 = null;
        FlowSequenceXy startPoint1 = new FlowSequenceXy();
        FlowSequenceXy startPoint2 = new FlowSequenceXy();
        FlowSequenceXy startPoint3 = new FlowSequenceXy();
        FlowSequenceXy startPoint4 = new FlowSequenceXy();
        FlowSequenceXy end1 = null;
        FlowSequenceXy end2 = null;
        FlowSequenceXy endPoint1 = new FlowSequenceXy();
        FlowSequenceXy endPoint2 = new FlowSequenceXy();
        FlowSequenceXy endPoint3 = new FlowSequenceXy();
        FlowSequenceXy endPoint4 = new FlowSequenceXy();
        FlowSequenceXy startNode1 = new FlowSequenceXy();
        FlowSequenceXy startNode2 = new FlowSequenceXy();
        FlowSequenceXy startNode3 = new FlowSequenceXy();
        FlowSequenceXy endNode1 = new FlowSequenceXy();
        FlowSequenceXy endNode2 = new FlowSequenceXy();
        FlowSequenceXy endNode3 = new FlowSequenceXy();
        for (FlowSequence path : paths) {
            List point;
            if (nextNodeId.equals(path.getStart().getKey())) {
                point = path.getPoints();
                double yChangeLength = 0.0;
                path.getEnd();
                if (elements != null) {
                    for (FlowObject flowObject : elements) {
                        if (!path.getEnd().getKey().equals(flowObject.getId())) continue;
                        yChangeLength = (Double.valueOf(flowObject.getHeight()) - 48.0) / 2.0;
                    }
                }
                if (point.size() > 3) {
                    double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + 75.0 + yChangeLength;
                    if (HussarUtils.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                        startPoint1 = (FlowSequenceXy)point.get(0);
                        startPoint2 = (FlowSequenceXy)point.get(1);
                        startPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                        startPoint3.setY(String.valueOf(addY));
                        startPoint4.setY(String.valueOf(addY));
                    }
                    startPoint4.setX(((FlowSequenceXy)point.get(3)).getX());
                } else if (point.size() == 3) {
                    double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + 75.0 + yChangeLength;
                    if (HussarUtils.isEmpty((Object)startNode3.getY()) || Double.parseDouble(startNode3.getY()) < addY) {
                        startNode1 = (FlowSequenceXy)point.get(0);
                        startNode2.setX(((FlowSequenceXy)point.get(1)).getX());
                        startNode3.setX(((FlowSequenceXy)point.get(2)).getX());
                        startNode2.setY(String.valueOf(addY));
                        startNode3.setY(String.valueOf(addY));
                    }
                } else {
                    start1 = (FlowSequenceXy)point.get(0);
                    start2 = (FlowSequenceXy)point.get(1);
                }
            }
            if (!endPointNodeId.equals(path.getEnd().getKey())) continue;
            if (!path.getStart().getKey().startsWith("jxd_bpm_custom_node")) {
                nodeIds.add(path.getStart().getKey());
            }
            if ((point = path.getPoints()).size() > 3) {
                if (endPoint3.getY() != null && !(Double.valueOf(((FlowSequenceXy)point.get(3)).getY()) > Double.valueOf(endPoint3.getY()))) continue;
                endPoint2.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setY(((FlowSequenceXy)point.get(3)).getY());
                endPoint4 = (FlowSequenceXy)point.get(3);
                continue;
            }
            if (point.size() == 3) {
                if (endNode3.getY() != null && !(Double.valueOf(((FlowSequenceXy)point.get(2)).getY()) > Double.valueOf(endNode3.getY()))) continue;
                endNode2.setX(((FlowSequenceXy)point.get(1)).getX());
                endNode3 = (FlowSequenceXy)point.get(2);
                continue;
            }
            end1 = (FlowSequenceXy)point.get(0);
            end2 = (FlowSequenceXy)point.get(1);
        }
        if (HussarUtils.isNotEmpty((Object)startNode1.getX())) {
            endNode1.setY(startNode3.getY());
            endNode1.setX(String.valueOf(Double.parseDouble(startNode3.getX()) + 48.0));
            endNode2.setY(startNode3.getY());
        }
        if (start1 != null && start2 != null && HussarUtils.isEmpty((Object)startPoint3.getX()) && HussarUtils.isNotEmpty((Object)start1.getX())) {
            startPoint1 = start1;
            startPoint2.setY(start1.getY());
            String midX = String.valueOf((Double.parseDouble(start1.getX()) + Double.parseDouble(start2.getX())) / 2.0);
            startPoint2.setX(midX);
            startPoint3.setX(midX);
            startPoint4.setX(start2.getX());
        }
        if (HussarUtils.isNotEmpty(start1)) {
            double addY = Double.parseDouble(start1.getY()) + 75.0;
            if (HussarUtils.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                startPoint3.setY(String.valueOf(addY));
                startPoint4.setY(String.valueOf(addY));
            }
        }
        if (HussarUtils.isNotEmpty((Object)startPoint1.getX())) {
            endPoint1.setY(startPoint4.getY());
            endPoint1.setX(String.valueOf(Double.parseDouble(startPoint4.getX()) + 48.0));
            endPoint2.setY(startPoint4.getY());
        }
        if (HussarUtils.isEmpty((Object)endPoint3.getX()) && end2 != null) {
            endPoint4 = end2;
            endPoint3.setY(end2.getY());
            String midX = String.valueOf((Double.parseDouble(end1.getX()) + Double.parseDouble(end2.getX())) / 2.0);
            endPoint2.setX(midX);
            endPoint3.setX(midX);
        }
        if (HussarUtils.isNotEmpty((Object)startNode2.getY()) && Double.parseDouble(startNode2.getY()) > Double.parseDouble(startPoint3.getY())) {
            ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
            startPoints.add(startNode1);
            startPoints.add(startNode2);
            startPoints.add(startNode3);
            endPoints = new ArrayList();
            endPoints.add(endNode1);
            endPoints.add(endNode2);
            endPoints.add(endNode3);
            map.put("startPoints", startPoints);
            map.put("endPoints", endPoints);
            list.add(map);
            for (int i = 1; i < num; ++i) {
                ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
                newStartPoints.add(startNode1);
                FlowSequenceXy newStartNode2 = new FlowSequenceXy();
                newStartNode2.setX(startNode2.getX());
                newStartNode2.setY(String.valueOf(Double.parseDouble(startNode2.getY()) + (double)(75 * i)));
                newStartPoints.add(newStartNode2);
                FlowSequenceXy newStartNode3 = new FlowSequenceXy();
                newStartNode3.setX(startNode3.getX());
                newStartNode3.setY(String.valueOf(Double.parseDouble(startNode3.getY()) + (double)(75 * i)));
                newStartPoints.add(newStartNode3);
                newEndPoints = new ArrayList<FlowSequenceXy>();
                FlowSequenceXy newEndNode1 = new FlowSequenceXy();
                newEndNode1.setX(endNode1.getX());
                newEndNode1.setY(String.valueOf(Double.parseDouble(endNode1.getY()) + (double)(75 * i)));
                newEndPoints.add(newEndNode1);
                FlowSequenceXy newEndNode2 = new FlowSequenceXy();
                newEndNode2.setX(endNode2.getX());
                newEndNode2.setY(String.valueOf(Double.parseDouble(endNode2.getY()) + (double)(75 * i)));
                newEndPoints.add(newEndNode2);
                newEndPoints.add(endNode3);
                HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
                newMap.put("startPoints", newStartPoints);
                newMap.put("endPoints", newEndPoints);
                list.add(newMap);
            }
            return list;
        }
        ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
        startPoints.add(startPoint1);
        startPoints.add(startPoint2);
        startPoints.add(startPoint3);
        startPoints.add(startPoint4);
        endPoints = new ArrayList<FlowSequenceXy>();
        endPoints.add(endPoint1);
        endPoints.add(endPoint2);
        endPoints.add(endPoint3);
        endPoints.add(endPoint4);
        map.put("startPoints", startPoints);
        map.put("endPoints", endPoints);
        list.add(map);
        for (int i = 1; i < num; ++i) {
            ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
            newStartPoints.add(startPoint1);
            newStartPoints.add(startPoint2);
            FlowSequenceXy newStartPoint3 = new FlowSequenceXy();
            newStartPoint3.setX(startPoint3.getX());
            newStartPoint3.setY(String.valueOf(Double.parseDouble(startPoint3.getY()) + (double)(75 * i)));
            newStartPoints.add(newStartPoint3);
            FlowSequenceXy newStartPoint4 = new FlowSequenceXy();
            newStartPoint4.setX(startPoint4.getX());
            newStartPoint4.setY(String.valueOf(Double.parseDouble(startPoint4.getY()) + (double)(75 * i)));
            newStartPoints.add(newStartPoint4);
            newEndPoints = new ArrayList();
            FlowSequenceXy newEndPoint1 = new FlowSequenceXy();
            newEndPoint1.setX(endPoint1.getX());
            newEndPoint1.setY(String.valueOf(Double.parseDouble(endPoint1.getY()) + (double)(75 * i)));
            newEndPoints.add(newEndPoint1);
            FlowSequenceXy newEndPoint2 = new FlowSequenceXy();
            newEndPoint2.setX(endPoint2.getX());
            newEndPoint2.setY(String.valueOf(Double.parseDouble(endPoint2.getY()) + (double)(75 * i)));
            newEndPoints.add(newEndPoint2);
            newEndPoints.add(endPoint3);
            newEndPoints.add(endPoint4);
            HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
            newMap.put("startPoints", newStartPoints);
            newMap.put("endPoints", newEndPoints);
            list.add(newMap);
        }
        return list;
    }

    private Map<String, String> getNewId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeId", "jxd_bpm_custom_node_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("pathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("endPathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        return map;
    }

    private FlowObject newNode(String nodeId, Object nodeName, String pathId, Object assignees, Object counterSwitch, Object multiType, Object multiNumber, double x, double y, FlowProps extendFlowProps) {
        FlowObject flowObject = new FlowObject();
        flowObject.setInstanceKey(nodeId);
        flowObject.setName(BpmNodeTypeEnum.BPM_USER.getType());
        flowObject.setAlias("");
        flowObject.setWidth(String.valueOf(48));
        flowObject.setHeight(String.valueOf(48));
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - 25.0));
        FlowProps flowProps = new FlowProps();
        flowProps.setFormAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getFormAddress()), Map.class));
        flowProps.setFormDetailAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getFormDetailAddress()), Map.class));
        flowProps.setAssistFormAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getAssistFormAddress()), Map.class));
        flowProps.setAssistFormDetailAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getAssistFormDetailAddress()), Map.class));
        flowProps.setCcFormAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getCcFormAddress()), Map.class));
        flowProps.setCcFormDetailAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getCcFormDetailAddress()), Map.class));
        flowProps.setTodoConfiguration((FlowTodoCondition)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getTodoConfiguration()), FlowTodoCondition.class));
        flowProps.setUseVariables((List)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getUseVariables()), List.class));
        flowProps.setMessageType(extendFlowProps.getMessageType());
        flowProps.setFlowName((String)nodeName);
        FlowAssignment flowAssignment = new FlowAssignment();
        flowAssignment.setJudgeBackCondition(new ArrayList());
        List<String> assigneeIds = Arrays.asList(((String)assignees).split(","));
        StringBuilder condition = new StringBuilder(" and O.ORGAN_ID IN ('" + assigneeIds.get(0) + "')");
        for (int i = 1; i < assigneeIds.size(); ++i) {
            condition.append(" or O.ORGAN_ID IN ('").append(assigneeIds.get(i)).append("')");
        }
        flowAssignment.setDefaultBackCondtion(condition.toString());
        flowProps.setFlowAssignment(flowAssignment);
        flowProps.setFlowRecipients(new FlowRecipients());
        flowProps.setDueDate("");
        flowProps.setFlowSkipRepetition("");
        flowProps.setFlowDefault(false);
        MultiUser multiUser = new MultiUser();
        multiUser.setCountersignNumByRatio(100.0);
        multiUser.setCountersign(false);
        multiUser.setCountersignNumByCount(0);
        multiUser.setCountersignType("radio");
        if (((Boolean)counterSwitch).booleanValue() && HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiNumber)) {
            multiUser.setCountersign(true);
            multiUser.setCountersignType((String)multiType);
            if ("radio".equals(multiType)) {
                multiUser.setCountersignNumByRatio(Double.parseDouble(String.valueOf(multiNumber)));
            } else {
                multiUser.setCountersignNumByCount(((Integer)multiNumber).intValue());
            }
        }
        flowProps.setFlowCountersign(multiUser);
        flowObject.setProps(flowProps);
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        return flowObject;
    }

    private FlowSequence newPath(String pathId, String nodeId, String nextNodeId, double x, double y, int moveWidth, List<FlowSequenceXy> points) {
        FlowSequence flowSequence = new FlowSequence();
        SequenceSourceTarget start = new SequenceSourceTarget();
        SequenceSourceTarget end = new SequenceSourceTarget();
        start.setKey(nodeId);
        end.setKey(nextNodeId);
        if (moveWidth < 0) {
            start.setPort("L");
            end.setPort("R");
        } else {
            start.setPort("R");
            end.setPort("L");
        }
        flowSequence.setStart(start);
        flowSequence.setEnd(end);
        if (HussarUtils.isEmpty(points)) {
            points = new ArrayList<FlowSequenceXy>();
            FlowSequenceXy startXy = new FlowSequenceXy();
            startXy.setX(String.valueOf(x));
            startXy.setY(String.valueOf(y));
            points.add(startXy);
            FlowSequenceXy endXy = new FlowSequenceXy();
            endXy.setX(String.valueOf(x + (double)moveWidth / 2.0));
            endXy.setY(String.valueOf(y));
            points.add(endXy);
            flowSequence.setPoints(points);
        } else {
            ArrayList<FlowSequenceXy> pointList = new ArrayList<FlowSequenceXy>();
            for (FlowSequenceXy flowSequenceXy : points) {
                FlowSequenceXy sequenceXy = new FlowSequenceXy();
                sequenceXy.setX(flowSequenceXy.getX());
                sequenceXy.setY(flowSequenceXy.getY());
                pointList.add(sequenceXy);
            }
            flowSequence.setPoints(pointList);
        }
        flowSequence.setFlowDefault(false);
        flowSequence.setLineConfig(new LineConfig());
        flowSequence.setInstanceKey(pathId);
        flowSequence.setName(BpmNodeTypeEnum.BPM_SEQUENCE.getType());
        flowSequence.setAlias("");
        flowSequence.setWidth("0");
        flowSequence.setHeight("0");
        FlowProps flowProps = new FlowProps();
        flowProps.setFlowName("");
        flowProps.setBackFlowCondition("");
        flowSequence.setProps(flowProps);
        flowSequence.setGoOutPathes(new ArrayList());
        return flowSequence;
    }

    private String getRealTaskId(String taskId) {
        String tempTaskId = taskId;
        if (taskId != null && taskId.contains(":")) {
            String[] str = taskId.split(":");
            tempTaskId = str[0];
        }
        String realTaskId = null;
        if (tempTaskId != null) {
            SubCandidate subCandidate = (SubCandidate)((LambdaQueryChainWrapper)this.subCandidateService.lambdaQuery().eq(SubCandidate::getSubCandidateId, (Object)tempTaskId)).one();
            realTaskId = subCandidate == null ? tempTaskId : String.valueOf(subCandidate.getTaskId());
        }
        return realTaskId;
    }
}

