/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class CommonPrepareCmd
extends NeedsActiveTaskCmd<PrepareReturn> {
    protected BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    protected IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    protected SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)SpringContextHolder.getBean(SysActCcTaskMapper.class);
    protected String userId;
    protected String mandator;
    protected String taskState;
    protected boolean isAuditAuthority = true;

    public CommonPrepareCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        super(taskId);
        this.userId = userId;
        this.mandator = mandator;
        this.isAuditAuthority = isAuditAuthority;
    }

    public PrepareReturn execute(CommandContext commandContext, TaskEntity task) {
        IdentityLinkEntity completeIdentityLink;
        block9: {
            boolean mandataryFlag;
            boolean mandatorFlag;
            ArrayList<IdentityLinkEntity> userTasks;
            block14: {
                block11: {
                    block12: {
                        block13: {
                            block10: {
                                this.taskAuthentication(task);
                                completeIdentityLink = null;
                                if (!this.isAuditAuthority) break block9;
                                if (!HussarUtils.isNotEmpty((Object)task.getAssignee()) || !task.getAssignee().equals(this.userId)) break block10;
                                this.mandator = null;
                                this.taskState = null;
                                break block9;
                            }
                            List identityLinks = task.getCandidates();
                            userTasks = new ArrayList<IdentityLinkEntity>();
                            mandatorFlag = HussarUtils.isEmpty((Object)this.mandator);
                            mandataryFlag = HussarUtils.isNotEmpty((Object)this.mandator);
                            for (IdentityLinkEntity identityLink : identityLinks) {
                                if (!this.userId.equals(identityLink.getUserId())) continue;
                                userTasks.add(identityLink);
                            }
                            if (userTasks.isEmpty()) {
                                for (IdentityLinkEntity identityLink : identityLinks) {
                                    if (!HussarUtils.isNotEmpty((Object)identityLink.getTaskState()) || !identityLink.getMandator().equals(this.userId)) continue;
                                    if (Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(new HistoricTaskInstanceQueryImpl().processInstanceId(task.getProcessInstanceId())) == 1L) {
                                        return new PrepareReturn(this, "\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId())).get(identityLink.getUserId()) + ")");
                                    }
                                    throw new BpmException("\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId())).get(identityLink.getUserId()) + ")");
                                }
                                throw new BpmException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u529e\u7406\u6743\u9650");
                            }
                            if (userTasks.size() != 1) break block11;
                            if (!TaskStateType.isEntrust((IdentityLink)((IdentityLink)userTasks.get(0)))) break block12;
                            String taskMandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                            if (!HussarUtils.isNotEmpty((Object)this.mandator) || !this.mandator.equals(taskMandator)) break block13;
                            completeIdentityLink = (IdentityLinkEntity)userTasks.get(0);
                            this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                            mandatorFlag = true;
                            break block14;
                        }
                        if (!HussarUtils.isEmpty((Object)this.mandator)) break block14;
                        this.mandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                        this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                        completeIdentityLink = (IdentityLinkEntity)userTasks.get(0);
                        mandataryFlag = true;
                        break block14;
                    }
                    if (!HussarUtils.isEmpty((Object)this.mandator)) break block14;
                    completeIdentityLink = (IdentityLinkEntity)userTasks.get(0);
                    mandataryFlag = true;
                    break block14;
                }
                for (IdentityLinkEntity identityLink : userTasks) {
                    if (HussarUtils.isEmpty((Object)this.mandator) && HussarUtils.isEmpty((Object)identityLink.getMandator())) {
                        completeIdentityLink = (IdentityLinkEntity)userTasks.get(0);
                        mandataryFlag = true;
                        break;
                    }
                    if (!HussarUtils.isNotEmpty((Object)this.mandator) || !this.mandator.equals(identityLink.getMandator())) continue;
                    mandatorFlag = true;
                    completeIdentityLink = (IdentityLinkEntity)userTasks.get(0);
                    this.taskState = identityLink.getTaskState();
                    break;
                }
            }
            if (!mandatorFlag) {
                throw new BpmException("\u7528\u6237(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(this.mandator)).get(this.mandator) + ")\u4e0d\u662f\u59d4\u6258\u4eba");
            }
            if (!mandataryFlag) {
                this.mandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
            }
            if (completeIdentityLink == null) {
                throw new PublicClientException("\u672a\u627e\u5230\u9700\u5ba1\u6279\u4efb\u52a1");
            }
            this.mandator = completeIdentityLink.getMandator();
            this.taskState = completeIdentityLink.getTaskState();
        }
        this.follow(commandContext, task);
        return new PrepareReturn(this, completeIdentityLink);
    }

    protected void taskAuthentication(TaskEntity task) {
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (task.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        if (task.getParentTaskId() != null) {
            throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE);
        }
    }

    public CommonPrepareCmd(String taskId, String userId) {
        super(taskId);
        this.userId = userId;
    }

    public CommonPrepareCmd(String taskId, String userId, String mandator) {
        super(taskId);
        this.userId = userId;
        this.mandator = mandator;
    }

    protected void follow(CommandContext commandContext, TaskEntity task) {
    }

    public CommonPrepareCmd notAuditAuthority() {
        this.isAuditAuthority = false;
        return this;
    }

    public CommonPrepareCmd isAuditAuthority(boolean isAuditAuthority) {
        this.isAuditAuthority = isAuditAuthority;
        return this;
    }

    public static class PrepareReturn {
        private final IdentityLink identityLink;
        private final boolean isSuccess;
        private final String message;

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMandator() {
            return this.identityLink != null ? this.identityLink.getMandator() : null;
        }

        public String getTaskState() {
            return this.identityLink != null ? this.identityLink.getTaskState() : null;
        }

        public IdentityLink getIdentityLink() {
            return this.identityLink;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd, String message) {
            this.identityLink = null;
            this.isSuccess = false;
            this.message = message;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd, IdentityLinkEntity identityLink) {
            this.identityLink = identityLink;
            this.isSuccess = true;
            this.message = null;
        }
    }
}

