/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActPostAction;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActPostActionService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.util.BusinessTableUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.config.HussarClientStartProcessConfigs;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.dto.StartProcessActionParamDto;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.service.IStartProcessActionConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.util.StartProcActionHttpClientUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.util.StartProcActionTokenUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartProcessActionServiceImpl
implements IStartProcessActionConfigService {
    private static final Logger logger = LoggerFactory.getLogger(StartProcessActionServiceImpl.class);
    private static final String START_PROC_ACTION_URL_ERROR = "\u672a\u914d\u7f6e\u7b2c\u4e00\u8282\u70b9\u540e\u7f6e\u52a8\u4f5c\u63a5\u53e3 url";
    @Autowired
    private ISysActPostActionService sysActPostActionService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private StartProcActionTokenUtil startProcActionTokenUtil;
    @Autowired
    private BusinessTableUtil businessTableUtil;

    public boolean execute(StartProcessActionParamDto startProcessActionParamDto) {
        String clientToken;
        String processDefinitionId = startProcessActionParamDto.getProcessDefinitionId();
        String processInstanceId = startProcessActionParamDto.getProcessInsId();
        String nodeId = this.getStartNodeId(processInstanceId);
        SysActPostAction postAction = (SysActPostAction)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysActPostActionService.lambdaQuery().eq(SysActPostAction::getProcDefId, (Object)processDefinitionId)).eq(SysActPostAction::getTaskDefKey, (Object)nodeId)).one();
        if (this.isOpenStartPorcAction(postAction) && this.isExecuteSql(postAction)) {
            String sql = postAction.getExecuteSql();
            String dataSource = postAction.getDataSource();
            return this.businessTableUtil.executeSql(sql, dataSource);
        }
        if (!this.isOpenStartPorcAction(postAction) || !this.isUserUrl(postAction)) {
            return true;
        }
        String url = postAction.getUrl();
        if (url == null || url.length() == 0) {
            logger.error(START_PROC_ACTION_URL_ERROR);
            throw new PublicClientException(START_PROC_ACTION_URL_ERROR);
        }
        String sendJson = JSONObject.toJSONString((Object)startProcessActionParamDto);
        String result = StartProcActionHttpClientUtil.postJson(sendJson, url, clientToken = this.getToken(postAction));
        ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class);
        if (apiResponse != null && apiResponse.getCode() == ResultCode.SUCCESS.getCode()) {
            return true;
        }
        String errorMsg = apiResponse != null ? JSONObject.toJSONString((Object)apiResponse.getData()) : "\u8bf7\u6c42\u54cd\u5e94\u4e3a\u7a7a";
        throw new PublicClientException(errorMsg);
    }

    private String getStartNodeId(String processInstanceId) {
        List historicActivityInstanceList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        if (historicActivityInstanceList != null && historicActivityInstanceList.size() != 0) {
            return (String)historicActivityInstanceList.stream().filter(historicActivityInstance -> "startEvent".equals(historicActivityInstance.getActivityType())).map(HistoricActivityInstance::getActivityId).collect(Collectors.toList()).get(0);
        }
        return null;
    }

    private boolean isOpenStartPorcAction(SysActPostAction postAction) {
        if (postAction != null) {
            return Boolean.parseBoolean(postAction.getIsChecked());
        }
        return false;
    }

    private boolean isUserUrl(SysActPostAction postAction) {
        if (postAction != null) {
            return "1".equals(postAction.getIsUseInterface());
        }
        return false;
    }

    private boolean isExecuteSql(SysActPostAction postAction) {
        if (postAction != null) {
            return "1".equals(postAction.getIsExecuteSql());
        }
        return false;
    }

    private String getToken(SysActPostAction postAction) {
        String hussarSystem = postAction.getIsHussarSystem();
        if ("1".equals(hussarSystem)) {
            HussarClientStartProcessConfigs hussarClientStartProcessConfigs = this.getFrontActionConfigsBy(postAction);
            return this.startProcActionTokenUtil.getHussarToken(hussarClientStartProcessConfigs);
        }
        return this.startProcActionTokenUtil.getThirdPartyToken();
    }

    private HussarClientStartProcessConfigs getFrontActionConfigsBy(SysActPostAction postAction) {
        HussarClientStartProcessConfigs hussarClientStartProcessConfigs = new HussarClientStartProcessConfigs();
        if (postAction != null) {
            String hussarAuthServer = postAction.getCertifiedAddress();
            String hussarClientId = postAction.getClientId();
            String hussarClientSecret = postAction.getClientSecretKey();
            String hussarScope = postAction.getContractOwnership();
            String hussarGrantType = postAction.getAuthenticationType();
            hussarClientStartProcessConfigs.setHussarAuthServer(hussarAuthServer);
            hussarClientStartProcessConfigs.setHussarClientId(hussarClientId);
            hussarClientStartProcessConfigs.setHussarClientSecret(hussarClientSecret);
            hussarClientStartProcessConfigs.setHussarScope(hussarScope);
            hussarClientStartProcessConfigs.setHussarGrantType(hussarGrantType);
            hussarClientStartProcessConfigs.setEnableAuth(!hussarClientStartProcessConfigs.isEmpty());
        }
        return hussarClientStartProcessConfigs;
    }
}

