/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class SubProcessEndCmd
implements Command<Void> {
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private String taskId;
    private BpmnModel bm;
    private String userId;
    private String mandator;
    private String comment;
    private String instanceId;
    private String subProcessKey;
    private String type;
    private boolean isMainEndProcess;

    public SubProcessEndCmd(String taskId, BpmnModel bm, String userId, String mandator, String comment, String instanceId, String subProcessKey, String type) {
        this.taskId = taskId;
        this.bm = bm;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.subProcessKey = subProcessKey;
        this.type = type;
        this.isMainEndProcess = false;
    }

    public SubProcessEndCmd(String taskId, BpmnModel bm, String userId, String mandator, String comment, String instanceId, String subProcessKey, String type, boolean isMainEndProcess) {
        this.taskId = taskId;
        this.bm = bm;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.subProcessKey = subProcessKey;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntity execution;
        RuntimeService runtimeService = commandContext.getProcessEngineConfiguration().getRuntimeService();
        List executions = runtimeService.createExecutionQuery().processInstanceId(this.instanceId).list();
        executions.removeIf(e -> Objects.equals(this.subProcessKey, e.getSubProcessKey()));
        ExecutionEntity executionEntity = execution = executions.isEmpty() ? null : (ExecutionEntity)executions.get(0);
        if (execution != null) {
            String targetNodeId = null;
            ActivityImpl currentActivity = execution.getActivity();
            if (currentActivity == null) {
                ExecutionEntity child = (ExecutionEntity)execution.getExecutions().get(0);
                if (child.getActivity() != null) {
                    currentActivity = child.getActivity();
                } else if ((child = (ExecutionEntity)child.getExecutions().get(0)).getActivity() != null) {
                    currentActivity = child.getActivity();
                }
            }
            Collection flowElements = ((SubProcess)this.bm.getFlowElement(this.subProcessKey.split(":")[0])).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof EndEvent)) continue;
                targetNodeId = flowElement.getId();
                break;
            }
            if (targetNodeId == null) {
                throw new BpmException(BpmExceptionCodeEnum.END_NODE_NOT_FOUND);
            }
            ParallelJumpTaskCmd parallelJumpTaskCmd = new ParallelJumpTaskCmd(this.taskId, this.userId, this.mandator, execution.getId(), new JumpModel(0).setJumpTo(targetNodeId), this.comment, this.subProcessKey, new HashMap<String, Object>(), currentActivity);
            parallelJumpTaskCmd.execute(commandContext);
        }
        return null;
    }
}

