/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigneemanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.model.BpmUserData;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.service.AssigneeManageService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysBpmOrgan;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysBpmRoles;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysBpmUserRole;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmOrganService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmRolesService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmUserRoleService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
@HussarTransactional
public class AssigneeManageImpl
implements AssigneeManageService {
    private static final Logger logger = LoggerFactory.getLogger(AssigneeManageImpl.class);
    private static final LinkedHashMap<String, String> SHEET_COLUMNS_USER = new LinkedHashMap();
    private static final LinkedHashMap<String, String> SHEET_COLUMNS_DEPT = new LinkedHashMap();
    private static final LinkedHashMap<String, String> SHEET_COLUMNS_ROLE = new LinkedHashMap();
    private static final LinkedHashMap<String, String> SHEET_COLUMNS_RELATION = new LinkedHashMap();
    private static final Map<String, LinkedHashMap<String, String>> SHEET_COLUMNS = new HashMap<String, LinkedHashMap<String, String>>();
    private static final String FAIL_MESSAGE = "\u7528\u6237\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff1a";
    @Autowired
    private SysBpmOrganService sysBpmOrganService;
    @Autowired
    private SysBpmRolesService sysBpmRolesService;
    @Autowired
    private SysBpmUserRoleService sysBpmUserRoleService;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    private void saveUserData(List<BpmUserData> bpmUserDataList) {
        bpmUserDataList.forEach(System.out::println);
        logger.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)bpmUserDataList.size());
        if (HussarUtils.isEmpty(bpmUserDataList)) {
            return;
        }
        switch (bpmUserDataList.get(0).getSheet()) {
            case "\u7528\u6237\u4fe1\u606f": {
                this.saveBpmOrganOfUser(bpmUserDataList);
                break;
            }
            case "\u90e8\u95e8\u4fe1\u606f": {
                this.saveBpmOrganOfDept(bpmUserDataList);
                break;
            }
            case "\u89d2\u8272\u4fe1\u606f": {
                this.saveBpmRoles(bpmUserDataList);
                break;
            }
            case "\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f": {
                this.saveBpmUserRole(bpmUserDataList);
                break;
            }
            default: {
                throw new HussarException("Sheet\u540d\u79f0\u9519\u8bef\uff01");
            }
        }
        logger.info("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    public void saveUserData(InputStream inputStream) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        inputStream.close();
        ArrayList<BpmUserData> userDataList = new ArrayList<BpmUserData>();
        for (Sheet sheet : workbook) {
            String sheetName = sheet.getSheetName();
            LinkedHashMap<String, String> sheetColumnMap = SHEET_COLUMNS.get(sheetName);
            if (HussarUtils.isEmpty(sheetColumnMap)) {
                throw new HussarException("Sheet[" + sheetName + "]\u4e3a\u975e\u6cd5\u540d\u79f0\uff01");
            }
            Collection<String> sheetColumn = SHEET_COLUMNS.get(sheetName).values();
            Iterator rows = sheet.iterator();
            Row firstRow = (Row)rows.next();
            for (Cell cell : firstRow) {
                if (sheetColumn.contains(cell.getStringCellValue())) continue;
                throw new HussarException("Sheet[" + sheetName + "]\u4e2d\u5217\u540d[" + cell.getStringCellValue() + "]\u4e3a\u975e\u6cd5\u540d\u79f0\uff01");
            }
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                HashMap<String, String> rowMap = new HashMap<String, String>();
                rowMap.put("sheet", sheetName);
                Iterator<Map.Entry<String, String>> iterator = sheetColumnMap.entrySet().iterator();
                for (Cell cell : row) {
                    cell.setCellType(CellType.STRING);
                    rowMap.put(iterator.next().getKey(), cell.getStringCellValue());
                }
                try {
                    BpmUserData bpmUserData = (BpmUserData)JSON.parseObject((String)JSON.toJSONString(rowMap), BpmUserData.class);
                    userDataList.add(bpmUserData);
                }
                catch (Exception e) {
                    throw new HussarException("Sheet[" + sheetName + "]\u89e3\u6790\u5931\u8d25\uff01");
                }
            }
            this.saveUserData(userDataList);
            userDataList.clear();
            logger.info("Sheet[{}]\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01", (Object)sheetName);
            logger.info("===============================================================");
        }
    }

    private void saveBpmOrganOfUser(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), bpmUserData.getUserId(), bpmUserData.getUserName(), bpmUserData.getDeptId(), bpmUserData.getOrder());
            SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
            sysBpmOrgan.setOrganId(bpmUserData.getUserId());
            sysBpmOrgan.setOrganName(bpmUserData.getUserName());
            sysBpmOrgan.setParentId(bpmUserData.getDeptId());
            sysBpmOrgan.setSort(Integer.valueOf(Integer.parseInt(bpmUserData.getOrder())));
            sysBpmOrgan.seteMail(bpmUserData.getEmail());
            sysBpmOrgan.setMobile(bpmUserData.getMobile());
            sysBpmOrgan.setIsMain(Integer.valueOf(Integer.parseInt(bpmUserData.getIsMain())));
            sysBpmOrgan.setUserAccount(bpmUserData.getUserAccount());
            sysBpmOrgan.setSecurityLevel(Integer.valueOf(3));
            sysBpmOrgan.setOrganType("user");
            sysBpmOrgans.add(sysBpmOrgan);
        }
        this.sysBpmOrganService.saveBatch(sysBpmOrgans);
    }

    private void saveBpmOrganOfDept(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), bpmUserData.getDeptId(), bpmUserData.getDeptName(), bpmUserData.getParentId(), bpmUserData.getOrder());
            SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
            sysBpmOrgan.setOrganId(bpmUserData.getDeptId());
            sysBpmOrgan.setOrganName(bpmUserData.getDeptName());
            sysBpmOrgan.setParentId(bpmUserData.getParentId());
            sysBpmOrgan.setSort(Integer.valueOf(Integer.parseInt(bpmUserData.getOrder())));
            sysBpmOrgan.setIsMain(Integer.valueOf(1));
            sysBpmOrgan.setOrganType("organ");
            sysBpmOrgans.add(sysBpmOrgan);
        }
        this.sysBpmOrganService.saveBatch(sysBpmOrgans);
    }

    private void saveBpmRoles(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmRoles> sysBpmRolesList = new ArrayList<SysBpmRoles>();
        int des = 1;
        List lastSysBpmRolesList = this.sysBpmRolesService.list((Wrapper)new LambdaQueryWrapper().orderByDesc(SysBpmRoles::getDes));
        SysBpmRoles lastSysBpmRoles = null;
        if (HussarUtils.isNotEmpty((Object)lastSysBpmRolesList)) {
            lastSysBpmRoles = (SysBpmRoles)lastSysBpmRolesList.get(0);
        }
        if (HussarUtils.isNotEmpty(lastSysBpmRoles) && HussarUtils.isNotEmpty((Object)lastSysBpmRoles.getDes())) {
            des = lastSysBpmRoles.getDes() + 1;
        }
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), String.valueOf(bpmUserData.getRoleId()), bpmUserData.getRoleName(), bpmUserData.getParentId(), bpmUserData.getRoleType());
            SysBpmRoles sysBpmRoles = new SysBpmRoles();
            sysBpmRoles.setRoleId(bpmUserData.getRoleId());
            sysBpmRoles.setRoleName(bpmUserData.getRoleName());
            sysBpmRoles.setParentId(bpmUserData.getParentId());
            sysBpmRoles.setRoleType(bpmUserData.getRoleType());
            sysBpmRoles.setDes(Integer.valueOf(des++));
            sysBpmRolesList.add(sysBpmRoles);
        }
        this.sysBpmRolesService.saveBatch(sysBpmRolesList);
    }

    private void saveBpmUserRole(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmUserRole> sysBpmUserRoles = new ArrayList<SysBpmUserRole>();
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), bpmUserData.getRoleId(), bpmUserData.getUserId());
            SysBpmUserRole sysBpmUserRole = new SysBpmUserRole();
            sysBpmUserRole.setUserId(bpmUserData.getUserId());
            sysBpmUserRole.setGrantedRole(bpmUserData.getRoleId());
            sysBpmUserRoles.add(sysBpmUserRole);
        }
        this.sysBpmUserRoleService.saveBatch(sysBpmUserRoles);
    }

    private void checkImportData(String sheetName, CharSequence ... data) {
        if (HussarUtils.isAnyBlank((CharSequence[])data)) {
            throw new HussarException("Sheet[" + sheetName + "]\u4e2d\u5b58\u5728\u6570\u636e\u4e3a\u7a7a\u6761\u76ee\uff01");
        }
    }

    public List<BpmTreeModel> deptTree(String id, String organId) {
        return this.assigneeChooseService.deptTree(id, organId, false);
    }

    public List<BpmTreeModel> deptTrees() {
        return this.assigneeChooseService.deptTrees();
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        return this.assigneeChooseService.queryList(page, getListDto);
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        return this.assigneeChooseService.queryDept(name);
    }

    public List<BpmTreeModel> roleTree(String id, String roleId) {
        return this.assigneeChooseService.roleTree(id, roleId, false);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        return this.assigneeChooseService.queryRole(name);
    }

    public String queryPlatformModel() {
        return this.assigneeChooseService.queryPlatformModel();
    }

    static {
        SHEET_COLUMNS_USER.put("userId", "\u7528\u6237ID");
        SHEET_COLUMNS_USER.put("userAccount", "\u7528\u6237\u8d26\u53f7");
        SHEET_COLUMNS_USER.put("userName", "\u7528\u6237\u540d\u79f0");
        SHEET_COLUMNS_USER.put("deptId", "\u6240\u5c5e\u90e8\u95e8");
        SHEET_COLUMNS_USER.put("order", "\u6392\u5e8f");
        SHEET_COLUMNS_USER.put("mobile", "\u624b\u673a\u53f7");
        SHEET_COLUMNS_USER.put("email", "\u7535\u5b50\u90ae\u4ef6");
        SHEET_COLUMNS_USER.put("isMain", "\u662f\u5426\u4e3b\u5c97");
        SHEET_COLUMNS_DEPT.put("deptId", "\u90e8\u95e8ID");
        SHEET_COLUMNS_DEPT.put("deptName", "\u90e8\u95e8\u540d\u79f0");
        SHEET_COLUMNS_DEPT.put("parentId", "\u6240\u5c5e\u90e8\u95e8");
        SHEET_COLUMNS_DEPT.put("order", "\u6392\u5e8f");
        SHEET_COLUMNS_ROLE.put("roleId", "\u89d2\u8272ID");
        SHEET_COLUMNS_ROLE.put("roleName", "\u89d2\u8272\u540d\u79f0");
        SHEET_COLUMNS_ROLE.put("parentId", "\u6240\u5c5e\u5206\u7ec4");
        SHEET_COLUMNS_ROLE.put("roleType", "\u89d2\u8272\u7c7b\u578b");
        SHEET_COLUMNS_RELATION.put("userId", "\u7528\u6237ID");
        SHEET_COLUMNS_RELATION.put("roleId", "\u89d2\u8272ID");
        SHEET_COLUMNS.put("\u7528\u6237\u4fe1\u606f", SHEET_COLUMNS_USER);
        SHEET_COLUMNS.put("\u90e8\u95e8\u4fe1\u606f", SHEET_COLUMNS_DEPT);
        SHEET_COLUMNS.put("\u89d2\u8272\u4fe1\u606f", SHEET_COLUMNS_ROLE);
        SHEET_COLUMNS.put("\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", SHEET_COLUMNS_RELATION);
    }
}

