/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.formdata.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.formdata.dao.FormDataMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.formdata.model.SysActFormData;
import com.jxdinfo.hussar.workflow.engine.bpm.formdata.service.IFormDataDsService;
import com.jxdinfo.hussar.workflow.engine.bpm.rectification.model.ReturnToRectification;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormDataDsServiceImpl
implements IFormDataDsService {
    @Autowired
    FormDataMapper formDataMapper;
    @Autowired
    DynamicDatasourceService dynamicDatasourceService;
    private static final Logger logger = LoggerFactory.getLogger(FormDataDsServiceImpl.class);
    private static final String URL_PREFIX_MYSQL_HEAD = "jdbc:mysql";
    private static final String URL_PREFIX_OSCAR_HEAD = "jdbc:oscar";
    private static final String URL_PREFIX_ORACLE_HEAD = "jdbc:oracle";
    private static final String URL_PREFIX_DM_HEAD = "jdbc:dm";
    private static final String URL_PREFIX_PGSQL_HEAD = "jdbc:postgresql";
    private static final String URL_PREFIX_SQLSERVER_HEAD = "jdbc:sqlserver";
    private static final String URL_PREFIX_KINGBASE_HEAD = "jdbc:kingbase8";

    @HussarDs(value="#connName")
    public ApiResponse<List<String>> selectColumnByTableName(String tableName, String connName) {
        ItemDataSource itemDataSource = this.dynamicDatasourceService.getCurrentDatasource();
        String url = "";
        String userName = "";
        try {
            userName = itemDataSource.getConnection().getMetaData().getUserName();
            url = itemDataSource.getConnection().getMetaData().getURL();
        }
        catch (SQLException e) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u5931\u8d25");
        }
        if (url.startsWith(URL_PREFIX_MYSQL_HEAD)) {
            if (HussarUtils.isEmpty((Object)url)) {
                throw new HussarException("\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u5931\u8d25");
            }
            String dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
            String dbName = dsName.substring(dsName.indexOf("/") + 1);
            return ApiResponse.success(this.formDataMapper.selectColumnByTableName(tableName, dbName));
        }
        if (url.startsWith(URL_PREFIX_ORACLE_HEAD)) {
            return ApiResponse.success(this.formDataMapper.selectColumnByOrcal(tableName));
        }
        if (url.startsWith(URL_PREFIX_OSCAR_HEAD)) {
            return ApiResponse.success(this.formDataMapper.selectColumnByOscar(tableName));
        }
        if (url.startsWith(URL_PREFIX_DM_HEAD)) {
            return ApiResponse.success(this.formDataMapper.selectColumnByDm(tableName, userName));
        }
        if (url.startsWith(URL_PREFIX_SQLSERVER_HEAD)) {
            return ApiResponse.success(this.formDataMapper.selectColumnBySqlServer(tableName));
        }
        if (url.startsWith(URL_PREFIX_PGSQL_HEAD)) {
            return ApiResponse.success(this.formDataMapper.selectColumnByPostgresql(tableName));
        }
        if (url.startsWith(URL_PREFIX_KINGBASE_HEAD)) {
            return ApiResponse.success(this.formDataMapper.selectColumnByKingbase8(tableName));
        }
        return ApiResponse.fail((String)"\u6682\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93");
    }

    @HussarDs(value="#connName")
    public Boolean copyDateBase(String connName, String rectificationBusinessId, List<SysActFormData> formList, ReturnToRectification returnToRectification, String businessId, String processInstId) throws HussarException {
        SysActFormData sysActFormDataReal = null;
        for (SysActFormData sysActFormData : formList) {
            if (!HussarUtils.isNotEmpty((Object)sysActFormData.getMainColumnName()) || !sysActFormData.getMainColumnName().equals(sysActFormData.getRelatedColumnName())) continue;
            sysActFormDataReal = sysActFormData;
            break;
        }
        if (HussarUtils.isNotEmpty(sysActFormDataReal)) {
            String taleName = sysActFormDataReal.getTableName();
            String mainColumnName = sysActFormDataReal.getMainColumnName();
            StringBuffer sqlCopyInsert = new StringBuffer();
            StringBuffer sqlCopySelect = new StringBuffer();
            this.spliceSql(sysActFormDataReal, rectificationBusinessId, sqlCopyInsert, sqlCopySelect);
            try {
                this.formDataMapper.executeCopySql(sqlCopyInsert.toString(), sqlCopySelect.toString(), businessId, taleName, mainColumnName);
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u6570\u636e\u590d\u5236sql\u9519\u8bef", (Throwable)e);
            }
        }
        if (HussarUtils.isNotEmpty((Object)returnToRectification.getStateSql())) {
            try {
                String stateSql = returnToRectification.getStateSql();
                stateSql = stateSql.replaceAll("\\{dataid\\}", rectificationBusinessId).replaceAll("\\{runflowid\\}", processInstId);
                this.formDataMapper.executeStateSql(stateSql);
            }
            catch (Exception e) {
                logger.error("\u8868\u5355\u53d8\u66f4\u4e3a\u8fd4\u56de\u6574\u6539\u72b6\u6001sql\u6267\u884c\u9519\u8bef", (Throwable)e);
            }
        }
        if (HussarUtils.isNotEmpty((Object)returnToRectification.getRecallSql())) {
            try {
                String recallSql = returnToRectification.getRecallSql();
                recallSql = recallSql.replaceAll("\\{dataid\\}", rectificationBusinessId).replaceAll("\\{runflowid\\}", processInstId);
                this.formDataMapper.executeRecallSql(recallSql);
            }
            catch (Exception e) {
                logger.error("\u8868\u5355\u53d8\u66f4\u4e3a\u4f5c\u5e9f\u72b6\u6001sql\u6267\u884c\u9519\u8bef", (Throwable)e);
            }
        }
        if (HussarUtils.isNotEmpty((Object)returnToRectification.getActionSql())) {
            try {
                String actionSql = returnToRectification.getActionSql();
                actionSql = actionSql.replaceAll("\\{dataid\\}", rectificationBusinessId).replaceAll("\\{runflowid\\}", processInstId);
                this.formDataMapper.executeActionSql(actionSql);
            }
            catch (Exception e) {
                logger.error("\u8868\u5355\u53d8\u66f4\u4e3a\u8349\u7a3f\u72b6\u6001sql\u6267\u884c\u9519\u8bef", (Throwable)e);
            }
        }
        return null;
    }

    private void spliceSql(SysActFormData sysActFormDataReal, String rectificationBusinessId, StringBuffer sqlCopyInsert, StringBuffer sqlCopySelect) {
        ArrayList<String> dateFormat = new ArrayList<String>(Arrays.asList(sysActFormDataReal.getDateFormatConfig().split(",")));
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat((String)dateFormat.get(0));
        String now = sdf.format(date);
        ArrayList<String> defaultColumn = new ArrayList<String>(Arrays.asList(sysActFormDataReal.getConstantColumnName().split(",")));
        sqlCopyInsert.append("(");
        sqlCopyInsert.append(sysActFormDataReal.getMainColumnName());
        sqlCopySelect.append("'" + rectificationBusinessId + "'");
        sqlCopyInsert.append(",");
        sqlCopySelect.append(",");
        sqlCopyInsert.append(sysActFormDataReal.getCopyColumn());
        sqlCopySelect.append(sysActFormDataReal.getCopyColumn());
        if (HussarUtils.isNotEmpty((Object)sysActFormDataReal.getConstantColumnName())) {
            sqlCopyInsert.append(",");
            sqlCopySelect.append(",");
            for (String str : defaultColumn) {
                ArrayList<String> defaultColumnList = new ArrayList<String>(Arrays.asList(str.split("=")));
                if (defaultColumnList.size() != 2) {
                    throw new HussarException("\u8868\u5355\u6570\u636e\u9ed8\u8ba4\u503c\u914d\u7f6e\u9519\u8bef");
                }
                sqlCopyInsert.append((String)defaultColumnList.get(0));
                sqlCopySelect.append("'" + (String)defaultColumnList.get(1) + "'");
            }
        }
        int index = 0;
        if (HussarUtils.isNotEmpty((Object)sysActFormDataReal.getTimeColumnName())) {
            sqlCopyInsert.append(",");
            sqlCopyInsert.append(sysActFormDataReal.getTimeColumnName());
            index = Arrays.asList(sysActFormDataReal.getTimeColumnName().split(",")).size();
        }
        for (int i = 0; i < index; ++i) {
            sqlCopySelect.append(",");
            sqlCopySelect.append("'" + now + "'");
        }
        sqlCopyInsert.append(")");
    }
}

