/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.upgrade;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CompleteCommentQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CountersignNodesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceGetTraceDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessDefinitionQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessCompleteStatusDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstBatchDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstFinishedQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstSuspendDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.ActivityTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u7ba1\u7406"})
@RequestMapping(value={"/bpm/upgrade/instance"})
public class StandardInstanceEngineController {
    private final IInstanceEngineService instanceEngineService;

    @Autowired
    public StandardInstanceEngineController(IInstanceEngineService iInstanceEngineService) {
        this.instanceEngineService = iInstanceEngineService;
    }

    @PostMapping(value={"/endProcess"})
    @ApiOperation(value="\u7ec8\u7ed3\u6d41\u7a0b\u5b9e\u4f8b", notes="\u7ec8\u7ed3\u6d41\u7a0b\u5b9e\u4f8b")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u7ec8\u7ed3\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult endProcess(@RequestBody ProcessInstEndDto processInstEndDto) {
        if (HussarUtils.isNotEmpty((Object)processInstEndDto.getTaskId())) {
            return this.instanceEngineService.endProcess(processInstEndDto.getTaskId(), processInstEndDto.getUserId(), processInstEndDto.getReason());
        }
        if (HussarUtils.isNotEmpty((Object)processInstEndDto.getProcessInsId())) {
            return this.instanceEngineService.endProcessByProcessInsId(processInstEndDto.getProcessInsId(), processInstEndDto.getUserId(), processInstEndDto.getReason());
        }
        return this.instanceEngineService.endProcessByBusinessIdOrProcessInsId(processInstEndDto.getBusinessId(), processInstEndDto.getProcessInsId(), processInstEndDto.getUserId(), processInstEndDto.getReason());
    }

    @PostMapping(value={"/deleteProcessInstance"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public BpmResponseResult deleteProcessInstance(@RequestBody ProcessInstDeleteDto processInstDeleteDto) {
        if (processInstDeleteDto.getIsFinish()) {
            if (HussarUtils.isNotEmpty((Object)processInstDeleteDto.getBusinessId())) {
                this.instanceEngineService.deleteFinishProcessInstanceByBusinessId(processInstDeleteDto.getBusinessId());
            } else {
                this.instanceEngineService.deleteFinishedProcessInstance(processInstDeleteDto.getProcessInsId());
            }
        }
        if (HussarUtils.isNotEmpty((Object)processInstDeleteDto.getBusinessId())) {
            return this.instanceEngineService.deleteProcessInstanceByBusinessId(processInstDeleteDto.getBusinessId());
        }
        return this.instanceEngineService.deleteProcessInstance(processInstDeleteDto.getProcessInsId(), processInstDeleteDto.getReason());
    }

    @PostMapping(value={"/deleteProcessInstanceByBusinessIds"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public BpmResponseResult deleteProcessInstanceByBusinessIds(@RequestBody ProcessInstBatchDeleteDto processInstBatchDeleteDto) {
        return this.instanceEngineService.deleteProcessInstanceByBusinessIdList(String.join((CharSequence)",", processInstBatchDeleteDto.getBusinessIdList()), processInstBatchDeleteDto.getIsValidate());
    }

    @GetMapping(value={"/checkProcessInstByBusinessId"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u542f\u52a8", notes="\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u542f\u52a8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u542f\u52a8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult checkProcessInstByBusinessId(@RequestParam(value="businessId") String businessId) {
        return this.instanceEngineService.checkProcessInstByBusinessId(businessId);
    }

    @GetMapping(value={"/queryActivityTask"})
    @ApiOperation(value="\u67e5\u8be2\u5b50\u6d41\u7a0b\u6216\u4e3b\u6d41\u7a0b\u7684\u4fe1\u606f", notes="\u67e5\u8be2\u5b50\u6d41\u7a0b\u6216\u4e3b\u6d41\u7a0b\u7684\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u5b50\u6d41\u7a0b\u6216\u4e3b\u6d41\u7a0b\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryActivityTask(ActivityTaskQueryDto activityTaskQueryDto) {
        return this.instanceEngineService.queryCallActivityTask(activityTaskQueryDto.getBusinessId(), activityTaskQueryDto.getProcessInsId(), activityTaskQueryDto.getType());
    }

    @GetMapping(value={"/queryAllComment"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5386\u53f2\u529e\u7406\u610f\u89c1", notes="\u83b7\u53d6\u6d41\u7a0b\u5386\u53f2\u529e\u7406\u610f\u89c1")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u83b7\u53d6\u6d41\u7a0b\u5386\u53f2\u529e\u7406\u610f\u89c1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryAllComment(CompleteCommentQueryDto commentQueryDto) {
        if (HussarUtils.isNotEmpty((Object)commentQueryDto.getBusinessId()) && HussarUtils.isNotEmpty((Object)commentQueryDto.getProcessInsId())) {
            return this.instanceEngineService.queryCompletecomment(commentQueryDto.getBusinessId(), commentQueryDto.getProcessInsId());
        }
        if (HussarUtils.isNotEmpty((Object)commentQueryDto.getBusinessId())) {
            return this.instanceEngineService.queryAllCommentByBusinessId(commentQueryDto.getBusinessId());
        }
        throw new HussarException("\u53c2\u6570\u5f02\u5e38");
    }

    @GetMapping(value={"/queryProcessDefinition"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49", notes="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryProcessDefinition(ProcessDefinitionQueryDto processDefinitionQueryDto) {
        if (HussarUtils.isNotEmpty((Object)processDefinitionQueryDto.getProcessInsId())) {
            return this.instanceEngineService.queryProcessDefinitionByInstanceId(processDefinitionQueryDto.getProcessInsId());
        }
        return this.instanceEngineService.queryProcessDefinitionByBusinessId(processDefinitionQueryDto.getBusinessId());
    }

    @GetMapping(value={"/queryProcessByStarter"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u542f\u52a8\u4eba\u67e5\u8be2\u6d41\u7a0b", notes="\u6839\u636e\u6d41\u7a0b\u542f\u52a8\u4eba\u67e5\u8be2\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processQueryByStarterDto", value="\u5165\u53c2", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u6839\u636e\u6d41\u7a0b\u542f\u52a8\u4eba\u67e5\u8be2\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        Page page = new Page();
        page.setCurrent(processQueryByStarterDto.getCurrent());
        page.setSize(processQueryByStarterDto.getSize());
        return this.instanceEngineService.queryProcessByStarter(page, processQueryByStarterDto);
    }

    @GetMapping(value={"/checkProcessStatus"})
    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u4e3b\u952e\u548c\u6d41\u7a0b\u5b9e\u4f8b\u6807\u8bc6\u68c0\u67e5\u6d41\u7a0b\u72b6\u6001", notes="\u901a\u8fc7\u4e1a\u52a1\u4e3b\u952e\u548c\u6d41\u7a0b\u5b9e\u4f8b\u6807\u8bc6\u68c0\u67e5\u6d41\u7a0b\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processStatusCheckDto", value="\u5165\u53c2", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u901a\u8fc7\u4e1a\u52a1\u4e3b\u952e\u548c\u6d41\u7a0b\u5b9e\u4f8b\u6807\u8bc6\u68c0\u67e5\u6d41\u7a0b\u72b6\u6001", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult checkProcessStatus(ProcessStatusCheckDto processStatusCheckDto) {
        return this.instanceEngineService.checkProcessStatus(processStatusCheckDto);
    }

    @PostMapping(value={"/suspendProcessInstance"})
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult suspendProcessInstance(@RequestBody ProcessInstSuspendDto processInstSuspendDto) {
        if (HussarUtils.isNotEmpty((Object)processInstSuspendDto.getProcessInsId())) {
            return this.instanceEngineService.suspendProcessInstanceById(processInstSuspendDto.getProcessInsId());
        }
        return this.instanceEngineService.suspendProcessInstanceByBusinessId(processInstSuspendDto.getBusinessId());
    }

    @PostMapping(value={"/activateProcessInstance"})
    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult activateProcessInstance(@RequestBody ProcessInstActivateDto processInstActivateDto) {
        if (HussarUtils.isNotEmpty((Object)processInstActivateDto.getProcessInsId())) {
            return this.instanceEngineService.activateProcessInstanceById(processInstActivateDto.getProcessInsId());
        }
        return this.instanceEngineService.activateProcessInstanceByBusinessId(processInstActivateDto.getBusinessId());
    }

    @GetMapping(value={"/queryProcessTrace"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u7684\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u7684\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryProcessTrace(@RequestParam(value="processInsId") String processInsId) {
        return this.instanceEngineService.getProcessTrace(processInsId);
    }

    @PostMapping(value={"/revokeProcess"})
    @ApiOperation(value="\u6d41\u7a0b\u64a4\u529e", notes="\u6d41\u7a0b\u64a4\u529e")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u6d41\u7a0b\u64a4\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult revokeProcess(@RequestBody ProcessRevokeDto processRevokeDto) {
        return this.instanceEngineService.revokeProcess(processRevokeDto);
    }

    @GetMapping(value={"/queryProcessInstance"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return this.instanceEngineService.queryProcessInstance(processDto);
    }

    @GetMapping(value={"/queryAllCountersignNodes"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u6240\u6709\u4f1a\u7b7e\u8282\u70b9\u53ca\u6761\u4ef6", notes="\u67e5\u8be2\u6d41\u7a0b\u6240\u6709\u4f1a\u7b7e\u8282\u70b9\u53ca\u6761\u4ef6")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u6240\u6709\u4f1a\u7b7e\u8282\u70b9\u53ca\u6761\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryAllCountersignNodes(CountersignNodesDto countersignNodesDto) {
        return this.instanceEngineService.queryAllCountersignNodes(countersignNodesDto.getTaskId(), countersignNodesDto.getProcessInsId(), countersignNodesDto.getBusinessId(), countersignNodesDto.getProcessKey(), countersignNodesDto.getVersion());
    }

    @GetMapping(value={"/queryProcessInstanceCompleteState"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u6d41\u7a0b\u662f\u5426\u5df2\u5b8c\u6210", notes="\u67e5\u8be2\u5f53\u524d\u6d41\u7a0b\u662f\u5426\u5df2\u5b8c\u6210")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u5f53\u524d\u6d41\u7a0b\u662f\u5426\u5df2\u5b8c\u6210", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryProcessInstanceCompleteState(ProcessCompleteStatusDto processCompleteStatusDto) {
        if (HussarUtils.isNotEmpty((Object)processCompleteStatusDto.getProcessInsId())) {
            return this.instanceEngineService.queryProcessInstanceCompleteState(processCompleteStatusDto.getProcessInsId());
        }
        return this.instanceEngineService.queryProcessInstanceCompleteStateByBusinessId(processCompleteStatusDto.getBusinessId());
    }

    @GetMapping(value={"/queryFinishedProcessInstance"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", notes="\u83b7\u53d6\u5df2\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u83b7\u53d6\u5df2\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryFinishedProcessInstance(ProcessInstFinishedQueryDto processInstFinishedQueryDto) {
        return this.instanceEngineService.queryFinishedProcessInstance(processInstFinishedQueryDto.getProcessKey(), processInstFinishedQueryDto.getBusinessId(), processInstFinishedQueryDto.getPage().intValue(), processInstFinishedQueryDto.getRows().intValue());
    }

    @GetMapping(value={"/getAllProcessTrace"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u529e\u7406\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u529e\u7406\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u529e\u7406\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult getAllProcessTrace(InstanceGetTraceDto instanceGetTraceDto) {
        return this.instanceEngineService.getAllProcessTrace(instanceGetTraceDto.getProcessInsId(), instanceGetTraceDto.getSubProcessKey(), instanceGetTraceDto.getCycleCount());
    }
}

