/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.config.HussarClientStartProcessConfigs;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.config.ThirdPartyClientStartProcessConfigs;
import com.jxdinfo.hussar.workflow.engine.bpm.startProcessAction.util.StartProcActionHttpClientUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StartProcActionTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(StartProcActionTokenUtil.class);
    private static final String FRONT_ACTION_CONFIG_ERROR = "\u5f53\u524d\u79df\u6237\u83b7\u53d6 token \u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 front-action \u914d\u7f6e";
    private static final String FRONT_ACTION_CONFIG_MESSAGE = "\u5f53\u524d\u79df\u6237\u83b7\u53d6 token \u5931\u8d25";
    private static HashMap<String, String> THIRD_PARTY_TOKEN_CACHE = null;
    private static HashMap<String, String> HUSSAR_TOKEN_CACHE = null;
    @Autowired
    private ThirdPartyClientStartProcessConfigs thirdPartyClientStartProcessConfigs;

    public String getHussarToken(HussarClientStartProcessConfigs hussarClientStartProcessConfigs) {
        HashMap<String, String> cacheToken = HUSSAR_TOKEN_CACHE;
        if (cacheToken != null) {
            String validTime = cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? cacheToken.get("client-token") : this.requestHussarToken(hussarClientStartProcessConfigs);
        }
        return this.requestHussarToken(hussarClientStartProcessConfigs);
    }

    private String requestHussarToken(HussarClientStartProcessConfigs hussarClientStartProcessConfigs) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        if (!hussarClientStartProcessConfigs.isEnableAuth()) {
            return null;
        }
        headerMap.put("client-id", hussarClientStartProcessConfigs.getHussarClientId());
        headerMap.put("client-secret", hussarClientStartProcessConfigs.getHussarClientSecret());
        String server = hussarClientStartProcessConfigs.getHussarAuthServer();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("grant_type", hussarClientStartProcessConfigs.getHussarGrantType()));
        paramList.add((NameValuePair)new BasicNameValuePair("scope", hussarClientStartProcessConfigs.getHussarScope()));
        String result = StartProcActionHttpClientUtil.httpGet(server, paramList, headerMap);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            throw new PublicClientException(FRONT_ACTION_CONFIG_MESSAGE);
        }
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
        cacheToken.put("validTime", timeInMillis);
        HUSSAR_TOKEN_CACHE = cacheToken;
        return (String)cacheToken.get("client-token");
    }

    public String getThirdPartyToken() {
        HashMap<String, String> cacheToken = THIRD_PARTY_TOKEN_CACHE;
        if (cacheToken != null) {
            String validTime = cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? cacheToken.get("client-token") : this.requestThirdPartyToken();
        }
        return this.requestThirdPartyToken();
    }

    private String requestThirdPartyToken() {
        HashMap<String, String> headerMap = new HashMap<String, String>(3);
        if (!this.thirdPartyClientStartProcessConfigs.isThirdPartyEnableAuth()) {
            return null;
        }
        if (this.thirdPartyClientStartProcessConfigs == null) {
            logger.error(FRONT_ACTION_CONFIG_ERROR);
            throw new PublicClientException(FRONT_ACTION_CONFIG_MESSAGE);
        }
        headerMap.put("client-id", this.thirdPartyClientStartProcessConfigs.getThirdPartyClientId());
        headerMap.put("client-secret", this.thirdPartyClientStartProcessConfigs.getThirdPartyClientSecret());
        headerMap.put("grant_type", this.thirdPartyClientStartProcessConfigs.getThirdPartyGrantType());
        String server = this.thirdPartyClientStartProcessConfigs.getThirdPartyAuthServer();
        String result = StartProcActionHttpClientUtil.httpPost(server, headerMap);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            throw new PublicClientException(FRONT_ACTION_CONFIG_MESSAGE);
        }
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
        cacheToken.put("validTime", timeInMillis);
        THIRD_PARTY_TOKEN_CACHE = cacheToken;
        return (String)cacheToken.get("client-token");
    }
}

