/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.ConfigUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.UnexpectedException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class ExtendSubProcessActivityBehavior
extends SubProcessActivityBehavior {
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);

    public void execute(ActivityExecution execution) {
        HistoricActivityInstanceEntity historicActivityInstance;
        List subProcessVariableConfigNode;
        String subProcessVariableConfig;
        ExecutionEntity entity = (ExecutionEntity)execution;
        Object parentLoopCounter = execution.getParent().getVariableLocal("loopCounter");
        int loopCounter = parentLoopCounter == null ? 0 : (Integer)parentLoopCounter;
        Map subProcessRejectAppointMsg = (Map)Context.getCommandContext().getAttribute("subProcessRejectAppointMsg");
        String appointMsg = null;
        if (subProcessRejectAppointMsg != null) {
            appointMsg = (String)subProcessRejectAppointMsg.get(execution.getCurrentActivityId());
        }
        BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        List instanceModeNode = (List)element.getExtensionElements().get("instanceMode");
        String instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)instanceModeNode.get(0)).getAttributes().get("instanceMode")).get(0)).getValue();
        boolean startByAssignee = instanceMode.equals("assignee");
        String subProcessVariable = parentLoopCounter == null ? (!startByAssignee ? (appointMsg == null ? (execution.getVariable(subProcessVariableConfig = ((ExtensionAttribute)((List)((ExtensionElement)(subProcessVariableConfigNode = (List)element.getExtensionElements().get("subProcessVariableConfig")).get(0)).getAttributes().get("subProcessVariableConfig")).get(0)).getValue()) == null ? "" : String.valueOf(execution.getVariable(subProcessVariableConfig))) : appointMsg) : "") : (String)entity.getLocalTempVariable("sub_process_variable");
        UnexpectedException.assertNotNull((Object)subProcessVariable);
        PvmActivity activity = execution.getActivity();
        List list = historyService.createHistoricActivityInstanceQuery().processInstanceId(execution.getProcessInstanceId()).activityId(activity.getId()).list();
        HashMap<String, String> subProcessKeyMap = new HashMap<String, String>();
        int num = 0;
        Integer cycleCount = 1;
        for (HistoricActivityInstance historicActivityInstance2 : list) {
            String oldSubProcessKey = historicActivityInstance2.getSubProcessKey();
            if (oldSubProcessKey == null) continue;
            subProcessKeyMap.put(oldSubProcessKey.split(":")[1], oldSubProcessKey);
            int oldLoopCounter = Integer.valueOf(oldSubProcessKey.split(":")[2]);
            if (oldLoopCounter >= num) {
                num = oldLoopCounter + 1;
            }
            Integer oldCycleCount = historicActivityInstance2.getCycleCount();
            if (cycleCount > oldCycleCount) continue;
            cycleCount = oldCycleCount + 1;
        }
        String[] subProcessVariables = subProcessVariable.split(",");
        execution.setVariableLocal("sub_process_separate_variable", (Object)subProcessVariables[loopCounter]);
        String subProcessKey = (String)subProcessKeyMap.get(subProcessVariables[loopCounter]);
        if (subProcessKey == null) {
            int addNum = 0;
            for (int i = 0; i < loopCounter; ++i) {
                if (subProcessKeyMap.keySet().contains(subProcessVariables[i])) continue;
                ++addNum;
            }
            subProcessKey = activity.getId() + ":" + subProcessVariables[loopCounter] + ":" + (num + addNum);
            if (parentLoopCounter == null) {
                subProcessKey = activity.getId() + "::" + (num + addNum);
            }
        }
        ExecutionEntity parent = (ExecutionEntity)execution.getParent();
        if (parentLoopCounter != null && loopCounter == 0) {
            parent = parent.getParent();
        }
        if (parentLoopCounter != null) {
            historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance(parent);
            historicActivityInstance.setSubProcessKey(subProcessKey);
            historicActivityInstance.setCycleCount(cycleCount);
        } else {
            historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
            historicActivityInstance.setSubProcessKey(subProcessKey);
            historicActivityInstance.setCycleCount(cycleCount);
        }
        entity.setSubProcessKey(subProcessKey);
        entity.setCycleCount(cycleCount);
        ActivityImpl initialActivity = (ActivityImpl)activity.getProperty("initial");
        if (initialActivity == null) {
            throw new ActivitiException("No initial activity found for subprocess " + execution.getActivity().getId());
        }
        String firstNodeId = ((PvmTransition)initialActivity.getOutgoingTransitions().get(0)).getDestination().getId();
        if (startByAssignee) {
            if (parentLoopCounter == null) {
                List user = null;
                if (appointMsg != null) {
                    user = BpmHistoryTask.getLastAppoint(execution.getProcessInstanceId(), subProcessKey, firstNodeId);
                }
                if (HussarUtils.isEmpty(user)) {
                    user = ConfigUser.getAllUserId(ArrayList::new, AnalyticalModelUtil.getConfigUser(bm, execution, false, null));
                }
                HashMap<String, List> appointMap = new HashMap<String, List>();
                appointMap.put(firstNodeId, user);
                execution.addLocalTempVariable("appoint_assignee", appointMap);
            } else {
                HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
                appointMap.put(firstNodeId, Arrays.asList(subProcessVariables[loopCounter].split(",")));
                execution.addLocalTempVariable("appoint_assignee", appointMap);
            }
        }
        this.initializeDataObjects(execution, activity);
        if (initialActivity.getActivityBehavior() != null && initialActivity.getActivityBehavior() instanceof NoneStartEventActivityBehavior) {
            ((ExecutionEntity)execution).setActivity(initialActivity);
            Context.getCommandContext().getHistoryManager().recordActivityStart((ExecutionEntity)execution);
        }
        execution.executeActivity((PvmActivity)initialActivity);
        ArrayList<TaskEntity> tasks = new ArrayList<TaskEntity>();
        this.getSubProcessStartTasks((ExecutionEntity)execution, tasks);
    }

    private void getSubProcessStartTasks(ExecutionEntity execution, List<TaskEntity> taskEntities) {
        if (execution.getTasks() != null) {
            taskEntities.addAll(execution.getTasks());
        }
        if (execution.getExecutions() != null) {
            for (ExecutionEntity entity : execution.getExecutions()) {
                this.getSubProcessStartTasks(entity, taskEntities);
            }
        }
    }

    public void lastExecutionEnded(ActivityExecution execution) {
        Map dataObjectVars;
        ScopeUtil.createEventScopeExecution((ExecutionEntity)((ExecutionEntity)execution));
        if (TaskEngineServiceImpl.getSubProcessRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        ExecutionEntity activityExecution = new ExecutionEntity();
        if (execution.getParent() != null) {
            activityExecution = execution.getParent();
            activityExecution.setAllPrevNode(((ExecutionEntity)execution).getActivityId());
        }
        if (activityExecution.getParent() != null) {
            activityExecution = activityExecution.getParent();
            activityExecution.setAllPrevNode(((ExecutionEntity)execution).getActivityId());
        }
        if ((dataObjectVars = ((ActivityImpl)execution.getActivity()).getVariables()) != null) {
            execution.removeVariablesLocal(dataObjectVars.keySet());
        }
        ((ExecutionEntity)execution).setSubProcessKey(null);
        this.bpmnActivityBehavior.performDefaultOutgoingBehavior(execution);
    }

    public void leave(ActivityExecution execution) {
        if (TaskEngineServiceImpl.getSubProcessRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        ((ExecutionEntity)execution).setSubProcessKey(null);
        super.leave(execution);
    }

    protected void initializeDataObjects(ActivityExecution execution, PvmActivity activity) {
        Map dataObjectVars = ((ActivityImpl)activity).getVariables();
        if (dataObjectVars != null) {
            execution.setVariablesLocal(dataObjectVars);
        }
    }
}

