/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.NodeInfQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefSuspendDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u6a21\u578b\u7ba1\u7406"})
@RequestMapping(value={"/bpm/upgrade/definition"})
public class StandardDefinitionEngineController {
    private final IDefinitionEngineService definitionEngineService;

    @Autowired
    public StandardDefinitionEngineController(IDefinitionEngineService definitionEngineService) {
        this.definitionEngineService = definitionEngineService;
    }

    @GetMapping(value={"/queryAllNodeFormInfo"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\uff0c\u7248\u672c\u53f7\u83b7\u53d6\u6240\u6709\u8282\u70b9\u7684\u8868\u5355\u5730\u5740", notes="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\uff0c\u7248\u672c\u53f7\u83b7\u53d6\u6240\u6709\u8282\u70b9\u7684\u8868\u5355\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6,\u7248\u672c\u53f7\u83b7\u53d6\u6240\u6709\u8282\u70b9\u7684\u8868\u5355\u5730\u5740", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryAllNodeFormInfo(NodeInfQueryDto nodeInfQueryDto) {
        return this.definitionEngineService.queryAllNodeFormKey(nodeInfQueryDto.getProcessKey(), nodeInfQueryDto.getVersion());
    }

    @GetMapping(value={"/getProcessMainOrNew"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", notes="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult getProcessMainOrNew(@RequestParam(value="processKey") String processKey) {
        return this.definitionEngineService.getProcessMainOrNew(processKey);
    }

    @GetMapping(value={"/queryProcessDefList"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868\uff08\u8fd4\u56de\u6240\u6709\u7248\u672c\uff09", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868\uff08\u8fd4\u56de\u6240\u6709\u7248\u672c\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processName", value="\u6d41\u7a0b\u540d", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u8fd4\u56de\u6240\u6709\u7248\u672c)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryProcessDefList(ProcessDefQueryDto processDefQueryDto) {
        if (HussarUtils.isNotEmpty((Object)processDefQueryDto.getProcessKey())) {
            return this.definitionEngineService.getProcessDefList(processDefQueryDto.getProcessKey());
        }
        return this.definitionEngineService.queryProcessDefList(processDefQueryDto.getProcessName());
    }

    @GetMapping(value={"/activateProcessDefinition"})
    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3", notes="\u6fc0\u6d3b\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u6fc0\u6d3b\u6d41\u7a0b\u5b9a\u4e49", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult activateProcessDefinition(ProcessDefActivateDto processDefActivateDto) {
        if (!HussarUtils.isEmpty((Object)processDefActivateDto.getProcessDefinitionId())) {
            return this.definitionEngineService.activateProcessDefinitionById(processDefActivateDto.getProcessDefinitionId());
        }
        return this.definitionEngineService.activateProcessByKeyAndVersion(processDefActivateDto.getProcessKey(), processDefActivateDto.getVersion());
    }

    @PostMapping(value={"/deleteProcessDefinition"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49", notes="\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult deleteProcessDefinition(@RequestBody ProcessDefDeleteDto processDefDeleteDto) {
        if (!HussarUtils.isEmpty((Object)processDefDeleteDto.getProcessDefinitionId())) {
            this.definitionEngineService.deleteProcessDefinition(processDefDeleteDto.getProcessDefinitionId());
        }
        return this.definitionEngineService.deleteProcessDefinitionByKeyAndVersion(processDefDeleteDto.getProcessKey(), processDefDeleteDto.getVersion());
    }

    @PostMapping(value={"/suspendProcessDefinition"})
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3", notes="\u6302\u8d77\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u6302\u8d77\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult suspendProcessDefinition(@RequestBody ProcessDefSuspendDto processDefSuspendDto) {
        if (HussarUtils.isNotEmpty((Object)processDefSuspendDto.getProcessDefinitionId())) {
            return this.definitionEngineService.suspendProcessDefinitionById(processDefSuspendDto.getProcessDefinitionId());
        }
        return this.definitionEngineService.suspendProcessByKeyAndVersion(processDefSuspendDto.getProcessKey(), processDefSuspendDto.getVersion());
    }

    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u4fe1\u606f", notes="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryProcess() {
        return this.definitionEngineService.queryProcess();
    }

    @GetMapping(value={"/queryIsPublish"})
    @ApiOperation(value="\u636e\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u53d1\u5e03", notes="\u636e\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u53d1\u5e03")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u636e\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u53d1\u5e03", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryIsPublish(@RequestParam(value="processKey") String processKey) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)this.definitionEngineService.queryIsPublish(processKey));
        return InstallResult.success((JSONArray)jsonArray);
    }

    @GetMapping(value={"/queryNodeInfoByProcessKeyAndVersion"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u7248\u672c\u53f7\u67e5\u8be2\u6d41\u7a0b\u5404\u8282\u70b9\u4fe1\u606f", notes="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u7248\u672c\u53f7\u67e5\u8be2\u6d41\u7a0b\u5404\u8282\u70b9\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9a\u4e49", eventDesc="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u7248\u672c\u53f7\u67e5\u8be2\u6d41\u7a0b\u5404\u8282\u70b9\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNodeInfoByProcessKeyAndVersion(NodeInfQueryDto nodeInfQueryDto) {
        return this.definitionEngineService.queryNodeInfoByProcessKeyAndVersion(nodeInfQueryDto.getProcessKey(), nodeInfQueryDto.getVersion());
    }
}

