/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.sqlcondition.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IExecuteSqlService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqlConditionHandleServiceImpl
implements SqlConditionHandleService {
    private static final Pattern SQL_REGEX = Pattern.compile("\\@Sql\\{([^@]|[^}]\\@)*\\}\\@");
    @Autowired
    private IExecuteSqlService executeSqlService;
    @Autowired
    private SysActProcessFileService processFileService;

    private String replaceNextBuiltinVariable(String sql, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (sql.contains("(${" + key.getKey() + "})") && key.getValue() == null) {
                    newMap.put(key.getKey(), "null");
                    continue;
                }
                if (sql.contains("('${" + key.getKey() + "}')")) {
                    newMap.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
                    continue;
                }
                newMap.put(key.getKey(), key.getValue());
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newMap);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        finalSql = finalSql.replace("'null'", "null");
        return finalSql;
    }

    public String getSqlRealCondition(String condition, ExecutionEntity executionEntity) {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        AnalyticalModelUtil.getSqlVariableMap(executionEntity, variableMap);
        condition = condition.substring(2, condition.length() - 1);
        String realCondition = condition = "${" + this.replaceNextBuiltinVariable(condition, variableMap) + "}";
        if (condition.contains("@Sql{")) {
            String dataSource = this.getDataSource(executionEntity.getProcessDefinitionId());
            Matcher matcher = SQL_REGEX.matcher(condition);
            while (matcher.find()) {
                String sql = matcher.group().substring(5, matcher.group().length() - 2);
                Boolean result = this.executeSqlService.executeSqlAsBooleanResult(sql, dataSource);
                if (result == null) {
                    result = false;
                }
                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
            }
        }
        return realCondition;
    }

    private String getDataSource(String procDefId) {
        List list = ((LambdaQueryChainWrapper)this.processFileService.lambdaQuery().eq(SysActProcessFile::getProcessId, (Object)procDefId)).list();
        if (list.isEmpty()) {
            throw new PublicClientException("\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u6587\u4ef6\uff01");
        }
        String remoteDbName = ((SysActProcessFile)list.get(0)).getRemoteDbName();
        if (HussarUtils.isEmpty((Object)remoteDbName)) {
            throw new PublicClientException("\u672a\u914d\u7f6e\u5916\u90e8\u6570\u636e\u6e90\uff01");
        }
        return remoteDbName;
    }

    public String getSqlRealCondition(String condition, Map<String, Object> map, String procDefId) {
        condition = condition.substring(2, condition.length() - 1);
        String realCondition = condition = "${" + this.replaceNextBuiltinVariable(condition, map) + "}";
        if (condition.contains("@Sql{")) {
            String dataSource = this.getDataSource(procDefId);
            Matcher matcher = SQL_REGEX.matcher(condition);
            while (matcher.find()) {
                String sql = matcher.group().substring(5, matcher.group().length() - 2);
                Boolean result = this.executeSqlService.executeSqlAsBooleanResult(sql, dataSource);
                if (result == null) {
                    result = false;
                }
                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
            }
        }
        return realCondition;
    }
}

