/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IExecuteSqlService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private IExecuteSqlService executeSqlService;
    @Autowired
    private SysActProcessFileService processFileService;
    private static Logger logger = LogManager.getLogger(TaskCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String assignee = taskEntity.getAssignee();
        if (HussarUtils.isEmpty((Object)taskEntity.getTaskSourceFlag())) {
            taskEntity.setTaskSourceFlag(BpmAttribute.getTaskSourceFlag((ActivityExecution)taskEntity.getProcessInstance()));
        }
        HistoricTaskInstanceEntity historicTaskInstanceEntity = (HistoricTaskInstanceEntity)Context.getCommandContext().getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskEntity.getId());
        historicTaskInstanceEntity.setApprovalNumber(CommonCodeUtil.getApprovalNumber());
        if (assignee == null) {
            assignee = historicTaskInstanceEntity.getAssignee();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)Long.valueOf(taskEntity.getProcessInstanceId()))).eq(SysActCcTask::getTaskDefKey, (Object)taskEntity.getTaskDefinitionKey())).eq(SysActCcTask::getReceiveUser, (Object)assignee);
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectOne((Wrapper)lambdaQueryWrapper);
        if (sysActCcTask != null) {
            sysActCcTask.setEndTime(new Timestamp(System.currentTimeMillis()));
            sysActCcTask.setTaskState("1");
            this.sysActCcTaskMapper.updateById(sysActCcTask);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(taskEntity.getProcessDefinitionId());
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setUserId(assignee);
                dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
                dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                this.dataPushService.readCcTask(dataPush);
            }
        }
        if ("1".equals(taskEntity.getUrgeState())) {
            this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
        }
        try {
            ExecutionEntity processInstance = taskEntity.getProcessInstance();
            String taskId = taskEntity.getId();
            List processFiles = this.processFileService.getProcessFile(processInstance.getProcessDefinitionId());
            if (HussarUtils.isNotEmpty((Object)processFiles)) {
                SysActProcessFile processFile = (SysActProcessFile)processFiles.get(0);
                this.tryUpdateBusinessTable((ProcessInstance)processInstance, processFile);
            } else {
                logger.info("\u672a\u53d1\u73b0\u8be5\u6d41\u7a0b\u7684\u6d41\u7a0b\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void tryUpdateBusinessTable(ProcessInstance processInstance, SysActProcessFile processFile) {
        String remoteDbName = processFile.getRemoteDbName();
        String businessMainTable = processFile.getBusinessMainTable();
        String businessMainTableKey = processFile.getBusinessMainTableKey();
        String businessMainTableName = processFile.getBusinessMainTableName();
        String businessMainTableState = processFile.getBusinessMainTableState();
        String lastUpdateTime = processFile.getLastUpdateTime();
        logger.info("\u6570\u636e\u6e90:{}\u3001\u4e3b\u8868:{}\u3001\u4e3b\u8868\u4e3b\u952e:{}\u3001\u72b6\u6001\u503c:{}\u3001\u72b6\u6001\u540d:{}", (Object)remoteDbName, (Object)businessMainTable, (Object)businessMainTableKey, (Object)businessMainTableName, (Object)businessMainTableState);
        if (HussarUtils.hasEmpty((Object[])new Object[]{remoteDbName, businessMainTable, businessMainTableKey})) {
            logger.info("\u8be5\u6d41\u7a0b\u6570\u636e\u6e90\u3001\u4e3b\u8868\u3001\u4e3b\u8868\u4e3b\u952e\u4e2d\u6709\u7a7a\u503c");
            return;
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{businessMainTableName, businessMainTableState})) {
            logger.info("\u8be5\u6d41\u7a0b\u72b6\u6001\u5b57\u6bb5\u4e3a\u7a7a");
            return;
        }
        ArrayList<String> updateColumn = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)lastUpdateTime)) {
            updateColumn.add(lastUpdateTime + " = '" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "'");
        }
        StringBuilder sql = new StringBuilder().append("UPDATE ").append(businessMainTable).append(" SET ").append(String.join((CharSequence)",", updateColumn)).append(" WHERE ").append(businessMainTableKey).append(" = '").append(processInstance.getBusinessKey()).append("'");
        logger.info("\u6267\u884csql\uff0c{}", (Object)sql.toString());
        Boolean res = this.executeSqlService.updateSql(sql.toString(), remoteDbName);
        logger.info("\u6267\u884csql\u7ed3\u675f\uff0c\u8fd4\u56de\u503c\u4e3a{}", (Object)res);
        if (!Boolean.TRUE.equals(res)) {
            throw new PublicClientException("\u6d41\u7a0b\u72b6\u6001\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
    }
}

