/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.frontAction.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.config.HussarClientFrontActionConfigs;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.config.ThirdPartyClientFrontActionConfigs;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.util.FrontActionHttpClientUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FrontActionTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(FrontActionTokenUtil.class);
    private static final String FRONT_ACTION_CONFIG_ERROR = "\u5f53\u524d\u79df\u6237\u83b7\u53d6 token \u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 front-action \u914d\u7f6e";
    private static final String FRONT_ACTION_CONFIG_MESSAGE = "\u5f53\u524d\u79df\u6237\u83b7\u53d6 token \u5931\u8d25";
    private static HashMap<String, String> THIRD_PARTY_TOKEN_CACHE = null;
    private static HashMap<String, String> HUSSAR_TOKEN_CACHE = null;
    @Autowired
    private ThirdPartyClientFrontActionConfigs thirdPartyClientFrontActionConfigs;

    public String getHussarToken(HussarClientFrontActionConfigs hussarClientFrontActionConfigs) {
        HashMap<String, String> cacheToken = HUSSAR_TOKEN_CACHE;
        if (cacheToken != null) {
            String validTime = cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? cacheToken.get("client-token") : this.requestHussarToken(hussarClientFrontActionConfigs);
        }
        return this.requestHussarToken(hussarClientFrontActionConfigs);
    }

    private String requestHussarToken(HussarClientFrontActionConfigs hussarClientFrontActionConfigs) {
        if (!hussarClientFrontActionConfigs.isEnableAuth()) {
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("client-id", hussarClientFrontActionConfigs.getHussarClientId());
        headerMap.put("client-secret", hussarClientFrontActionConfigs.getHussarClientSecret());
        String server = hussarClientFrontActionConfigs.getHussarAuthServer();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("grant_type", hussarClientFrontActionConfigs.getHussarGrantType()));
        paramList.add((NameValuePair)new BasicNameValuePair("scope", hussarClientFrontActionConfigs.getHussarScope()));
        String result = FrontActionHttpClientUtil.httpGet(server, paramList, headerMap);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            throw new PublicClientException(FRONT_ACTION_CONFIG_MESSAGE);
        }
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
        cacheToken.put("validTime", timeInMillis);
        HUSSAR_TOKEN_CACHE = cacheToken;
        return (String)cacheToken.get("client-token");
    }

    public String getThirdPartyToken() {
        HashMap<String, String> cacheToken = THIRD_PARTY_TOKEN_CACHE;
        if (cacheToken != null) {
            String validTime = cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? cacheToken.get("client-token") : this.requestThirdPartyToken();
        }
        return this.requestThirdPartyToken();
    }

    private String requestThirdPartyToken() {
        if (!this.thirdPartyClientFrontActionConfigs.isThirdPartyEnableAuth()) {
            return null;
        }
        if (this.thirdPartyClientFrontActionConfigs == null) {
            logger.error(FRONT_ACTION_CONFIG_ERROR);
            throw new PublicClientException(FRONT_ACTION_CONFIG_MESSAGE);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>(3);
        headerMap.put("client-id", this.thirdPartyClientFrontActionConfigs.getThirdPartyClientId());
        headerMap.put("client-secret", this.thirdPartyClientFrontActionConfigs.getThirdPartyClientSecret());
        headerMap.put("grant_type", this.thirdPartyClientFrontActionConfigs.getThirdPartyGrantType());
        String server = this.thirdPartyClientFrontActionConfigs.getThirdPartyAuthServer();
        String result = FrontActionHttpClientUtil.httpPost(server, headerMap);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            throw new PublicClientException(FRONT_ACTION_CONFIG_MESSAGE);
        }
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
        cacheToken.put("validTime", timeInMillis);
        THIRD_PARTY_TOKEN_CACHE = cacheToken;
        return (String)cacheToken.get("client-token");
    }
}

