/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class PreemptTaskCmd
extends CommonPrepareCmd {
    protected static DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    protected static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    public static final String PREEMPT = "1";

    @Override
    protected void follow(CommandContext commandContext, TaskEntity task) {
        task.setPreempted(PREEMPT);
        List identityLinkEntityList = task.getCandidates();
        Set users = identityLinkEntityList.stream().filter(identityLink -> !TaskStateType.isEntrust((IdentityLink)identityLink)).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
        users.remove(this.userId);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (dataPushService.isDataPush(processDefinitionIdList) && identityLinkEntityList.size() > 1) {
            HashSet<String> deleteUsers = new HashSet<String>();
            ArrayList deleteUserMaps = new ArrayList();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                if (!identityLinkEntity.getUserId().equals(this.userId)) {
                    deleteUsers.add(identityLinkEntity.getUserId());
                }
                if (Objects.equals(identityLinkEntity.getUserId(), this.userId) && Objects.equals(identityLinkEntity.getMandator(), this.mandator)) continue;
                HashMap<String, String> deleteUserMap = new HashMap<String, String>();
                deleteUserMap.put("userId", identityLinkEntity.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLinkEntity)) {
                    deleteUserMap.put("mandator", identityLinkEntity.getMandator());
                    deleteUserMap.put("taskState", identityLinkEntity.getTaskState());
                }
                deleteUserMaps.add(deleteUserMap);
            }
            String string = String.join((CharSequence)",", deleteUsers);
        }
        if (!users.isEmpty()) {
            taskEngineMapper.unPreemptDeduplication(users, Long.parseLong(this.taskId));
        }
        taskEngineMapper.preemptTask(Long.parseLong(this.taskId), this.userId, this.mandator);
        new ProcessActionCmd(task.getProcessInstanceId()).execute(commandContext);
    }

    public PreemptTaskCmd(String taskId, String userId) {
        super(taskId, userId);
    }

    public PreemptTaskCmd(String taskId, String userId, String mandator) {
        super(taskId, userId, mandator);
    }

    public PreemptTaskCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        super(taskId, userId, mandator, isAuditAuthority);
    }
}

