/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ExecutionInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class CompleteLeapTaskCmd
extends AddAttributeCmd<TaskEntity> {
    private String taskId;
    private String comment;
    private String userId;
    private String mandator;
    private Map<String, Object> variables;
    private boolean isSubmit;
    private Boolean isNotAdd;
    private Boolean notNeedCheckAssignee;
    private static final BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    private CommandContext commandContext;
    private String approvalType;
    private IdentityLink identityLink;

    public CompleteLeapTaskCmd setApprovalType(String approvalType) {
        this.approvalType = approvalType;
        return this;
    }

    public CompleteLeapTaskCmd setIdentityLink(IdentityLink identityLink) {
        this.identityLink = identityLink;
        return this;
    }

    public CompleteLeapTaskCmd(String taskId, String mandator, String userId, String comment, Map<String, Object> variables, boolean isSubmit) {
        this.taskId = taskId;
        this.comment = comment;
        this.userId = userId;
        this.mandator = mandator;
        this.variables = variables;
        this.isSubmit = isSubmit;
    }

    public CompleteLeapTaskCmd(String taskId, String mandator, String userId, String comment, Map<String, Object> variables, boolean isSubmit, boolean aFlg, Boolean notNeedCheckAssignee) {
        this.taskId = taskId;
        this.comment = comment;
        this.userId = userId;
        this.mandator = mandator;
        this.variables = variables;
        this.isSubmit = isSubmit;
        this.isNotAdd = aFlg;
        this.notNeedCheckAssignee = notNeedCheckAssignee;
    }

    public TaskEntity execute(CommandContext commandContext) {
        this.addAttribute(commandContext);
        commandContext.addAttribute("approvalType", (Object)this.approvalType);
        commandContext.addAttribute("notNeedCheckAssignee", (Object)this.notNeedCheckAssignee);
        if (this.isSubmit) {
            commandContext.addAttribute("isNotAdd", (Object)true);
        } else {
            commandContext.addAttribute("isNotAdd", (Object)this.isNotAdd);
        }
        this.commandContext = commandContext;
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        ExecutionEntity processInstance = task.getProcessInstance();
        this.addExecutionAttribute(processInstance);
        String subProcessKey = task.getSubProcessKey();
        Object lastRejectTask = TaskSourceFlag.isReject((String)task.getCompleteType()) && task.getJumpInfo() != null ? task : BpmHistoryTask.getLastRejectTask(task.getProcessInstanceId(), subProcessKey, task.getTaskDefinitionKey());
        if (lastRejectTask != null) {
            ActivityBehavior activityBehavior = task.getExecution().getActivity().getActivityBehavior();
            boolean isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            JumpInfo jumpInfo = JumpInfo.toJumpInfo((String)lastRejectTask.getJumpInfo());
            List rejectTo = jumpInfo.getJumpTo();
            List rejectFrom = jumpInfo.getJumpFrom();
            if (HussarUtils.isEmpty((Object)rejectFrom)) {
                return this.complete(task);
            }
            if (!rejectTo.contains(task.getTaskDefinitionKey())) {
                return this.complete(task);
            }
            List rejectExecution = jumpInfo.isJumpExecution() ? (List)task.getVariableLocal("jump_execution_info") : null;
            String executionId = task.getExecutionId();
            ActivityImpl currentActivity = task.getExecution().getActivity();
            Map<String, Object> objectMap = this.getBackTypeWithTasks(rejectFrom, (Task)task);
            TaskRejectModel taskRejectModel = new TaskRejectModel();
            taskRejectModel.setIdentityLink(this.identityLink);
            taskRejectModel.setApprovalType(this.approvalType);
            taskRejectModel.setType("complete");
            taskRejectModel.setTargetIds(rejectFrom.size() == 0 ? "" : (String)rejectFrom.get(0));
            taskRejectModel.setUserId(this.userId);
            taskRejectModel.setTask((Task)task);
            taskRejectModel.setMap(this.variables);
            if (objectMap == null) {
                return this.complete(task);
            }
            if (rejectTo.size() == 1) {
                Set affectedTasks = (Set)objectMap.get("affectedTasks");
                if (affectedTasks.size() == 1 && ((String)affectedTasks.iterator().next()).equals(task.getTaskDefinitionKey())) {
                    if (!isScope) {
                        this.taskAssigneeHandle(rejectFrom.size() == 0 ? "" : (String)rejectFrom.get(0), (Task)task);
                        task.setAssignee(this.userId, true, true);
                        JumpModel jumpModel = new JumpModel(1).setJumpFrom(task.getTaskDefinitionKey()).setJumpTo(rejectFrom).setJumpToExecution(rejectExecution);
                        this.addAllPrevNode(jumpModel, jumpModel.getJumpTo(), task.getTaskDefinitionKey());
                        this.addComment();
                        new CommonJumpTaskCmd(this.userId, this.mandator, executionId, jumpModel, this.comment, "complete", this.variables, currentActivity, taskRejectModel).execute(commandContext);
                        return task;
                    }
                    if (this.multiCondition(task)) {
                        this.taskAssigneeHandle(rejectFrom.size() == 0 ? "" : (String)rejectFrom.get(0), (Task)task);
                        task.setAssignee(this.userId, true, true);
                        JumpModel jumpModel = new JumpModel(2).setJumpFrom(task.getTaskDefinitionKey()).setJumpTo(rejectFrom).setJumpToExecution(rejectExecution);
                        this.addAllPrevNode(jumpModel, jumpModel.getJumpTo(), task.getTaskDefinitionKey());
                        this.addComment();
                        new MultiInstanceJumpTaskCmd(this.userId, this.mandator, executionId, jumpModel, this.taskId, this.comment, this.variables, currentActivity, taskRejectModel).execute(commandContext);
                        return task;
                    }
                    return this.complete(task);
                }
                return this.complete(task);
            }
            HashSet rejectToNodes = new HashSet(rejectTo);
            String targetGateway = this.recentSharedGateway(new ArrayList<String>(rejectFrom), task.getProcessDefinitionId());
            List executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(task.getProcessInstanceId());
            boolean isCompleteLeap = true;
            Set affectedUserTasks = (Set)objectMap.get("affectedUserTasks");
            Map affectedExecution = (Map)objectMap.get("affectedExecution");
            Set affectedCallActicity = (Set)objectMap.get("affectedCallActivity");
            Set affectedSubProcess = (Set)objectMap.get("affectedSubProcess");
            if (HussarUtils.isNotEmpty((Object)affectedCallActicity) || HussarUtils.isNotEmpty((Object)affectedSubProcess)) {
                isCompleteLeap = false;
            } else if (affectedExecution.size() > 1 || affectedExecution.size() == 1 && !affectedExecution.containsKey(targetGateway)) {
                isCompleteLeap = false;
            } else if (rejectToNodes.size() < affectedExecution.size() || rejectToNodes.addAll(affectedUserTasks)) {
                isCompleteLeap = false;
            } else {
                List targetGatewayExecution = affectedExecution.get(targetGateway) != null ? (List)affectedExecution.get(targetGateway) : new ArrayList();
                List runningRejectTasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(task.getProcessInstanceId()).stream().filter(o -> affectedUserTasks.contains(o.getTaskDefinitionKey()) && Objects.equals(o.getSubProcessKey(), subProcessKey)).collect(Collectors.toList());
                HashSet<String> runningRejectNode = new HashSet<String>();
                Iterator iterator = runningRejectTasks.iterator();
                while (iterator.hasNext()) {
                    Task runningRejectTask = (Task)iterator.next();
                    if (runningRejectNode.add(runningRejectTask.getTaskDefinitionKey()) || rejectTo.equals(runningRejectTask.getJumpInfo() == null ? null : JumpInfo.toJumpInfo((String)runningRejectTask.getJumpInfo()).getJumpTo())) continue;
                    isCompleteLeap = false;
                    break;
                }
                if (isCompleteLeap && rejectTo.size() != runningRejectNode.size() + targetGatewayExecution.size()) {
                    isCompleteLeap = false;
                }
            }
            if (!isCompleteLeap) {
                return this.complete(task);
            }
            if (!isScope || this.multiCondition(task)) {
                int targetGatewayExecutionNum = 0;
                for (Execution execution : executionList) {
                    if (subProcessKey != null && !subProcessKey.equals(execution.getSubProcessKey()) || !targetGateway.equals(execution.getActivityId())) continue;
                    ++targetGatewayExecutionNum;
                }
                if (targetGatewayExecutionNum >= rejectToNodes.size() - 1) {
                    this.taskAssigneeHandle(rejectFrom.size() == 0 ? "" : (String)rejectFrom.get(0), (Task)task);
                    ArrayList<String> affectedTasks = new ArrayList<String>();
                    affectedTasks.add(targetGateway);
                    affectedTasks.add(currentActivity.getId());
                    task.setAssignee(this.userId, true, true);
                    JumpModel jumpModel = new JumpModel(3).setJumpFrom(task.getTaskDefinitionKey()).setJumpTo(rejectFrom).setAffectedTasks(affectedTasks).setJumpToExecution(rejectExecution);
                    this.addAllPrevNode(jumpModel, jumpModel.getJumpTo(), String.join((CharSequence)",", rejectTo));
                    this.addComment();
                    new ParallelJumpTaskCmd(this.taskId, this.userId, this.mandator, executionId, jumpModel, this.comment, task.getSubProcessKey(), this.variables, currentActivity).setTaskRejectModel(taskRejectModel).execute(commandContext);
                    return task;
                }
                task.setAssignee(this.userId, true, true);
                JumpModel jumpModel = new JumpModel(1).setJumpFrom(task.getTaskDefinitionKey()).setJumpToExecution(Collections.singletonList(new ExecutionInfo(targetGateway, task.getTaskDefinitionKey(), null)));
                this.addComment();
                new CommonJumpTaskCmd(this.userId, this.mandator, executionId, jumpModel, this.comment, "complete", this.variables, currentActivity, taskRejectModel).execute(commandContext);
                return task;
            }
            return this.complete(task);
        }
        return this.complete(task);
    }

    private void addAllPrevNode(JumpModel jumpModel, List<String> taskDefKey, String allPrevNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : taskDefKey) {
            map.put(s, allPrevNode);
        }
        jumpModel.setAllPrevNode(map);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(Collection<String> nodeIds, Task task) {
        if (nodeIds.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet affectedUserTasks = new HashSet();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String subProcessKey = task.getSubProcessKey();
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(processDefinitionId);
        if (task.getSubProcessKey() != null) {
            for (String nodeId : nodeIds) {
                if (bm.getMainProcess().getFlowElement(nodeId) == null) continue;
                return null;
            }
        }
        boolean isSubProcessJump = false;
        if (bm.getMainProcess().getFlowElement(nodeIds.iterator().next()) != null) {
            isSubProcessJump = true;
            subProcessKey = null;
        }
        List list = this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (Object historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        result.put("runningActivitiNodeIds", runningActivityNodeIds);
        HashSet<String> runningSubProcessNodeIds = new HashSet<String>();
        if (!isSubProcessJump) {
            list = this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("subProcess").list();
            for (Object historicActivityInstance : list) {
                runningSubProcessNodeIds.add(historicActivityInstance.getActivityId());
            }
        }
        result.put("runningSubProcessNodeIds", runningSubProcessNodeIds);
        List executions = this.commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(processInstanceId);
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.isScope() || executionEntity.getActivityId() == null || executionEntity.getSubProcessKey() != null && !Objects.equals(subProcessKey, executionEntity.getSubProcessKey())) continue;
            taskIds.add(executionEntity.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds.addAll(runningSubProcessNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            for (String string : nodeIds) {
                if (!HussarUtils.isEmpty((Object)bm.getFlowElement(string))) continue;
                throw new BpmException(BpmExceptionCodeEnum.NODE_NOT_FOUND);
            }
            boolean isFindTask = false;
            for (String string : nodeIds) {
                Map<String, Set<String>> map = this.findAffectedTask(bm, string, true, taskIds);
                affectedTasks.addAll((Collection)map.get("affectedTasks"));
                affectedUserTasks.addAll(map.get("affectedUserTasks"));
            }
            if (affectedTasks.contains(taskDefinitionKey)) {
                isFindTask = true;
                affectedTasks.remove(taskDefinitionKey);
            }
            if (!affectedTasks.isEmpty()) {
                newNum = 3;
            }
            if (!isFindTask) {
                void var19_28;
                HashSet hashSet = new HashSet();
                if (!affectedTasks.isEmpty()) {
                    HashSet<String> hashSet2 = affectedTasks;
                }
                for (String nodeId : nodeIds) {
                    Map<String, Set<String>> map = this.findAffectedTask(bm, nodeId, false, taskIds);
                    affectedTasks.addAll((Collection)map.get("affectedTasks"));
                    affectedUserTasks.addAll(map.get("affectedUserTasks"));
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (!affectedTasks.isEmpty()) {
                    newNum = 3;
                }
                if (!isFindTask && affectedTasks.size() + var19_28.size() > 0) {
                    newNum = -1;
                }
            }
        }
        HashSet<String> affectedCallActivity = new HashSet<String>();
        for (String string : runningActivityNodeIds) {
            if (!affectedTasks.contains(string)) continue;
            affectedCallActivity.add(string);
        }
        affectedUserTasks.addAll(affectedCallActivity);
        HashSet<String> hashSet = new HashSet<String>();
        for (String activityId : runningSubProcessNodeIds) {
            if (!affectedTasks.contains(activityId)) continue;
            hashSet.add(activityId);
        }
        affectedUserTasks.addAll(hashSet);
        HashMap hashMap = new HashMap();
        for (ExecutionEntity execution1 : executions) {
            List<Map> affectedExecutionList;
            if (execution1.isScope() || execution1.getActivityId() == null || affectedUserTasks.contains(execution1.getActivityId()) || !affectedTasks.contains(execution1.getActivityId()) || subProcessKey != null && !subProcessKey.equals(execution1.getSubProcessKey())) continue;
            if (hashMap.get(execution1.getActivityId()) != null) {
                affectedExecutionList = (List)hashMap.get(execution1.getActivityId());
                affectedExecutionList.add(execution1.getVariablesLocal());
                continue;
            }
            affectedExecutionList = new ArrayList<Map>();
            affectedExecutionList.add(execution1.getVariablesLocal());
            hashMap.put(execution1.getActivityId(), affectedExecutionList);
        }
        result.put("affectedExecution", hashMap);
        affectedTasks.add(taskDefinitionKey);
        result.put("affectedTasks", affectedTasks);
        result.put("affectedUserTasks", affectedUserTasks);
        result.put("affectedCallActivity", affectedCallActivity);
        result.put("affectedSubProcess", hashSet);
        result.put("num", newNum);
        return result;
    }

    private Map<String, Set<String>> findAffectedTask(BpmnModel bm, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(bm.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(bm.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(bm.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    private String recentSharedGateway(List<String> nodes, String procDefId) {
        Collections.sort(nodes);
        String node = nodes.get(0);
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(procDefId);
        FlowElement flowElement = bm.getFlowElement(node);
        while (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) {
            SequenceFlow sequenceFlow = (SequenceFlow)((FlowNode)flowElement).getIncomingFlows().get(0);
            if (!((flowElement = bm.getFlowElement(sequenceFlow.getSourceRef())) instanceof StartEvent)) continue;
            throw new BpmException(BpmExceptionCodeEnum.NO_PUBLIC_GATEWAY);
        }
        return flowElement.getId();
    }

    private void taskAssigneeHandle(String rejectNodes, Task task) {
    }

    private boolean multiCondition(TaskEntity task) {
        Map multiVariables = task.getExecution().getVariables();
        int nrOfCompletedInstances = (Integer)multiVariables.get("nrOfCompletedInstances") + 1;
        int nrOfInstances = (Integer)multiVariables.get("nrOfInstances");
        if (nrOfInstances != 0 && nrOfInstances > nrOfCompletedInstances) {
            String multiFinishCondition;
            String multiType = (String)multiVariables.get("multi_type");
            String string = multiFinishCondition = multiVariables.get("multi_finish_condition") == null ? null : multiVariables.get("multi_finish_condition").toString();
            if (HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiFinishCondition)) {
                if ("0".equals(multiType) ? (double)nrOfCompletedInstances / (double)nrOfInstances >= Double.parseDouble(multiFinishCondition) / 100.0 : "1".equals(multiType) && nrOfCompletedInstances == Integer.parseInt(multiFinishCondition)) {
                    return true;
                }
            } else {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("nrOfCompletedInstances", nrOfCompletedInstances);
                contextMap.put("nrOfInstances", nrOfInstances);
                boolean condition = false;
                BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(task.getProcessDefinitionId());
                String k = ((Activity)bm.getFlowElement(task.getTaskDefinitionKey())).getLoopCharacteristics().getCompletionCondition();
                ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                SimpleContext context = CompleteLeapTaskCmd.getVariables(contextMap);
                ValueExpression e = factory.createValueExpression((ELContext)context, k, Boolean.TYPE);
                if (((Boolean)e.getValue((ELContext)context)).booleanValue()) {
                    condition = true;
                }
                if (condition) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && !map.isEmpty()) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    private void addComment() {
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(this.commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            this.commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
    }

    private TaskEntity complete(TaskEntity task) {
        task.setAssignee(this.userId, true, true);
        task.getProcessInstance().addTempVariable("taskSourceFlag", (Object)"complete");
        return new TaskCompleteCmd(this.taskId, this.userId, this.mandator, this.comment, this.variables, this.notNeedCheckAssignee, this.isNotAdd).setApprovalType(this.approvalType).execute(this.commandContext);
    }
}

