/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricTaskInstance;

public class CommonCodeUtil {
    private static Boolean isStartAlone;
    private static ModelService modelService;
    private static RepositoryService repositoryService;
    private static ActivityRedisTimerService activityRedisTimerService;
    private static SysActProcessFileService sysActProcessFileService;
    public static ThreadLocal<Map<String, List<String>>> msg;
    public static ThreadLocal<Map<String, List<Long>>> time;

    public static Map<String, Object> getGodAxeResult(String nodeId, String businessId, String procDefId) {
        return new HashMap<String, Object>();
    }

    public static void handleVariables(Map<String, Object> variable) {
        for (Map.Entry<String, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && HussarUtils.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            BigDecimal bigDecimal = (BigDecimal)k.getValue();
            if (new BigDecimal(bigDecimal.longValue()).compareTo(bigDecimal) == 0) {
                variable.put(k.getKey(), bigDecimal.longValue());
                continue;
            }
            variable.put(k.getKey(), bigDecimal.doubleValue());
        }
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith("jxd_bpm_custom_node")) {
            id = id.contains("parallel_node") ? id.split("parallel_node")[1] : ((SequenceFlow)((FlowNode)bm.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new BpmException("\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
        return id;
    }

    public static void triggerEventHandleClass(Map<String, Object> map) {
        BpmnModel bm = repositoryService.getBpmnModel((String)map.get("processDefinitionId"));
        String type = "";
        Object tType = map.get("type");
        if (HussarUtils.isNotEmpty((Object)tType)) {
            type = tType.toString();
        }
        if ("processCreateEnd".equals(type)) {
            activityRedisTimerService.addGlobalTimeOutModel(bm, map);
        } else if ("processCompleteEnd".equals(type)) {
            activityRedisTimerService.delGlobalTimeOutModel(map);
        }
    }

    public static boolean isBindTable(Set<String> processDefinitionIdList) {
        return false;
    }

    private CommonCodeUtil() {
    }

    public static String getApprovalNumber() {
        String randomStr = String.format("%02d", (int)(Math.random() * 100.0));
        String date = new SimpleDateFormat("yyMMddHHmmss", Locale.CHINESE).format(new Date());
        return date + randomStr;
    }

    public static <T extends Collection<String>> T getLastCompleted(List<? extends HistoricTaskInstance> currentNodeTasks, T collection) {
        return CommonCodeUtil.getLastCompleted(currentNodeTasks, collection, task -> !TaskSourceFlag.NORMAL_COMPLETE.contains(task.getTaskSourceFlag()) || TaskType.isRevoked((String)task.getTaskType()), HistoricTaskInstance::getOriginalAssignee);
    }

    public static <T extends Collection<E>, E> T getLastCompleted(List<? extends HistoricTaskInstance> currentNodeTasks, T collection, Predicate<HistoricTaskInstance> filter, Function<HistoricTaskInstance, E> function) {
        ArrayList<HistoricTaskInstance> lastCompleted = new ArrayList<HistoricTaskInstance>();
        Long multiId = null;
        for (HistoricTaskInstance historicTaskInstance : currentNodeTasks) {
            if (filter.test(historicTaskInstance)) continue;
            if (multiId == null) {
                if (!lastCompleted.isEmpty()) continue;
                lastCompleted.add(historicTaskInstance);
                if (historicTaskInstance.getMultiId() == null) break;
                multiId = historicTaskInstance.getMultiId();
                continue;
            }
            if (!multiId.equals(historicTaskInstance.getMultiId())) continue;
            lastCompleted.add(historicTaskInstance);
        }
        lastCompleted.forEach(o -> collection.add(function.apply((HistoricTaskInstance)o)));
        return collection;
    }

    static {
        modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
        repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
        activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
        sysActProcessFileService = (SysActProcessFileService)SpringContextHolder.getBean(SysActProcessFileService.class);
        msg = new ThreadLocal();
        time = new ThreadLocal();
    }
}

