/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.assignee.model.Personnel;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.approvefile.model.ApproveFile;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ApprovalExtendPropertiesVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.util.BusinessTableUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.EliminateRemindersDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.GetPersonnelByDepartmentIdDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.GetPersonnelByUserNameDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.vo.PersonnelQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.ProcessInstanceHistoryTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.constant.ProcessState;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private SysActProcessFileService processFileService;
    @Autowired
    private BusinessTableUtil businessTableUtil;
    @Autowired
    private UnifiedToDoDataPushProperties unifiedToDoDataPushProperties;
    private static final Map<String, String> APPROVAL_STATE = new HashMap<String, String>();
    private static final Map<String, String> APPROVAL_TYPE = new HashMap<String, String>();

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        Object variables2;
        if (HussarUtils.isEmpty((Object)flowTaskQueryModel.getDateTime())) {
            flowTaskQueryModel.setDateTime(new Date());
        }
        long todoTotal = this.flowTaskMapper.countTodoTotal(flowTaskQueryModel);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables2 : allVariables) {
            List<Object> list;
            if (variables2.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables2.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables2);
                processVariablesMap.put(variables2.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables2.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables2);
            taskVariablesMap.put(variables2.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables2 = todoList.iterator();
        while (variables2.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)variables2.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setTimeoutState(flowTask.getTimeoutState());
            taskManagerQueryVo.setSuspensionState(String.valueOf(flowTask.getSuspensionState()));
            taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
            taskManagerQueryVo.setTaskType(flowTask.getTaskType());
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
            taskManagerQueryVo.setTaskSourceFlag(flowTask.getTaskSourceFlag());
            taskManagerQueryVo.setSendUser(flowTask.getSendUser());
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getProcessStartUserId()));
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        Iterator<Object> iterator = resultData.iterator();
        while (iterator.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(finalUsers.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(finalUsers.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setProcessStartUserName(finalUsers.get(taskManagerQueryVo.getProcessStartUserId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        Object variables2;
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null);
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowTaskMapper.countDoneTotal(flowTaskQueryModel);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables2 : allVariables) {
            List<Object> list;
            if (variables2.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables2.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables2);
                processVariablesMap.put(variables2.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables2.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables2);
            taskVariablesMap.put(variables2.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables2 = doneList.iterator();
        while (variables2.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)variables2.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList));
        return ApiResponse.success((Object)page);
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty((Object)flowTask.getSendUser())) {
                    userIds.add(flowTask.getSendUser());
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskManagerQueryVo.setTaskVariables(taskVariables);
                String taskSourceFlag = flowTask.getTaskSourceFlag();
                taskManagerQueryVo.setTaskSourceFlag(taskSourceFlag);
                String scope = taskSourceFlag;
                taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
                taskManagerQueryVo.setTaskType(flowTask.getTaskType());
                scope = TaskSourceFlag.isReject((String)scope) ? "\u5df2\u9a73\u56de" : "\u5df2\u5b8c\u6210";
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser(flowTask.getSendUser());
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(flowTask.getSendUser()));
                taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
                taskManagerQueryVo.setProcessStartUserName((String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
                taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public ApiResponse<ProcessInstanceHistoryTaskVo> processInstanceHistoryTaskList(String businessId, String outOriginId, String outUserId) {
        String userIdType = this.unifiedToDoDataPushProperties.getUserIdType();
        String userId = null;
        if ("outOriginId".equals(userIdType)) {
            userId = this.iAssigneeChooseService.getOrganIdByOutOrganId(outOriginId);
        } else if ("outUserId".equals(userIdType)) {
            userId = this.iAssigneeChooseService.getOrganIdByOutStruId(outUserId);
        }
        ProcessInstanceHistoryTaskVo processInstanceHistoryTaskVo = new ProcessInstanceHistoryTaskVo();
        String processInstanceId = "";
        ArrayList<Object> taskManagerQueryVos = new ArrayList<Object>();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> userIdsForDepartmentAndPost = new ArrayList<String>();
        ArrayList<String> departmentIds = new ArrayList<String>();
        ArrayList<String> postIds = new ArrayList<String>();
        Map departmentMap = new HashMap();
        Map postMap = new HashMap();
        Map userDepartmentAndPostModelMap = new HashMap();
        String adaptApprover = "0";
        String adaptSubsequentApprover = "0";
        ArrayList<String> permitForApprovalNodes = new ArrayList<String>();
        HashMap<String, String> permitForApprovalMap = new HashMap<String, String>();
        List<FlowTask> flowTasks = this.flowTaskMapper.processInstanceHistoryTaskList(businessId);
        for (FlowTask flowTask : flowTasks) {
            void var26_24;
            ApprovalExtendPropertiesVo approvalExtendPropertiesVo;
            Object processDeyId;
            Object taskManagerQueryVo = new TaskManagerQueryVo();
            ArrayList arrayList = new ArrayList();
            if ("0".equals(flowTask.getApprovalState())) {
                List<ApproveFile> list = this.flowTaskMapper.approveFileList(flowTask.getTaskId());
            }
            ArrayList list = new ArrayList();
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setTaskId(flowTask.getTaskId());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getAssigneeId());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setApprovalState(APPROVAL_STATE.get(flowTask.getApprovalState()));
            taskManagerQueryVo.setApprovalType(APPROVAL_TYPE.get(flowTask.getApprovalType()));
            taskManagerQueryVo.setEndTime(flowTask.getEndTime());
            taskManagerQueryVo.setDueTime(flowTask.getDueTime());
            taskManagerQueryVo.setComment(flowTask.getComment());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefKey());
            taskManagerQueryVo.setBusinessId(businessId);
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setSeq(Integer.valueOf(flowTask.getSeq()));
            taskManagerQueryVo.setDepartmentId(flowTask.getDepartmentId());
            taskManagerQueryVo.setPostId(flowTask.getPostId());
            if ("1".equals(flowTask.getApprovalState()) && userId != null && userId.equals(flowTask.getAssigneeId())) {
                taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
                processDeyId = flowTask.getProcessDefinitionId();
                String string = flowTask.getTaskDefKey();
                approvalExtendPropertiesVo = this.sysActExtendPropertiesService.getApprovalExtendProperties((String)processDeyId, string);
                adaptApprover = approvalExtendPropertiesVo.getAdaptApprover();
                if ("0".equals(adaptSubsequentApprover)) {
                    adaptSubsequentApprover = approvalExtendPropertiesVo.getAdaptSubsequentApprover();
                }
                taskManagerQueryVo.setIsPermitForModifyingAssignee(adaptApprover);
                taskManagerQueryVo.setIsPermitForApproval("1");
                taskManagerQueryVo.setAheadActionFormAddress(approvalExtendPropertiesVo.getAheadActionFormAddress());
                taskManagerQueryVo.setAheadActionFormType(approvalExtendPropertiesVo.getAheadActionFormType());
                taskManagerQueryVo.setAheadActionFormName(approvalExtendPropertiesVo.getAheadActionFormName());
                taskManagerQueryVo.setAheadActionIsUsed(approvalExtendPropertiesVo.isAheadActionIsUsed());
                permitForApprovalNodes.add(flowTask.getTaskDefKey());
                permitForApprovalMap.put(flowTask.getTaskDefKey(), adaptApprover);
            } else if ("2".equals(flowTask.getApprovalState())) {
                taskManagerQueryVo.setIsPermitForModifyingAssignee(adaptSubsequentApprover);
                taskManagerQueryVo.setIsPermitForApproval("0");
            } else {
                taskManagerQueryVo.setIsPermitForModifyingAssignee("0");
                taskManagerQueryVo.setIsPermitForApproval("0");
            }
            if ("1".equals(flowTask.getApprovalState()) && ("0".equals(processInstanceHistoryTaskVo.getIsPermitForAddApprovalNode()) || "0".equals(processInstanceHistoryTaskVo.getIsPermitForEditForm())) && userId != null && userId.equals(flowTask.getAssigneeId())) {
                String string;
                processDeyId = flowTask.getProcessDefinitionId();
                approvalExtendPropertiesVo = this.sysActExtendPropertiesService.getApprovalExtendProperties((String)processDeyId, string = flowTask.getTaskDefKey());
                if ("1".equals(String.valueOf(approvalExtendPropertiesVo.getAddApprovalNode()))) {
                    processInstanceHistoryTaskVo.setIsPermitForAddApprovalNode("1");
                }
                if ("1".equals(String.valueOf(approvalExtendPropertiesVo.getAllowEditForm()))) {
                    processInstanceHistoryTaskVo.setIsPermitForEditForm("1");
                }
            }
            if ("0".equals(flowTask.getApprovalState()) && var26_24 != null && var26_24.size() != 0) {
                for (ApproveFile approveFile : var26_24) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fileId", approveFile.getFileId());
                    map.put("attachmentName", approveFile.getAttachmentName());
                    list.add(map);
                }
            }
            taskManagerQueryVo.setApproveFile(list);
            userIds.add(flowTask.getAssigneeId());
            if (taskManagerQueryVo.getOwner() != null && taskManagerQueryVo.getOwner().length() != 0) {
                userIdsForDepartmentAndPost.add(taskManagerQueryVo.getOwner());
            } else if (taskManagerQueryVo.getAssigneeId() != null && taskManagerQueryVo.getAssigneeId().length() != 0) {
                userIdsForDepartmentAndPost.add(taskManagerQueryVo.getAssigneeId());
            }
            if (taskManagerQueryVo.getDepartmentId() != null && taskManagerQueryVo.getDepartmentId().length() != 0) {
                departmentIds.add(taskManagerQueryVo.getDepartmentId());
            }
            if (taskManagerQueryVo.getPostId() != null && taskManagerQueryVo.getPostId().length() != 0) {
                postIds.add(taskManagerQueryVo.getPostId());
            }
            taskManagerQueryVos.add(taskManagerQueryVo);
        }
        if (permitForApprovalNodes != null && permitForApprovalNodes.size() != 0) {
            for (String permitForApprovalNode : permitForApprovalNodes) {
                for (TaskManagerQueryVo taskManagerQueryVo : taskManagerQueryVos) {
                    if (!taskManagerQueryVo.getTaskDefinitionKey().equals(permitForApprovalNode) || APPROVAL_STATE.get("0").equals(taskManagerQueryVo.getApprovalState())) continue;
                    taskManagerQueryVo.setIsPermitForModifyingAssignee((String)permitForApprovalMap.get(permitForApprovalNode));
                }
            }
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        Map finalUserNumbers = this.iAssigneeChooseService.getUserNumberListByUserId(userIds);
        if (!userIdsForDepartmentAndPost.isEmpty()) {
            userDepartmentAndPostModelMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIdsForDepartmentAndPost);
        }
        if (!departmentIds.isEmpty()) {
            departmentMap = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
        }
        if (!postIds.isEmpty()) {
            postMap = this.iAssigneeChooseService.getPostNameBypostIds(postIds);
        }
        Iterator<Object> iterator = taskManagerQueryVos.iterator();
        while (iterator.hasNext()) {
            UserDepartmentAndPostModel userDepartmentAndPostModel;
            Object taskManagerQueryVo;
            taskManagerQueryVo.setAssignee(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setUserNumber(finalUserNumbers.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)finalUserNumbers.get(taskManagerQueryVo.getAssigneeId()));
            if (taskManagerQueryVo.getDepartmentId() == null || taskManagerQueryVo.getDepartmentId().length() == 0) {
                if (taskManagerQueryVo.getOwner() != null && taskManagerQueryVo.getOwner().length() != 0) {
                    userDepartmentAndPostModel = (UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getOwner());
                    if (userDepartmentAndPostModel != null) {
                        taskManagerQueryVo.setDepartmentId(userDepartmentAndPostModel.getDepartmentId());
                        taskManagerQueryVo.setDepartmentName(userDepartmentAndPostModel.getDepartmentName());
                    }
                } else if (taskManagerQueryVo.getAssigneeId() != null && taskManagerQueryVo.getAssigneeId().length() != 0 && (userDepartmentAndPostModel = (UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getAssigneeId())) != null) {
                    taskManagerQueryVo.setDepartmentId(userDepartmentAndPostModel.getDepartmentId());
                    taskManagerQueryVo.setDepartmentName(userDepartmentAndPostModel.getDepartmentName());
                }
            } else {
                taskManagerQueryVo.setDepartmentName((String)departmentMap.get(taskManagerQueryVo.getDepartmentId()));
            }
            if (taskManagerQueryVo.getPostId() == null || taskManagerQueryVo.getPostId().length() == 0 || "null".equals(taskManagerQueryVo.getPostId())) {
                if (taskManagerQueryVo.getOwner() != null && taskManagerQueryVo.getOwner().length() != 0) {
                    userDepartmentAndPostModel = (UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getOwner());
                    if (userDepartmentAndPostModel == null) continue;
                    taskManagerQueryVo.setPostId(userDepartmentAndPostModel.getPostId());
                    taskManagerQueryVo.setPostName(userDepartmentAndPostModel.getPostName());
                    continue;
                }
                if (taskManagerQueryVo.getAssigneeId() == null || taskManagerQueryVo.getAssigneeId().length() == 0 || (userDepartmentAndPostModel = (UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getAssigneeId())) == null) continue;
                taskManagerQueryVo.setPostId(userDepartmentAndPostModel.getPostId());
                taskManagerQueryVo.setPostName(userDepartmentAndPostModel.getPostName());
                continue;
            }
            taskManagerQueryVo.setPostName((String)postMap.get(taskManagerQueryVo.getPostId()));
        }
        Collections.sort(taskManagerQueryVos, new Comparator<TaskManagerQueryVo>(){

            @Override
            public int compare(TaskManagerQueryVo t1, TaskManagerQueryVo t2) {
                Integer seq1 = t1.getSeq();
                Integer seq2 = t2.getSeq();
                if (seq1 == 0 && seq2 == 0) {
                    if (t1.getStartTime() != null && t2.getStartTime() != null) {
                        Long time1 = t1.getStartTime().getTime();
                        Long time2 = t2.getStartTime().getTime();
                        if (time2 - time1 < 0L) {
                            return 1;
                        }
                        if (time1 - time2 == 0L) {
                            return 0;
                        }
                        return -1;
                    }
                    if (t1.getStartTime() != null && t2.getStartTime() == null) {
                        return -1;
                    }
                    if (t2.getStartTime() != null && t1.getStartTime() == null) {
                        return 1;
                    }
                    return 0;
                }
                if (seq1 != 0 && seq2 == 0) {
                    return 1;
                }
                if (seq2 != 0 && seq1 == 0) {
                    return -1;
                }
                if (seq2 - seq1 < 0) {
                    return 1;
                }
                if (seq1 - seq2 == 0) {
                    return 0;
                }
                return -1;
            }
        });
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null && historicProcessInstance.getId() != null && historicProcessInstance.getId().length() != 0) {
            processInstanceId = historicProcessInstance.getId();
        }
        if ("".equals(processInstanceId)) {
            for (Object taskManagerQueryVo : taskManagerQueryVos) {
                taskManagerQueryVo.setIsPermitForModifyingAssignee("1");
            }
            ProcessInst processInst = this.processInstService.getProcessInstByOriginalProcInstId(businessId);
            if (processInst != null && processInst.getProcessInsId() != null && processInst.getProcessInsId().length() != 0) {
                processInstanceId = processInst.getProcessInsId();
            }
        }
        if (!"".equals(processInstanceId)) {
            List<ApproveFile> approveFiles = this.flowTaskMapper.approveFileListByProcessInstanceId(processInstanceId);
            ArrayList processAttachmentList = new ArrayList();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (approveFiles != null) {
                for (ApproveFile approveFile : approveFiles) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("fileId", approveFile.getFileId());
                    hashMap.put("fileName", approveFile.getAttachmentName());
                    hashMap.put("createTime", simpleDateFormat.format(approveFile.getCreateTime()));
                    processAttachmentList.add(hashMap);
                }
                processInstanceHistoryTaskVo.setProcessAttachmentList(processAttachmentList);
            }
        }
        for (Object taskManagerQueryVo : taskManagerQueryVos) {
            if (taskManagerQueryVo.getDueTime() == null || taskManagerQueryVo.getDueTime().equals("")) continue;
            Timestamp timestamp = Timestamp.valueOf(taskManagerQueryVo.getDueTime());
            if (taskManagerQueryVo.getEndTime() == null) continue;
            taskManagerQueryVo.setDueFlag(timestamp.before(taskManagerQueryVo.getEndTime()));
        }
        processInstanceHistoryTaskVo.setProcessInstanceHistoryTaskList(taskManagerQueryVos);
        return ApiResponse.success((Object)processInstanceHistoryTaskVo);
    }

    public ApiResponse<String> getBusinessDetails(String processKey, String businessId) {
        List processFiles = null;
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            processFiles = ((LambdaQueryChainWrapper)this.processFileService.lambdaQuery().eq(SysActProcessFile::getProcessKey, (Object)processKey)).list();
        }
        String businessMainTable = null;
        String businessMainTableKeyColumn = null;
        String mainBusinessTableDetailColumn = null;
        String externalDataSource = null;
        if (HussarUtils.isNotEmpty((Object)processFiles)) {
            businessMainTable = ((SysActProcessFile)processFiles.get(0)).getBusinessMainTable();
            businessMainTableKeyColumn = ((SysActProcessFile)processFiles.get(0)).getBusinessMainTableKey();
            mainBusinessTableDetailColumn = ((SysActProcessFile)processFiles.get(0)).getDetailName();
            externalDataSource = ((SysActProcessFile)processFiles.get(0)).getRemoteDbName();
        }
        String sql = null;
        if (HussarUtils.isNotEmpty(businessMainTable) && HussarUtils.isNotEmpty(businessMainTableKeyColumn) && HussarUtils.isNotEmpty(mainBusinessTableDetailColumn) && HussarUtils.isNotEmpty(externalDataSource) && HussarUtils.isNotEmpty((Object)businessId)) {
            sql = "SELECT " + mainBusinessTableDetailColumn + " FROM " + businessMainTable + " WHERE " + businessMainTableKeyColumn + " = " + businessId;
        }
        String detailValue = null;
        if (HussarUtils.isNotEmpty(sql) && HussarUtils.isNotEmpty(externalDataSource)) {
            detailValue = this.businessTableUtil.getDetailValueFromBusinessTable(sql, externalDataSource);
        }
        return ApiResponse.success(detailValue);
    }

    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByDepartmentId(GetPersonnelByDepartmentIdDto getPersonnelByDepartmentIdDto) {
        List personnels;
        String organType = getPersonnelByDepartmentIdDto.getOrganType();
        String departmentId = getPersonnelByDepartmentIdDto.getDepartmentId();
        ArrayList<PersonnelQueryVo> personnelQueryVos = new ArrayList<PersonnelQueryVo>();
        if (departmentId != null && departmentId.length() != 0 && (personnels = this.iAssigneeChooseService.getPersonnelByDepartmentId(organType, departmentId)) != null) {
            for (Personnel personnel : personnels) {
                PersonnelQueryVo personnelQueryVo = new PersonnelQueryVo();
                personnelQueryVo.setUserId(personnel.getUserId());
                personnelQueryVo.setUserName(personnel.getUserName());
                personnelQueryVo.setUnitId(personnel.getUnitId());
                personnelQueryVo.setDepartmentId(personnel.getDepartmentId());
                personnelQueryVo.setUserNumber(personnel.getUserNumber());
                personnelQueryVo.setUnit(personnel.getUnitName());
                personnelQueryVo.setDepartmentName(personnel.getDepartmentName());
                if (personnel.getOrganName() != null && personnel.getUnitName() != null) {
                    if (personnel.getOrganName().indexOf(personnel.getUnitName()) != -1) {
                        personnelQueryVo.setOrganName(personnel.getOrganName().substring(personnel.getOrganName().indexOf(personnel.getUnitName())));
                    } else {
                        personnelQueryVo.setOrganName(personnel.getOrganName());
                    }
                } else {
                    personnelQueryVo.setOrganName(personnel.getOrganName());
                }
                personnelQueryVo.setPostId(personnel.getPostId());
                personnelQueryVo.setPostName(personnel.getPostName());
                personnelQueryVos.add(personnelQueryVo);
            }
        }
        return ApiResponse.success(personnelQueryVos);
    }

    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByUserName(GetPersonnelByUserNameDto getPersonnelByUserNameDto) {
        String userName = getPersonnelByUserNameDto.getUserName();
        if (HussarUtils.isEmpty((Object)userName)) {
            return ApiResponse.success(new ArrayList());
        }
        List personnels = this.iAssigneeChooseService.getPersonnelByUserName(userName);
        ArrayList<PersonnelQueryVo> personnelQueryVos = new ArrayList<PersonnelQueryVo>();
        if (personnels != null) {
            for (Personnel personnel : personnels) {
                PersonnelQueryVo personnelQueryVo = new PersonnelQueryVo();
                personnelQueryVo.setUserId(personnel.getUserId());
                personnelQueryVo.setUserName(personnel.getUserName());
                personnelQueryVo.setDepartmentId(personnel.getDepartmentId());
                personnelQueryVo.setUnitId(personnel.getUnitId());
                personnelQueryVo.setUserNumber(personnel.getUserNumber());
                personnelQueryVo.setDepartmentName(personnel.getDepartmentName());
                personnelQueryVo.setUnit(personnel.getUnitName());
                if (personnel.getOrganName() != null && personnel.getUnitName() != null) {
                    if (personnel.getOrganName().indexOf(personnel.getUnitName()) != -1) {
                        personnelQueryVo.setOrganName(personnel.getOrganName().substring(personnel.getOrganName().indexOf(personnel.getUnitName())));
                    } else {
                        personnelQueryVo.setOrganName(personnel.getOrganName());
                    }
                } else {
                    personnelQueryVo.setOrganName(personnel.getOrganName());
                }
                personnelQueryVo.setPostId(personnel.getPostId());
                personnelQueryVo.setPostName(personnel.getPostName());
                personnelQueryVos.add(personnelQueryVo);
            }
        }
        return ApiResponse.success(personnelQueryVos);
    }

    public ApiResponse<String> eliminateReminders(EliminateRemindersDto eliminateRemindersDto) {
        String processInstanceId;
        String taskId = eliminateRemindersDto.getTaskId();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{taskId, processInstanceId = eliminateRemindersDto.getProcInstId()})) {
            throw new PublicClientException("\u975e\u7a7a\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (HussarUtils.isEmpty((Object)taskId)) {
            return this.eliminateRemindersByProcessInstanceId(processInstanceId);
        }
        String message = "";
        taskId = RealTaskId.getRealTaskId(taskId);
        BpmActHiTaskinst bpmActHiTaskinst = (BpmActHiTaskinst)this.bpmActHiTaskinstMapper.selectById(Long.valueOf(taskId));
        bpmActHiTaskinst.setIsEliminateReminders("1");
        message = this.bpmActHiTaskinstMapper.updateById(bpmActHiTaskinst) > 0 ? BpmEnum.DEFAULT_SUCCESS_MESSAGE.getMessage() : BpmEnum.DEFAULT_FAILURE_MESSAGE.getMessage();
        this.dataPushService.updateProcess(new DataPush().setProcessInsId(bpmActHiTaskinst.getProcInstId().toString()).setProcessState(ProcessState.DONE_RECTIFICATION.getValue()));
        return ApiResponse.success((String)message);
    }

    public ApiResponse<String> eliminateRemindersByProcessInstanceId(String processInstanceId) {
        String message = "";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BpmActHiTaskinst::getProcInstId, (Object)processInstanceId)).eq(BpmActHiTaskinst::getApprovalType, (Object)"rectification");
        List bpmActHiTaskinsts = this.bpmActHiTaskinstMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (bpmActHiTaskinsts != null && bpmActHiTaskinsts.size() != 0) {
            for (BpmActHiTaskinst bpmActHiTaskinst : bpmActHiTaskinsts) {
                bpmActHiTaskinst.setIsEliminateReminders("1");
                if (this.bpmActHiTaskinstMapper.updateById(bpmActHiTaskinst) > 0) {
                    message = BpmEnum.DEFAULT_SUCCESS_MESSAGE.getMessage();
                    continue;
                }
                message = BpmEnum.DEFAULT_FAILURE_MESSAGE.getMessage();
            }
        }
        this.dataPushService.updateProcess(new DataPush().setProcessInsId(processInstanceId).setProcessState(ProcessState.DONE_RECTIFICATION.getValue()));
        return ApiResponse.success((String)message);
    }

    static {
        APPROVAL_STATE.put("0", "\u5ba1\u6279\u5b8c\u6210");
        APPROVAL_STATE.put("1", "\u672a\u5ba1\u6279");
        APPROVAL_STATE.put("2", "\u672a\u6d41\u8f6c\u5230");
        APPROVAL_TYPE.put("agree", "\u540c\u610f");
        APPROVAL_TYPE.put("disagree", "\u4e0d\u540c\u610f");
        APPROVAL_TYPE.put("accept", "\u63a5\u53d7");
        APPROVAL_TYPE.put("rectification", "\u8fd4\u56de\u6574\u6539");
        APPROVAL_TYPE.put("suspend", "\u7ec8\u6b62");
        APPROVAL_TYPE.put("reject", "\u8fd4\u56de\u5230\u6307\u5b9a\u4eba");
    }
}

