/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessFileServiceImpl
extends HussarBaseServiceImpl<SysActProcessFileMapper, SysActProcessFile>
implements SysActProcessFileService {
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;

    @CacheEvict(value={"workflow_file", "workflow_file_by_key", "workflow_file_by_id", "get_file_by_process_key_and_id"}, allEntries=true)
    public boolean updateProcessFileList(List<SysActProcessFile> sysActProcessFiles) {
        return this.updateBatchById(sysActProcessFiles);
    }

    @CacheEvict(value={"workflow_file", "workflow_file_by_key", "workflow_file_by_id", "get_file_by_process_key_and_id"}, allEntries=true)
    public void updateFile(WorkFlow workFlow, Integer version) {
        if (HussarUtils.isEmpty((Object)version)) {
            version = 0;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity());
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)version);
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        wfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        wfdFile.setModelId(workFlow.getModelId());
        wfdFile.setProcessName(workFlow.getName());
        wfdFile.setLastTime(ts);
        this.sysActProcessFileMapper.updateById(wfdFile);
        metaFile.setModelId(workFlow.getModelId());
        String data = workFlow.getData();
        workFlow.setData(null);
        metaFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        metaFile.setProcessName(wfdFile.getProcessName());
        metaFile.setLastTime(ts);
        this.sysActProcessFileMapper.updateById(metaFile);
        workFlow.setData(data);
    }

    public void addFile(WorkFlow workFlow, Integer latestVersion) {
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Integer realLatestVersion = latestVersion;
        if (HussarUtils.isEmpty((Object)latestVersion)) {
            realLatestVersion = this.sysActProcessFileMapper.selectLatestVersion(workFlow.getIdentity()) + 1;
        }
        SysActProcessFile file = new SysActProcessFile();
        file.setId(null);
        file.setCreateTime(ts);
        file.setLastTime(ts);
        file.setVersion(realLatestVersion);
        if (HussarUtils.isNotEmpty((Object)workFlow.getProcDefId()) && Integer.parseInt(workFlow.getProcDefId().split(":")[1]) < 1) {
            file.setVersion(Integer.valueOf(-1));
        } else if (HussarUtils.isNotEmpty((Object)workFlow.getVersion()) && Integer.parseInt(workFlow.getVersion()) > 0 && latestVersion == null) {
            file.setVersion(Integer.valueOf(Integer.parseInt(workFlow.getVersion())));
        }
        file.setProcessKey(workFlow.getIdentity());
        file.setModelId(workFlow.getModelId());
        file.setProcessId(workFlow.getProcDefId());
        file.setType("wfd");
        file.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        file.setBusinessModuleId(workFlow.getBusinessModuleId());
        file.setBusinessMainTable(workFlow.getBusinessMainTable());
        file.setBusinessMainTableKey(workFlow.getBusinessMainTableKey());
        file.setBusinessMainTableName(workFlow.getBusinessMainTableName());
        file.setBusinessMainTableState(workFlow.getBusinessMainTableState());
        file.setDetailName(workFlow.getDetailName());
        file.setRemoteDbName(workFlow.getRemoteDbName());
        file.setProcessName(workFlow.getName());
        file.setAttachmentFieldName(workFlow.getFileCountField());
        this.sysActProcessFileMapper.insert(file);
        file.setId(null);
        file.setType("meta");
        String data = workFlow.getData();
        workFlow.setData(null);
        file.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        this.sysActProcessFileMapper.insert(file);
        workFlow.setData(data);
    }

    public void addFileBatch(List<WorkFlow> workFlowList) {
        ArrayList<SysActProcessFile> list = new ArrayList<SysActProcessFile>();
        for (WorkFlow workFlow : workFlowList) {
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            SysActProcessFile wfdFile = new SysActProcessFile();
            wfdFile.setId(null);
            wfdFile.setCreateTime(ts);
            wfdFile.setLastTime(ts);
            wfdFile.setVersion(Integer.valueOf(0));
            wfdFile.setProcessKey(workFlow.getIdentity());
            wfdFile.setModelId(workFlow.getModelId());
            wfdFile.setProcessId(workFlow.getProcDefId());
            wfdFile.setType("wfd");
            wfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            wfdFile.setProcessName(workFlow.getName());
            list.add(wfdFile);
            SysActProcessFile metaFile = new SysActProcessFile();
            BeanUtils.copyProperties((Object)wfdFile, (Object)metaFile);
            metaFile.setId(null);
            metaFile.setType("meta");
            String data = workFlow.getData();
            workFlow.setData(null);
            metaFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            list.add(metaFile);
            workFlow.setData(data);
        }
        this.saveBatch(list);
    }

    public WorkFlow getLastFileByProcessKey(String processKey) {
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(processKey);
        return this.getFileByProcessKey(processKey, lastVersion);
    }

    @Cacheable(value={"workflow_file"}, key="'workflow_file:'+#processKey+':'+#version", unless="#result == null")
    public WorkFlow getFileByProcessKey(String processKey, Integer version) {
        Integer lastVersion = version;
        if (HussarUtils.isEmpty((Object)version)) {
            lastVersion = 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)lastVersion);
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        String wfdInfo = null;
        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setBusinessModuleId(wfdFile.getBusinessModuleId());
            workFlow.setBusinessMainTable(wfdFile.getBusinessMainTable());
            workFlow.setBusinessMainTableKey(wfdFile.getBusinessMainTableKey());
            workFlow.setBusinessMainTableName(wfdFile.getBusinessMainTableName());
            workFlow.setBusinessMainTableState(wfdFile.getBusinessMainTableState());
            workFlow.setDetailName(wfdFile.getDetailName());
            workFlow.setRemoteDbName(wfdFile.getRemoteDbName());
            workFlow.setData(wfdInfo);
            if (metaFile.getProcessId() != null) {
                workFlow.setProcDefId(metaFile.getProcessId());
            }
            return workFlow;
        }
        return null;
    }

    @Cacheable(value={"workflow_file_by_key"}, key="#processKey + '_' + #version", unless="#result == null")
    public List<SysActProcessFile> getProcessFile(String processKey, Integer version) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getVersion, (Object)version)).list();
    }

    @Cacheable(value={"workflow_file_by_id"}, key="#procDefId", unless="#result == null")
    public List<SysActProcessFile> getProcessFile(String procDefId) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysActProcessFile::getProcessId, (Object)procDefId)).list();
    }

    public List<WorkFlow> getFilesByProcessKeys(List<String> processKeys) {
        List<SysActProcessFile> list = this.sysActProcessFileMapper.getFilesByProcessKeys(processKeys);
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        if (HussarUtils.isNotEmpty(list)) {
            for (SysActProcessFile sysActProcessfile : list) {
                WorkFlow workFlow = new WorkFlow();
                workFlow = (WorkFlow)JSON.parseObject((byte[])sysActProcessfile.getContent(), WorkFlow.class, (Feature[])new Feature[0]);
                workFlowList.add(workFlow);
            }
        }
        return workFlowList;
    }

    public WorkFlow getFileByProcessDefId(String processDefId, String processKey, String version) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (processDefId != null && !"".equals(processDefId)) {
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processDefId);
        } else {
            String processId = null;
            if (HussarUtils.isNotEmpty((Object)version)) {
                processId = this.processDefinitionsMapper.selectProcessIdByProcessKeyAndVersion(processKey, Long.parseLong(version));
            } else {
                List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
                processId = list.get(0).getId();
            }
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processId);
        }
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        String wfdInfo = null;
        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    @Cacheable(value={"get_file_by_process_key_and_id"}, key="#processKey + '_' + #processId", unless="#result == null")
    public WorkFlow getFileByProcessKeyAndProcessId(String processKey, String processId) {
        LambdaQueryWrapper queryWrapper;
        String wfdInfo = null;
        String metaInfo = null;
        if (HussarUtils.equals((Object)processId, (Object)processKey)) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
            queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
            List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : list) {
                if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            }
        } else {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processId);
            List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : list) {
                if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            }
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject(metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    public List<SysActProcessFile> getBaseFileList(String processKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public boolean copyFiles(String processKey, String id) {
        WorkFlow workFlow = HussarUtils.isNotEmpty((Object)id) ? this.getFileByProcessKeyAndProcessId(processKey, id) : this.getFileByProcessKey(processKey, 0);
        this.updateFile(workFlow, 0);
        return true;
    }

    public List<SysActProcessFile> exportFileList(List<String> modelIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List longModelIds = modelIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        queryWrapper.in(SysActProcessFile::getModelId, longModelIds);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFileListByKeys(List<String> keys) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getProcessKey, keys);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFile(String procId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getProcessId, new Object[]{procId});
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    @CacheEvict(value={"workflow_file", "workflow_file_by_key", "workflow_file_by_id", "get_file_by_process_key_and_id"}, allEntries=true)
    public void updateMetaByIdentity(String identity, String name, String category) {
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(identity);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(lastVersion);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)identity);
        queryWrapper.in(SysActProcessFile::getVersion, list);
        queryWrapper.eq(SysActProcessFile::getType, (Object)"meta");
        List sysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((byte[])sysActProcessFile.getContent(), WorkFlow.class, (Feature[])new Feature[0]);
            if (HussarUtils.isNotEmpty((Object)name)) {
                workFlow.setName(name);
            }
            sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            this.sysActProcessFileMapper.updateById(sysActProcessFile);
        }
    }

    public SysActProcessFile getExtendContend(String processKey) {
        return (SysActProcessFile)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getType, (Object)"wfd"));
    }
}

