/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.constant.CustomFormConstant;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.dao.CustomCategoryMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomCategory;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomForm;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomCategoryService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomFormService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.util.CustomFormUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.CustomCategoryVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class CustomCategoryServiceImpl
extends HussarServiceImpl<CustomCategoryMapper, CustomCategory>
implements ICustomCategoryService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ICustomFormService customFormService;

    private CustomCategoryVo getVoByCustomCategory(CustomCategory customCategory) {
        return new CustomCategoryVo().setId(customCategory.getCategoryId()).setName(customCategory.getCategoryName()).setCategoryOrder(customCategory.getCategoryOrder()).setParentId(customCategory.getParentId());
    }

    public boolean add(CustomCategory customCategory) {
        if (HussarUtils.isEmpty((Object)customCategory.getParentId())) {
            customCategory.setCategoryId(CustomFormConstant.CATEGORY_ROOT);
        }
        Integer maxOrder = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomCategory::getParentId, (Object)customCategory.getParentId())).orderByDesc(CustomCategory::getCategoryOrder)).stream().map(CustomCategory::getCategoryOrder).findFirst().orElseGet(() -> 0);
        customCategory.setCategoryOrder(Integer.valueOf(maxOrder + 1));
        return this.save((BaseEntity)customCategory);
    }

    public boolean update(CustomCategory customCategory) {
        if (HussarUtils.isEmpty((Object)customCategory.getCategoryId())) {
            throw new BpmException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        customCategory.setCategoryOrder(null);
        customCategory.setParentId(null);
        return this.updateById((BaseEntity)customCategory);
    }

    public boolean delete(Long categoryId) {
        if (categoryId == null) {
            throw new BpmException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (!((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomCategory::getParentId, (Object)categoryId)).list().isEmpty()) {
            throw new BpmException("\u8be5\u5206\u7ec4\u5b58\u5728\u5b50\u5206\u7ec4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        if (!((LambdaQueryChainWrapper)this.customFormService.lambdaQuery().eq(CustomForm::getCategoryId, (Object)categoryId)).list().isEmpty()) {
            throw new BpmException("\u8be5\u5206\u7ec4\u4e0b\u5b58\u5728\u8868\u5355\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        return this.removeById(categoryId);
    }

    public List<CustomCategory> categoryTree(Long parentId, Long categoryId) {
        if (categoryId != null) {
            CustomCategory category = (CustomCategory)this.getById(categoryId);
            if (category == null) {
                return Collections.singletonList(new CustomCategory());
            }
            if (((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomCategory::getParentId, (Object)categoryId)).list().isEmpty()) {
                category.setIsLeaf(true);
            }
            return CustomFormUtil.buildCustomCategoryTreeByNodes(Collections.singletonList(category.getCategoryId()), (Collection)this.list());
        }
        List categoryList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomCategory::getParentId, (Object)parentId)).list();
        if (categoryList.isEmpty()) {
            return categoryList;
        }
        Set hasChildSet = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CustomCategory::getParentId, (Collection)categoryList.stream().map(CustomCategory::getCategoryId).collect(Collectors.toList()))).list().stream().map(CustomCategory::getParentId).collect(Collectors.toSet());
        categoryList.forEach(customCategory -> {
            if (!hasChildSet.contains(customCategory.getCategoryId())) {
                customCategory.setIsLeaf(true);
            }
        });
        return categoryList;
    }

    public Page<CustomCategoryVo> queryCategoryTreeByName(Page<CustomCategory> page, String categoryName) {
        this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(CustomCategory::getCategoryName, (Object)categoryName)).orderByAsc(CustomCategory::getCategoryOrder));
        List likeList = page.getRecords();
        Page result = new Page();
        result.setCurrent(page.getCurrent()).setSize(page.getSize()).setTotal(page.getTotal());
        if (likeList.isEmpty()) {
            return result.setRecords(Collections.emptyList());
        }
        List parent = this.list((Wrapper)new LambdaQueryWrapper().in(CustomCategory::getCategoryId, (Collection)likeList.stream().map(CustomCategory::getParentId).collect(Collectors.toSet())));
        HashMap<String, String> parentNameMap = new HashMap<String, String>();
        parentNameMap.put(CustomFormConstant.CATEGORY_ROOT, CustomFormConstant.CATEGORY_ROOT_NAME);
        parent.forEach(customCategory -> parentNameMap.put(customCategory.getCategoryId(), customCategory.getCategoryName()));
        return result.setRecords(likeList.stream().map(customCategory -> this.getVoByCustomCategory((CustomCategory)customCategory).setParentName((String)parentNameMap.get(customCategory.getParentId()))).collect(Collectors.toList()));
    }
}

