/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.IWorkflowMigrationService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowLoadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.WorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowMigrationServiceImpl
implements IWorkflowMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ModelService modelService;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private WorkflowMigrationMapper workflowMigrationMapper;
    @Resource
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private RepositoryService repositoryService;

    public List<WorkflowDumpVo> dump(List<WorkflowDumpDto> workflowDumpDtos) {
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            processKeys.add(workflowDumpDto.getProcessKey());
        }
        List<ExportModel> list = this.modelMapper.selectModelNames(processKeys);
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        for (ExportModel exportModel : list) {
            serviceNameMap.put(exportModel.getBusinessId(), exportModel.getCategory());
        }
        ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            WorkflowDumpVo workflowDumpVo;
            String processKey = workflowDumpDto.getProcessKey();
            int version = workflowDumpDto.getVersion();
            if (workflowDumpDto.getExportData().getAssigneeData().booleanValue()) {
                List sysActAssignees = this.sysActAssigneeService.list((Wrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActAssignees), "\u53c2\u4e0e\u8005.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (workflowDumpDto.getExportData().getFormAuthData().booleanValue()) {
                List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActFormAuths), "\u6743\u9650.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (!workflowDumpDto.getExportData().getWorkflowData().booleanValue()) continue;
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)workflowDumpDto.getProcessDefId()));
            WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActExtendProperties), "\u62d3\u5c55.json", (String)serviceNameMap.get(processKey));
            workflowDumpVoList.add(extendPropertiesDumpVo);
            List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)workflowDumpDto.getProcessDefId()));
            WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActProcessFiles), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", (String)serviceNameMap.get(processKey));
            workflowDumpVoList.add(sysActProcessFilesDumpVo);
            InputStream resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(workflowDumpDto.getProcessDefId());
            String xmlByteString = null;
            try {
                int temp;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((temp = resourceAsStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, temp);
                }
                byte[] finalBytes = outputStream.toByteArray();
                xmlByteString = new String(finalBytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(workflowDumpDto, xmlByteString, "bpmn20.xml", (String)serviceNameMap.get(processKey));
            workflowDumpVoList.add(xmlDumpVo);
        }
        return workflowDumpVoList;
    }

    public List<WorkflowMigrationPreloadVo> preload(List<WorkflowPreloadDto> workflowPreloadDtos) {
        ArrayList<WorkflowMigrationPreloadVo> result = new ArrayList<WorkflowMigrationPreloadVo>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            processKeys.add(workflowPreloadDto.getProcessKey());
        }
        List<DefinitionModel> list = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DefinitionModel definitionModel : list) {
            map.put(definitionModel.getMykey(), Integer.parseInt(definitionModel.getVersion()));
        }
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, (Integer)map.get(workflowPreloadDto.getProcessKey()));
            result.add(workflowMigrationPreloadVo);
        }
        return result;
    }

    public List<WorkflowLoadVo> load(WorkflowLoadDto workflowLoadDto) {
        if (!workflowLoadDto.getAssigneeMsgs().isEmpty()) {
            ArrayList<SysActAssignee> SysActAssignees = new ArrayList<SysActAssignee>();
            for (String assignee : workflowLoadDto.getAssigneeMsgs()) {
                SysActAssignees.addAll(JSON.parseArray((String)assignee, SysActAssignee.class));
            }
            this.importAssignee(SysActAssignees);
        }
        this.importFormAuth(workflowLoadDto);
        if (!workflowLoadDto.getExpandMsgs().isEmpty()) {
            ArrayList<SysActExtendProperties> extendProperties = new ArrayList<SysActExtendProperties>();
            for (Object extendPropertie : workflowLoadDto.getExpandMsgs()) {
                extendProperties.addAll(JSON.parseArray((String)extendPropertie, SysActExtendProperties.class));
            }
            this.importExtendProperties(extendProperties);
        }
        Map importMap = workflowLoadDto.getImportMsgMap();
        Map serviceNameMap = workflowLoadDto.getServiceNameMap();
        if (importMap != null) {
            for (String processKey : importMap.keySet()) {
                Map workflowFile = (Map)workflowLoadDto.getWorkflowFiles().get(processKey);
                if (workflowFile == null) continue;
                String lcpbBpmFile = (String)workflowFile.get("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
                String xml = (String)workflowFile.get("bpmn20.xml");
                String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
                if ("unable".equals(type)) continue;
                this.importModel(xml, lcpbBpmFile, (String)serviceNameMap.get(processKey), "override".equals(type));
            }
        }
        ArrayList<WorkflowLoadVo> workflowLoadVos = new ArrayList<WorkflowLoadVo>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgs()) {
            workflowLoadVos.add(new WorkflowLoadVo(workflowMigrationPreloadVo));
        }
        return workflowLoadVos;
    }

    private void importAssignee(List<SysActAssignee> sysActAssignees) {
        if (sysActAssignees.isEmpty()) {
            return;
        }
        HashSet<String> procDefKeys = new HashSet<String>();
        for (SysActAssignee sysActAssignee : sysActAssignees) {
            String procDefKey = sysActAssignee.getProcDefKey();
            procDefKeys.add(procDefKey);
        }
        List sameList = ((QueryChainWrapper)this.sysActAssigneeService.query().in((Object)"PROC_DEF_KEY", procDefKeys)).list();
        ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
        ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
        for (SysActAssignee sysActAssignee : sysActAssignees) {
            boolean isadd = true;
            for (SysActAssignee actAssignee : sameList) {
                String taskDefKeyOld;
                String taskDefKey = sysActAssignee.getTaskDefKey() == null ? "" : sysActAssignee.getTaskDefKey();
                String string = taskDefKeyOld = actAssignee.getTaskDefKey() == null ? "" : actAssignee.getTaskDefKey();
                if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !taskDefKey.equals(taskDefKeyOld) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                sysActAssignee.setId(actAssignee.getId());
                updateList.add(sysActAssignee);
                isadd = false;
                break;
            }
            if (!isadd) continue;
            addList.add(sysActAssignee);
        }
        this.sysActAssigneeService.saveBatch(addList);
        this.sysActAssigneeService.updateBatchById(updateList);
    }

    private void importFormAuth(WorkflowLoadDto workflowLoadDto) {
        ArrayList<String> formAuthImportProcess = new ArrayList<String>();
        for (WorkflowMigrationPreloadVo workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getFormAuthData().booleanValue()) continue;
            formAuthImportProcess.add(workflow.getProcessKey());
        }
        if (!formAuthImportProcess.isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActFormAuth::getProcessKey, formAuthImportProcess);
            this.sysActFormAuthService.remove((Wrapper)lambdaQueryWrapper);
            if (!workflowLoadDto.getFormAuthMsgs().isEmpty()) {
                ArrayList formAuths = new ArrayList();
                for (String formAuth : workflowLoadDto.getFormAuthMsgs()) {
                    formAuths.addAll(JSON.parseArray((String)formAuth, SysActFormAuth.class));
                }
                if (!formAuths.isEmpty()) {
                    this.sysActFormAuthService.saveBatch(formAuths);
                }
            }
        }
    }

    private void importExtendProperties(List<SysActExtendProperties> extendProperties) {
        if (extendProperties.isEmpty()) {
            return;
        }
        ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
        ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
        for (SysActExtendProperties sysActExtendProperties : extendProperties) {
            SysActExtendProperties temp = (SysActExtendProperties)sysActExtendProperties.selectById((Serializable)sysActExtendProperties.getId());
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, new Object[]{sysActExtendProperties.getProcDefId()})).eq(SysActExtendProperties::getTaskDefKey, (Object)sysActExtendProperties.getTaskDefKey());
            SysActExtendProperties newTemp = (SysActExtendProperties)sysActExtendProperties.selectOne((Wrapper)lambdaQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)temp) || HussarUtils.isNotEmpty((Object)newTemp)) {
                if (newTemp != null) {
                    sysActExtendProperties.setId(newTemp.getId());
                }
                updateList.add(sysActExtendProperties);
                continue;
            }
            addList.add(sysActExtendProperties);
        }
        this.sysActExtendPropertiesService.saveBatch(addList);
        this.sysActExtendPropertiesService.updateBatchById(updateList);
    }

    private Boolean importModel(String xml, String lcdpbpm, String serviceName, boolean isOverride) {
        List oldSysActProcessFiles;
        String processKey;
        BpmnModel bpmnModel = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String identityId = this.modelMapper.getIdByIdentity(modelKey);
        List sysActProcessFiles = JSON.parseArray((String)lcdpbpm, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        boolean needModify = false;
        String workFlowName = null;
        if (!isOverride) {
            List oldSysActProcessFiles2 = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles2)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles2) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        if ("wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                if ("wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            if (HussarUtils.isEmpty((Object)identityId)) {
                Model modelData = this.repositoryService.newModel();
                ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                modelObjectNode.put("name", impModelName);
                modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                modelObjectNode.put("revision", 1);
                modelData.setMetaInfo(modelObjectNode.toString());
                modelData.setName(impModelName);
                modelData.setKey(modelKey);
                modelData.setCategory(serviceName);
                this.repositoryService.saveModel(modelData);
                identityId = modelData.getId();
            }
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
            if (workFlow == null) {
                logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
            }
            workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
            this.sysActProcessFileService.updateFile(workFlow);
            this.modelService.deployModel(Long.valueOf(Long.parseLong(identityId)));
        } else {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            int highestVersion = Integer.parseInt(this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys).get(0).getVersion());
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)highestVersion)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            int overVersion = Integer.parseInt(this.processDefinitionsMapper.getMainOrNew(processKey).get(0).getVersion());
            needModify = overVersion == highestVersion;
            String processId = null;
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        processId = String.valueOf(oldSysActProcessFile.getProcessId());
                        file.setProcessId(processId);
                        file.setVersion(Integer.valueOf(highestVersion));
                        if ("wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(highestVersion));
                if ("wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                workFlow.setModelId(Long.valueOf(identityId));
                workFlowName = workFlow.getName();
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getModelId(highestVersion, processKey)) ? Long.valueOf(this.bpm2XMLMapper.getModelId(highestVersion, processKey)) : null;
            updateByteArrayModel.setId(id);
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            this.processDefinitionsMapper.updateProcessName(processId, workFlowName);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processId));
        }
        if (needModify) {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<SysActProcessFile> wfds = new ArrayList<SysActProcessFile>();
            ArrayList<SysActProcessFile> metas = new ArrayList<SysActProcessFile>();
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        file.setProcessId(null);
                        if ("wfd".equals(file.getType())) {
                            wfds.add(file);
                            continue;
                        }
                        metas.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                file.setProcessId(null);
                if ("wfd".equals(file.getType())) {
                    wfds.add(file);
                    continue;
                }
                metas.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metas) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                workFlow.setModelId(Long.valueOf(identityId));
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfds);
            addList.addAll(metas);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId))) ? this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)) : null;
            updateByteArrayModel.setId(id);
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            this.processDefinitionsMapper.setNameAndDeploymentId(workFlowName, null, processKey);
        }
        return true;
    }

    public BpmResponseResult selectByName(WorkflowQueryDto workflowQueryDto) {
        List<WorkflowQueryVo> list = this.queryModelList((Page<WorkflowQueryVo>)workflowQueryDto.getPage(), workflowQueryDto.getName());
        if (!list.isEmpty()) {
            int i;
            ArrayList<String> processKeys = new ArrayList<String>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String a = list.get(i2).getProcessKey();
                processKeys.add(a);
            }
            List<ProcessDefinitionModel> processDefinitionModels = this.workflowMigrationMapper.queryProcessDefList(processKeys);
            ArrayList<String> processDefinitonKeys = new ArrayList<String>();
            HashMap versionMap = new HashMap();
            for (int i3 = 0; i3 < processKeys.size(); ++i3) {
                ArrayList list1 = new ArrayList();
                for (int j = 0; j < processDefinitionModels.size(); ++j) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String pd = processDefinitionModels.get(j).getId();
                    String version = processDefinitionModels.get(j).getVersion();
                    String[] arr = pd.split(":");
                    if (!((String)processKeys.get(i3)).equals(arr[0])) continue;
                    map.put("key", version);
                    map.put("value", pd);
                    int index = 0;
                    for (Map map2 : list1) {
                        if (Integer.parseInt((String)map2.get("key")) <= Integer.parseInt(version)) continue;
                        ++index;
                    }
                    list1.add(index, map);
                }
                versionMap.put(processKeys.get(i3), list1);
            }
            for (int j = 0; j < processDefinitionModels.size(); ++j) {
                String pd = processDefinitionModels.get(j).getId();
                processDefinitonKeys.add(pd);
            }
            HashMap map = new HashMap();
            for (i = 0; i < processKeys.size(); ++i) {
                ArrayList list2 = new ArrayList();
                for (int j = 0; j < processDefinitonKeys.size(); ++j) {
                    String[] arr = ((String)processDefinitonKeys.get(j)).split(":");
                    if (!((String)processKeys.get(i)).equals(arr[0])) continue;
                    list2.add(processDefinitonKeys.get(j));
                }
                map.put(processKeys.get(i), list2);
            }
            for (i = 0; i < list.size(); ++i) {
                list.get(i).setVersionMap((List)versionMap.get(list.get(i).getProcessKey()));
            }
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)workflowQueryDto.getPage().setRecords(list));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public List<WorkflowQueryVo> queryModelList(Page<WorkflowQueryVo> page, String processName) {
        return this.workflowMigrationMapper.queryModelList(page, processName);
    }
}

