/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.StartProcessReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.CcRecipientVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.activiti.engine.task.TaskStateType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class InstanceEngineServiceImpl
implements IInstanceEngineService,
InitializingBean {
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private ITaskEngineService taskEngineService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Resource
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    public static final String SUB_PROCINST_NAME = "\u5b9e\u4f8b";
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";

    public void afterPropertiesSet() {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u7ed3\u6d41\u7a0b");
        TASK_SOURCE_FLAG.put("complete_leap", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revokeProcess", "\u6d41\u7a0b\u64a4\u529e");
        TASK_SOURCE_FLAG.put("assist_complete", "\u529e\u7406\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist_add", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("CcTask", "\u4f20\u9605");
        if (this.bpmConstantProperties != null && HussarUtils.isNotEmpty(this.bpmConstantProperties.getTaskSourceFlag())) {
            TASK_SOURCE_FLAG.putAll(this.bpmConstantProperties.getTaskSourceFlag());
        }
    }

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        boolean flag;
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (!(flag = this.validateAuthority(userId, processDefinitionId, businessId, variables))) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        String processDefinitionId;
        boolean flag;
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (!(flag = this.validateAuthority(userId, processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey), businessId, variables))) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult validationStartProcess(String processKey, String userId, String businessId, Map<String, Object> variables) {
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey);
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult checkProcessInstByBusinessId(String businessId) {
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONObject object = new JSONObject();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processKey", (Object)task.getProcessDefinitionId().split(":")[0]);
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessId", (Object)businessId);
                object.put("taskId", (Object)task.getId());
                return ApiResponse.success((Object)object);
            }
            return ApiResponse.fail((String)this.bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult validateDeleteByBusinessId(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryAllCommentByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (instance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        String processInsId = instance.getId();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().finished().asc()).list();
        return this.getResult(hisTaskList, true, true);
    }

    private boolean validateAuthority(String userId, String processDefinitionId, String businessId, Map<String, Object> variables) {
        boolean flag;
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, processDefinitionId, businessId, variables);
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (HussarUtils.isEmpty((Object)sql)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(userId);
            HashMap<String, ArrayList<String>> appointAssignee = new HashMap<String, ArrayList<String>>();
            appointAssignee.put("static_appoint_assignee", users);
            variables.put("appoint_assignee", appointAssignee);
            return true;
        }
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowStarterUserId", userId);
        processInfo.put("workflowProcessDefinitionId", processDefinitionId);
        processInfo.put("workflowProcessKey", processDefinitionId.split(":")[0]);
        processInfo.put("workflowBusinessId", businessId);
        List users = this.iAssigneeChooseService.getCandidateUser(sql, processDefinitionKey, (Integer)variables.get("security_level"), processInfo);
        if (users != null && !users.isEmpty()) {
            flag = users.contains(userId);
        } else {
            users.add(userId);
            flag = true;
        }
        HashMap<String, List> appointAssignee = new HashMap<String, List>();
        appointAssignee.put("static_appoint_assignee", users);
        variables.put("appoint_assignee", appointAssignee);
        return flag;
    }

    public Map<String, Object> installVariables(String processDefinitionId, Map<String, Object> variables) {
        if (HussarUtils.isEmpty((Object)processDefinitionId)) {
            return variables;
        }
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(processDefinitionId, null);
        if (map.isEmpty()) {
            return variables;
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("todoConfiguration", map.get("todoConfiguration"));
        return variables;
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        this.runtimeService.suspendProcessInstanceById(processInsId);
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setDescription("suspendProcess");
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "suspendEnd");
        map.put("processInsId", processInstance.getId());
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setDescription("suspendProcess");
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        this.runtimeService.activateProcessInstanceById(processInsId);
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setDescription("activateProcess");
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "activateEnd");
        map.put("processInsId", processInstance.getId());
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setDescription("activateProcess");
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        List<Long> procIdList = new ArrayList<Long>();
        procIdList.add(Long.valueOf(processInsId));
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(stringProcIds)).list();
        StringBuilder taskIds = new StringBuilder();
        for (Object task : tasks) {
            if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
            taskIds.append(",").append(task.getId());
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        this.runtimeService.deleteProcessInstance(processInsId, reason);
        if (this.dataPushService.isDataPush()) {
            HashMap<String, String> businessKeyMap = new HashMap<String, String>();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionKey());
                businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
                businessKeyMap.put(historicProcessInstance.getProcessDefinitionKey(), businessIds);
            }
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setComment(reason);
            dataPush.setDescription("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
        }
        LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
        urgeQueryWrapper.in(SysActUrgeTask::getProcessInsId, allProcId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
        lineQueryWrapper.in(SysActHiLine::getProcessInsId, allProcId);
        this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        List<Long> procIdList = new ArrayList<Long>();
        procIdList.add(Long.valueOf(processInsId));
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        this.historyService.deleteHistoricProcessInstance(processInsId);
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        if (this.dataPushService.isDataPush()) {
            HashMap<String, String> businessKeyMap = new HashMap<String, String>();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionKey());
                businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
                businessKeyMap.put(historicProcessInstance.getProcessDefinitionKey(), businessIds);
            }
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setDescription("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        ArrayList<String> businessKeys = new ArrayList<String>();
        businessKeys.add(businessId);
        List<Long> procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessKeys);
        if (procIdList.size() == 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        Long processInstanceId = procIdList.get(0);
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        for (int i = 0; i < historicProcessInstances.size(); ++i) {
            if (!HussarUtils.isEmpty((Object)((HistoricProcessInstance)historicProcessInstances.get(i)).getEndTime())) continue;
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        this.historyService.deleteHistoricProcessInstance(String.valueOf(processInstanceId));
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        if (this.dataPushService.isDataPush()) {
            HashMap<String, String> businessKeyMap = new HashMap<String, String>();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionKey());
                businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
                businessKeyMap.put(historicProcessInstance.getProcessDefinitionKey(), businessIds);
            }
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setDescription("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            List<Long> procIdList = new ArrayList<Long>();
            procIdList.add(Long.valueOf(historicProcessInstance.getId()));
            ArrayList<Long> allProcId = new ArrayList<Long>();
            do {
                allProcId.addAll(procIdList);
            } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
            List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(stringProcIds)).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.in(SysActUrgeTask::getProcessInsId, allProcId);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
            lineQueryWrapper.in(SysActHiLine::getProcessInsId, allProcId);
            this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
            if (this.dataPushService.isDataPush()) {
                HashMap<String, String> businessKeyMap = new HashMap<String, String>();
                for (HistoricProcessInstance processInstance : historicProcessInstances) {
                    String businessIds = (String)businessKeyMap.get(processInstance.getProcessDefinitionKey());
                    businessIds = businessIds == null ? processInstance.getBusinessKey() : businessIds + "," + processInstance.getBusinessKey();
                    businessKeyMap.put(processInstance.getProcessDefinitionKey(), businessIds);
                }
                DataPush dataPush = new DataPush();
                dataPush.setBusinessMap(businessKeyMap);
                dataPush.setDescription("deleteProcess");
                this.dataPushService.deleteDataPush(dataPush);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessId, boolean isValidate) {
        try {
            List<String> businessIdList;
            if (HussarUtils.isNotEmpty((Object)businessId) && HussarUtils.isNotEmpty(businessIdList = Arrays.asList(businessId.split(",")))) {
                if (isValidate) {
                    for (String s : businessIdList) {
                        BpmResponseResult validateResult;
                        if (s.isEmpty() || (validateResult = this.validateDeleteByBusinessId(s)).getResult().get(0) != null && "1".equals(validateResult.getResult().get(0).toString())) continue;
                        return InstallResult.getResult((String)"0", (String)validateResult.getMsg(), null);
                    }
                }
                List<Long> procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIdList);
                List<ProcessInstVo> businessProcKeyList = this.instanceEngineMapper.selectProcKeyByBusinessIdList(businessIdList);
                HashMap<String, String> businessMap = new HashMap<String, String>();
                if (HussarUtils.isNotEmpty(businessProcKeyList)) {
                    for (ProcessInstVo processInstVo : businessProcKeyList) {
                        if (businessMap.containsKey(processInstVo.getProcessDefinitionKey())) {
                            String businessIds = (String)businessMap.get(processInstVo.getProcessDefinitionKey());
                            businessIds = businessIds + "," + processInstVo.getBusinessId();
                            businessMap.put(processInstVo.getProcessDefinitionKey(), businessIds);
                            continue;
                        }
                        businessMap.put(processInstVo.getProcessDefinitionKey(), processInstVo.getBusinessId());
                    }
                }
                if (!procIdList.isEmpty()) {
                    ArrayList<Long> allProcId = new ArrayList<Long>();
                    do {
                        allProcId.addAll(procIdList);
                    } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
                    this.multiDeleteByProcIdList(allProcId, businessMap);
                }
            }
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        Long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).processDefinitionKey(processKey).finished().count();
        List insts = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).processDefinitionKey(processKey).orderByProcessInstanceEndTime().desc()).finished().listPage((page - 1) * rows, rows);
        object.put("data", (Object)insts);
        object.put("count", (Object)count);
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        Boolean isEnded = historicProcessInstance == null ? null : Boolean.valueOf(historicProcessInstance.getEndTime() != null);
        json.add(isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        Boolean isEnded = historicProcessInstance == null ? null : Boolean.valueOf(historicProcessInstance.getEndTime() != null);
        json.add(isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<Object> userList = new ArrayList();
        if (hisList != null && !hisList.isEmpty()) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (!user.isEmpty()) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && !hisList.isEmpty()) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && !comments.isEmpty()) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).list();
        return this.getResult(hisTaskList, true, true);
    }

    public JSONArray getAllProcessTraceForComment(String processInsId) {
        if (processInsId == null) {
            return new JSONArray();
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).includeTaskLocalVariables()).finished().list();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        if (this.lcdpBpmProperties.isOrderByTime()) {
            hisTaskList.sort((o1, o2) -> {
                if (!o1.getStartTime().equals(o2.getStartTime())) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
                if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        } else {
            hisTaskList.sort((o1, o2) -> {
                if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        JSONArray jsonArray = new JSONArray();
        for (HistoricTaskInstance hsi : hisTaskList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("taskId", (Object)hsi.getId());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            jsonObject.put("endTime", (Object)sdf.format(hsi.getEndTime()));
            jsonObject.put("activityName", (Object)hsi.getName());
            jsonObject.put("sub_process_key", (Object)hsi.getSubProcessKey());
            jsonObject.put("start", (Object)hsi.getStartTime());
            String user = null;
            user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : this.bpmConstantProperties.getNullComplete();
            jsonObject.put("assignee", (Object)user);
            jsonObject.put("taskType", (Object)hsi.getTaskType());
            Map variables = hsi.getTaskLocalVariables();
            String taskSourceFlag = (String)variables.get("taskSourceFlag");
            if ("reject_revoke".equals(taskSourceFlag)) {
                taskSourceFlag = "revoke";
            }
            if (hsi.getTaskType() != null && hsi.getEndTime() != null) {
                taskSourceFlag = hsi.getParentTaskId() != null ? "assist_complete" : "assist_add";
            }
            jsonObject.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(taskSourceFlag));
            jsonArray.add((Object)jsonObject);
        }
        this.handleSubProcessMessage(jsonArray, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), processInsId);
        return jsonArray;
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId, int type) {
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<Object> processInsIds = new ArrayList();
        if (type == 0) {
            if (HussarUtils.isEmpty((Object)processInsId)) {
                historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
                if (historicProcessInstance == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
                }
                processInsId = historicProcessInstance.getId();
            }
            if ((processInsIds = this.taskEngineMapper.getCallActivityInstId(Long.parseLong(processInsId))).isEmpty()) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
        } else {
            historicProcessInstance = HussarUtils.isEmpty((Object)processInsId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (historicProcessInstance == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
            }
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            processInsIds.add(historicProcessInstance.getSuperProcessInstanceId());
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(processInsIds)).list();
        return this.getResult(historicTaskInstances, true, true);
    }

    public BpmResponseResult getAllProcessTraceByBusinessId(String businessId, int page, int size) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        Long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, true, true);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, boolean flag, boolean handleSubProcessMessage) {
        JSONArray json = new JSONArray();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        if (this.lcdpBpmProperties.isOrderByTime()) {
            hisTaskList.sort((o1, o2) -> {
                if (!o1.getStartTime().equals(o2.getStartTime())) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
                if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                if (o1.getEndTime() == null && o2.getEndTime() != null) {
                    return o2.getEndTime().compareTo(new Date(0L));
                }
                if (o1.getEndTime() != null && o2.getEndTime() == null) {
                    return new Date(0L).compareTo(o1.getEndTime());
                }
                if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        } else {
            hisTaskList.sort((o1, o2) -> {
                if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                if (o1.getEndTime() == null && o2.getEndTime() != null) {
                    return new Date(0L).compareTo(o2.getEndTime());
                }
                if (o1.getEndTime() != null && o2.getEndTime() == null) {
                    return o1.getEndTime().compareTo(new Date(0L));
                }
                if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            List<String> taskIds = hisTaskList.stream().map(TaskInfo::getId).collect(Collectors.toList());
            List<CcRecipientVo> sysCcTaskList = this.taskEngineMapper.getCcRecipientByTaksIds(taskIds);
            Map<String, Object> ccRecipientMap = sysCcTaskList.stream().collect(Collectors.groupingBy(CcRecipientVo::getTaskId)).entrySet().stream().map(entry -> {
                HashMap map = new HashMap();
                map.put("taskId", entry.getKey());
                map.put("ccRecipient", ((List)entry.getValue()).stream().map(CcRecipientVo::getCcRecipient).collect(Collectors.joining(",")));
                return map;
            }).collect(Collectors.toMap(map -> String.valueOf(map.get("taskId")), map -> String.valueOf(map.get("ccRecipient"))));
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            for (HistoricTaskInstance hisTask : hisTaskList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(Long.parseLong(hisTask.getId()));
            }
            List<Object> commentsMap = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getMessage());
            }
            List<Object> allVariables = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                allVariables = this.flowTaskMapper.getAllVariables(hisTaskIds, null);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Variables variables : allVariables) {
                if (!"taskSourceFlag".equals(variables.getName())) continue;
                hashMap.put(variables.getTaskId(), variables.getTextValue());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String processKey = hisTaskList.get(0).getProcessDefinitionId().split(":")[0];
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            Map modelNames = this.modelService.selectModelNames(processKeys);
            String value = (String)modelNames.get(processKey);
            for (HistoricTaskInstance hsi : hisTaskList) {
                String comment;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : this.bpmConstantProperties.getNullComplete();
                String nullCommont = "";
                if (flag) {
                    nullCommont = this.bpmConstantProperties.getNullComment();
                }
                object.put("comments", (Object)((comment = (String)taskComment.get(hsi.getId())) == null ? nullCommont : comment));
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("start", (Object)hsi.getStartTime());
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<IdentityLink> users = this.getIdentityLinkByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(users));
                        if (HussarUtils.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)this.bpmConstantProperties.getNullComplete());
                        }
                    }
                    object.put("comments", (Object)"");
                }
                object.put("modelName", (Object)value);
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                object.put("assigneeId", (Object)hsi.getAssignee());
                String taskSourceFlag = (String)hashMap.get(hsi.getId());
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                if (hsi.getTaskType() != null && hsi.getEndTime() != null) {
                    taskSourceFlag = hsi.getParentTaskId() != null ? "assist_complete" : "assist_add";
                }
                object.put("sub_process_key", (Object)hsi.getSubProcessKey());
                object.put("taskSourceFlag", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                object.put("taskType", (Object)hsi.getTaskType());
                if (ccRecipientMap.containsKey(hsi.getId())) {
                    object.put("ccRecipient", ccRecipientMap.get(hsi.getId()));
                }
                json.add((Object)object);
            }
            if (handleSubProcessMessage) {
                this.handleSubProcessMessage(json, sdf, hisTaskList.get(0).getProcessInstanceId());
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void handleSubProcessMessage(JSONArray json, SimpleDateFormat sdf, String procInstId) {
        List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procInstId).activityType("subProcess").orderByHistoricActivityInstanceStartTime().desc()).list();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject object = json.getJSONObject(i);
            if (!HussarUtils.isNotEmpty((Object)object.get((Object)"sub_process_key"))) continue;
            String taskSubProcessKey = (String)object.get((Object)"sub_process_key");
            HistoricActivityInstance activity = null;
            for (int j = 0; j < activityInstances.size(); ++j) {
                activity = (HistoricActivityInstance)activityInstances.get(j);
                if (!activity.getSubProcessKey().equals(taskSubProcessKey) || !object.getDate("start").after(activity.getStartTime()) || activity.getEndTime() != null && !object.getDate("start").before(activity.getEndTime())) continue;
                activityInstances.remove(j);
                break;
            }
            if (activity == null) continue;
            JSONObject subProcessMsg = new JSONObject();
            subProcessMsg.put("activityName", (Object)activity.getActivityName());
            subProcessMsg.put("activityId", (Object)activity.getId());
            subProcessMsg.put("taskDefinitionKey", (Object)activity.getActivityId());
            subProcessMsg.put("startTime", (Object)sdf.format(activity.getStartTime()));
            subProcessMsg.put("start", (Object)activity.getStartTime());
            subProcessMsg.put("taskSourceFlag", (Object)"");
            subProcessMsg.put("sub_process_key", (Object)taskSubProcessKey);
            if (taskSubProcessKey.equals(activity.getActivityId() + "::0")) {
                subProcessMsg.put("type", (Object)"subProcess");
            } else {
                subProcessMsg.put("type", (Object)"multiSubProcess");
            }
            if (activity.getEndTime() != null) {
                subProcessMsg.put("endTime", (Object)sdf.format(activity.getEndTime()));
                subProcessMsg.put("end", (Object)activity.getEndTime());
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)object);
            subProcessMsg.put("subProcessTask", (Object)jsonArray);
            json.set(i, (Object)subProcessMsg);
            for (int j = i + 1; j < json.size(); ++j) {
                JSONObject subObject = json.getJSONObject(j);
                if (!taskSubProcessKey.equals(subObject.get((Object)"sub_process_key")) || !subObject.getDate("start").after(activity.getStartTime()) || activity.getEndTime() != null && !subObject.getDate("start").before(activity.getEndTime())) continue;
                jsonArray.add((Object)subObject);
                json.remove(j--);
            }
        }
        HashMap<String, JSONObject> message = new HashMap<String, JSONObject>();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject object = json.getJSONObject(i);
            if (!HussarUtils.isNotEmpty((Object)object.get((Object)"sub_process_key")) || !"multiSubProcess".equals(object.get((Object)"type"))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityName", object.get((Object)"activityName"));
            jsonObject.put("activityId", object.get((Object)"activityId"));
            jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
            Date start = object.getDate("start");
            Date end = object.getDate("end");
            jsonObject.put("taskSourceFlag", (Object)"");
            String subProcessKey = object.getString("sub_process_key");
            if (message.get(subProcessKey) != null) {
                ((JSONObject)message.get(subProcessKey)).put("type", (Object)"reStart");
            }
            if (end == null) {
                object.put("type", (Object)"start");
                message.put(subProcessKey, object);
            }
            int loopCounter = Integer.parseInt(subProcessKey.split(":")[2]);
            object.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
            JSONArray jsonArray = new JSONArray();
            while (jsonArray.size() < loopCounter + 1) {
                jsonArray.add((Object)"");
            }
            jsonArray.set(loopCounter, (Object)object);
            jsonObject.put("subProcess", (Object)jsonArray);
            jsonObject.put("type", (Object)"multiSubProcess");
            json.set(i, (Object)jsonObject);
            for (int j = i + 1; j < json.size(); ++j) {
                boolean isSameMulti;
                JSONObject subObject = json.getJSONObject(j);
                if (subObject.get((Object)"sub_process_key") == null || !"multiSubProcess".equals(subObject.get((Object)"type"))) continue;
                if (object.get((Object)"end") == null) {
                    isSameMulti = subObject.get((Object)"end") == null ? true : subObject.getDate("end").after(object.getDate("start"));
                } else if (subObject.get((Object)"end") == null) {
                    isSameMulti = object.getDate("end").after(subObject.getDate("start"));
                } else {
                    boolean bl = isSameMulti = subObject.getDate("end").after(object.getDate("start")) && subObject.getDate("start").before(object.getDate("end"));
                }
                if (!isSameMulti) continue;
                subProcessKey = subObject.getString("sub_process_key");
                loopCounter = Integer.parseInt(subProcessKey.split(":")[2]);
                subObject.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
                Date date = start = start.after(subObject.getDate("start")) ? subObject.getDate("start") : start;
                if (end != null) {
                    Date newEnd = subObject.getDate("end");
                    if (newEnd == null) {
                        end = null;
                    } else {
                        Date date2 = end = end.before(newEnd) ? newEnd : end;
                    }
                }
                if (message.get(subProcessKey) != null) {
                    ((JSONObject)message.get(subProcessKey)).put("type", (Object)"reStart");
                }
                if (subObject.getDate("end") == null) {
                    subObject.put("type", (Object)"start");
                    message.put(subProcessKey, subObject);
                }
                while (jsonArray.size() < loopCounter + 1) {
                    jsonArray.add((Object)"");
                }
                jsonArray.set(loopCounter, (Object)subObject);
                json.remove(j--);
            }
            while (jsonArray.remove((Object)"")) {
            }
            for (int m = 0; m < jsonArray.size(); ++m) {
                jsonArray.getJSONObject(m).put("activityName", (Object)(SUB_PROCINST_NAME + (m + 1)));
            }
            jsonObject.put("startTime", (Object)sdf.format(start));
            if (end == null) continue;
            jsonObject.put("endTime", (Object)sdf.format(end));
        }
    }

    public BpmResponseResult getAllProcessTraceByMicroApp(String processInsId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        for (HistoricTaskInstance hsi : nullList) {
            hisTaskList.add(hsi);
        }
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (HussarUtils.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                object.put("variables", (Object)variables);
                if (hsi.getTaskType() != null && hsi.getEndTime() != null) {
                    taskSourceFlag = hsi.getParentTaskId() != null ? "assist_complete" : "assist_add";
                }
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(taskSourceFlag));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getDoneProcessTrace(String businessId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (HussarUtils.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setProcessName(processDefinition.getName());
        processDefinitionModel.setId(processDefinition.getId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        HistoricProcessInstance processInstance;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator));
        mandator = prepareReturn.getMandator();
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(userId, mandator, reason, task.getProcessInstanceId(), "endProcess"));
        String superProcessInstanceId = task.getProcessInstanceId();
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        HistoricProcessInstance processInstance;
        String processInstanceId = null;
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstanceId = processInsId;
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            ArrayList<String> businessIds = new ArrayList<String>();
            businessIds.add(businessId);
            List<Long> processInstanceIds = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIds);
            if (processInstanceIds.size() == 0) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
            }
            processInstanceId = String.valueOf(processInstanceIds.get(0));
        } else {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(userId, null, comment, processInstanceId, "endProcess"));
        String superProcessInstanceId = processInstanceId;
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcessByProcessInsId(String processInstanceId, String userId, String reason) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessInsIdNull(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(userId, null, reason, processInstanceId, "endProcess"));
        String superProcessInstanceId = processInstanceId;
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    private List<IdentityLink> getIdentityLinkByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }

    public List<Map<String, String>> getCallNodeType(String processInsId) {
        List<FlowTask> callNodeType = this.taskEngineMapper.getCallNodeType(Long.parseLong(processInsId));
        ArrayList<Map<String, String>> callNodeTypeList = new ArrayList<Map<String, String>>();
        for (FlowTask flowTask : callNodeType) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("node", flowTask.getTaskDefinitionKey());
            map.put("type", flowTask.getCompleteType());
            callNodeTypeList.add(map);
        }
        return callNodeTypeList;
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        Page processPage = new Page();
        if (page == null) {
            processPage.setCurrent(1L).setSize(Integer.MAX_VALUE);
        } else {
            processPage.setCurrent(page.getCurrent()).setSize(page.getSize());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getStarter())) {
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getProcessKeyList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getProcessKey()) && processQueryByStarterDto.getProcessKey().contains(",")) {
                processQueryByStarterDto.setProcessKeyList(Arrays.asList(processQueryByStarterDto.getProcessKey().split(",")));
                processQueryByStarterDto.setProcessKey(null);
            }
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getBusinessIdList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getBusinessId()) && processQueryByStarterDto.getBusinessId().contains(",")) {
                processQueryByStarterDto.setBusinessIdList(Arrays.asList(processQueryByStarterDto.getBusinessId().split(",")));
                processQueryByStarterDto.setBusinessId(null);
            }
            List<ProcessInstVo> list = this.instanceEngineMapper.queryProcessByStarter((Page<ProcessInstVo>)processPage, processQueryByStarterDto);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setStarter(processQueryByStarterDto.getStarter());
            }
            jsonObject.put("data", list);
            jsonObject.put("count", (Object)processPage.getTotal());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return bpmResponseResult;
            }
        }
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).finished().asc()).list();
        return this.getResult(hisTaskList, false, false);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        if (HussarUtils.isEmpty((Object)processRevokeDto.getStartUserId())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricProcessInstance processInstance = this.getProcessInst(processRevokeDto.getProcessInsId(), processRevokeDto.getBusinessId(), processRevokeDto.getTaskId(), true);
        if (HussarUtils.isNotEmpty((Object)processInstance.getSuperProcessInstanceId())) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorCallActivityRevoke());
        }
        if (!processInstance.getStartUserId().equals(processRevokeDto.getStartUserId())) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorStartUser());
        }
        if (!processRevokeDto.getIsForce()) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).list();
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                throw new PublicClientException(this.bpmConstantProperties.getForbidPrcoessRevoke());
            }
        }
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(processRevokeDto.getStartUserId(), null, processRevokeDto.getReason(), processInstance.getId(), "revokeProcess", true));
        String userId = processRevokeDto.getStartUserId();
        String superProcessInstanceId = processInstance.getId();
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void multiDeleteByProcIdList(List<Long> allProcId, Map<String, String> businessMap) {
        List<Long> taskIdList = this.instanceEngineMapper.selectTaskIdByProcInstIdList(allProcId);
        this.instanceEngineMapper.deleteHiComment(allProcId, taskIdList);
        this.instanceEngineMapper.deleteHiDetail(allProcId);
        this.instanceEngineMapper.deleteHiActinst(allProcId);
        this.instanceEngineMapper.deleteHiIdentityLink(allProcId, taskIdList);
        this.instanceEngineMapper.deleteHiTaskinst(allProcId);
        this.instanceEngineMapper.deleteHiVarinst(allProcId);
        this.instanceEngineMapper.deleteRuIdentityLink(allProcId, taskIdList);
        this.instanceEngineMapper.deleteRuTask(allProcId);
        this.instanceEngineMapper.deleteRuVariable(allProcId);
        this.instanceEngineMapper.deleteRuExecution(allProcId);
        this.instanceEngineMapper.deleteCcTask(allProcId);
        this.instanceEngineMapper.deleteHiLine(allProcId);
        this.instanceEngineMapper.deleteUrgeTask(allProcId);
        this.instanceEngineMapper.deleteHiProcinst(allProcId);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessMap);
            dataPush.setProcessInsId(String.join((CharSequence)",", allProcId.toString()));
            dataPush.setDescription("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
        }
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        String processInstId = processDto.getProcessInsId();
        String businessId = processDto.getBusinessId();
        String taskId = processDto.getTaskId();
        HistoricProcessInstance historicProcessInstance = this.getProcessInst(processInstId, businessId, taskId, null);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("processInsId", historicProcessInstance.getId());
        resMap.put("businessId", historicProcessInstance.getBusinessKey());
        resMap.put("startTime", historicProcessInstance.getStartTime());
        resMap.put("endTime", historicProcessInstance.getEndTime());
        resMap.put("startUser", historicProcessInstance.getStartUserId());
        resMap.put("processDefinitionId", historicProcessInstance.getProcessDefinitionId());
        resMap.put("processDefinitionName", historicProcessInstance.getProcessDefinitionName());
        resMap.put("processKey", historicProcessInstance.getProcessDefinitionKey());
        List taskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicProcessInstance.getId())).includeTaskLocalVariables()).list();
        if (!taskList.isEmpty()) {
            ArrayList taskUser;
            ArrayList<Map<String, String>> todo = new ArrayList<Map<String, String>>();
            ArrayList<Map<String, String>> done = new ArrayList<Map<String, String>>();
            HashSet<String> userId = new HashSet<String>();
            for (HistoricTaskInstance task : taskList) {
                Map<String, String> taskMap = new HashMap<String, String>();
                taskMap.put("taskId", task.getId());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("startTime", (String)((Object)task.getCreateTime()));
                taskMap.put("sendUser", (String)task.getTaskLocalVariables().get("sendUser"));
                userId.add((String)task.getTaskLocalVariables().get("sendUser"));
                taskMap.put("todoConfiguration", (String)task.getTaskLocalVariables().get("todoConfiguration"));
                taskMap.put("taskType", task.getTaskType());
                if (task.getEndTime() != null) {
                    userId.add(task.getAssignee());
                    taskUser = new ArrayList();
                    HashMap<String, String> taskUserMap = new HashMap<String, String>();
                    taskUserMap.put("userId", task.getAssignee());
                    taskUser.add(taskUserMap);
                    taskMap.put("assignee", (String)((Object)taskUser));
                    taskMap.put("endTime", (String)((Object)task.getEndTime()));
                    done.add(taskMap);
                    continue;
                }
                Set userSet = this.taskService.getIdentityLinksType(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
                if (!userSet.isEmpty()) {
                    userId.addAll(userSet);
                    ArrayList taskUser2 = new ArrayList();
                    for (String taskUserId : userSet) {
                        HashMap<String, String> taskUserMap = new HashMap<String, String>();
                        taskUserMap.put("userId", taskUserId);
                        taskUser2.add(taskUserMap);
                    }
                    taskMap.put("assignee", (String)((Object)taskUser2));
                }
                todo.add(taskMap);
            }
            Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userId));
            for (Map<String, String> taskMap : todo) {
                if (taskMap.get("assignee") != null) {
                    taskUser = (ArrayList)taskMap.get("assignee");
                    for (Map map : taskUser) {
                        map.put("userName", finalUsers.get(map.get("userId")));
                    }
                }
                if (taskMap.get("sendUser") == null) continue;
                taskMap.put("sendUserName", (String)finalUsers.get(taskMap.get("sendUser")));
            }
            for (Map<String, String> taskMap : done) {
                if (taskMap.get("assignee") == null) continue;
                taskUser = (List)taskMap.get("assignee");
                for (Map map : taskUser) {
                    map.put("userName", finalUsers.get(map.get("userId")));
                }
            }
            resMap.put("todo", todo);
            resMap.put("done", done);
        }
        if (historicProcessInstance.getStartUserId() != null) {
            resMap.put("startUserName", this.iAssigneeChooseService.getUserNames(Collections.singletonList(historicProcessInstance.getStartUserId())));
        }
        return InstallResult.success(resMap);
    }

    public BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        HistoricProcessInstance processInstance;
        String processDefinitionId = null;
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            taskId = RealTaskId.getRealTaskId(taskId);
            Task task = this.taskEngineService.getTask(taskId, "0");
            processDefinitionId = task.getProcessDefinitionId();
        } else if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            processDefinitionId = processInstance.getProcessDefinitionId();
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            processDefinitionId = processInstance.getProcessDefinitionId();
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(processDefinitionId, processKey, version);
        if (workFlow == null) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        FlowModel w = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class, (Feature[])new Feature[0]);
        List elements = w.getSlots().getElement();
        JSONArray json = new JSONArray();
        for (int i = 0; i < elements.size(); ++i) {
            JSONObject object = new JSONObject();
            if ("com.jxdinfo.workflow.SubProcess".equals(((FlowObject)elements.get(i)).getName())) {
                JSONObject o = new JSONObject();
                if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() != null && ((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) {
                    o.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
                    o.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                    o.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                    o.put("taskDefinitionType", (Object)"SubProcess");
                    if ("radio".equals(o.get((Object)"multi_type"))) {
                        o.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
                    } else {
                        o.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
                    }
                    json.add((Object)o);
                }
                List elements2 = ((FlowObject)elements.get(i)).getSlots().getElement();
                for (int j = 0; j < elements2.size(); ++j) {
                    if (((FlowObject)elements2.get(j)).getProps().getFlowCountersign() == null || !((FlowObject)elements2.get(j)).getProps().getFlowCountersign().isCountersign()) continue;
                    object.put("multi_type", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignType());
                    object.put("taskDefinitionKey", (Object)((FlowObject)elements2.get(j)).getInstanceKey());
                    object.put("taskDefinitionName", (Object)((FlowObject)elements2.get(j)).getProps().getFlowName());
                    object.put("subProcessDefId", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                    object.put("subProcessDefName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                    object.put("taskDefinitionType", (Object)"UserTask");
                    if ("radio".equals(object.get((Object)"multi_type"))) {
                        object.put("multi_finish_condition", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignNumByRatio());
                    } else {
                        object.put("multi_finish_condition", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignNumByCount());
                    }
                    json.add((Object)object);
                }
                continue;
            }
            if ("com.jxdinfo.workflow.CallActivity".equals(((FlowObject)elements.get(i)).getName())) {
                if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() == null || !((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) continue;
                object.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
                object.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                object.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                object.put("taskDefinitionType", (Object)"CallActivity");
                if ("radio".equals(object.get((Object)"multi_type"))) {
                    object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
                } else {
                    object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
                }
                json.add((Object)object);
                continue;
            }
            if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() == null || !((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) continue;
            object.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
            object.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
            object.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
            object.put("taskDefinitionType", (Object)"UserTask");
            if ("radio".equals(object.get((Object)"multi_type"))) {
                object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
            } else {
                object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
            }
            json.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private HistoricProcessInstance getProcessInst(String processInstId, String businessKey, String taskId, Boolean isUnFinish) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInstId, businessKey, taskId})) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isEmpty((Object)processInstId)) {
            if (HussarUtils.isNotEmpty((Object)businessKey)) {
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (processInstance == null) {
                    throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart());
                }
                processInstId = processInstance.getId();
            } else {
                HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
                if (taskInstance == null) {
                    throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
                }
                processInstId = taskInstance.getProcessInstanceId();
            }
        } else {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
            if (processInstance == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart());
            }
        }
        processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
        if (isUnFinish != null) {
            if (isUnFinish.booleanValue()) {
                if (processInstance.getEndTime() != null) {
                    throw new PublicClientException(this.bpmConstantProperties.getProcessEnd());
                }
            } else if (processInstance.getEndTime() == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessUnEnd());
            }
        }
        return processInstance;
    }
}

