/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dao.TaskManagerMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.FreeRejectDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.vo.TaskVo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerServiceImpl
implements TaskManagerService {
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskManagerMapper taskManagerMapper;
    @Resource
    private AssigneeChooseServiceImpl assigneeChooseService;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private HistoryService historyService;
    @Autowired
    ITaskEngineService taskEngineService;
    @Autowired
    private IInstanceEngineService instanceEngineService;

    public int count() {
        return this.taskManagerMapper.count(new Date());
    }

    public List<TaskManager> getTask(Page<TaskManager> pages, GetTaskManagerDto taskManagerDto) {
        taskManagerDto.setDateTime(new Date());
        List<TaskManager> list = this.taskManagerMapper.getTask(pages, taskManagerDto);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (TaskManager taskManager : list) {
            taskIds.add(Long.parseLong(taskManager.getId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!list.isEmpty()) {
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
        }
        HashMap<String, Map> variableMap = new HashMap<String, Map>();
        for (Variables variables : allVariables) {
            if (!"todoConfiguration".equals(variables.getName()) && !"sendUser".equals(variables.getName())) continue;
            Map map2 = (Map)variableMap.get(variables.getTaskId());
            map2 = map2 == null ? new HashMap() : map2;
            map2.put(variables.getName(), variables.getTextValue());
            variableMap.put(variables.getTaskId(), map2);
        }
        for (TaskManager taskManager : list) {
            Map map2 = (Map)variableMap.get(taskManager.getId());
            map2 = map2 == null ? new HashMap() : map2;
            taskManager.setSendUser((String)map2.get("sendUser"));
            taskManager.setTodoConfiguration((String)map2.get("todoConfiguration"));
        }
        ArrayList<String> users = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            List receiver = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)taskManager.getReceivers())) {
                receiver = taskManager.getReceivers();
            }
            if (HussarUtils.isNotEmpty((Object)taskManager.getFirstReceiver())) {
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("userId", taskManager.getFirstReceiver());
                receiver.add(0, map3);
            } else if (HussarUtils.isNotEmpty((Object)taskManager.getReceivers())) {
                taskManager.setFirstReceiver((String)((Map)taskManager.getReceivers().get(0)).get("userId"));
            }
            if (HussarUtils.isNotEmpty((Object)taskManager.getSendUser())) {
                users.add(taskManager.getSendUser());
            }
            receiver.forEach(map -> users.addAll(map.values()));
        }
        HashSet hashSet = new HashSet(users);
        hashSet.remove(null);
        users.clear();
        users.addAll(hashSet);
        Map<String, String> userMap = this.assigneeChooseService.getUserListByUserId(users);
        if (userMap == null) {
            userMap = new HashMap<String, String>();
        }
        for (TaskManager taskManager : list) {
            List receiver = taskManager.getReceivers();
            ArrayList<String> name = new ArrayList<String>();
            for (Map id : receiver) {
                String userName = userMap.get(id.get("userId"));
                id.put("userName", userName);
                if (id.get("mandator") != null && HussarUtils.isNotEmpty((Object)userMap.get(id.get("mandator")))) {
                    userName = userName + "(" + userMap.get(id.get("mandator")) + ")";
                    id.put("mandatorName", userMap.get(id.get("mandator")));
                }
                name.add(userName);
            }
            taskManager.setReceiverName(name);
            taskManager.setSendUserName(userMap.get(taskManager.getSendUser()));
        }
        return list;
    }

    public ApiResponse<String> suspendTaskById(String processInsId) {
        try {
            this.instanceEngineService.suspendProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    public ApiResponse<String> activateTaskById(String processInsId) {
        try {
            this.instanceEngineService.activateProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    private Map<String, String> getFileByTaskId(String taskId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String processDefinitionId = "";
        String processInstanceId = "";
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
            if (historicTaskInstance == null) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            processDefinitionId = historicTaskInstance.getProcessDefinitionId();
            processInstanceId = historicTaskInstance.getProcessInstanceId();
            map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        } else {
            processInstanceId = processInsId;
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processDefinitionId = historicProcessInstance.getProcessDefinitionId();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processDefinitionId);
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        SysActProcessFile sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper);
        String file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        map.put("main", file);
        if (historicProcessInstance.getSuperProcessInstanceId() != null) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(historicProcessInstance.getSuperProcessInstanceId()).callProcInstId(historicProcessInstance.getId()).listPage(0, 1).get(0);
            map.put("callTaskDefinitionKey", historicActivityInstance.getActivityId());
            String procDefId = historicActivityInstance.getProcessDefinitionId();
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper);
            file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            map.put("call", file);
        }
        return map;
    }

    public ApiResponse<IPage<TaskManager>> getTaskManager(Page<TaskManager> page, GetTaskManagerDto taskManagerDto) {
        List<TaskManager> list = this.getTask(page, taskManagerDto);
        page.setRecords(list);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<TaskVo>> getJumpTasks(String taskId, String processInsId) {
        FlowModel flowModel;
        Map<String, String> flowModelMessage = this.getFileByTaskId(taskId, processInsId);
        String taskDefinitionKey = flowModelMessage.get("taskDefinitionKey");
        String subProcessNodeId = null;
        ArrayList<Object> tasks = new ArrayList<Object>();
        if (flowModelMessage.get("main") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage.get("main"), FlowModel.class);
            if (taskDefinitionKey != null) {
                FlowObject flowObject;
                Iterator iterator = flowModel.getSlots().getElement().iterator();
                while (iterator.hasNext() && !taskDefinitionKey.equals((flowObject = (FlowObject)iterator.next()).getId())) {
                    if (!"com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) continue;
                    for (FlowObject object : flowObject.getSlots().getElement()) {
                        if (!taskDefinitionKey.equals(object.getId())) continue;
                        subProcessNodeId = flowObject.getId();
                        break;
                    }
                    if (subProcessNodeId == null) continue;
                    break;
                }
            }
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                Object task;
                if ("com.jxdinfo.workflow.User".equals(flowObject.getName())) {
                    task = new TaskVo();
                    task.setId(flowObject.getId());
                    task.setValue(flowObject.getProps().getFlowName());
                    task.setType("User");
                    tasks.add(task);
                    continue;
                }
                if ("com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) {
                    task = new TaskVo();
                    task.setId(flowObject.getId());
                    task.setValue(flowObject.getProps().getFlowName());
                    task.setType("CallActivity");
                    tasks.add(task);
                    continue;
                }
                if (!"com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) continue;
                if (subProcessNodeId != null && subProcessNodeId.equals(flowObject.getId())) {
                    for (FlowObject object : flowObject.getSlots().getElement()) {
                        TaskVo task2;
                        if ("com.jxdinfo.workflow.User".equals(object.getName())) {
                            task2 = new TaskVo();
                            task2.setId(object.getId());
                            task2.setValue(object.getProps().getFlowName());
                            task2.setType("User");
                            tasks.add(task2);
                            continue;
                        }
                        if (!"com.jxdinfo.workflow.CallActivity".equals(object.getName())) continue;
                        task2 = new TaskVo();
                        task2.setId(object.getId());
                        task2.setValue(object.getProps().getFlowName());
                        task2.setType("CallActivity");
                        tasks.add(task2);
                    }
                    continue;
                }
                task = new TaskVo();
                task.setId(flowObject.getId());
                task.setValue(flowObject.getProps().getFlowName());
                task.setType("SubProcess");
                tasks.add(task);
            }
        }
        if (HussarUtils.isEmpty((Object)processInsId) && flowModelMessage.get("call") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage.get("call"), FlowModel.class);
            String callTaskDefinitionKey = flowModelMessage.get("callTaskDefinitionKey");
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                TaskVo task;
                if ("com.jxdinfo.workflow.User".equals(flowObject.getName())) {
                    task = new TaskVo();
                    task.setId("main_process_" + flowObject.getId());
                    task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                    task.setType("User");
                    tasks.add(task);
                    continue;
                }
                if ("com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) {
                    if (callTaskDefinitionKey.equals(flowObject.getId())) continue;
                    task = new TaskVo();
                    task.setId("main_process_" + flowObject.getId());
                    task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                    task.setType("CallActivity");
                    tasks.add(task);
                    continue;
                }
                if (!"com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) continue;
                task = new TaskVo();
                task.setId("main_process_" + flowObject.getId());
                task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                task.setType("SubProcess");
                tasks.add(task);
            }
        }
        return ApiResponse.success(tasks);
    }

    public BpmResponseResult rejectToFirstTask(FreeRejectDto freeRejectDto) {
        String taskId = freeRejectDto.getTaskId();
        String userId = freeRejectDto.getUserId();
        String comment = freeRejectDto.getComment();
        boolean isSubmit = true;
        return this.taskEngineService.rejectToFirstTask(taskId, userId, comment, null, true, isSubmit, null, false);
    }

    public BpmResponseResult rejectToAnyTask(FreeRejectDto freeRejectDto) {
        String taskId = freeRejectDto.getTaskId();
        String userId = freeRejectDto.getUserId();
        String comment = freeRejectDto.getComment();
        boolean isSubmit = true;
        String backActivityId = freeRejectDto.getBackActivityId();
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, null, null, isSubmit, null, false);
    }

    public BpmResponseResult rejectToLastTask(FreeRejectDto freeRejectDto) {
        String taskId = freeRejectDto.getTaskId();
        String userId = freeRejectDto.getUserId();
        String comment = freeRejectDto.getComment();
        boolean isSubmit = true;
        return this.taskEngineService.rejectToLastTask(taskId, userId, comment, null, true, isSubmit, null, null, false);
    }

    public String getFormDetailKey(String formDetailId) {
        return this.taskManagerMapper.getFormDetailKey(formDetailId);
    }
}

