/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HussarDataPushEhcacheManager;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeChatDataPush {
    private static final String TEXT = "text";
    public static final boolean IS_DATAPUSH = true;
    private static final String DATAPUSH_CACHE = "datapushCache";
    private static final long TOKEN_TIMEOUT = 40010L;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired(required=false)
    HussarDataPushEhcacheManager hussarDataPushEhcacheManager;

    public void dataPush(String str) {
        try {
            if (this.lcdpBpmProperties.isIhnIsDataPush()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("touser", this.lcdpBpmProperties.getIhnDatapushTouser());
                map.put("toparty", null);
                map.put("totag", null);
                map.put("msgtype", TEXT);
                map.put("agentid", Long.valueOf(this.lcdpBpmProperties.getIhnDataPushAgentid()));
                HashMap<String, String> textMap = new HashMap<String, String>();
                textMap.put("content", str);
                map.put(TEXT, textMap);
                String url = (this.lcdpBpmProperties.getIhnDatapushUrl() != null && this.lcdpBpmProperties.getIhnDatapushUrl().startsWith(HTTPS) ? "" : HTTP) + this.lcdpBpmProperties.getIhnDatapushUrl() + "/cgi-bin/message/send?access_token=";
                JSONObject jsonObject = JSON.parseObject((String)HttpUtil.post((String)(url + this.getAccessToken(false)), (String)JSON.toJSONString(map)));
                if (jsonObject.getLongValue("errcode") == 40010L) {
                    jsonObject = JSON.parseObject((String)HttpUtil.post((String)(url + this.getAccessToken(true)), (String)JSON.toJSONString(map)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAccessToken(boolean getnew) {
        AccessToken accessToken = (AccessToken)this.hussarDataPushEhcacheManager.getObject(DATAPUSH_CACHE, this.lcdpBpmProperties.getIhnTenantId());
        if (accessToken != null && !accessToken.isTimeOut() && !getnew) {
            return accessToken.getAccessToken();
        }
        String url = (this.lcdpBpmProperties.getIhnDatapushUrl() != null && this.lcdpBpmProperties.getIhnDatapushUrl().startsWith(HTTPS) ? "" : HTTP) + this.lcdpBpmProperties.getIhnDatapushUrl() + "/cgi-bin/gettoken";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("corpid", this.lcdpBpmProperties.getIhnDatapushCorpid());
        map.put("corpsecret", this.lcdpBpmProperties.getIhnDatapushCorpsecret());
        JSONObject jsonObject = JSONObject.parseObject((String)HttpUtil.get((String)url, map));
        this.hussarDataPushEhcacheManager.setObject(DATAPUSH_CACHE, this.lcdpBpmProperties.getIhnTenantId(), new AccessToken(jsonObject.getString("access_token"), jsonObject.getLong("expires_in")));
        return jsonObject.getString("access_token");
    }

    private static class AccessToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String accessToken;
        private final long deadTime;

        AccessToken(String accessToken, long effectiveSecond) {
            this.accessToken = accessToken;
            this.deadTime = System.currentTimeMillis() + effectiveSecond * 1000L;
        }

        boolean isTimeOut() {
            return this.deadTime < System.currentTimeMillis();
        }

        String getAccessToken() {
            return this.accessToken;
        }
    }
}

