/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCancleListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(ProcessCancleListener.class);
    @Autowired
    private BpmMsgPushService msgPushService;

    public void onEvent(ActivitiEvent event) {
        ExecutionEntity entity = Context.getCommandContext().getExecutionEntityManager().findExecutionById(event.getProcessInstanceId());
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(event.getProcessInstanceId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (historicProcessInstance.getSuperProcessInstanceId() == null) {
            if ("endProcess".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                this.endProcessMsgPush(map);
            } else {
                this.completeProcessMsgPush(map);
            }
        }
        new ProcessActionCmd(historicProcessInstance.getId(), 1).execute(Context.getCommandContext());
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5220\u9664\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void endProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("terminated");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void completeProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("complete");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void addMessage(Map<String, Object> map, BpmActMsgDetail bpmActMsgDetail) {
        bpmActMsgDetail.setProcessName(map.get("processDefinitionName").toString());
        bpmActMsgDetail.setProcessDefinitionId(map.get("processDefinitionId").toString());
        bpmActMsgDetail.setProcessKey(map.get("processDefinitionId").toString().split(":")[0]);
        ArrayList<String> user = new ArrayList<String>();
        user.add(map.get("starter").toString());
        bpmActMsgDetail.setReceive(user);
    }
}

