/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendSubProcessActivityBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.JuelExpression;
import org.activiti.engine.impl.el.ParsingElContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;

public class ExtendParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    private static final String VARIABLE_NAME = "multiInstanceAssignee";
    private static final String USER_ID = "userId";
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private ICandidateUserService candidateUserService = (ICandidateUserService)SpringContextHolder.getApplicationContext().getBean(ICandidateUserService.class);
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    private TaskManagerService taskManagerService = (TaskManagerService)SpringContextHolder.getApplicationContext().getBean(TaskManagerService.class);

    public ExtendParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected void createInstances(ActivityExecution execution) throws Exception {
        ArrayList<String> messageType;
        List<Map<String, String>> users;
        int nrOfInstances;
        List timeOutElement;
        boolean flag = "callActivity".equals(execution.getActivity().getProperty("type")) || "subProcess".equals(execution.getActivity().getProperty("type"));
        BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        String timeOutStrategy = null;
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        if (!flag && HussarUtils.isNotEmpty((Object)(timeOutElement = (List)element.getExtensionElements().get("TimeOutStrategy"))) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutElement.get(0)).getAttributes())) {
            timeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)timeOutElement.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
        }
        int n = nrOfInstances = (users = this.getUser(bm, execution, flag, messageType = new ArrayList<String>())) == null ? 0 : users.size();
        if (nrOfInstances == 0 && ((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId()) instanceof SubProcess) {
            HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
            historicActivityInstance.setSubProcessKey("");
            historicActivityInstance.setCycleCount(Integer.valueOf(0));
        }
        HashMap<String, Object> map = flag ? new HashMap() : AnalyticalModelUtil.getCcUser(bm, execution);
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = execution.createExecution();
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        ArrayList<String> userList = new ArrayList<String>();
        ArrayList<TaskEntity> skipTaskEntityList = new ArrayList<TaskEntity>();
        Date date = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            TaskEntity taskEntity = null;
            taskEntity = loopCounter == 0 ? this.executeBpmOriginalBehavior(concurrentExecution, loopCounter, users, flag, userList, timeOutStrategy, map, date) : this.executeBpmOriginalBehavior(concurrentExecution, loopCounter, users, flag, userList, timeOutStrategy, null, date);
            if (taskEntity == null) continue;
            skipTaskEntityList.add(taskEntity);
        }
        execution.removeVariable("reject_from");
        execution.removeVariable("reject_to");
        execution.removeVariable("reject_execution");
        if (!flag) {
            execution.removeVariable("TimeOutStrategy");
        }
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
        if (HussarUtils.isNotEmpty(skipTaskEntityList)) {
            for (TaskEntity taskEntity : skipTaskEntityList) {
                taskEntity.setVariableLocal("sendUser", (Object)taskEntity.getAssignee());
                taskEntity.setVariableLocal("taskSourceFlag", (Object)"skip");
                Context.getCommandContext().addAttribute("skipOrSatisfied", (Object)"skip");
                taskEntity.complete(null, false);
                String skipOrSatisfied = (String)Context.getCommandContext().getAttribute("skipOrSatisfied");
                Context.getCommandContext().addAttribute("skipOrSatisfied", null);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setTaskId(taskEntity.getId());
                    dataPush.setUserId(String.join((CharSequence)",", userList));
                    dataPush.setEndDate(new Date());
                    this.dataPushService.completeDataPush(dataPush);
                }
                if (!HussarUtils.isNotEmpty((Object)skipOrSatisfied) || !skipOrSatisfied.equals("satisfied")) continue;
                break;
            }
        }
        List<Object> receiveUser = new ArrayList();
        if (HussarUtils.isNotEmpty(users)) {
            receiveUser = users.stream().filter(Objects::nonNull).map(o -> (String)o.get(USER_ID)).collect(Collectors.toList());
            receiveUser.removeAll(userList);
        }
        if (!"revoke".equals(Context.getCommandContext().getAttribute("taskSourceFlag")) && HussarUtils.isNotEmpty(receiveUser) && nrOfInstances != 0 && !"main_process_start".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setProcessKey(((ExecutionEntity)execution).getProcessDefinitionKey());
            bpmActMsgDetail.setProcessName(((ExecutionEntity)execution).getProcessDefinition().getName());
            bpmActMsgDetail.setProcessDefinitionId(((ExecutionEntity)execution).getProcessDefinition().getId());
            bpmActMsgDetail.setTaskDefKey(((ExecutionEntity)execution).getActivityId());
            bpmActMsgDetail.setTaskDefName(execution.getCurrentActivityName());
            bpmActMsgDetail.setReceive(receiveUser);
            bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? (String)messageType.get(0) : null);
            if ("reject".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                bpmActMsgDetail.setSceneCode("reject");
            } else {
                bpmActMsgDetail.setSceneCode("todo");
            }
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
        if (nrOfInstances == 0) {
            this.leave(execution);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TaskEntity executeBpmOriginalBehavior(ActivityExecution execution, int loopCounter, List<Map<String, String>> collection, boolean flag, List<String> userList, String timeOutStrategy, Map<String, Object> ccUserMap, Date date) throws Exception {
        Map<String, String> value = null;
        if (collection != null && !collection.isEmpty()) {
            Iterator<Map<String, String>> it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, VARIABLE_NAME, value != null ? value.get(USER_ID) : null);
        }
        if (loopCounter == 0) {
            if (!flag) return this.insertTask(execution, value, true, userList, timeOutStrategy, ccUserMap, date);
            if (this.innerActivityBehavior instanceof ExtendSubProcessActivityBehavior) {
                ActivityExecution subProcessExecution = execution.createExecution();
                subProcessExecution.setActive(true);
                subProcessExecution.setConcurrent(false);
                subProcessExecution.setScope(true);
                this.innerActivityBehavior.execute(subProcessExecution);
                return null;
            } else {
                this.innerActivityBehavior.execute(execution);
            }
            return null;
        } else {
            if (!flag) return this.insertTask(execution, value, false, userList, timeOutStrategy, ccUserMap, date);
            execution.executeActivity((PvmActivity)this.activity);
        }
        return null;
    }

    private void ccTask(Task task, Set<String> users, String userId, ActivityExecution execution) {
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(task.getFormKey());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                Map map = ((TaskEntity)task).getVariables();
                if (HussarUtils.isNotEmpty((Object)map)) {
                    sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActCcTask);
            }
        }
        if (!list.isEmpty()) {
            this.iSysActCcTaskService.saveBatch(list);
        }
    }

    private JSONArray getRightActivity(JSONArray allCallActivityInfos, ActivityExecution execution) {
        JSONArray callActivityInfos = new JSONArray();
        for (Object allCallActivityInfo : allCallActivityInfos) {
            JSONObject object = (JSONObject)allCallActivityInfo;
            if (!HussarUtils.isEmpty((Object)object.get((Object)"taskDefinitionKey")) && !((ExecutionEntity)execution).getActivityId().equals(object.get((Object)"taskDefinitionKey"))) continue;
            callActivityInfos.add((Object)object);
        }
        return callActivityInfos;
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return (T)Context.getCommandContext().getSession(sessionClass);
    }

    private TaskEntity insertTask(ActivityExecution execution, Map<String, String> userMap, boolean flag, List<String> userList, String timeOutStrategy, Map<String, Object> ccUserMap, Date date) {
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.create((Date)date);
        Object separatedVariable = execution.getVariable("sub_process_key");
        if (HussarUtils.isNotEmpty((Object)separatedVariable)) {
            Integer cycleCount = (Integer)execution.getVariable("cycle_count");
            task.setSubProcessKey((String)separatedVariable);
            task.setCycleCount(cycleCount);
        }
        task.insert((ExecutionEntity)execution);
        task.setExecution((DelegateExecution)execution);
        TaskDefinition taskDefinition = (TaskDefinition)execution.getActivity().getProperty("taskDefinition");
        Expression activeNameExpression = null;
        Expression activeDescriptionExpression = null;
        Expression activeDueDateExpression = null;
        Expression activePriorityExpression = null;
        Expression activeCategoryExpression = null;
        Expression activeFormKeyExpression = null;
        Expression activeSkipExpression = null;
        Expression activeAssigneeExpression = null;
        Expression activeOwnerExpression = null;
        Set<Expression> activeCandidateUserExpressions = null;
        Set<Expression> activeCandidateGroupExpressions = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)execution.getActivity().getId(), (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            activeSkipExpression = this.getActiveValue(taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = taskDefinition.getNameExpression();
            activeDescriptionExpression = taskDefinition.getDescriptionExpression();
            activeDueDateExpression = taskDefinition.getDueDateExpression();
            activePriorityExpression = taskDefinition.getPriorityExpression();
            activeCategoryExpression = taskDefinition.getCategoryExpression();
            activeFormKeyExpression = taskDefinition.getFormKeyExpression();
            activeSkipExpression = taskDefinition.getSkipExpression();
        }
        task.setTaskDefinition(taskDefinition);
        if (activeNameExpression != null) {
            String name = null;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description = null;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null && (dueDate = activeDueDateExpression.getValue((VariableScope)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.parseInt((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        Map extensionElementsNode = bm.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements();
        boolean skip = false;
        if (extensionElementsNode.get("skiprepetition") != null) {
            Object taskSourceFlag;
            String skipTypeValue = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue();
            List hisTaskList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).listPage(0, 1);
            if (hisTaskList != null && !hisTaskList.isEmpty() && ((taskSourceFlag = Context.getCommandContext().getAttribute("taskSourceFlag")) == null || "complete".equals(taskSourceFlag))) {
                List<String> skipList = Arrays.asList(skipTypeValue.split(","));
                if (skipList.contains("1") && HussarUtils.isEmpty((Object)userMap.get(USER_ID))) {
                    if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                        this.activityRedisTimer.delTimeOutModel(task.getId());
                    }
                    skip = true;
                }
                if (skipList.contains("2")) {
                    Object lastActivityId = task.getVariable("all_prev_node");
                    ArrayList<String> lastNodeAssignees = new ArrayList<String>();
                    if (HussarUtils.isNotEmpty((Object)lastActivityId)) {
                        String lastTaskDefinitionKey = lastActivityId.toString().replace("'", "");
                        List<String> lastTaskDefinitionKeyList = Arrays.asList(lastTaskDefinitionKey.split(","));
                        block6: for (String taskDefinitionKey : lastTaskDefinitionKeyList) {
                            List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(taskDefinitionKey)).orderByHistoricTaskInstanceEndTime().desc()).list();
                            historicTaskInstances.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                            if (!HussarUtils.isNotEmpty((Object)historicTaskInstances)) continue;
                            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)historicTaskInstances.get(0);
                            lastNodeAssignees.add(historicTaskInstance.getAssignee());
                            Date start = historicTaskInstance.getStartTime();
                            for (int j = 1; j < historicTaskInstances.size(); ++j) {
                                HistoricTaskInstance hisTask = (HistoricTaskInstance)historicTaskInstances.get(j);
                                if (start.getTime() > hisTask.getEndTime().getTime()) continue block6;
                                if (hisTask.getCreateTime().compareTo(start) < 0) {
                                    start = hisTask.getCreateTime();
                                }
                                lastNodeAssignees.add(hisTask.getOriginalAssignee());
                            }
                        }
                    }
                    if (userMap != null && HussarUtils.isNotEmpty(lastNodeAssignees)) {
                        for (String lastNodeAssignee : lastNodeAssignees) {
                            if (!userMap.get(USER_ID).equals(lastNodeAssignee)) continue;
                            task.setAssignee(lastNodeAssignee);
                            skip = true;
                            if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) break;
                            this.activityRedisTimer.delTimeOutModel(task.getId());
                            break;
                        }
                    }
                }
            }
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            delayToAssign = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign")).get(0)).getValue();
        }
        if (userMap != null && !userMap.isEmpty() && userMap.get(USER_ID) != null && !userMap.get(USER_ID).equals("")) {
            if (!"true".equals(delayToAssign)) {
                task.addCandidateUser(userMap.get(USER_ID), userMap.get("mandator"), "1");
            } else {
                String taskId = task.getId();
                CandidateUser tmp = new CandidateUser();
                tmp.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                if (userMap.get("mandator") != null) {
                    tmp.setAssignee(userMap.get("mandator"));
                } else {
                    tmp.setAssignee(userMap.get(USER_ID));
                }
                this.candidateUserService.save((Object)tmp);
            }
        }
        task.fireEvent("create");
        this.setVariables(task, execution.getVariables());
        if (HussarUtils.isNotEmpty(ccUserMap)) {
            Set ccUsers = (Set)ccUserMap.get("ccUser");
            String sendUserId = (String)ccUserMap.get("ccSendUser");
            if (HussarUtils.isNotEmpty((Object)ccUsers) && HussarUtils.isNotEmpty((Object)sendUserId)) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution);
            }
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (!skip && HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            timeOutModel.setAssignee(userMap.get(USER_ID));
            timeOutModel.setTimeOutType(timeOutStrategy);
            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", task.getName());
                map.put("processInsId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("todoConfiguration", task.getVariable("todoConfiguration"));
                map.put("sendUser", task.getVariable("sendUser"));
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (flag) {
            this.insertActHiActinst(execution, userMap != null ? userMap.get(USER_ID) : null, task);
        }
        task.fireEvent("start");
        if (skip) {
            if (HussarUtils.isNotEmpty((Object)userMap.get(USER_ID))) {
                userList.add(userMap.get(USER_ID));
                this.completeDataPush(task, userMap.get(USER_ID));
            }
            return task;
        }
        return null;
    }

    private void setVariables(TaskEntity task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.isEmpty()) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        String todo = !newVariables.isEmpty() ? AnalyticalModelUtil.getTodo(newVariables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        task.setVariableLocal("todoConfiguration", (Object)todo);
        if (newVariables.containsKey("all_prev_node")) {
            task.setVariableLocal("all_prev_node", newVariables.get("all_prev_node"));
        }
        if (newVariables.containsKey("reject_to")) {
            task.setVariableLocal("reject_from", newVariables.get("reject_from"));
            task.setVariableLocal("reject_to", newVariables.get("reject_to"));
            if (newVariables.containsKey("reject_execution")) {
                task.setVariableLocal("reject_execution", newVariables.get("reject_execution"));
            }
        }
    }

    public void leave(ActivityExecution execution) {
        ExecutionEntity executionEntity;
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution);
        ActivityExecution newExecution = execution;
        if (this.innerActivityBehavior instanceof ExtendSubProcessActivityBehavior) {
            executionEntity = (ExecutionEntity)execution;
            newExecution = execution.getParent();
            executionEntity.remove();
        }
        if (TaskEngineServiceImpl.getSubProcessRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        if (TaskEngineServiceImpl.getCallRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        if (nrOfInstances == 0) {
            execution.setVariableLocal("all_prev_node", (Object)("'" + ((ExecutionEntity)execution).getActivityId() + "'"));
            super.leave(execution);
        } else {
            int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
            int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
            int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
            if (newExecution.getParent() != null) {
                this.setLoopVariable(newExecution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
                this.setLoopVariable(newExecution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
            }
            this.logLoopDetails(newExecution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
            executionEntity = (ExecutionEntity)newExecution;
            if (executionEntity.getParent() != null) {
                String currActivityId = executionEntity.getActivityId();
                if (executionEntity.getParent().getParent() != null) {
                    String skip = (String)Context.getCommandContext().getAttribute("skipOrSatisfied");
                    if (HussarUtils.isNotEmpty((Object)skip) && skip.equals("skip")) {
                        String all_prev_node = (String)executionEntity.getParent().getParent().getVariableLocal("all_prev_node");
                        executionEntity.getParent().getParent().setVariableLocal("all_prev_node", (Object)("'" + all_prev_node + "'"));
                    } else {
                        executionEntity.getParent().getParent().setVariableLocal("all_prev_node", (Object)("'" + currActivityId + "'"));
                    }
                }
                executionEntity.inactivate();
                executionEntity.getParent().forceUpdate();
                List joinedExecutions = executionEntity.findInactiveConcurrentExecutions(newExecution.getActivity());
                if (nrOfCompletedInstances >= nrOfInstances || this.completionConditionSatisfied(newExecution)) {
                    Context.getCommandContext().addAttribute("skipOrSatisfied", (Object)"satisfied");
                    execution.removeVariable("reject_appoint_assignee");
                    ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
                    for (ActivityExecution childExecution : executionEntity.getParent().getExecutions()) {
                        if (!childExecution.isActive()) continue;
                        executionsToRemove.add((ExecutionEntity)childExecution);
                    }
                    ArrayList<String> updateTaskIds = new ArrayList<String>();
                    for (ExecutionEntity executionEntity2 : executionsToRemove) {
                        this.getExecutionAllTasks(updateTaskIds, executionEntity2);
                    }
                    StringBuilder taskIds = new StringBuilder();
                    for (String taskId : updateTaskIds) {
                        taskIds.append(",").append(taskId);
                    }
                    if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                        this.activityRedisTimer.delTimeOutModel(taskIds.toString().substring(1));
                    }
                    if (HussarUtils.isNotEmpty(updateTaskIds)) {
                        List<Long> list = updateTaskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                        TaskEntityManager taskEntityManager = Context.getCommandContext().getTaskEntityManager();
                        String processKey = "";
                        for (String taskId : updateTaskIds) {
                            TaskEntity taskEntity = taskEntityManager.findTaskById(taskId);
                            processKey = taskEntity.getProcessDefinitionId().split(":")[0];
                            taskEntityManager.deleteTask(taskEntity, "", true, "");
                        }
                        this.taskEngineMapper.removeMultiHistoryTask(list);
                        if (this.dataPushService.isDataPush()) {
                            DataPush dataPush = new DataPush();
                            dataPush.setProcessKey(processKey);
                            dataPush.setTaskIds(updateTaskIds);
                            this.dataPushService.deleteMultiTask(dataPush);
                        }
                        List ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, list));
                        String unDelTaskId = null;
                        HashSet<String> taskIdSet = new HashSet<String>(updateTaskIds);
                        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).taskDefinitionKey(execution.getActivity().getId())).list();
                        for (Object historicTaskInstance : historicTaskInstanceList) {
                            if (taskIdSet.contains(historicTaskInstance.getId())) continue;
                            unDelTaskId = historicTaskInstance.getId();
                        }
                        if (HussarUtils.isNotEmpty((Object)ccTasks) && HussarUtils.isNotEmpty(unDelTaskId)) {
                            ArrayList<String> userList = new ArrayList<String>();
                            for (SysActCcTask ccTask : ccTasks) {
                                ccTask.setTaskId(Long.valueOf(Long.parseLong(unDelTaskId)));
                                userList.add(ccTask.getReceiveUser());
                            }
                            this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                            if (this.dataPushService.isDataPush()) {
                                DataPush dataPush = new DataPush();
                                dataPush.setUserId(String.join((CharSequence)",", userList));
                                dataPush.setTaskId(unDelTaskId);
                                this.dataPushService.addCcTask(dataPush);
                            }
                        }
                    }
                    for (ExecutionEntity executionEntity3 : executionsToRemove) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Execution {} still active, but multi-instance is completed. Removing this execution.", (Object)executionEntity3);
                        }
                        this.handleDataPush((TaskEntity)executionEntity3.getTasks().get(0));
                        executionEntity3.inactivate();
                        executionEntity3.deleteCascade("multi-instance completed");
                    }
                    executionEntity.takeAll(executionEntity.getActivity().getOutgoingTransitions(), joinedExecutions);
                }
            } else {
                execution.setVariableLocal("all_prev_node", (Object)("'" + ((ExecutionEntity)execution).getActivityId() + "'"));
                super.leave((ActivityExecution)executionEntity);
            }
        }
    }

    private void getExecutionAllTasks(List<String> taskIds, ExecutionEntity executionEntity) {
        block3: {
            block4: {
                block2: {
                    if (!HussarUtils.isNotEmpty((Object)executionEntity.getExecutions())) break block2;
                    for (ExecutionEntity execution : executionEntity.getExecutions()) {
                        this.getExecutionAllTasks(taskIds, execution);
                    }
                    break block3;
                }
                if (!HussarUtils.isNotEmpty((Object)executionEntity.getSubProcessInstance())) break block4;
                this.getExecutionAllTasks(taskIds, executionEntity.getSubProcessInstance());
                break block3;
            }
            if (!HussarUtils.isNotEmpty((Object)executionEntity.getTasks())) break block3;
            TaskEntityManager taskEntityManager = Context.getCommandContext().getTaskEntityManager();
            for (TaskEntity taskEntity : executionEntity.getTasks()) {
                taskEntityManager.deleteTask(taskEntity, "", true, "");
                taskIds.add(taskEntity.getId());
            }
        }
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        Object multiType = execution.getVariable("multi_type");
        if (HussarUtils.isNotEmpty((Object)multiType)) {
            ValueExpression valueExpression;
            JuelExpression expression;
            Object value;
            String condition = "";
            if ("0".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances/nrOfInstances >=" + Double.parseDouble(String.valueOf(execution.getVariable("multi_finish_condition"))) / 100.0 + "}";
            }
            if ("1".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances == " + Integer.parseInt(String.valueOf(execution.getVariable("multi_finish_condition"))) + " }";
            }
            if (!((value = (expression = new JuelExpression(valueExpression = expressionFactory.createValueExpression((ELContext)new ParsingElContext(), condition, Object.class), condition)).getValue((VariableScope)execution)) instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + expression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue((VariableScope)execution);
            if (!(value instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    private void insertActHiActinst(ActivityExecution execution, String userId, TaskEntity task) {
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInsId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInsId);
        historicActivityInstance.setExecutionId(executionId);
        historicActivityInstance.setActivityId(execution.getActivity().getId());
        historicActivityInstance.setActivityName((String)execution.getActivity().getProperty("name"));
        historicActivityInstance.setActivityType((String)execution.getActivity().getProperty("type"));
        historicActivityInstance.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        historicActivityInstance.setAssignee(userId);
        historicActivityInstance.setTaskId(task.getId());
        Object separatedVariable = execution.getVariable("sub_process_key");
        if (HussarUtils.isNotEmpty((Object)separatedVariable)) {
            Integer cycleCount = (Integer)execution.getVariable("cycle_count");
            historicActivityInstance.setSubProcessKey((String)separatedVariable);
            historicActivityInstance.setCycleCount(cycleCount);
        }
        this.getDbSqlSession().insert((PersistentObject)historicActivityInstance);
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.isEmpty()) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    protected List<Map<String, String>> getUser(BpmnModel bm, ActivityExecution execution, boolean flag, List<String> messageType) {
        ArrayList<Map<String, String>> collection = new ArrayList<Map<String, String>>();
        if (flag) {
            FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId());
            if (flowElement instanceof CallActivity) {
                JSONArray allCallActivityInfos;
                JSONArray callActivityInfos = null;
                JSONArray jSONArray = allCallActivityInfos = execution.getVariable("call_activity_info") == null ? null : JSONArray.parseArray((String)JSON.toJSONString((Object)execution.getVariable("call_activity_info"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                if (HussarUtils.isNotEmpty(allCallActivityInfos)) {
                    callActivityInfos = this.getRightActivity(allCallActivityInfos, execution);
                }
                if (HussarUtils.isNotEmpty(callActivityInfos)) {
                    for (Object object : callActivityInfos) {
                        collection.add(null);
                    }
                    return collection;
                }
                List<Object> list = new ArrayList();
                CallActivity callActivity = (CallActivity)flowElement;
                String processDefinitionJson = callActivity.getCalledElement();
                if (HussarUtils.isNotEmpty((Object)processDefinitionJson)) {
                    list = Arrays.asList(processDefinitionJson.split(","));
                }
                for (int i = 0; i < list.size(); ++i) {
                    collection.add(null);
                }
                return collection;
            }
            if (flowElement instanceof SubProcess) {
                String subProcessVariable;
                String appointMsg;
                Map subProcessRejectAppointMsg = (Map)Context.getCommandContext().getAttribute("subProcessRejectAppointMsg");
                if (subProcessRejectAppointMsg != null && (appointMsg = (String)subProcessRejectAppointMsg.get(execution.getCurrentActivityId())) != null) {
                    execution.setVariable("sub_process_variable", (Object)appointMsg);
                    for (int i = 0; i < appointMsg.split(",").length; ++i) {
                        collection.add(null);
                    }
                    return collection;
                }
                FlowElement element = bm.getFlowElement(execution.getActivity().getId());
                List instanceModeNode = (List)element.getExtensionElements().get("instanceMode");
                String instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)instanceModeNode.get(0)).getAttributes().get("instanceMode")).get(0)).getValue();
                if (instanceMode.equals("assignee")) {
                    HashSet<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, false, null);
                    execution.setVariable("sub_process_variable", (Object)String.join((CharSequence)",", users));
                    if (users.isEmpty()) {
                        throw new PublicClientException("\u6d41\u7a0b\u8fd0\u8f6c\u5230" + execution.getCurrentActivityName() + "\u65f6\u5b50\u6d41\u7a0b\u542f\u52a8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7981\u6b62\u64cd\u4f5c\uff01");
                    }
                    for (int i = 0; i < users.size(); ++i) {
                        collection.add(null);
                    }
                    return collection;
                }
                ArrayList<Object> list = new ArrayList();
                List subProcessVariableConfigNode = (List)element.getExtensionElements().get("subProcessVariableConfig");
                String subProcessVariableConfig = ((ExtensionAttribute)((List)((ExtensionElement)subProcessVariableConfigNode.get(0)).getAttributes().get("subProcessVariableConfig")).get(0)).getValue();
                String string = subProcessVariable = execution.getVariable(subProcessVariableConfig) == null ? "" : String.valueOf(execution.getVariable(subProcessVariableConfig));
                if (subProcessVariable == null) {
                    throw new PropertyNotFoundException();
                }
                execution.setVariable("sub_process_variable", (Object)subProcessVariable);
                if (HussarUtils.isNotEmpty((Object)subProcessVariable)) {
                    list = new ArrayList<String>(new HashSet<String>(Arrays.asList(subProcessVariable.split(","))));
                }
                if (list.isEmpty()) {
                    throw new PublicClientException("\u6d41\u7a0b\u8fd0\u8f6c\u5230" + execution.getCurrentActivityName() + "\u65f6\u5b50\u6d41\u7a0b\u542f\u52a8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7981\u6b62\u64cd\u4f5c\uff01");
                }
                for (int i = 0; i < list.size(); ++i) {
                    collection.add(null);
                }
                return collection;
            }
        }
        Map<String, String> map = AnalyticalModelUtil.getEntrustCandidateUser(bm, ((ExecutionEntity)execution).getActivityId(), execution, false, null, messageType);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            if (map.get(entry.getKey()) != null) {
                userMap.put(USER_ID, entry.getValue());
                userMap.put("mandator", entry.getKey());
            } else {
                userMap.put(USER_ID, entry.getKey());
            }
            collection.add(userMap);
        }
        if (HussarUtils.isEmpty(collection)) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put(USER_ID, "");
            collection.add(userMap);
        }
        return collection;
    }

    protected int resolveNrOfInstances(ActivityExecution execution) {
        boolean flag = "callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"));
        BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        List<Map<String, String>> users = this.getUser(bm, execution, flag, null);
        return users == null ? 0 : users.size();
    }

    public void execute(ActivityExecution execution) throws Exception {
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            try {
                this.createInstances(execution);
            }
            catch (BpmnError var3) {
                ErrorPropagation.propagateError((BpmnError)var3, (ActivityExecution)execution);
            }
        } else if (this.innerActivityBehavior instanceof ExtendSubProcessActivityBehavior) {
            ActivityExecution subProcessExecution = execution.createExecution();
            subProcessExecution.setActive(true);
            subProcessExecution.setConcurrent(false);
            subProcessExecution.setScope(true);
            this.innerActivityBehavior.execute(subProcessExecution);
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    private void completeDataPush(TaskEntity task, String userId) {
        String processInstanceId = task.getProcessInstanceId();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", processInstance.getStartUserId());
        map.put("start_time", processInstance.getStartTime().getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInstance.getProcessDefinitionName());
        map.put("title", task.getVariable("todoConfiguration"));
        HistoricTaskInstance hisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId())).singleResult();
        ArrayList previousTasks = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)hisTask)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", hisTask.getId());
            StringBuilder formDetailId = new StringBuilder();
            formDetailId.append(hisTask.getProcessDefinitionId()).append(hisTask.getTaskDefinitionKey());
            String formDetailKey = this.taskManagerService.getFormDetailKey(formDetailId.toString());
            String jumpUrl = null;
            String pcJumpUrl = null;
            if (ToolUtil.isNotEmpty((Object)formDetailKey)) {
                String webUrl;
                Map formKeyMap = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                String mobileUrl = (String)formKeyMap.get("mobile");
                if (ToolUtil.isNotEmpty((Object)mobileUrl)) {
                    jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), hisTask.getId(), processInstance.getProcessDefinitionKey(), hisTask.getTaskDefinitionKey());
                }
                if (ToolUtil.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                    pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), hisTask.getId(), processInstance.getProcessDefinitionKey(), hisTask.getTaskDefinitionKey());
                }
            }
            taskMap.put("touser", userId);
            taskMap.put("jump_url", jumpUrl);
            taskMap.put("pc_jump_url", pcJumpUrl);
            taskMap.put("task_status", 1);
            taskMap.put("assign_time", hisTask.getEndTime().getTime() / 1000L);
            previousTasks.add(taskMap);
        }
        map.put("previous_tasks", previousTasks);
        CommonCodeUtil.taskDataPush(task.getTenantId(), map);
    }

    private void handleDataPush(TaskEntity task) {
        String processInstanceId = task.getProcessInstanceId();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", processInstance.getStartUserId());
        map.put("start_time", processInstance.getStartTime().getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInstance.getProcessDefinitionName());
        map.put("title", task.getVariable("todoConfiguration"));
        ArrayList previousTasks = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)task)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", task.getId());
            StringBuilder formDetailId = new StringBuilder();
            formDetailId.append(task.getProcessDefinitionId()).append(task.getTaskDefinitionKey());
            String formDetailKey = this.taskManagerService.getFormDetailKey(formDetailId.toString());
            String jumpUrl = null;
            String pcJumpUrl = null;
            if (ToolUtil.isNotEmpty((Object)formDetailKey)) {
                String webUrl;
                Map formKeyMap = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                String mobileUrl = (String)formKeyMap.get("mobile");
                if (ToolUtil.isNotEmpty((Object)mobileUrl)) {
                    jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), task.getId(), processInstance.getProcessDefinitionKey(), task.getTaskDefinitionKey());
                }
                if (ToolUtil.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                    pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), task.getId(), processInstance.getProcessDefinitionKey(), task.getTaskDefinitionKey());
                }
            }
            taskMap.put("touser", task.getAssignee());
            taskMap.put("jump_url", jumpUrl);
            taskMap.put("pc_jump_url", pcJumpUrl);
            taskMap.put("task_status", 1);
            taskMap.put("assign_time", new Date().getTime() / 1000L);
            previousTasks.add(taskMap);
        }
        map.put("previous_tasks", previousTasks);
        CommonCodeUtil.taskDataPush(task.getTenantId(), map);
    }
}

