/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class MultiInstanceDelAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected String taskId;
    private List<String> assignees;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);

    public MultiInstanceDelAssigneeCmd(String executionId, String taskId, List<String> assignees) {
        this.executionId = executionId;
        this.taskId = taskId;
        this.assignees = assignees;
    }

    public Void execute(CommandContext commandContext) {
        ActivityBehavior activityBehavior;
        List executionEntities;
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        HistoryService historyService = pec.getHistoryService();
        TaskService taskService = pec.getTaskService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        int num = 1;
        if (nrOfInstances == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), Boolean.valueOf(false));
        }
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        String processKey = ee.getProcessDefinitionKey();
        if (this.assignees != null && !this.assignees.isEmpty()) {
            Object longUpdateTaskIds;
            List ccTasks;
            executionEntities = ee.getParent().getExecutions();
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<Long> longTaskIds = new ArrayList<Long>();
            ArrayList<ExecutionEntity> entities = new ArrayList<ExecutionEntity>();
            String unDelTaskId = null;
            for (ExecutionEntity entity : executionEntities) {
                if (HussarUtils.isNotEmpty((Object)entity.getTasks()) && this.isTaskAssignee(entity)) {
                    longTaskIds.add(Long.parseLong(((TaskEntity)entity.getTasks().get(0)).getId()));
                    taskIds.add(((TaskEntity)entity.getTasks().get(0)).getId());
                    entities.add(entity);
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)entity.getTasks())) continue;
                unDelTaskId = ((TaskEntity)entity.getTasks().get(0)).getId();
            }
            num = entities.size();
            if (nrOfInstances == num) {
                throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), Boolean.valueOf(false));
            }
            if (num == 0) {
                return null;
            }
            this.taskEngineMapper.removeMultiHistoryTask(longTaskIds);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(taskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
            this.deleteMultiTaskDataPush(taskEntity);
            if (HussarUtils.isNotEmpty((Object)unDelTaskId) && HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, longUpdateTaskIds = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()))))) && !ccTasks.isEmpty()) {
                ArrayList<String> userList = new ArrayList<String>();
                for (SysActCcTask ccTask : ccTasks) {
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(unDelTaskId)));
                    userList.add(ccTask.getReceiveUser());
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(String.join((CharSequence)",", userList));
                    dataPush.setTaskId(unDelTaskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
            if (((TaskEntity)((ExecutionEntity)entities.get(0)).getTasks().get(0)).getDueDate() != null) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            ee = (ExecutionEntity)entities.get(0);
            for (ExecutionEntity entity : entities) {
                entity.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(entity);
            }
        } else {
            List ccTasks;
            this.taskEngineMapper.removeMultiHistoryTask(new ArrayList<Long>(Collections.singletonList(Long.parseLong(this.taskId))));
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(new ArrayList<String>(Collections.singletonList(this.taskId)));
                this.dataPushService.deleteMultiTask(dataPush);
            }
            executionEntities = ee.getParent().getExecutions();
            String unDelTaskId = null;
            for (ExecutionEntity entity : executionEntities) {
                if (!HussarUtils.isNotEmpty((Object)entity.getTasks()) || this.taskId.equals(((TaskEntity)entity.getTasks().get(0)).getId())) continue;
                unDelTaskId = ((TaskEntity)entity.getTasks().get(0)).getId();
                break;
            }
            if (HussarUtils.isNotEmpty(unDelTaskId) && HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)Long.parseLong(this.taskId)))))) {
                ArrayList<String> userList = new ArrayList<String>();
                for (SysActCcTask ccTask : ccTasks) {
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(unDelTaskId)));
                    userList.add(ccTask.getReceiveUser());
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(String.join((CharSequence)",", userList));
                    dataPush.setTaskId(unDelTaskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances - num);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        if (num > 1) {
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(ee, "nrOfActiveInstances", nrOfActiveInstances - num + 1);
        }
        if ((activityBehavior = ee.getActivity().getActivityBehavior()) instanceof ExtendParallelMultiInstanceBehavior) {
            ((ExtendParallelMultiInstanceBehavior)activityBehavior).leave((ActivityExecution)ee);
        }
        return null;
    }

    private boolean isTaskAssignee(ExecutionEntity entity) {
        return this.assignees.contains(((IdentityLinkEntity)((TaskEntity)entity.getTasks().get(0)).getIdentityLinks().get(0)).getUserId()) || this.assignees.contains(((TaskEntity)entity.getTasks().get(0)).getAssignee());
    }

    private void deleteMultiTaskDataPush(TaskEntity taskEntity) {
        String processInstanceId = taskEntity.getProcessInstanceId();
        ExecutionEntity processInstance = taskEntity.getProcessInstance();
        List identityLinks = processInstance.getIdentityLinks();
        String starter = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            starter = identityLinkEntity.getUserId();
            break;
        }
        HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Date date = new Date();
        if (ToolUtil.isNotEmpty((Object)processInst)) {
            date = processInst.getStartTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", starter);
        map.put("start_time", date.getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInstance.getProcessDefinitionName());
        map.put("title", taskEntity.getVariable("todoConfiguration"));
        ArrayList previousTasks = new ArrayList();
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("taskid", taskEntity.getId());
        taskMap.put("touser", taskEntity.getAssignee());
        taskMap.put("jump_url", null);
        taskMap.put("pc_jump_url", null);
        taskMap.put("task_status", 5);
        taskMap.put("assign_time", new Date().getTime() / 1000L);
        previousTasks.add(taskMap);
        map.put("previous_tasks", previousTasks);
        CommonCodeUtil.taskDataPush(processInstance.getTenantId(), map);
    }
}

