/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class EntrustAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    private TaskManagerService taskManagerService = (TaskManagerService)SpringContextHolder.getBean(TaskManagerService.class);
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;

    public EntrustAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            this.userId = taskEntity.getAssignee();
            taskEntity.addCandidateUser(this.mandatary);
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
            this.todoEntrustDataPush(taskEntity, this.userId, this.mandatary, new Date(), this.taskId);
            return null;
        }
        if (this.isSame) {
            taskEntity.deleteCandidateUser(this.userId);
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, null);
            this.todoEntrustDataPush(taskEntity, this.userId, this.mandatary, new Date(), this.taskId);
        }
        List identityLinks = taskEntity.getCandidates();
        if (HussarUtils.isNotEmpty((Object)this.userId)) {
            taskEntity.deleteCandidateUser(this.userId);
            taskEntity.addCandidateUsers(Arrays.asList(this.mandatary.split(",")));
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
            this.todoEntrustDataPush(taskEntity, this.userId, this.mandatary, new Date(), this.taskId);
        } else {
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(this.mandatary.split(",")));
            ArrayList<String> currentUsers = new ArrayList<String>();
            for (IdentityLink identityLink : identityLinks) {
                if (this.isAdd) {
                    users.remove(identityLink.getUserId());
                    continue;
                }
                taskEntity.deleteCandidateUser(identityLink.getUserId());
                currentUsers.add(identityLink.getUserId());
            }
            if (!users.isEmpty()) {
                taskEntity.addCandidateUsers(users);
                if (this.isAdd) {
                    this.dataPushService.addUserDataPush(this.dataPush((Task)taskEntity, String.join((CharSequence)",", users)));
                    this.messagePush(taskEntity, users);
                    this.todoAddUserDataPush(taskEntity, String.join((CharSequence)",", users));
                } else {
                    this.entrustDataPush((Task)taskEntity, String.join((CharSequence)",", currentUsers), String.join((CharSequence)",", users), taskEntity.getCreateTime(), new Date());
                    this.todoEntrustDataPush(taskEntity, String.join((CharSequence)",", currentUsers), String.join((CharSequence)",", users), new Date(), null);
                }
            }
        }
        return null;
    }

    private DataPush dataPush(Task task, String userId) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setBusinessKey(((TaskEntity)task).getProcessInstance().getBusinessKey());
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee, Date startTime, Date endTime) {
        this.messagePush((TaskEntity)task, new ArrayList<String>(Arrays.asList(userId.split(","))));
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(startTime);
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(endTime);
            }
            this.dataPushService.entrustDataPush(dataPush);
        }
    }

    private void messagePush(TaskEntity taskEntity, List<String> users) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        bpmActMsgDetail.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        bpmActMsgDetail.setProcessName(taskEntity.getProcessInstance().getProcessDefinition().getName());
        bpmActMsgDetail.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        bpmActMsgDetail.setTaskDefKey(taskEntity.getTaskDefinitionKey());
        bpmActMsgDetail.setTaskDefName(taskEntity.getName());
        bpmActMsgDetail.setReceive(users);
        bpmActMsgDetail.setChannelType(null);
        bpmActMsgDetail.setSceneCode("todo");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void todoEntrustDataPush(TaskEntity taskEntity, String userIds, String consignee, Date endTime, String entrustHisId) {
        String webUrl;
        String mobileUrl;
        Map formKeyMap;
        String pcJumpUrl;
        String jumpUrl;
        String webUrl2;
        String mobileUrl2;
        Map formKeyMap2;
        String pcJumpUrl2;
        String jumpUrl2;
        String processInstanceId = taskEntity.getProcessInstanceId();
        ExecutionEntity processInstance = taskEntity.getProcessInstance();
        List identityLinks = processInstance.getIdentityLinks();
        String starter = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            starter = identityLinkEntity.getUserId();
            break;
        }
        HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Date date = new Date();
        if (ToolUtil.isNotEmpty((Object)processInst)) {
            date = processInst.getStartTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", starter);
        map.put("start_time", date.getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInst.getProcessDefinitionName());
        map.put("title", taskEntity.getVariable("todoConfiguration"));
        ArrayList previousTasks = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)entrustHisId)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", entrustHisId);
            StringBuilder formDetailId = new StringBuilder();
            formDetailId.append(taskEntity.getProcessDefinitionId()).append(taskEntity.getTaskDefinitionKey());
            String formDetailKey = taskEntity.getFormKey();
            jumpUrl2 = null;
            pcJumpUrl2 = null;
            if (ToolUtil.isNotEmpty((Object)formDetailKey)) {
                formKeyMap2 = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                mobileUrl2 = (String)formKeyMap2.get("mobile");
                if (ToolUtil.isNotEmpty((Object)mobileUrl2)) {
                    jumpUrl2 = CommonCodeUtil.getUrl(mobileUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
                if (ToolUtil.isNotEmpty((Object)(webUrl2 = (String)formKeyMap2.get("web")))) {
                    pcJumpUrl2 = CommonCodeUtil.getUrl(webUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
            }
            taskMap.put("touser", userIds);
            taskMap.put("groupid", taskEntity.getId());
            taskMap.put("jump_url", jumpUrl2);
            taskMap.put("pc_jump_url", pcJumpUrl2);
            taskMap.put("task_status", 6);
            taskMap.put("assign_time", new Date().getTime() / 1000L);
            previousTasks.add(taskMap);
        }
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(userIds.split(",")));
            if (ToolUtil.isNotEmpty((Object)consignee)) {
                ArrayList<String> consigneeList = new ArrayList<String>(Arrays.asList(consignee.split(",")));
                userIdList.removeAll(consigneeList);
            }
            if (ToolUtil.isNotEmpty(userIdList)) {
                for (String userId : userIdList) {
                    if (!ToolUtil.isNotEmpty((Object)userIds)) continue;
                    HashMap<String, Object> taskMap = new HashMap<String, Object>();
                    taskMap.put("taskid", taskEntity.getId());
                    taskMap.put("touser", userId);
                    taskMap.put("groupid", taskEntity.getId());
                    StringBuilder formDetailId = new StringBuilder();
                    formDetailId.append(taskEntity.getProcessDefinitionId()).append(taskEntity.getTaskDefinitionKey());
                    String formDetailKey = this.taskManagerService.getFormDetailKey(formDetailId.toString());
                    jumpUrl = null;
                    pcJumpUrl = null;
                    if (ToolUtil.isNotEmpty((Object)formDetailKey)) {
                        formKeyMap = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                        mobileUrl = (String)formKeyMap.get("mobile");
                        if (ToolUtil.isNotEmpty((Object)mobileUrl)) {
                            jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                        if (ToolUtil.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                            pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                    }
                    taskMap.put("jump_url", jumpUrl);
                    taskMap.put("pc_jump_url", pcJumpUrl);
                    taskMap.put("task_status", 5);
                    taskMap.put("assign_time", endTime.getTime() / 1000L);
                    previousTasks.add(taskMap);
                }
            }
        }
        map.put("previous_tasks", previousTasks);
        ArrayList tasks = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)consignee)) {
            ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(consignee.split(",")));
            if (ToolUtil.isNotEmpty((Object)userIds)) {
                ArrayList<String> consigneeList = new ArrayList<String>(Arrays.asList(userIds.split(",")));
                userIdList.removeAll(consigneeList);
            }
            if (ToolUtil.isNotEmpty(userIdList)) {
                for (String id : userIdList) {
                    HashMap<String, Object> taskMap = new HashMap<String, Object>();
                    taskMap.put("taskid", taskEntity.getId());
                    taskMap.put("task_name", taskEntity.getName());
                    taskMap.put("touser", id);
                    taskMap.put("groupid", taskEntity.getId());
                    String formKey = taskEntity.getFormKey();
                    jumpUrl = null;
                    pcJumpUrl = null;
                    if (ToolUtil.isNotEmpty((Object)formKey)) {
                        formKeyMap = (Map)JSON.parseObject((String)formKey, Map.class);
                        mobileUrl = (String)formKeyMap.get("mobile");
                        if (ToolUtil.isNotEmpty((Object)mobileUrl)) {
                            jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                        if (ToolUtil.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                            pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                    }
                    taskMap.put("jump_url", jumpUrl);
                    taskMap.put("pc_jump_url", pcJumpUrl);
                    taskMap.put("level", 0);
                    taskMap.put("isnotify", 1);
                    taskMap.put("task_status", 0);
                    if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                        taskMap.put("countersign", 0);
                    } else {
                        taskMap.put("countersign", null);
                    }
                    taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
                    tasks.add(taskMap);
                }
            }
        } else {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", taskEntity.getId());
            taskMap.put("task_name", taskEntity.getName());
            taskMap.put("touser", "noAssignee");
            taskMap.put("groupid", taskEntity.getId());
            String formKey = taskEntity.getFormKey();
            jumpUrl2 = null;
            pcJumpUrl2 = null;
            if (ToolUtil.isNotEmpty((Object)formKey)) {
                formKeyMap2 = (Map)JSON.parseObject((String)formKey, Map.class);
                mobileUrl2 = (String)formKeyMap2.get("mobile");
                if (ToolUtil.isNotEmpty((Object)mobileUrl2)) {
                    jumpUrl2 = CommonCodeUtil.getUrl(mobileUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
                if (ToolUtil.isNotEmpty((Object)(webUrl2 = (String)formKeyMap2.get("web")))) {
                    pcJumpUrl2 = CommonCodeUtil.getUrl(webUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
            }
            taskMap.put("jump_url", jumpUrl2);
            taskMap.put("pc_jump_url", pcJumpUrl2);
            taskMap.put("level", 0);
            taskMap.put("isnotify", 1);
            taskMap.put("task_status", 0);
            if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                taskMap.put("countersign", 0);
            } else {
                taskMap.put("countersign", null);
            }
            taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
            tasks.add(taskMap);
        }
        map.put("tasks", tasks);
        CommonCodeUtil.taskDataPush(taskEntity.getTenantId(), map);
    }

    private void todoAddUserDataPush(TaskEntity taskEntity, String users) {
        String processInstanceId = taskEntity.getProcessInstanceId();
        ExecutionEntity processInstance = taskEntity.getProcessInstance();
        List identityLinks = processInstance.getIdentityLinks();
        String starter = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            starter = identityLinkEntity.getUserId();
            break;
        }
        HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Date date = new Date();
        if (ToolUtil.isNotEmpty((Object)processInst)) {
            date = processInst.getStartTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", starter);
        map.put("start_time", date.getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInst.getProcessDefinitionName());
        map.put("title", taskEntity.getVariable("todoConfiguration"));
        ArrayList tasks = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)users)) {
            List<String> userIdList = Arrays.asList(users.split(","));
            for (String id : userIdList) {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                taskMap.put("taskid", taskEntity.getId());
                taskMap.put("task_name", taskEntity.getName());
                taskMap.put("touser", id);
                taskMap.put("groupid", taskEntity.getId());
                String formKey = taskEntity.getFormKey();
                String jumpUrl = null;
                String pcJumpUrl = null;
                if (ToolUtil.isNotEmpty((Object)formKey)) {
                    String webUrl;
                    Map formKeyMap = (Map)JSON.parseObject((String)formKey, Map.class);
                    String mobileUrl = (String)formKeyMap.get("mobile");
                    if (ToolUtil.isNotEmpty((Object)mobileUrl)) {
                        jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                    }
                    if (ToolUtil.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                        pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                    }
                }
                taskMap.put("jump_url", jumpUrl);
                taskMap.put("pc_jump_url", pcJumpUrl);
                taskMap.put("level", 0);
                taskMap.put("isnotify", 1);
                taskMap.put("task_status", 0);
                if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                    taskMap.put("countersign", 0);
                } else {
                    taskMap.put("countersign", null);
                }
                taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
                tasks.add(taskMap);
            }
        } else {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", taskEntity.getId());
            taskMap.put("task_name", taskEntity.getName());
            taskMap.put("touser", "noAssignee");
            taskMap.put("groupid", taskEntity.getId());
            String formKey = taskEntity.getFormKey();
            String jumpUrl = null;
            String pcJumpUrl = null;
            if (ToolUtil.isNotEmpty((Object)formKey)) {
                String webUrl;
                Map formKeyMap = (Map)JSON.parseObject((String)formKey, Map.class);
                String mobileUrl = (String)formKeyMap.get("mobile");
                if (ToolUtil.isNotEmpty((Object)mobileUrl)) {
                    jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
                if (ToolUtil.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                    pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
            }
            taskMap.put("jump_url", jumpUrl);
            taskMap.put("pc_jump_url", pcJumpUrl);
            taskMap.put("level", 0);
            taskMap.put("isnotify", 1);
            taskMap.put("task_status", 0);
            if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                taskMap.put("countersign", 0);
            } else {
                taskMap.put("countersign", null);
            }
            taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
            tasks.add(taskMap);
        }
        map.put("tasks", tasks);
        CommonCodeUtil.taskDataPush(taskEntity.getTenantId(), map);
    }
}

