/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/bpm/publicProcess"})
public class PublicProcessController {
    @Autowired
    public GodAxeModelService godAxeModelService;
    @Autowired
    private IInstanceEngineService iInstanceEngineService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ITaskEngineService taskEngineService;

    @GetMapping(value={"/queryNextNode"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        return TaskEngineService.queryNextUserTask((String)processDefinitionKey, (String)taskId, (boolean)false, (boolean)false, null);
    }

    @GetMapping(value={"/queryNextUserTask"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextUserTask(@RequestParam(value="processDefinitionKey", required=false) String processDefinitionKey, @RequestParam(value="taskId") String taskId, @RequestParam(value="isGetRevokeNode", defaultValue="false") boolean isGetRevokeNode) {
        return TaskEngineService.queryNextUserTask((String)processDefinitionKey, (String)taskId, (boolean)isGetRevokeNode, (boolean)true, new HashMap());
    }

    @GetMapping(value={"/queryRejectNodeOrNextNode"})
    @ApiOperation(value="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", eventDesc="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryRejectNodeOrNextNode(String processDefinitionKey, String taskId) {
        return TaskEngineService.queryNextUserTask((String)processDefinitionKey, (String)taskId, (boolean)true, (boolean)false, null);
    }

    @GetMapping(value={"/queryNextNodeByLineCondition"})
    @ApiOperation(value="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="lineCondition", value="\u7ebf\u6761\u4ef6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventDesc="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextNodeByLineCondition(String processDefinitionKey, String taskId, Map<String, Object> lineCondition) {
        return TaskEngineService.queryNextUserTask((String)processDefinitionKey, (String)taskId, (boolean)false, (boolean)false, lineCondition);
    }

    @GetMapping(value={"/queryNextAssigneeByTaskIdAndNodeId"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId) {
        return TaskEngineService.queryNextAssignee((String)processDefinitionKey, (String)taskId, (String)nodeId, (String)String.valueOf(BaseSecurityUtil.getUser().getId()), null);
    }

    @GetMapping(value={"/queryAllAssignee"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryAllAssignee(String processDefinitionKey) {
        return TaskEngineService.queryAllAssignee((String)processDefinitionKey);
    }

    @GetMapping(value={"/getAllProcessTraceByBusinessKey"})
    @ApiOperation(value="\u83b7\u53d6\u529e\u7406\u5386\u53f2", notes="\u83b7\u53d6\u529e\u7406\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u529e\u7406\u5386\u53f2", eventDesc="\u83b7\u53d6\u529e\u7406\u5386\u53f2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int size) {
        return InstanceEngineService.getAllProcessTraceByBusinessKey((String)businessKey, (int)page, (int)size);
    }

    @PostMapping(value={"/addCustomNode"})
    @ApiOperation(value="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", notes="\u589e\u52a0\u4e34\u65f6\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", eventDesc="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<?> addCustomNode(@RequestBody Map<String, Object> map) {
        return TaskEngineService.addCustomNode((String)String.valueOf(map.get("taskId")), (List)((List)map.get("list")), (String)String.valueOf(map.get("parallel")));
    }

    @GetMapping(value={"/isAddParallel"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", notes="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", eventDesc="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> isAddParallel(String taskId) {
        return TaskEngineService.isAddParallel((String)taskId);
    }

    @GetMapping(value={"/queryRejectNode"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", notes="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", eventDesc="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryRejectNode(String taskId, boolean getWithMainProcess) {
        return TaskEngineService.queryRejectNode((String)taskId, (boolean)getWithMainProcess);
    }

    @GetMapping(value={"/queryJumpNode"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9", notes="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9", eventDesc="\u83b7\u53d6\u53ef\u8df3\u8f6c\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryJumpNode(String taskId, boolean getWithMainProcess) {
        return TaskEngineService.queryJumpNode((String)taskId, (boolean)getWithMainProcess);
    }

    @GetMapping(value={"/queryCompletecComments"})
    @ApiOperation(value="\u67e5\u8be2\u529e\u7406\u610f\u89c1", notes="\u67e5\u8be2\u529e\u7406\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query"), @ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    @AuditLog(moduleName="\u67e5\u8be2\u529e\u7406\u610f\u89c1", eventDesc="\u67e5\u8be2\u529e\u7406\u610f\u89c1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryCompleteComments(String processInsId, String businessKey) {
        return this.iInstanceEngineService.queryCompletecomment(businessKey, processInsId);
    }

    @GetMapping(value={"/getModifyConfigurationOnline"})
    @ApiOperation(value="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e", notes="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e")
    @AuditLog(moduleName="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e", eventDesc="\u83b7\u53d6\u662f\u5426\u5728\u7ebf\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getModifyConfigurationOnline() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isModifyConfigurationOnline()));
    }

    @PostMapping(value={"/isProductionMode"})
    @ApiOperation(value="\u83b7\u53d6\u80fd\u5426\u5728\u7ebf\u7f16\u8f91", notes="\u83b7\u53d6\u80fd\u5426\u5728\u7ebf\u7f16\u8f91")
    @AuditLog(moduleName="\u83b7\u53d6\u80fd\u5426\u5728\u7ebf\u7f16\u8f91", eventDesc="\u83b7\u53d6\u80fd\u5426\u5728\u7ebf\u7f16\u8f91", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> isProductionMode() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isEditableOnline()));
    }

    @GetMapping(value={"/queryUserTree"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", notes="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811")
    @ApiImplicitParam(name="organName", value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u540d\u6216\u90e8\u95e8\u540d", required=true, paramType="query")
    @AuditLog(moduleName="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventDesc="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryUserTree(String organName) {
        return ApiResponse.success((Object)this.iAssigneeChooseService.queryUserTree(organName));
    }

    @GetMapping(value={"/queryUserListByPage"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="bpmTreeModel", value="\u5de5\u4f5c\u6d41\u6811\u6a21\u578b\u7c7b", paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", eventDesc="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<BpmTreeModel>> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        return ApiResponse.success((Object)this.iAssigneeChooseService.queryUserListByPage(pages, bpmTreeModel));
    }

    @GetMapping(value={"/dept"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811", notes="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811")
    @ApiImplicitParam(name="id", value="\u7236\u8282\u70b9id", required=false, paramType="query")
    @AuditLog(moduleName="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811", eventDesc="\u61d2\u52a0\u8f7d\u90e8\u95e8\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> dept(String id) {
        return ApiResponse.success((Object)this.iAssigneeChooseService.deptTree(id, false));
    }

    @GetMapping(value={"/queryDeptTreeByChildren"})
    @ApiOperation(value="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", notes="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811")
    @ApiImplicitParam(name="bpmTreeModel", value="\u5de5\u4f5c\u6d41\u6811\u6a21\u578b\u7c7b", paramType="query")
    @AuditLog(moduleName="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", eventDesc="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        return ApiResponse.success((Object)this.iAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel));
    }

    @GetMapping(value={"/queryNodeAssigneeAndDept"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParam(name="nodeAssigneeQueryDto", value="\u8282\u70b9\u53c2\u4e0e\u8005\u67e5\u8be2dto", paramType="query")
    @AuditLog(moduleName="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u6a21\u7cca\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        nodeAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        return ApiResponse.success((Object)this.taskEngineService.queryNodeAssigneeAndDept(nodeAssigneeQueryDto));
    }

    @GetMapping(value={"/queryNodeAssigneeListByPage"})
    @ApiOperation(value="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="nodeAssigneeQueryDto", value="\u8282\u70b9\u53c2\u4e0e\u8005\u67e5\u8be2dto", paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventDesc="\u6839\u636e\u90e8\u95e8\u6216\u4eba\u5458\u5206\u9875\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<BpmTreeModel>> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        nodeAssigneeQueryDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        return ApiResponse.success((Object)this.taskEngineService.queryNodeAssigneeListByPage(pages, nodeAssigneeQueryDto));
    }

    @GetMapping(value={"/queryRejectComment"})
    @ApiOperation(value="\u67e5\u8be2\u9a73\u56de\u610f\u89c1", notes="\u67e5\u8be2\u9a73\u56de\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    @AuditLog(moduleName="\u67e5\u8be2\u9a73\u56de\u610f\u89c1", eventDesc="\u67e5\u8be2\u9a73\u56de\u610f\u89c1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult queryRejectComment(String taskId) {
        return this.taskEngineService.queryRejectComment(taskId);
    }
}

