/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.formdesign.visitor.AssemblyVariablesVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmUserAccountModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HussarDataPushEhcacheManager;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.WeChatDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskLog.model.SysActTaskDataPushLog;
import com.jxdinfo.hussar.workflow.engine.bsp.taskLog.service.ISysActTaskDataPushLogService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.outside.variable.service.GodAxeVariablesService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.springframework.stereotype.Component;

@Component
public class CommonCodeUtil {
    private static Boolean isStartAlone;
    private static ModelService modelService;
    private static RepositoryService repositoryService;
    private static ActivityRedisTimerService activityRedisTimerService;
    private static WeChatDataPush weChatDataPush;
    private static ISysUserService sysUserService;
    private static ISysActTaskDataPushLogService sysActTaskDataPushLogService;
    private static final String GET_ACCESS_TOKEN = "get_access_token";
    private static final String GET_LAST_TOKEN_GET_TIME = "get_last_token_get_time";
    private static final String GET_TOKEN_EXPAND_URL = "/cgi-bin/gettoken?corpid=";
    private static final String TASK_DATA_PUSH_EXPAND_URL = "/api/saas-tenant-messagecenter/v4/unifiedtask?access_token=";
    private static IAssigneeChooseService iAssigneeChooseService;
    private static final int OPERATEDELAYTIME = 1000;
    private static final int COREPOOLSIZE = 10;
    private static ScheduledThreadPoolExecutor executor;

    public static Map<String, Object> getGodAxeResult(String nodeId, String businessId, String procDefId) {
        Map variable;
        if (isStartAlone == null) {
            LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
            isStartAlone = lcdpBpmProperties.isStartAlone();
        }
        String procDefKey = procDefId.split(":")[0];
        String realVersion = String.valueOf(modelService.getRealVersion(procDefId));
        BpmnModel bm = repositoryService.getBpmnModel(procDefId);
        String beanId = procDefKey + ":" + realVersion + CommonCodeUtil.getVisitorNodeId(nodeId, bm);
        if (!isStartAlone.booleanValue()) {
            AssemblyVariablesVisitor assemblyVariablesVisitor;
            try {
                assemblyVariablesVisitor = (AssemblyVariablesVisitor)SpringContextHolder.getBean(AssemblyVariablesVisitor.class);
            }
            catch (Exception e) {
                return new HashMap<String, Object>();
            }
            try {
                variable = assemblyVariablesVisitor.assemblyVariables(beanId, businessId);
            }
            catch (Exception e) {
                return new HashMap<String, Object>();
            }
        }
        String serviceName = String.valueOf(modelService.getServiceName(procDefKey));
        try {
            GodAxeVariablesService godAxeVariablesService = (GodAxeVariablesService)SpringContextHolder.getBean(GodAxeVariablesService.class);
            variable = godAxeVariablesService.assemblyVariables(beanId, businessId, serviceName);
        }
        catch (Exception e) {
            throw new PublicClientException("\u4ece\u670d\u52a1" + serviceName + "\u83b7\u53d6\u53d8\u91cf\u5931\u8d25\uff01");
        }
        CommonCodeUtil.handleVariables(variable);
        return variable;
    }

    public static void handleVariables(Map<String, Object> variable) {
        for (Map.Entry<String, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && HussarUtils.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            BigDecimal bigDecimal = (BigDecimal)k.getValue();
            if (new BigDecimal(bigDecimal.longValue()).compareTo(bigDecimal) == 0) {
                variable.put(k.getKey(), bigDecimal.longValue());
                continue;
            }
            variable.put(k.getKey(), bigDecimal.doubleValue());
        }
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith("jxd_bpm_custom_node")) {
            id = id.contains("parallel_node") ? id.split("parallel_node")[1] : ((SequenceFlow)((FlowNode)bm.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new PublicClientException("\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
        return id;
    }

    public static void triggerEventHandleClass(Map<String, Object> map) {
        BpmnModel bm = repositoryService.getBpmnModel((String)map.get("processDefinitionId"));
        String type = "";
        Object tType = map.get("type");
        if (HussarUtils.isNotEmpty((Object)tType)) {
            type = tType.toString();
        }
        if ("processCreateEnd".equals(type)) {
            activityRedisTimerService.addGlobalTimeOutModel(bm, map);
        } else if ("processCompleteEnd".equals(type)) {
            activityRedisTimerService.delGlobalTimeOutModel(map);
        }
    }

    public static void taskDataPush(String tenantId, final Map<String, Object> dataPushMsg, boolean isAsync) throws PublicClientException {
        final LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        if (lcdpBpmProperties.isIhnIsTaskDataPush()) {
            if (dataPushMsg != null) {
                StringBuffer webTaskUrl;
                StringBuffer mobileTaskUrl;
                String toUser;
                String pcJumpUrl;
                String jumpUrl;
                String toUser2;
                ArrayList tasksList = (ArrayList)dataPushMsg.get("tasks");
                ArrayList previousTasksList = (ArrayList)dataPushMsg.get("previous_tasks");
                String startUser = dataPushMsg.get("startUser").toString();
                HashSet<String> toUsers = new HashSet<String>();
                toUsers.add(startUser);
                if (tasksList != null) {
                    for (Map tasks : tasksList) {
                        toUser2 = (String)tasks.get("touser");
                        toUsers.add(toUser2);
                    }
                }
                if (previousTasksList != null) {
                    for (Map previousTasks : previousTasksList) {
                        toUser2 = (String)previousTasks.get("touser");
                        toUsers.add(toUser2);
                    }
                }
                ArrayList toUserList = new ArrayList(toUsers);
                Map userAccounts = iAssigneeChooseService.getUserAccount(toUserList, tenantId);
                dataPushMsg.put("startUser", userAccounts.get(startUser));
                dataPushMsg.put("start_user", userAccounts.get(startUser));
                if (tasksList != null) {
                    for (Map tasks : tasksList) {
                        jumpUrl = (String)tasks.get("jump_url");
                        pcJumpUrl = (String)tasks.get("pc_jump_url");
                        toUser = (String)tasks.get("touser");
                        if (jumpUrl != null && jumpUrl.length() != 0) {
                            mobileTaskUrl = new StringBuffer(lcdpBpmProperties.getIhnMobileTaskurl());
                            mobileTaskUrl.append(jumpUrl);
                            jumpUrl = mobileTaskUrl.toString();
                            tasks.put("jump_url", jumpUrl);
                        }
                        if (pcJumpUrl != null && pcJumpUrl.length() != 0) {
                            webTaskUrl = new StringBuffer(lcdpBpmProperties.getIhnWebTaskurl());
                            webTaskUrl.append(pcJumpUrl);
                            pcJumpUrl = webTaskUrl.toString();
                            tasks.put("pc_jump_url", pcJumpUrl);
                        }
                        if (toUser == null || toUser.length() == 0) continue;
                        tasks.put("touser", userAccounts.get(toUser));
                    }
                    dataPushMsg.put("tasks", tasksList);
                }
                if (previousTasksList != null) {
                    for (Map previousTasks : previousTasksList) {
                        jumpUrl = (String)previousTasks.get("jump_url");
                        pcJumpUrl = (String)previousTasks.get("pc_jump_url");
                        toUser = (String)previousTasks.get("touser");
                        if (jumpUrl != null && jumpUrl.length() != 0) {
                            mobileTaskUrl = new StringBuffer(lcdpBpmProperties.getIhnMobileTaskurl());
                            mobileTaskUrl.append(jumpUrl);
                            jumpUrl = mobileTaskUrl.toString();
                            previousTasks.put("jump_url", jumpUrl);
                        }
                        if (pcJumpUrl != null && pcJumpUrl.length() != 0) {
                            webTaskUrl = new StringBuffer(lcdpBpmProperties.getIhnWebTaskurl());
                            webTaskUrl.append(pcJumpUrl);
                            pcJumpUrl = webTaskUrl.toString();
                            previousTasks.put("pc_jump_url", pcJumpUrl);
                        }
                        if (toUser == null || toUser.length() == 0) continue;
                        previousTasks.put("touser", userAccounts.get(toUser));
                    }
                    dataPushMsg.put("previous_tasks", previousTasksList);
                }
            }
            if (lcdpBpmProperties.getIhnTaskDataPushUrl() == null || lcdpBpmProperties.getIhnTaskDataPushUrl().length() == 0 || lcdpBpmProperties.getIhnMobileTaskurl() == null || lcdpBpmProperties.getIhnMobileTaskurl().length() == 0 || lcdpBpmProperties.getIhnWebTaskurl() == null || lcdpBpmProperties.getIhnWebTaskurl().length() == 0 || lcdpBpmProperties.getIhnDataPushAgentid() == null || lcdpBpmProperties.getIhnDataPushAgentid().length() == 0 || lcdpBpmProperties.getIhnDatapushCorpid() == null || lcdpBpmProperties.getIhnDatapushCorpid().length() == 0 || lcdpBpmProperties.getIhnDatapushCorpsecret() == null || lcdpBpmProperties.getIhnDatapushCorpsecret().length() == 0) {
                throw new PublicClientException("\u5f85\u529e\u63a8\u9001\u914d\u7f6e\u6709\u8bef");
            }
            if (isAsync) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (dataPushMsg != null) {
                            dataPushMsg.put("source", lcdpBpmProperties.getIhnDataPushAgentid());
                            boolean pushSuccess = CommonCodeUtil.pushMsg(JSON.toJSONString((Object)dataPushMsg));
                            if (!pushSuccess) {
                                SysActTaskDataPushLog sysActTaskDataPushLog = new SysActTaskDataPushLog();
                                Date date = new Date();
                                sysActTaskDataPushLog.setProcessName((String)dataPushMsg.get("process_name"));
                                sysActTaskDataPushLog.setProcessInstId((String)dataPushMsg.get("processid"));
                                sysActTaskDataPushLog.setDataPushCount(0);
                                sysActTaskDataPushLog.setLogType(Character.valueOf('0'));
                                sysActTaskDataPushLog.setlogContent(JSON.toJSONString((Object)dataPushMsg));
                                sysActTaskDataPushLog.setLogTime(date);
                                sysActTaskDataPushLog.setLastLogTime(date);
                                sysActTaskDataPushLogService.saveLog(sysActTaskDataPushLog);
                                BpmUserAccountModel sysUser = iAssigneeChooseService.getUserAccountInfo();
                                StringBuilder dataPushStr = new StringBuilder().append("\u8d26\u53f7\uff1a").append(sysUser.getUserAccount()).append("\uff0c\u8d26\u53f7\u540d\u79f0\uff1a").append(sysUser.getUserName()).append("\uff0c\u4e8e").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append("\u5f85\u529e\u63a8\u9001\u5931\u8d25");
                                weChatDataPush.dataPush(dataPushStr.toString());
                            }
                        }
                    }
                };
                executor.schedule(timerTask, 1000L, TimeUnit.MILLISECONDS);
            } else {
                dataPushMsg.put("source", lcdpBpmProperties.getIhnDataPushAgentid());
                boolean pushSuccess = CommonCodeUtil.pushMsg(JSON.toJSONString(dataPushMsg));
                if (!pushSuccess) {
                    SysActTaskDataPushLog sysActTaskDataPushLog = new SysActTaskDataPushLog();
                    Date date = new Date();
                    sysActTaskDataPushLog.setProcessName((String)dataPushMsg.get("process_name"));
                    sysActTaskDataPushLog.setProcessInstId((String)dataPushMsg.get("processid"));
                    sysActTaskDataPushLog.setDataPushCount(0);
                    sysActTaskDataPushLog.setLogType(Character.valueOf('0'));
                    sysActTaskDataPushLog.setlogContent(JSON.toJSONString(dataPushMsg));
                    sysActTaskDataPushLog.setLogTime(date);
                    sysActTaskDataPushLog.setLastLogTime(date);
                    sysActTaskDataPushLogService.saveLog(sysActTaskDataPushLog);
                    BpmUserAccountModel sysUser = iAssigneeChooseService.getUserAccountInfo();
                    StringBuilder dataPushStr = new StringBuilder().append("\u8d26\u53f7\uff1a").append(sysUser.getUserAccount()).append("\uff0c\u8d26\u53f7\u540d\u79f0\uff1a").append(sysUser.getUserName()).append("\uff0c\u4e8e").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append("\u5f85\u529e\u63a8\u9001\u5931\u8d25");
                    weChatDataPush.dataPush(dataPushStr.toString());
                }
            }
        }
    }

    public static void taskDataPush(String tenantId, Map<String, Object> dataPushMsg) throws PublicClientException {
        CommonCodeUtil.taskDataPush(tenantId, dataPushMsg, true);
    }

    public static boolean pushMsg(String pushMsg) {
        try {
            LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
            String token = CommonCodeUtil.getAccessToken(lcdpBpmProperties.getIhnTenantId());
            String url = lcdpBpmProperties.getIhnTaskDataPushUrl();
            url = url + TASK_DATA_PUSH_EXPAND_URL + token;
            String result = HttpUtil.post((String)url, (String)pushMsg);
            Map map = (Map)JSON.parseObject((String)result, Map.class);
            if ((Integer)map.get("errcode") != 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String getAccessToken(String tenantId) {
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        HussarDataPushEhcacheManager hussarDataPushEhcacheManager = (HussarDataPushEhcacheManager)SpringContextHolder.getBean(HussarDataPushEhcacheManager.class);
        String accessToken = (String)hussarDataPushEhcacheManager.getObject(GET_ACCESS_TOKEN, tenantId);
        Long lastTokenGetTime = (Long)hussarDataPushEhcacheManager.getObject(GET_LAST_TOKEN_GET_TIME, tenantId);
        if (accessToken == null || accessToken.length() == 0 || System.currentTimeMillis() - lastTokenGetTime > 3600000L) {
            String url = lcdpBpmProperties.getIhnTaskDataPushUrl();
            url = url + GET_TOKEN_EXPAND_URL + lcdpBpmProperties.getIhnDatapushCorpid() + "&corpsecret=" + lcdpBpmProperties.getIhnDatapushCorpsecret();
            try {
                Map map;
                String result = HttpRequestUtil.getResult(url, new HashMap<String, Object>());
                if (ToolUtil.isNotEmpty((Object)result) && (Integer)(map = (Map)JSON.parseObject((String)result, HashMap.class)).get("errcode") == 0) {
                    String token = (String)map.get("access_token");
                    hussarDataPushEhcacheManager.setObject(GET_ACCESS_TOKEN, tenantId, token);
                    hussarDataPushEhcacheManager.setObject(GET_LAST_TOKEN_GET_TIME, tenantId, System.currentTimeMillis());
                    return token;
                }
                throw new PublicClientException("\u4efb\u52a1\u63a8\u9001\u83b7\u53d6token\u5931\u8d25");
            }
            catch (Exception e) {
                throw new PublicClientException("\u4efb\u52a1\u63a8\u9001\u83b7\u53d6token\u5931\u8d25");
            }
        }
        return accessToken;
    }

    public static String getUrl(String url, String businessId, String taskId, String processDefinitionKey, String taskDefinitionKey) {
        StringBuilder jumpUrl = new StringBuilder();
        jumpUrl.append(url);
        jumpUrl.append("?businessId=").append(businessId);
        jumpUrl.append("&taskId=").append(taskId);
        jumpUrl.append("&processDefinitionKey=").append(processDefinitionKey);
        jumpUrl.append("&taskDefinitionKey=").append(taskDefinitionKey);
        return jumpUrl.toString();
    }

    public static boolean isMulti(Task task) {
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            return false;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        return activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
    }

    private CommonCodeUtil() {
    }

    static {
        modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
        repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
        activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
        weChatDataPush = (WeChatDataPush)SpringContextHolder.getBean(WeChatDataPush.class);
        sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
        sysActTaskDataPushLogService = (ISysActTaskDataPushLogService)SpringContextHolder.getBean(ISysActTaskDataPushLogService.class);
        iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
        executor = new ScheduledThreadPoolExecutor(10);
    }
}

