/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.FireEvent;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class ParallelJumpTaskCmd
implements Command<Void> {
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private String taskId;
    protected String userId;
    private String executionId;
    protected String comment;
    protected String type;
    private String subProcessKey;
    private String targetNodeIds;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private List<String> affectedTasks;
    private String processEventType;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private FireEvent fireEvent = (FireEvent)SpringContextHolder.getBean(FireEvent.class);
    private static final String DELETE_REASON = "ParallelJumpTaskCmd-Completed";
    private static Map<String, String> createType = new HashMap<String, String>();
    private static Map<String, String> deleteType = new HashMap<String, String>();

    public ParallelJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String comment, String type, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.comment = comment;
        this.type = type;
        this.subProcessKey = subProcessKey;
        if (paramvar.get("affectedTasks") != null) {
            this.affectedTasks = (List)paramvar.get("affectedTasks");
            paramvar.remove("affectedTasks");
        }
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
        this.taskId = taskRejectModel.getTaskId();
    }

    public ParallelJumpTaskCmd(String taskId, String userId, String mandator, String executionId, String targetNodeIds, String comment, String type, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.taskId = taskId;
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.comment = comment;
        this.type = type;
        this.subProcessKey = subProcessKey;
        if (paramvar.get("affectedTasks") != null) {
            this.affectedTasks = (List)paramvar.get("affectedTasks");
            paramvar.remove("affectedTasks");
        }
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
    }

    public ParallelJumpTaskCmd setProcessEventType(String processEventType) {
        this.processEventType = processEventType;
        return this;
    }

    public ParallelJumpTaskCmd addParam(String str, Object obj) {
        this.paramMap.put(str, obj);
        return this;
    }

    public Void execute(CommandContext commandContext) {
        HistoryManager historyManager = commandContext.getHistoryManager();
        commandContext.addAttribute("taskSourceFlag", (Object)this.type);
        boolean reject = "reject".equals(this.type);
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity execution = executionEntityManager.findExecutionById(this.executionId);
        ParamModel paramModel = this.getParamModel(execution, this.taskRejectModel);
        commandContext.addAttribute("listenerParam", (Object)paramModel);
        this.fireEvent.fireEvent(execution, this.processEventType, (String)this.paramMap.get("sub_process"));
        List list = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        ExecutionEntity executionEntity = null;
        for (ExecutionEntity entity : list) {
            if ((this.subProcessKey == null || !this.subProcessKey.equals(entity.getVariableLocal("sub_process_key"))) && (this.subProcessKey != null || entity.getParentId() != null)) continue;
            executionEntity = entity;
            break;
        }
        ArrayList<TaskEntity> taskEntities = new ArrayList<TaskEntity>();
        ArrayList<ExecutionEntity> executionEntities = new ArrayList<ExecutionEntity>();
        this.getExecutionAndTask(executionEntity, taskEntities, executionEntities);
        this.taskHandle(taskEntities, commandContext);
        for (int i = 1; i < executionEntities.size(); ++i) {
            ExecutionEntity ee = (ExecutionEntity)executionEntities.get(i);
            while (HussarUtils.isNotEmpty((Object)ee.getExecutions())) {
                this.executionHandle((ExecutionEntity)ee.getExecutions().get(0), historyManager);
            }
            ExecutionEntity eeParent = ee.getParent();
            while (eeParent != null && eeParent.getExecutions().size() == 1) {
                ee.remove();
                if (ee.getActivityId() != null) {
                    this.fireExecutionListener(ee);
                    historyManager.recordActivityEnd(ee);
                }
                ee = eeParent;
                eeParent = ee.getParent();
            }
            ee.remove();
            if (ee.getActivityId() == null) continue;
            this.fireExecutionListener(ee);
            historyManager.recordActivityEnd(ee);
        }
        ExecutionEntity ee = (ExecutionEntity)executionEntities.get(0);
        while (HussarUtils.isNotEmpty((Object)ee.getExecutions())) {
            this.executionHandle((ExecutionEntity)ee.getExecutions().get(0), historyManager);
        }
        ExecutionEntity eeParent = ee.getParent();
        while (eeParent != null && eeParent.getExecutions().size() == 1 && !ee.getId().equals(executionEntity.getId())) {
            ee.remove();
            if (ee.getActivityId() != null) {
                this.fireExecutionListener(ee);
                historyManager.recordActivityEnd(ee);
            }
            ee = eeParent;
            eeParent = ee.getParent();
        }
        if (ee.getActivityId() != null) {
            this.fireExecutionListener(ee);
            historyManager.recordActivityEnd(ee);
        }
        if (reject) {
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userId, this.type, this.paramvar));
        return null;
    }

    private void getExecutionAndTask(ExecutionEntity executionEntity, List<TaskEntity> taskEntities, List<ExecutionEntity> executionEntities) {
        block6: {
            block5: {
                if (this.affectedTasks != null && executionEntities != null && (executionEntity.getCurrentActivityId() == null || !this.affectedTasks.contains(executionEntity.getCurrentActivityId()))) break block5;
                if (executionEntity.getTasks() != null) {
                    taskEntities.addAll(executionEntity.getTasks());
                }
                if (executionEntities != null) {
                    executionEntities.add(executionEntity);
                }
                if (executionEntity.getExecutions() == null) break block6;
                for (ExecutionEntity entity : executionEntity.getExecutions()) {
                    this.getExecutionAndTask(entity, taskEntities, null);
                }
                break block6;
            }
            if (executionEntity.getExecutions() != null) {
                for (ExecutionEntity entity : executionEntity.getExecutions()) {
                    this.getExecutionAndTask(entity, taskEntities, executionEntities);
                }
            }
        }
    }

    private void taskHandle(List<TaskEntity> taskEntities, CommandContext commandContext) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        boolean needDelTask = "revoke".equals(this.type) || "reject_revoke".equals(this.type) || "reject".equals(this.type);
        ArrayList<String> allTimeOutTaskIds = new ArrayList<String>();
        ArrayList<String> delTaskIds = new ArrayList<String>();
        String processKey = null;
        for (TaskEntity taskEntity : taskEntities) {
            ParamModel paramModel;
            if (taskEntity.getDueDate() != null) {
                allTimeOutTaskIds.add(taskEntity.getId());
            }
            if (this.taskId != null && this.taskId.equals(taskEntity.getId())) {
                paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
                paramModel.setDeleteType(null);
                commandContext.addAttribute("listenerParam", (Object)paramModel);
                taskEntity.fireEvent("complete");
                if (HussarUtils.isNotEmpty((Object)this.comment)) {
                    this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                }
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
                taskEntity.setAssignee(this.userId);
                taskEntityManager.deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
                continue;
            }
            if (needDelTask) {
                paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
                paramModel.setDeleteType(deleteType.get(this.type));
                commandContext.addAttribute("listenerParam", (Object)paramModel);
                taskEntity.fireEvent("complete");
                processKey = taskEntity.getProcessDefinitionId().split(":")[0];
                delTaskIds.add(taskEntity.getId());
                taskEntityManager.deleteTask(taskEntity, DELETE_REASON, true, this.mandator);
                continue;
            }
            paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
            paramModel.setDeleteType(null);
            commandContext.addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            if (HussarUtils.isNotEmpty((Object)this.comment)) {
                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
            taskEntity.setAssignee(this.userId);
            taskEntityManager.deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
        }
        if (this.dataPushService.isDataPush() && delTaskIds.size() > 0) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessKey(processKey);
            dataPush.setTaskIds(delTaskIds);
            this.dataPushService.deleteMultiTask(dataPush);
        }
        if (HussarUtils.isNotEmpty(allTimeOutTaskIds)) {
            this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", allTimeOutTaskIds));
        }
    }

    private void executionHandle(ExecutionEntity executionEntity, HistoryManager historyManager) {
        while (HussarUtils.isNotEmpty((Object)executionEntity.getExecutions())) {
            this.executionHandle((ExecutionEntity)executionEntity.getExecutions().get(0), historyManager);
        }
        executionEntity.remove();
        if (executionEntity.getActivityId() != null) {
            this.fireExecutionListener(executionEntity);
            historyManager.recordActivityEnd(executionEntity);
        }
    }

    public ParamModel getParamModel(ExecutionEntity executionEntity, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        if (HussarUtils.isNotEmpty((Object)this.processEventType) && "process_restart".equals(this.processEventType)) {
            paramModel.setCreateReason("reStartCreate");
            paramModel.setStarter(this.userId);
            return paramModel;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        if ("endProcess".equals(this.type) || "revokeProcess".equals(this.type) || "complete".equals(this.type)) {
            paramModel.setCompleteType(this.type);
            paramModel.setFrom(this.currentActivity.getId());
            paramModel.setTo(this.targetNodeIds);
            paramModel.setHandler(this.userId);
            if ("complete".equals(this.type)) {
                paramModel.setSendUser(this.userId);
                paramModel.setCreateReason(createType.get(this.type));
                paramModel.setLastNodeId(this.currentActivity.getId());
                paramModel.setLastTaskId(this.taskId);
                paramModel.setLastCompleteType(this.type);
                paramModel.setLastNodeHandler(this.userId);
            }
            return paramModel;
        }
        if (HussarUtils.isNotEmpty((Object)taskRejectModel)) {
            paramModel.setCompleteType(taskRejectModel.getType());
            String targetIds = taskRejectModel.getTargetIds();
            Map<String, String> targetAssigneeMap = new HashMap<String, String>();
            if (taskRejectModel.getMap().containsKey("reject_appoint_assignee")) {
                String targetAssignee = taskRejectModel.getMap().get("reject_appoint_assignee").toString();
                targetAssigneeMap.put(targetIds, targetAssignee);
            } else if (taskRejectModel.getMap().containsKey("appoint_assignee")) {
                targetAssigneeMap = (Map)taskRejectModel.getMap().get("appoint_assignee");
            }
            paramModel.setTo(taskRejectModel.getTargetIds());
            paramModel.setTargetAssignee(targetAssigneeMap);
            String fromNodeId = null;
            if ("revoke".equals(this.type) || "reject_revoke".equals(this.type)) {
                if (taskRejectModel.getMap().containsKey("reject_from")) {
                    fromNodeId = taskRejectModel.getMap().get("reject_from").toString();
                }
            } else {
                fromNodeId = taskRejectModel.getTask().getTaskDefinitionKey();
            }
            paramModel.setFrom(fromNodeId);
            String affectedTaskIds = null;
            affectedTaskIds = taskRejectModel.getMap().containsKey("affectedTasks") ? taskRejectModel.getMap().get("affectedTasks").toString() : taskRejectModel.getAllAffectedTaskIds();
            paramModel.setAffectedNodeId(affectedTaskIds);
            paramModel.setHandler(taskRejectModel.getUserId());
            paramModel.setSendUser(taskRejectModel.getUserId());
            if (createType.containsKey(taskRejectModel.getType())) {
                paramModel.setCreateReason(createType.get(taskRejectModel.getType()));
            }
            paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
            paramModel.setLastNodeName(taskRejectModel.getTask().getName());
            paramModel.setLastCompleteType(taskRejectModel.getType());
            paramModel.setLastNodeHandler(taskRejectModel.getUserId());
        } else {
            paramModel.setCompleteType(this.type);
            paramModel.setHandler(this.userId);
            paramModel.setFrom(this.currentActivity.getId());
            paramModel.setTo(this.targetNodeIds);
            paramModel.setCreateReason(createType.get(this.type));
        }
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PublicClientException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }

    static {
        createType.put("reject", "rejectCreate");
        createType.put("revoke", "revokeCreate");
        createType.put("reject_revoke", "revokeCreate");
        createType.put("freejump", "freeJumpCreate");
        createType.put("complete", "completeToRejectCreate");
        deleteType.put("reject", "rejectDeleted");
        deleteType.put("revoke", "revokeDeleted");
        deleteType.put("reject_revoke", "revokeDeleted");
        deleteType.put("freejump", "freeJumpDeleted");
        deleteType.put("endProcess", "endProcessDeleted");
        deleteType.put("revokeProcess", "revokeProcessDeleted");
    }
}

