/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class MultiInstanceJumpTaskCmd
implements Command<Void> {
    protected String userId;
    private String executionId;
    private String targetNodeIds;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String taskId;
    private String comment;
    private String type;
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private static Map<String, String> createType = new HashMap<String, String>();
    private static Map<String, String> deleteType = new HashMap<String, String>();

    public Void execute(CommandContext commandContext) {
        boolean needRemoveTask = this.paramvar.get("ADD_HISTORY_TASK_START_TIME") != null;
        boolean reject = this.type.equals("reject");
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setExecutions(null);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ArrayList taskEntities = new ArrayList();
        ExecutionEntity scopeExecution = (ExecutionEntity)executionEntity.getExecutions().get(0);
        for (ExecutionEntity taskExecution : scopeExecution.getExecutions()) {
            taskEntities.addAll(taskExecution.getTasks());
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Long> longTaskIds = new ArrayList<Long>();
        String processKey = null;
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId) && !needRemoveTask) continue;
            taskIds.add(taskEntity.getId());
            longTaskIds.add(Long.parseLong(taskEntity.getId()));
            processKey = taskEntity.getProcessDefinitionId().split(":")[0];
        }
        if (HussarUtils.isNotEmpty(taskIds)) {
            Object ccTasks;
            this.taskEngineMapper.removeMultiHistoryTask(longTaskIds);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(taskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
            if (HussarUtils.isNotEmpty((Object)((TaskEntity)taskEntities.get(0)).getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            if (HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, longTaskIds))))) {
                ArrayList<String> userList = new ArrayList<String>();
                Iterator iterator = ccTasks.iterator();
                while (iterator.hasNext()) {
                    SysActCcTask ccTask = (SysActCcTask)iterator.next();
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(this.taskId)));
                    userList.add(ccTask.getReceiveUser());
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(String.join((CharSequence)",", userList));
                    dataPush.setTaskId(this.taskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId)) {
                taskEntity.setAssignee(this.userId);
            }
            ParamModel paramModel = this.getParamModel(taskEntity, this.taskRejectModel);
            Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "MultiInstanceJumpTaskCmd-Completed", false, this.mandator);
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity.getId());
        ExecutionEntity ee = new ExecutionEntity();
        for (ExecutionEntity executionEntity2 : list) {
            List parent = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity2.getId());
            for (ExecutionEntity executionEntity3 : parent) {
                executionEntity3.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
            }
            executionEntity2.remove();
            List tasks = executionEntity2.getTasks();
            if (tasks != null && !tasks.isEmpty() && HussarUtils.isNotEmpty((Object)this.userId)) {
                ((TaskEntity)tasks.get(0)).setAssignee(this.userId);
            }
            ee = executionEntity2;
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        if (reject) {
            this.paramvar.put("reject_from", this.currentActivity.getId());
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        if (executionEntity.getActivityId() != null) {
            this.fireExecutionListener(executionEntity);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userId, this.type, this.paramvar));
        return null;
    }

    public MultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String taskId, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = type;
        this.mandator = mandator;
    }

    public MultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String taskId, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = type;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
    }

    public ParamModel getParamModel(TaskEntity task, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        if (HussarUtils.isEmpty((Object)taskRejectModel)) {
            paramModel.setCompleteType(this.type);
            paramModel.setFrom(task.getTaskDefinitionKey());
            paramModel.setTo(this.targetNodeIds);
            paramModel.setHandler(this.userId);
            paramModel.setSendUser(this.userId);
            paramModel.setCreateReason(createType.get(this.type));
            paramModel.setLastNodeId(task.getTaskDefinitionKey());
            paramModel.setLastNodeName(task.getName());
            paramModel.setLastCompleteType(this.type);
            paramModel.setLastNodeHandler(this.userId);
            return paramModel;
        }
        paramModel.setCompleteType(taskRejectModel.getType());
        if (HussarUtils.isNotEmpty((Object)taskRejectModel.getTaskId())) {
            if (!task.getId().equals(taskRejectModel.getTaskId())) {
                paramModel.setDeleteType(deleteType.get(taskRejectModel.getType()));
            }
        } else {
            paramModel.setDeleteType(deleteType.get(taskRejectModel.getType()));
        }
        String targetIds = taskRejectModel.getTargetIds();
        Map<String, String> targetAssigneeMap = new HashMap<String, String>();
        if (taskRejectModel.getMap().containsKey("reject_appoint_assignee")) {
            String targetAssignee = taskRejectModel.getMap().get("reject_appoint_assignee").toString();
            targetAssigneeMap.put(targetIds, targetAssignee);
        } else if (taskRejectModel.getMap().containsKey("appoint_assignee")) {
            targetAssigneeMap = (Map)taskRejectModel.getMap().get("appoint_assignee");
        }
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setTo(targetIds);
        paramModel.setFrom(task.getTaskDefinitionKey());
        paramModel.setAffectedNodeId(taskRejectModel.getAllAffectedTaskIds());
        paramModel.setHandler(taskRejectModel.getUserId());
        paramModel.setSendUser(taskRejectModel.getUserId());
        if (createType.containsKey(taskRejectModel.getType())) {
            paramModel.setCreateReason(createType.get(taskRejectModel.getType()));
        }
        paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
        paramModel.setLastNodeName(taskRejectModel.getTask().getName());
        paramModel.setLastCompleteType(taskRejectModel.getType());
        paramModel.setLastNodeHandler(taskRejectModel.getUserId());
        paramModel.setActivityType("userTask");
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PublicClientException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }

    static {
        createType.put("reject", "rejectCreate");
        createType.put("revoke", "revokeCreate");
        createType.put("reject_revoke", "revokeCreate");
        createType.put("freejump", "freeJumpCreate");
        createType.put("complete", "completeToRejectCreate");
        deleteType.put("reject", "rejectDeleted");
        deleteType.put("revoke", "revokeDeleted");
        deleteType.put("reject_revoke", "revokeDeleted");
        deleteType.put("freejump", "freeJumpDeleted");
        deleteType.put("endProcess", "endProcessDeleted");
        deleteType.put("revokeProcess", "revokeProcessDeleted");
    }
}

