/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.FireEvent;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class ParallelJumpTaskCmd
implements Command<Void> {
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    protected String userId;
    private String executionId;
    protected String comment;
    protected String type;
    private String targetNodeIds;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private List<String> affectedTasks;
    private String processEventType;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private String mandator;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private FireEvent fireEvent = (FireEvent)SpringContextHolder.getBean(FireEvent.class);
    private static final String DELETE_REASON = "ParallelJumpTaskCmd-Completed";

    public Void execute(CommandContext commandContext) {
        List tasks;
        List parent;
        ArrayList<Long> longDelTaskIds;
        ArrayList<String> delTaskIds;
        commandContext.addAttribute("taskSourceFlag", (Object)this.type);
        boolean revoke = "revoke".equals(this.type) || "reject_revoke".equals(this.type);
        boolean reject = "reject".equals(this.type);
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        this.fireEvent.fireEvent(executionEntity, this.processEventType, (String)this.paramMap.get("sub_process"));
        if (executionEntity.getParent() != null) {
            if ((executionEntity = executionEntity.getParent()).getParent() != null) {
                executionEntity = executionEntity.getParent();
            }
            if (executionEntity.getParent() != null) {
                executionEntity = executionEntity.getParent();
            }
        }
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> delTaskIdList = new ArrayList<String>();
        ArrayList<Long> longDelTaskIdList = new ArrayList<Long>();
        for (Object taskEntity : taskEntities) {
            delTaskIdList.add(taskEntity.getId());
            longDelTaskIdList.add(Long.parseLong(taskEntity.getId()));
        }
        if (revoke && HussarUtils.isNotEmpty((Object)taskEntities) && HussarUtils.isNotEmpty(delTaskIdList)) {
            this.taskEngineMapper.removeMultiHistoryTask(longDelTaskIdList);
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(delTaskIdList);
            }
        }
        for (Object taskEntity : taskEntities) {
            if (HussarUtils.isNotEmpty((Object)this.comment) && (this.type.equals("endProcess") || this.type.equals("revokeProcess"))) {
                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
            }
            if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.add(taskEntity.getId());
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
            taskEntity.setAssignee(this.userId);
            Context.getCommandContext().getTaskEntityManager().deleteTask((TaskEntity)taskEntity, DELETE_REASON, false, this.mandator);
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
        List list = executionEntityManager.findChildExecutionsByProcessInstanceId(executionEntity.getProcessInstanceId());
        for (ExecutionEntity entity : list) {
            if (!HussarUtils.isEmpty((Object)entity.getParentId())) continue;
            list.remove(entity);
            break;
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object entity : list) {
            if (!entity.toString().contains("ScopeExecution")) continue;
            ids.add(entity.getId());
            parentIds.add(entity.getParentId());
        }
        ArrayList<ExecutionEntity> deleteList = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity entity : list) {
            if (!parentIds.contains(entity.getId()) && !ids.contains(entity.getParentId())) continue;
            deleteList.add(entity);
        }
        list.removeAll(deleteList);
        if (revoke) {
            delTaskIds = new ArrayList<String>();
            longDelTaskIds = new ArrayList<Long>();
            for (Object ee : list) {
                if (HussarUtils.isNotEmpty(this.affectedTasks) && !this.affectedTasks.contains(ee.getActivityId())) continue;
                if (ee.toString().contains("ScopeExecution")) {
                    parent = executionEntityManager.findChildExecutionsByParentExecutionId(ee.getId());
                    for (int i = 1; i < parent.size(); ++i) {
                        ExecutionEntity executionEntity3 = (ExecutionEntity)parent.get(i);
                        tasks = executionEntity3.getTasks();
                        for (TaskEntity taskEntity : tasks) {
                            delTaskIds.add(taskEntity.getId());
                            longDelTaskIds.add(Long.parseLong(taskEntity.getId()));
                        }
                    }
                    continue;
                }
                List tasks2 = ee.getTasks();
                for (TaskEntity taskEntity : tasks2) {
                    delTaskIds.add(taskEntity.getId());
                    longDelTaskIds.add(Long.parseLong(taskEntity.getId()));
                }
            }
            if (HussarUtils.isNotEmpty(delTaskIds)) {
                this.taskEngineMapper.removeMultiHistoryTask(longDelTaskIds);
                if (this.dataPushService.isDataPush()) {
                    this.dataPushService.deleteMultiTask(delTaskIds);
                }
            }
        } else if (reject) {
            delTaskIds = new ArrayList();
            longDelTaskIds = new ArrayList();
            for (Object ee : list) {
                if (HussarUtils.isNotEmpty(this.affectedTasks) && !this.affectedTasks.contains(ee.getActivityId())) continue;
                if (ee.toString().contains("ScopeExecution")) {
                    parent = executionEntityManager.findChildExecutionsByParentExecutionId(ee.getId());
                    for (ExecutionEntity executionEntity3 : parent) {
                        if (this.executionId.equals(executionEntity3.getId())) continue;
                        tasks = executionEntity3.getTasks();
                        for (TaskEntity taskEntity : tasks) {
                            delTaskIds.add(taskEntity.getId());
                            longDelTaskIds.add(Long.parseLong(taskEntity.getId()));
                        }
                    }
                    continue;
                }
                if (this.currentActivity.getId().equals(ee.getActivityId()) || !HussarUtils.isNotEmpty((Object)ee.getTasks())) continue;
                delTaskIds.add(((TaskEntity)ee.getTasks().get(0)).getId());
                longDelTaskIds.add(Long.parseLong(((TaskEntity)ee.getTasks().get(0)).getId()));
            }
            if (HussarUtils.isNotEmpty(delTaskIds)) {
                this.taskEngineMapper.removeMultiHistoryTask(longDelTaskIds);
                if (this.dataPushService.isDataPush()) {
                    this.dataPushService.deleteMultiTask(delTaskIds);
                }
            }
        }
        for (ExecutionEntity ee : list) {
            if (HussarUtils.isNotEmpty(this.affectedTasks) && !this.affectedTasks.contains(ee.getActivityId())) continue;
            if (ee.toString().contains("ScopeExecution")) {
                List parent2 = executionEntityManager.findChildExecutionsByParentExecutionId(ee.getId());
                for (ExecutionEntity executionEntity3 : parent2) {
                    List tasks3 = executionEntity3.getTasks();
                    if (tasks3 != null && !tasks3.isEmpty() && HussarUtils.isNotEmpty((Object)this.userId)) {
                        for (TaskEntity taskEntity : tasks3) {
                            if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
                                taskIds.add(taskEntity.getId());
                            }
                            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                            taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
                            if (HussarUtils.isNotEmpty((Object)this.comment) && (this.type.equals("endProcess") || this.type.equals("revokeProcess")) && !delTaskIdList.contains(taskEntity.getId())) {
                                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                            }
                            taskEntity.setAssignee(this.userId);
                            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
                        }
                    }
                    executionEntity3.remove();
                    Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
                }
                ee.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
                ExecutionEntity eeParent = executionEntityManager.findExecutionById(ee.getParentId());
                if (!executionEntity.getId().equals(eeParent.getId())) {
                    eeParent.remove();
                    Context.getCommandContext().getHistoryManager().recordActivityEnd(eeParent);
                }
            }
            List tasks4 = ee.getTasks();
            taskIds = new ArrayList();
            for (TaskEntity taskEntity : tasks4) {
                if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
                    taskIds.add(taskEntity.getId());
                }
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
                if (HussarUtils.isNotEmpty((Object)this.comment) && (this.type.equals("endProcess") || this.type.equals("revokeProcess"))) {
                    this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                }
                taskEntity.setAssignee(this.userId);
                Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
            }
            if (HussarUtils.isNotEmpty(taskIds)) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        if (reject) {
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userId, this.type, this.paramvar));
        return null;
    }

    public ParallelJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.comment = comment;
        this.type = type;
        if (paramvar.get("affectedTasks") != null) {
            this.affectedTasks = (List)paramvar.get("affectedTasks");
            paramvar.remove("affectedTasks");
        }
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
    }

    public ParallelJumpTaskCmd setProcessEventType(String processEventType) {
        this.processEventType = processEventType;
        return this;
    }

    public ParallelJumpTaskCmd addParam(String str, Object obj) {
        this.paramMap.put(str, obj);
        return this;
    }
}

