/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmUserMsg;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.task.IdentityLink;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    AssigneeChooseMapper assigneeChooseMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private HistoryService historyService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");
    private static final String DEFAULT_PARENTID = "11";
    private static final String DEFAULT_ORGAN_PARENTID = "1";
    public static final String ORGAN = "organ";
    public static final String USER = "user";

    public List<BpmTreeModel> userTree(String id, String tenantId, boolean isInterface, boolean isGetTenantUser) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userTree(Long.parseLong(newId), null);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.userTree(newId);
    }

    public List<BpmTreeModel> deptTree(String id, String tenantId, boolean isInterface) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.deptTree(Long.parseLong(newId), null);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.deptTree(newId);
    }

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.roleTree(null);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.roleTree();
    }

    public List<BpmTreeModel> roleTree(String id, boolean isInterface) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_ORGAN_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.roleTree(Long.parseLong(newId));
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.roleTree(newId);
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, String tenantId, boolean isInterface) {
        if (userIds != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            userIds.removeAll(removeList);
        }
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> userIdL = new ArrayList<Long>();
        for (String str : userIds) {
            if (!ToolUtil.isNotEmpty((Object)str)) continue;
            userIdL.add(Long.parseLong(str));
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userDetail(userIdL);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.userDetail(String.join((CharSequence)",", userIds));
    }

    private List<BpmTreeModel> userDeptDetail(String userId, String tenantId, boolean isInterface) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return new ArrayList<BpmTreeModel>();
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userDeptDetail(userId);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.userDeptDetail(userId);
    }

    public String getUserNames(List<String> userIds, String tenantId) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds, String tenantId) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (identityLink.isEntrust()) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users, tenantId);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (identityLink.isEntrust()) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList, String tenantId) {
        List<BpmTreeModel> list = this.userDetail(userList, tenantId, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    public List<String> getCandidateUser(String condition, String serviceName, String tenantId, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        if (!this.lcdpBpmProperties.isStartAlone()) {
            condition = this.getRealCondition(condition);
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT DISTINCT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.ORGAN_TYPE = 'user' AND O.IS_DISABLE != '0' ");
                sb.append(condition);
                return this.assigneeChooseMapper.getCandidateUsers(sb.toString(), securityLevel);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        try {
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getCandidateUser(condition, securityLevel, false);
        }
        catch (Exception e) {
            throw new PublicClientException("\u83b7\u53d6\u53c2\u4e0e\u8005\u5f02\u5e38\uff01");
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private String getRealCondition(String realCondition) {
        if (realCondition.contains("CONTAINSCHILD")) {
            List<AssigneeChooseDto> allOrgans = this.assigneeChooseMapper.getAllOrgans();
            HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
            for (AssigneeChooseDto assigneeChooseDto : allOrgans) {
                String organId = assigneeChooseDto.getOrganId();
                String parentId = assigneeChooseDto.getParentId();
                ArrayList<String> list = (ArrayList<String>)maps.get(parentId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(organId);
                maps.put(parentId, list);
            }
            Matcher organMatcher = ORGAN_CONTAINS_CHILD_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                int i;
                String organCondition = organMatcher.group();
                String[] organConditions = organCondition.split("'");
                ArrayList<String> organIds = new ArrayList<String>();
                for (i = 1; i < organConditions.length; i += 2) {
                    organIds.add(organConditions[i]);
                }
                for (i = 0; i < organIds.size(); ++i) {
                    List addOrgans = (List)maps.get(organIds.get(i));
                    if (addOrgans == null) continue;
                    organIds.addAll(addOrgans);
                }
                organIds = new ArrayList(new HashSet(organIds));
                StringBuilder stringBuilder = new StringBuilder();
                boolean isConditionNotIn = organCondition.contains("NOT CONTAINSCHILD");
                if (isConditionNotIn) {
                    stringBuilder.append("O.PARENT_ID NOT IN (");
                } else {
                    stringBuilder.append("O.PARENT_ID IN (");
                }
                for (String s : organIds) {
                    stringBuilder.append("'").append(s).append("',");
                }
                stringBuilder.append("'')");
                String replactCondition = stringBuilder.toString();
                while (replactCondition.contains(",''")) {
                    replactCondition = replactCondition.replace(",''", "");
                }
                while (replactCondition.contains("'',")) {
                    replactCondition = replactCondition.replace("'',", "");
                }
                if (replactCondition.contains("('')")) {
                    replactCondition = isConditionNotIn ? "1=1" : "1!=1";
                }
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        try {
            if (beanId == null) {
                return new ArrayList<String>();
            }
            if (this.lcdpBpmProperties.getRequestMethod().equals("bean")) {
                AssigneeVisitor hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((String)beanId);
                return hussarBpmVariablesVisitor.visit((Map)message.get(beanId));
            }
            String url = this.lcdpBpmProperties.getUseUrlPrefix() ? this.lcdpBpmProperties.getUrlPrefix() + beanId : beanId;
            String str = HttpRequestUtil.post(url, (Map)message.get(beanId));
            return (List)JSON.parseObject((String)str, ArrayList.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return new ArrayList<String>();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public String getSameLevelDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getSameLevelDeptIdByUserId(userId);
                return String.join((CharSequence)",", deptId);
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getSameLevelDeptIdByUserId(userId);
        }
        return "";
    }

    public String getParentDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getParentDeptIdByUserId(userId);
                return String.join((CharSequence)",", deptId);
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getParentDeptIdByUserId(userId);
        }
        return "";
    }

    public String getDeptIdByUserIds(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getDeptIdByUserIds(new ArrayList<String>(Arrays.asList(userId.split(","))));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getDeptIdByUserIds(userId);
        }
        return "";
    }

    public String getSameLevelDeptIdByUserIds(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getSameLevelDeptIdByUserIds(new ArrayList<String>(Arrays.asList(userId.split(","))));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getSameLevelDeptIdByUserIds(userId);
        }
        return "";
    }

    public String getParentDeptIdByUserIds(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getParentDeptIdByUserIds(new ArrayList<String>(Arrays.asList(userId.split(","))));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getParentDeptIdByUserIds(userId);
        }
        return "";
    }

    public Integer getSecurityLevel(String userId, String url, String tenantId) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.getSecurityLevel(userId);
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return Integer.valueOf(remoteAssigneeChooseService.getSecurityLevel(userId));
    }

    public String getStarterDept(String userId, String tenantId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, tenantId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, String tenantId) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            List<BpmTreeModel> childrenNode = this.assigneeChooseMapper.queryDeptTreeByDeptName(organName);
            return this.queryAllTreeByChildrenNode(childrenNode, 0);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryDeptTreeByDeptName(organName);
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName, String tenantId) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            List<BpmTreeModel> childrenNode = this.assigneeChooseMapper.queryUserTreeByUserName(organName);
            return this.queryAllTreeByChildrenNode(childrenNode, 0);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryUserTreeByUserName(organName);
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        roleName = roleName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            List<BpmTreeModel> childrenNode = this.assigneeChooseMapper.queryRoleTreeByRoleName(roleName);
            return this.queryAllTreeByChildrenNode(childrenNode, 1);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryRoleTreeByRoleName(roleName);
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode, Integer type) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<BpmTreeModel> allDept = type == 0 ? this.assigneeChooseMapper.getAllDept() : this.assigneeChooseMapper.getAllRole();
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (!HussarUtils.isEmpty((Object)childrenList)) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    public List<BpmTreeModel> queryUserTree(String organName, String tenantId) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.queryUserTree(organName);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryUserTree(organName);
    }

    public IPage<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel, String tenantId) {
        if (HussarUtils.isEmpty((Object)bpmTreeModel.getId()) || HussarUtils.isEmpty((Object)bpmTreeModel.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getUserListByParentId(pages, null));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getUserListByParentId(pages, null));
        }
        if (ORGAN.equals(bpmTreeModel.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getUserListByParentId(pages, Long.parseLong(bpmTreeModel.getId())));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getUserListByParentId(pages, bpmTreeModel.getId()));
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getUserListByUserId(pages, Long.parseLong(bpmTreeModel.getId())));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getUserListByUserId(pages, bpmTreeModel.getId()));
        }
        return pages.setRecords(new ArrayList());
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel, String tenantId) {
        if (HussarUtils.isEmpty((Object)bpmTreeModel.getId()) || HussarUtils.isEmpty((Object)bpmTreeModel.getParentId())) {
            return new ArrayList<BpmTreeModel>();
        }
        List<BpmTreeModel> allDept = this.assigneeChooseMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptmap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptmap.put(dept.getId(), dept);
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (HussarUtils.isEmpty((Object)(bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())))) {
                return new ArrayList<BpmTreeModel>();
            }
        } else if (ORGAN.equals(bpmTreeModel.getType())) {
            bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getId());
        }
        while (deptmap.containsKey(bpmTreeModel.getParentId())) {
            ArrayList<BpmTreeModel> children = new ArrayList<BpmTreeModel>();
            children.add(bpmTreeModel);
            bpmTreeModel = ((BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())).setChildrenList(children);
        }
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        result.add(bpmTreeModel);
        return result;
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName, String tenantId) {
        if (HussarUtils.isEmpty(users) || HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.queryAssigneeAndDept(users, organName);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryAssigneeAndDept(users, organName);
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        AssigneeChooseService assigneeChooseService;
        ArrayList<Long> LongUsers = new ArrayList<Long>();
        for (String user : users) {
            LongUsers.add(Long.parseLong(user));
        }
        if (HussarUtils.isEmpty((Object)nodeAssigneeQueryDto.getId()) || HussarUtils.isEmpty((Object)nodeAssigneeQueryDto.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getNodeAssigneeListByParentId(pages, null, LongUsers));
            }
            assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getNodeAssigneeListByParentId(pages, null, String.join((CharSequence)",", users)));
        }
        if (ORGAN.equals(nodeAssigneeQueryDto.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getNodeAssigneeListByParentId(pages, Long.parseLong(nodeAssigneeQueryDto.getId()), LongUsers));
            }
            assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getNodeAssigneeListByParentId(pages, nodeAssigneeQueryDto.getId(), String.join((CharSequence)",", users)));
        }
        if (USER.equals(nodeAssigneeQueryDto.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getNodeAssigneeListByUserId(pages, Long.parseLong(nodeAssigneeQueryDto.getId()), LongUsers));
            }
            assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getNodeAssigneeListByUserId(pages, nodeAssigneeQueryDto.getId(), String.join((CharSequence)",", users)));
        }
        return pages.setRecords(new ArrayList());
    }

    public List<Map<String, Object>> getUserAndAccountListByUserId(List<String> userIds) {
        ArrayList<Long> LongUsers = new ArrayList<Long>();
        for (String user : userIds) {
            LongUsers.add(Long.parseLong(user));
        }
        return this.assigneeChooseMapper.getUserAndAccountListByUserId(LongUsers);
    }

    public List<BpmUserMsg> getUserMsgByUserIds(List<String> userIds, String tenantId) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserMsg>();
        }
        List<Long> ids = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
        return this.assigneeChooseMapper.getUserMsgByUserIds(ids);
    }
}

