/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutHandleUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.model.SysUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TimeOutSetListUtil {
    @Autowired
    private RedisTemplate redisTemplate;
    private static Logger logger = LogManager.getLogger(TimeOutSetListUtil.class);
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;

    @HussarDs(value="#connName")
    public void setList(SysUser sysUser, String connName) {
        try {
            if (TimeOutHandleUtil.useRedis) {
                try {
                    List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                    for (TimeOutModel timeOutModel : timeOutModels) {
                        this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + timeOutModel.getId()), (Object)JSON.toJSONString((Object)timeOutModel));
                        Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)"bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                        if (HussarUtils.isEmpty((Object)oldTask)) {
                            this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)timeOutModel.getId(), (double)timeOutModel.getDueTime().getTime());
                            continue;
                        }
                        this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)((String)new ArrayList(oldTask).get(0) + "," + timeOutModel.getId()), (double)timeOutModel.getDueTime().getTime());
                    }
                    this.activityRedisTimerMapper.delete(null);
                }
                catch (Exception e) {
                    logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
                }
                return;
            }
            List timeOutModels = this.activityRedisTimerMapper.selectList(null);
            for (TimeOutModel timeOutModel : timeOutModels) {
                HussarCacheUtil.put((String)"bpm_timer_activity", (Object)String.valueOf(timeOutModel.getId()), (Object)timeOutModel);
                Long time = timeOutModel.getDueTime().getTime();
                TimeOutHandleUtil.timeOutList.add(time);
                TimeOutHandleUtil.timeOutMap.put(time, TimeOutHandleUtil.timeOutMap.get(time) == null ? String.valueOf(timeOutModel.getId()) : TimeOutHandleUtil.timeOutMap.get(time) + "," + timeOutModel.getId());
            }
        }
        catch (Exception e) {
            String prefix = sysUser.getUserAccount() == null ? "" : "\u79df\u6237" + sysUser.getUserAccount();
            logger.error("{}\u79df\u6237\u5e93\u83b7\u53d6\u8d85\u65f6\u4fe1\u606f\u51fa\u9519\uff1a{}", new Object[]{prefix, e.getMessage()});
        }
    }
}

