/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysBpmService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysBpmServiceImpl")
public class SysBpmServiceImpl
implements SysBpmService {
    @Resource
    private SysActFormAuthService sysActFormAuthService;
    @Resource
    private SysActAssigneeService sysActAssigneeService;
    @Resource
    private ModelService modelService;
    @Resource
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;

    public Boolean actFormAuthBatchImport(List<SysActFormAuth> actFormAuths) {
        ArrayList<SysActFormAuth> insertOrUpdateList = new ArrayList<SysActFormAuth>();
        for (SysActFormAuth actFormAuth : actFormAuths) {
            if (HussarUtils.isEmpty((Object)actFormAuth.getProcessKey())) continue;
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)actFormAuth.getProcessKey())).eq(SysActFormAuth::getFormType, (Object)actFormAuth.getFormType());
            if (HussarUtils.isNotEmpty((Object)actFormAuth.getTaskDefinitionKey())) {
                queryWrapper.eq(SysActFormAuth::getTaskDefinitionKey, (Object)actFormAuth.getTaskDefinitionKey());
            } else {
                queryWrapper.eq(SysActFormAuth::getTaskDefinitionKey, (Object)"");
            }
            this.sysActFormAuthService.remove((Wrapper)queryWrapper);
            actFormAuth.setId(null);
            insertOrUpdateList.add(actFormAuth);
        }
        return this.sysActFormAuthService.saveBatch(insertOrUpdateList);
    }

    public Boolean actAssigneeBatchImport(List<SysActAssignee> actAssignees) {
        List<SysActAssignee> addList = new ArrayList();
        QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
        HashSet<String> procDefKeys = new HashSet<String>();
        for (SysActAssignee sysActAssignee : actAssignees) {
            String procDefKey = sysActAssignee.getProcDefKey();
            procDefKeys.add(procDefKey);
        }
        queryWrapper = (QueryChainWrapper)queryWrapper.in((Object)"PROC_DEF_KEY", procDefKeys);
        List sameList = queryWrapper.list();
        ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
        for (SysActAssignee sysActAssignee : actAssignees) {
            boolean isadd = true;
            for (SysActAssignee actAssignee : sameList) {
                String taskDefKeyOld;
                String taskDefKey = sysActAssignee.getTaskDefKey() == null ? "" : sysActAssignee.getTaskDefKey();
                String string = taskDefKeyOld = actAssignee.getTaskDefKey() == null ? "" : actAssignee.getTaskDefKey();
                if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !taskDefKey.equals(taskDefKeyOld) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                sysActAssignee.setId(actAssignee.getId());
                updateList.add(sysActAssignee);
                isadd = false;
                break;
            }
            if (!isadd) continue;
            addList.add(sysActAssignee);
        }
        addList = addList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysActAssignee>(Comparator.comparing(o -> o.getTaskDefKey() + o.getProcDefKey() + o.getContentType()))), ArrayList::new));
        Boolean isSave = this.sysActAssigneeService.saveBatch(addList);
        Boolean isUpdate = this.sysActAssigneeService.updateBatchById(updateList);
        boolean result = false;
        if (isSave.booleanValue() && isUpdate.booleanValue()) {
            result = true;
        }
        return result;
    }

    public List<SysActFormAuth> actFormAuthExportData(List<String> keys) {
        return this.sysActFormAuthService.list((Wrapper)new LambdaQueryWrapper().in(SysActFormAuth::getProcessKey, keys));
    }

    public List<SysActAssignee> actAssigneeExportData(List<String> keys) {
        return this.sysActAssigneeService.list((Wrapper)new LambdaQueryWrapper().in(SysActAssignee::getProcDefKey, keys));
    }

    public Boolean importModel(String tenantId, File file, List<String> list) {
        return this.modelService.importModel(tenantId, file, list);
    }

    public String exportAllFileModel(String tenantId, String keys, File file) {
        return this.modelService.exportAllFileModel(tenantId, keys, file);
    }

    public void actExtendPropertiesImport(List<SysActExtendProperties> list) {
        ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
        ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
        for (SysActExtendProperties sysActExtendProperties : list) {
            SysActExtendProperties temp = (SysActExtendProperties)sysActExtendProperties.selectById((Serializable)sysActExtendProperties.getId());
            if (ToolUtil.isNotEmpty((Object)temp)) {
                updateList.add(sysActExtendProperties);
                continue;
            }
            addList.add(sysActExtendProperties);
        }
        this.sysActExtendPropertiesService.saveBatch(addList);
        this.sysActExtendPropertiesService.updateBatchById(updateList);
    }

    public List<SysActExtendProperties> actExtendPropertiesExportData(List<String> keys) {
        ArrayList<SysActExtendProperties> list = new ArrayList<SysActExtendProperties>();
        for (String key : keys) {
            List sysActExtendProperties = new SysActExtendProperties().selectList((Wrapper)new LambdaQueryWrapper().like(SysActExtendProperties::getProcDefId, (Object)key));
            if (!HussarUtils.isNotEmpty((Object)sysActExtendProperties)) continue;
            list.addAll(sysActExtendProperties);
        }
        return list;
    }
}

