/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudTaskListener")
public class DefaultTaskListener
implements TaskListener {
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);

    public void notify(DelegateTask delegateTask) {
        BpmnModel bm = repositoryService.getBpmnModel(delegateTask.getProcessDefinitionId());
        FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(delegateTask.getTaskDefinitionKey());
        String beanId = (String)delegateTask.getVariableLocal("beanId");
        delegateTask.removeVariableLocal("beanId");
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeId", delegateTask.getTaskDefinitionKey());
        map.put("nodeName", flowElement.getName());
        map.put("businessId", "");
        map.put("processInsId", delegateTask.getProcessInstanceId());
        map.put("processDefinitionId", delegateTask.getProcessDefinitionId());
        map.put("processKey", delegateTask.getProcessDefinitionId().split(":")[0]);
        map.put("tenantId", delegateTask.getTenantId());
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateTask.getExecution()).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("processName", ((ExecutionEntity)delegateTask.getExecution()).getProcessDefinition().getName());
        map.put("listenerType", "TaskListener");
        if (beanId != null) {
            try {
                if (this.lcdpBpmProperties.getRequestMethod().equals("bean")) {
                    if (!this.lcdpBpmProperties.isStartAlone()) {
                        HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                        workflowListenerVisitor.notify(map);
                        return;
                    }
                    map.put("beanId", beanId);
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                    workflowListenerService.executeListener(map, serviceName);
                } else {
                    String url = this.lcdpBpmProperties.getUseUrlPrefix() ? this.lcdpBpmProperties.getUrlPrefix() + beanId : beanId;
                    HttpRequestUtil.post(url, map);
                }
            }
            catch (Exception e) {
                throw new PublicClientException("\u8bbf\u95ee\u4efb\u52a1\u76d1\u542c\u5668\u5931\u8d25\uff01");
            }
        }
    }
}

