/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class MultiInstanceJumpTaskCmd
implements Command<Void> {
    protected String userId;
    private String executionId;
    private String targetNodeIds;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String taskId;
    private String comment;
    private String type;
    private String mandator;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);

    public Void execute(CommandContext commandContext) {
        boolean needRemoveTask = this.paramvar.get("ADD_HISTORY_TASK_START_TIME") != null;
        boolean reject = this.type.equals("reject");
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setExecutions(null);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ArrayList taskEntities = new ArrayList();
        ExecutionEntity scopeExecution = (ExecutionEntity)executionEntity.getExecutions().get(0);
        for (ExecutionEntity taskExecution : scopeExecution.getExecutions()) {
            taskEntities.addAll(taskExecution.getTasks());
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Long> longTaskIds = new ArrayList<Long>();
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId) && !needRemoveTask) continue;
            taskIds.add(taskEntity.getId());
            longTaskIds.add(Long.parseLong(taskEntity.getId()));
        }
        if (HussarUtils.isNotEmpty(taskIds)) {
            Object ccTasks;
            this.taskEngineMapper.removeMultiHistoryTask(longTaskIds);
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(taskIds);
            }
            if (HussarUtils.isNotEmpty((Object)((TaskEntity)taskEntities.get(0)).getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            if (HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, longTaskIds))))) {
                ArrayList<String> userList = new ArrayList<String>();
                Iterator iterator = ccTasks.iterator();
                while (iterator.hasNext()) {
                    SysActCcTask ccTask = (SysActCcTask)iterator.next();
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(this.taskId)));
                    userList.add(ccTask.getReceiveUser());
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(String.join((CharSequence)",", userList));
                    dataPush.setTaskId(this.taskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId)) {
                taskEntity.setAssignee(this.userId);
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "MultiInstanceJumpTaskCmd-Completed", false, this.mandator);
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity.getId());
        ExecutionEntity ee = new ExecutionEntity();
        for (ExecutionEntity executionEntity2 : list) {
            List parent = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity2.getId());
            for (ExecutionEntity executionEntity3 : parent) {
                executionEntity3.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
            }
            executionEntity2.remove();
            List tasks = executionEntity2.getTasks();
            if (tasks != null && !tasks.isEmpty() && HussarUtils.isNotEmpty((Object)this.userId)) {
                ((TaskEntity)tasks.get(0)).setAssignee(this.userId);
            }
            ee = executionEntity2;
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        if (reject) {
            this.paramvar.put("reject_from", this.currentActivity.getId());
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userId, this.type, this.paramvar));
        return null;
    }

    public MultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String taskId, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = type;
        this.mandator = mandator;
    }
}

