/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class CommonPrepareCmd
implements Command<PrepareReturn> {
    protected BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    protected IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    protected String taskId;
    protected String userId;
    protected String mandator;
    protected String taskState;
    protected boolean isAuditAuthority = true;

    public PrepareReturn execute(CommandContext commandContext) {
        TaskEntity task;
        block9: {
            boolean mandataryFlag;
            boolean mandatorFlag;
            ArrayList<IdentityLinkEntity> userTasks;
            block14: {
                block11: {
                    block12: {
                        block13: {
                            block10: {
                                if (this.taskId == null) {
                                    throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull());
                                }
                                task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
                                this.taskAuthentication(task);
                                if (!this.isAuditAuthority) break block9;
                                if (!HussarUtils.isNotEmpty((Object)task.getAssignee()) || !task.getAssignee().equals(this.userId)) break block10;
                                this.mandator = null;
                                this.taskState = null;
                                break block9;
                            }
                            List identityLinks = task.getCandidates();
                            userTasks = new ArrayList<IdentityLinkEntity>();
                            mandatorFlag = HussarUtils.isEmpty((Object)this.mandator);
                            mandataryFlag = HussarUtils.isNotEmpty((Object)this.mandator);
                            for (IdentityLinkEntity identityLink : identityLinks) {
                                if (!this.userId.equals(identityLink.getUserId())) continue;
                                userTasks.add(identityLink);
                            }
                            if (userTasks.isEmpty()) {
                                for (IdentityLinkEntity identityLink : identityLinks) {
                                    if (!HussarUtils.isNotEmpty((Object)identityLink.getTaskState()) || !identityLink.getMandator().equals(this.userId)) continue;
                                    if (Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(new HistoricTaskInstanceQueryImpl().processInstanceId(task.getProcessInstanceId())) == 1L) {
                                        return new PrepareReturn(this, "\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId()), task.getTenantId()).get(identityLink.getUserId()) + ")\uff01");
                                    }
                                    throw new PublicClientException("\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId()), task.getTenantId()).get(identityLink.getUserId()) + ")\uff01");
                                }
                                throw new PublicClientException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u529e\u7406\u6743\u9650\uff01");
                            }
                            if (userTasks.size() != 1) break block11;
                            if (!((IdentityLinkEntity)userTasks.get(0)).isEntrust()) break block12;
                            String taskMandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                            if (!HussarUtils.isNotEmpty((Object)this.mandator) || !this.mandator.equals(taskMandator)) break block13;
                            this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                            mandatorFlag = true;
                            break block14;
                        }
                        if (!HussarUtils.isEmpty((Object)this.mandator)) break block14;
                        this.mandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                        this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                        mandataryFlag = true;
                        break block14;
                    }
                    if (!HussarUtils.isEmpty((Object)this.mandator)) break block14;
                    mandataryFlag = true;
                    break block14;
                }
                for (IdentityLinkEntity identityLink : userTasks) {
                    if (HussarUtils.isEmpty((Object)this.mandator) && HussarUtils.isEmpty((Object)identityLink.getMandator())) {
                        mandataryFlag = true;
                        break;
                    }
                    if (!HussarUtils.isNotEmpty((Object)this.mandator) || !this.mandator.equals(identityLink.getMandator())) continue;
                    mandatorFlag = true;
                    this.taskState = identityLink.getTaskState();
                    break;
                }
            }
            if (!mandatorFlag) {
                throw new PublicClientException("\u7528\u6237(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(this.mandator), task.getTenantId()).get(this.mandator) + ")\u4e0d\u662f\u59d4\u6258\u4eba\uff01");
            }
            if (!mandataryFlag) {
                this.mandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
            }
        }
        this.execute(commandContext, task);
        return new PrepareReturn(this);
    }

    protected void execute(CommandContext commandContext, TaskEntity task) {
    }

    protected void taskAuthentication(TaskEntity task) {
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended());
        }
    }

    public CommonPrepareCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public CommonPrepareCmd(String taskId, String userId, String mandator) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandator = mandator;
    }

    public CommonPrepareCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandator = mandator;
        this.isAuditAuthority = isAuditAuthority;
    }

    public CommonPrepareCmd notAuditAuthority() {
        this.isAuditAuthority = false;
        return this;
    }

    public CommonPrepareCmd isAuditAuthority(boolean isAuditAuthority) {
        this.isAuditAuthority = isAuditAuthority;
        return this;
    }

    public static class PrepareReturn {
        private final String mandator;
        private final String taskState;
        private final boolean isSuccess;
        private final String message;

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMandator() {
            return this.mandator;
        }

        public String getTaskState() {
            return this.taskState;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd) {
            this.mandator = commonPrepareCmd.mandator;
            this.taskState = commonPrepareCmd.taskState;
            this.isSuccess = true;
            this.message = null;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd, String message) {
            this.mandator = commonPrepareCmd.mandator;
            this.taskState = commonPrepareCmd.taskState;
            this.isSuccess = false;
            this.message = message;
        }
    }
}

